/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.graph.Graph;
import com.kingdee.bos.ctrl.common.util.graph.Vertex;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParamsRelationSettingPanel
extends KDPanel
implements SimpleDialog.PanelOfSimpleDialog {
    private List<DesignParameter> ps;
    private KDList psList;
    private KDTree psTree;
    private KDWorkButton btnConnection;
    private KDScrollPane treePane;
    private KDScrollPane listPane;
    private List<Link> links = new ArrayList<Link>();

    public ParamsRelationSettingPanel(List<DesignParameter> ps) {
        this.ps = new ArrayList<DesignParameter>();
        for (DesignParameter dp : ps) {
            InputType inputType = dp.getInputType();
            if (inputType.intValue() == 9 || inputType.intValue() == 8) continue;
            this.ps.add(dp);
        }
        this.initConponent();
    }

    private void initConponent() {
        this.btnConnection = new KDWorkButton("\u8fde\u63a5");
        this.btnConnection.setEnabled(false);
        this.btnConnection.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = ParamsRelationSettingPanel.this.psList.getSelectedIndex();
                DesignParameter dp = ParamsRelationSettingPanel.this.getDesignParameterFromList(index);
                TreePath path = ParamsRelationSettingPanel.this.psTree.getSelectionPath();
                DesignParameter disDp = ParamsRelationSettingPanel.this.getDesignParameterFromTree(path);
                DesignParameter disDpParent = ParamsRelationSettingPanel.this.getDesignParameterFromTree(path.getParentPath());
                if (dp == null || disDp == null || disDpParent == null) {
                    return;
                }
                if ("\u8fde\u63a5".equals(ParamsRelationSettingPanel.this.btnConnection.getText())) {
                    boolean disrepeat = false;
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (!node.isLeaf()) {
                        MessageUtil.showWarning(null, "\"" + node.getText() + "\"\u4e3a\u4e00\u7ea7\u53c2\u6570\u4e0d\u80fd\u5173\u8054\uff0c\u8bf7\u9009\u62e9\u4e8c\u7ea7\u53c2\u6570\u8fdb\u884c\u5173\u8054");
                        return;
                    }
                    DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                    DesignParameter disParentDp = (DesignParameter)((Object)parentNode.getUserObject());
                    for (Link link : ParamsRelationSettingPanel.this.links) {
                        DesignParameter dis = link.getDis();
                        DesignParameter disParent = link.getDisParent();
                        if (!dis.equals((Object)disDp) || !disParent.equals((Object)disParentDp)) continue;
                        disrepeat = true;
                        break;
                    }
                    if (dp.equals((Object)disParentDp)) {
                        MessageUtil.showWarning(null, "\"" + disParentDp.getAliasName() + "\"\u4e0d\u80fd\u548c\u672c\u53c2\u6570\u5173\u8054");
                        return;
                    }
                    if (ParamsRelationSettingPanel.this.checkCycle(dp.getName(), disParentDp.getName())) {
                        MessageUtil.showWarning(null, "\"" + dp.getAliasName() + "\"\u4e0e\"" + disParentDp.getAliasName() + "\"\u4e0d\u80fd\u5faa\u73af\u5173\u8054");
                        return;
                    }
                    if (disrepeat) {
                        if (MessageUtil.showConfirm("\u63a5\u6536\u65b9\u5df2\u5efa\u7acb\u8fde\u63a5\uff0c\u6b64\u64cd\u4f5c\u5c06\u65ad\u5f00\u5176\u539f\u6709\u8fde\u63a5\u3002\u662f\u5426\u7ee7\u7eed\uff1f", false)) {
                            for (Link link : ParamsRelationSettingPanel.this.links) {
                                if (!link.getDis().equals((Object)disDp)) continue;
                                ParamsRelationSettingPanel.this.links.remove(link);
                                break;
                            }
                        } else {
                            return;
                        }
                    }
                    ParamsRelationSettingPanel.this.links.add(new Link(dp, disDp, disParentDp));
                    ParamsRelationSettingPanel.this.btnConnection.setText("\u65ad\u5f00");
                } else {
                    Link deleteLink = null;
                    for (Link link : ParamsRelationSettingPanel.this.links) {
                        DesignParameter dis = link.getDis();
                        DesignParameter disParent = link.getDisParent();
                        DesignParameter src = link.getSrc();
                        if (!src.equals((Object)dp) || !dis.equals((Object)disDp) || !disParent.equals((Object)disDpParent)) continue;
                        deleteLink = link;
                        break;
                    }
                    if (deleteLink != null) {
                        ParamsRelationSettingPanel.this.links.remove(deleteLink);
                    }
                    ParamsRelationSettingPanel.this.btnConnection.setText("\u8fde\u63a5");
                }
                ParamsRelationSettingPanel.this.repaint();
            }
        });
        ListModel listModel = new ListModel(){

            @Override
            public void removeListDataListener(ListDataListener l) {
            }

            @Override
            public int getSize() {
                return ParamsRelationSettingPanel.this.ps.size();
            }

            public Object getElementAt(int index) {
                return ((DesignParameter)((Object)ParamsRelationSettingPanel.this.ps.get(index))).getAliasName();
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }
        };
        this.psList = new KDList(listModel);
        this.psList.setFixedCellHeight(25);
        this.psList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParamsRelationSettingPanel.this.changeConectionBtnState();
            }
        });
        this.psList.setSelectionMode(0);
        this.psTree = new KDTree();
        this.psTree.setRowHeight(25);
        this.psTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ParamsRelationSettingPanel.this.changeConectionBtnState();
            }
        });
        this.psTree.getSelectionModel().setSelectionMode(1);
        this.psTree.setRootVisible(false);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        this.psTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        for (DesignParameter dp : this.ps) {
            DesignParameter[][] children = dp.getSupplierParams();
            if (children == null || children.length <= 0) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            root.add((MutableTreeNode)node);
            node.setUserObject((Object)dp);
            node.setText(dp.getAliasName());
            for (int index = 0; index < children.length; ++index) {
                DesignParameter childDp = children[index][0];
                InputType inputType = childDp.getInputType();
                if (inputType.intValue() == 9 || inputType.intValue() == 8) continue;
                DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode();
                childNode.setText(childDp.getAliasName());
                childNode.setUserObject((Object)childDp);
                node.add((MutableTreeNode)childNode);
                if (children[index][1] == null) continue;
                this.links.add(new Link(children[index][1], children[index][0], dp));
            }
        }
        this.psTree.setCollapsePathDisabled(true);
        TableLayout2 layout = new TableLayout2(6, 5);
        layout.setRowsSpacing(new int[]{0}, 6);
        layout.setFixedHeight(0, 30);
        layout.setFixedHeight(1, 25);
        layout.setRatableHeight(2, 100);
        layout.setFixedHeight(3, 25);
        layout.setFixedHeight(4, 19);
        layout.setFixedHeight(5, 19);
        layout.setRatableWidth(new int[]{0, 4}, 100);
        layout.setFixedWidth(1, 60);
        layout.setFixedWidth(2, 100);
        layout.setFixedWidth(3, 60);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.btnConnection, TableLayout2.param((int)0, (int)2));
        this.add((Component)new KDLabel("\u53d1\u9001\u65b9\uff08\u6570\u636e\u96c6\u7684\u53c2\u6570\uff09"), TableLayout2.param((int)1, (int)0));
        this.add((Component)new KDLabel("\u63a5\u6536\u65b9\uff08\u53f6\u5b50\u8282\u70b9\u5373\u4e3a\u6765\u6e90\u6570\u636e\u96c6\u4e2d\u7684\u53c2\u6570\uff09"), TableLayout2.param((int)1, (int)4));
        this.add((Component)new KDLabel("\u8bf4\u660e\uff1a"), TableLayout2.param((int)3, (int)0));
        this.add((Component)new KDLabel("1\u3001\u63a5\u6536\u65b9\u53ea\u80fd\u4ece\u552f\u4e00\u7684\u53d1\u9001\u65b9\u83b7\u5f97\u6570\u636e\uff0c\u4e0d\u80fd\u7531\u591a\u4e2a\u53d1\u9001\u65b9\u7ed9\u4e00\u4e2a\u63a5\u6536\u65b9\u63d0\u4f9b\u6570\u636e\u3002"), TableLayout2.param((int)4, (int)0, (int)4, (int)4));
        this.add((Component)new KDLabel("2\u3001\u901a\u8fc7\u9009\u4e2d\u53d1\u9001\u65b9\u4e0e\u63a5\u6536\u65b9\u5b9a\u4f4d\u8fde\u63a5\u3002"), TableLayout2.param((int)5, (int)0, (int)5, (int)4));
        this.listPane = new KDScrollPane((Component)this.psList);
        this.add((Component)this.listPane, TableLayout2.param((int)2, (int)0));
        this.treePane = new KDScrollPane((Component)this.psTree);
        this.treePane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.add((Component)this.treePane, TableLayout2.param((int)2, (int)4));
    }

    public boolean checkCycle() {
        Graph<String> relations = ParamsRelationSettingPanel.buildLinkGraph(this.links);
        return relations.findCycles().length > 0;
    }

    private static Graph<String> buildLinkGraph(List<Link> links) {
        Graph relations = new Graph();
        for (Link link : links) {
            Vertex keyV = relations.findVertexByName(link.getSrc().getName());
            Vertex valueV = relations.findVertexByName(link.getDisParent().getName());
            if (keyV == null) {
                keyV = new Vertex(link.getSrc().getName());
                relations.addVertex(keyV);
            }
            if (valueV == null) {
                valueV = new Vertex(link.getDisParent().getName());
                relations.addVertex(valueV);
            }
            relations.addEdge(keyV, valueV, 1);
        }
        return relations;
    }

    private boolean checkCycle(String key, String value) {
        Graph<String> relations = ParamsRelationSettingPanel.buildLinkGraph(this.links);
        Vertex keyV = relations.findVertexByName(key);
        Vertex valueV = relations.findVertexByName(value);
        if (keyV == null) {
            keyV = new Vertex(key);
            relations.addVertex(keyV);
        }
        if (valueV == null) {
            valueV = new Vertex(value);
            relations.addVertex(valueV);
        }
        relations.addEdge(keyV, valueV, 1);
        return relations.findCycles().length > 0;
    }

    private void changeConectionBtnState() {
        DesignParameter dp = this.getDesignParameterFromList(this.psList.getSelectedIndex());
        TreePath path = this.psTree.getSelectionPath();
        if (dp != null && path != null) {
            boolean isContains = false;
            DesignParameter disdp = this.getDesignParameterFromTree(path);
            DesignParameter disParent = this.getDesignParameterFromTree(path.getParentPath());
            if (disParent == null) {
                this.btnConnection.setEnabled(false);
            } else {
                this.btnConnection.setEnabled(true);
            }
            for (Link link : this.links) {
                if (!link.getSrc().equals((Object)dp) || !link.getDis().equals((Object)disdp) || !link.getDisParent().equals((Object)disParent)) continue;
                isContains = true;
                break;
            }
            if (isContains) {
                this.btnConnection.setText("\u65ad\u5f00");
            } else {
                this.btnConnection.setText("\u8fde\u63a5");
            }
        } else {
            this.btnConnection.setEnabled(false);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintLine(g);
    }

    private Point getPosintFromPsList(DesignParameter dp) {
        int index = this.ps.indexOf((Object)dp);
        Point point = this.psList.indexToLocation(index);
        if (point == null) {
            return null;
        }
        int top = this.listPane.getY();
        int y = point.y - this.listPane.getViewport().getViewPosition().y;
        point.y = y < 0 ? top - 3 : (y > this.listPane.getViewport().getViewRect().height ? this.listPane.getViewport().getViewRect().height + top + 3 : y + top + 10);
        point.x += this.listPane.getWidth();
        return point;
    }

    private void paintLine(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object old = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        KingdeeTreeModel model = (KingdeeTreeModel)this.psTree.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        DesignParameter currentDp = this.getDesignParameterFromList(this.psList.getSelectedIndex());
        TreePath currentPath = this.psTree.getSelectionPath();
        DesignParameter disdp = null;
        DesignParameter disParent = null;
        if (currentDp != null && currentPath != null) {
            disdp = this.getDesignParameterFromTree(currentPath);
            disParent = this.getDesignParameterFromTree(currentPath.getParentPath());
        }
        boolean isCurrent = false;
        for (Link link : this.links) {
            TreePath path;
            Rectangle rg;
            Point point = this.getPosintFromPsList(link.getSrc());
            if (point == null || (rg = this.psTree.getPathBounds(path = this.getPathFromTree(root, link.getDis(), link.getDisParent()))) == null) continue;
            int x = this.treePane.getX();
            int y = rg.y + rg.height / 2 + this.treePane.getY();
            Color oldColor = null;
            if (!isCurrent && currentDp != null && disdp != null && disParent != null && link.getSrc().equals((Object)currentDp) && link.getDis().equals((Object)disdp) && link.getDisParent().equals((Object)disParent)) {
                isCurrent = true;
                oldColor = g2d.getColor();
                g2d.setColor(Color.blue);
            }
            Point point2 = new Point(x, y);
            g2d.drawLine(point.x, point.y, point2.x, point2.y);
            g2d.fillPolygon(new int[]{point2.x - 4, point2.x - 4, point2.x}, new int[]{point2.y - 4, point2.y + 4, point2.y}, 3);
            if (oldColor == null) continue;
            g2d.setColor(oldColor);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
    }

    private DesignParameter getDesignParameterFromList(int index) {
        if (index < 0 || index >= this.ps.size()) {
            return null;
        }
        return this.ps.get(index);
    }

    private DesignParameter getDesignParameterFromTree(TreePath path) {
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        return (DesignParameter)((Object)parentNode.getUserObject());
    }

    private TreePath getPathFromTree(DefaultKingdeeTreeNode node, DesignParameter dp, DesignParameter dpParent) {
        if (node != null) {
            for (int index = 0; index < node.getChildCount(); ++index) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(index);
                if (dp.equals(child.getUserObject()) && dpParent.equals(node.getUserObject())) {
                    return new TreePath(child.getPath());
                }
                TreePath path = this.getPathFromTree(child, dp, dpParent);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    public boolean verify() {
        if (this.checkCycle()) {
            MessageUtil.showWarning((Component)((Object)this), "\u5b58\u5728\u5faa\u73af\u5173\u8054!");
            return false;
        }
        return true;
    }

    public List<Link> getLink() {
        return this.links;
    }

    class Links {
        private DesignParameter src;
        private List<DesignParameter> disParents;

        public Links(DesignParameter src) {
            this.src = src;
            this.disParents = new ArrayList<DesignParameter>();
        }
    }

    class Link {
        private DesignParameter src;
        private DesignParameter dis;
        private DesignParameter disParent;

        public Link(DesignParameter src, DesignParameter dis, DesignParameter disParent) {
            this.src = src;
            this.dis = dis;
            this.disParent = disParent;
        }

        public DesignParameter getSrc() {
            return this.src;
        }

        public DesignParameter getDis() {
            return this.dis;
        }

        public DesignParameter getDisParent() {
            return this.disParent;
        }
    }
}

