/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PopupF7DisplayFieldTree
extends KDDialog
implements KDPromptSelector {
    private static final long serialVersionUID = -2641793053008447576L;
    private KDTreeView kDTreeView1;
    private KDTree kDTree1;
    protected KDSeparator kDSeparator2;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    private boolean isOk = false;
    String fullName = null;
    String oldQueryInfo;
    String newQueryInfo;

    private PopupF7DisplayFieldTree() {
    }

    private PopupF7DisplayFieldTree(Frame owner) {
        super(owner, true);
        this.initDialog();
    }

    private PopupF7DisplayFieldTree(Dialog owner) {
        super(owner, true);
        this.initDialog();
    }

    public static PopupF7DisplayFieldTree getInstance() {
        Window owner = ComponentUtil.getCurrentActiveWindow();
        if (owner instanceof Dialog) {
            return new PopupF7DisplayFieldTree((Dialog)owner);
        }
        if (owner instanceof Frame || owner == null) {
            return new PopupF7DisplayFieldTree((Frame)owner);
        }
        return new PopupF7DisplayFieldTree((Frame)owner);
    }

    private void initDialog() {
        this.initCtrl();
        KDPanel panTemp = new KDPanel();
        this.initUIContentLayout(panTemp);
        this.installListener();
        this.initTree();
        this.setSize(panTemp.getWidth(), panTemp.getHeight());
        this.setLocationRelativeTo(null);
        this.setTitle(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label41"));
    }

    private void initCtrl() {
        this.kDTreeView1 = new KDTreeView();
        this.kDTreeView1.setMinimumSize(new Dimension(10, 10));
        this.kDTreeView1.setName("kDTreeView1");
        this.kDSeparator2 = new KDSeparator();
        this.kDSeparator2.setName("kDSeparator2");
        this.btnOk = new KDButton();
        this.btnOk.setName("kDButton1");
        this.btnOk.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label42"));
        this.btnCancel = new KDButton();
        this.btnCancel.setName("kDButton2");
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label43"));
        this.kDTree1 = new KDTree();
        this.kDTree1.setName("kDTree1");
        this.kDTreeView1.setTree(this.kDTree1);
    }

    private void initUIContentLayout(KDPanel panTemp) {
        panTemp.setBounds(new Rectangle(10, 10, 480, 520));
        panTemp.setLayout((LayoutManager)new KDLayout());
        panTemp.setOpaque(false);
        panTemp.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 480, 520));
        this.kDTreeView1.setBounds(new Rectangle(4, 4, 472, 473));
        panTemp.add((Component)this.kDTreeView1, (Object)new KDLayout.Constraints(4, 4, 472, 473, 418));
        this.kDSeparator2.setBounds(new Rectangle(-1, 483, 483, 10));
        panTemp.add((Component)this.kDSeparator2, (Object)new KDLayout.Constraints(-1, 483, 483, 10, 14));
        this.btnOk.setBounds(new Rectangle(319, 490, 73, 21));
        panTemp.add((Component)this.btnOk, (Object)new KDLayout.Constraints(319, 490, 73, 21, 10));
        this.btnCancel.setBounds(new Rectangle(401, 490, 73, 21));
        panTemp.add((Component)this.btnCancel, (Object)new KDLayout.Constraints(401, 490, 73, 21, 10));
        this.getContentPane().add((Component)panTemp, "Center");
    }

    private void installListener() {
        this.kDTree1.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(PopupF7DisplayFieldTree.this.kDTree1.getModel().getRoot())) {
                    PopupF7DisplayFieldTree.this.kDTree1.expandPath(new TreePath(PopupF7DisplayFieldTree.this.kDTree1.getModel().getRoot()));
                }
            }
        });
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PopupF7DisplayFieldTree.this.kDTree1_mouseClicked(e);
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupF7DisplayFieldTree.this.btnOk_actionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupF7DisplayFieldTree.this.btnCancel_actionPerformed();
            }
        });
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree1.setShowsRootHandles(true);
        this.kDTree1.setRootVisible(false);
    }

    private void kDTree1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.addQueryInfo();
        }
    }

    public void show() {
        if (!StringUtil.equals((String)this.oldQueryInfo, (String)this.newQueryInfo)) {
            this.resetTreeModel();
            this.setOldQueryInfo(this.newQueryInfo);
        }
        super.show();
    }

    public void resetTreeModel() {
        DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
        if (this.newQueryInfo.length() != 0) {
            try {
                IObjectValue bosObj = CtrlDesignUtil.getBosObj(MetaDataTypeList.JOINQUERY, this.newQueryInfo);
                QueryInfo queryInfo = (QueryInfo)bosObj;
                DefaultKingdeeTreeNode nodeTable = new DefaultKingdeeTreeNode((Object)(queryInfo.getAlias() + "(" + queryInfo.getName() + ")"));
                for (QueryFieldInfo qfi : queryInfo.getSelector().getFields()) {
                    DefObj def = new DefObj(){

                        public String toString() {
                            return this.getAliasName() + "(" + this.getName() + ")";
                        }
                    };
                    def.setName(qfi.getName());
                    def.setAlias(qfi.getDisplayName());
                    nodeTable.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)def));
                }
                newRoot.add((MutableTreeNode)nodeTable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)newRoot);
        this.kDTree1.expandAllNodes(true, (TreeNode)newRoot);
    }

    private void addQueryInfo() {
        this.fullName = null;
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            DefObj def = (DefObj)selectedNode.getUserObject();
            this.fullName = def.getName();
            this.closeWin(true);
        }
    }

    private void btnOk_actionPerformed() {
        this.addQueryInfo();
    }

    private void btnCancel_actionPerformed() {
        this.closeWin(false);
    }

    private void closeWin(boolean flag) {
        this.isOk = flag;
        this.dispose();
    }

    public Object getData() {
        return this.fullName;
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    public String getOldQueryInfo() {
        return this.oldQueryInfo;
    }

    public void setOldQueryInfo(String oldQueryInfo) {
        this.oldQueryInfo = oldQueryInfo;
    }

    public String getNewQueryInfo() {
        return this.newQueryInfo;
    }

    public void setNewQueryInfo(String newQueryInfo) {
        this.newQueryInfo = newQueryInfo;
    }
}

