/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.bo.BlobBO;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractPreviewKSQLPanelUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.CurrentSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ExecuteKSQLUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ReportCommonFilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class PreviewKSQLPanelUI
extends AbstractPreviewKSQLPanelUI {
    private static final long serialVersionUID = -4330303623770370806L;
    private static final Logger logger = CoreUIObject.getLogger(PreviewKSQLPanelUI.class);
    private boolean isinitLayout = false;
    private String solutionID;
    private String parameterXmlString;
    private int shareType;
    private boolean isShowPreviewUI = true;
    private HashMap logMap = new HashMap();
    private CtrlDesignQueryModel model = DesignUI.getInstance().getModel();
    private MacroVO macro;

    public PreviewKSQLPanelUI(CtrlDesignQueryModel model, MacroVO macro) throws Exception {
        this(model);
        this.macro = macro;
    }

    public PreviewKSQLPanelUI(CtrlDesignQueryModel model) throws Exception {
        this();
        this.model = model;
    }

    public PreviewKSQLPanelUI() throws Exception {
        this.spnTop.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
        this.initLayout();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    @Override
    protected void btnSQL_actionPerformed(ActionEvent e) throws Exception {
        CurrentSQLUI ui = new CurrentSQLUI();
        ui.setLogMap(this.logMap);
        ReportDialog.showDialog((CoreUIObject)ui, MessageUtil.getMsgInfo("label257"), true);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.preview(true, false);
    }

    @Override
    protected void btnSettingArgs_actionPerformed(ActionEvent e) throws Exception {
        this.preview(false, false);
    }

    private boolean isContineSearch(boolean isVisible) throws Exception {
        boolean isContinue = true;
        String paramRelationFullName = CtrlReportUtil.getObjectString(this.model.getCommonQuery().getProperty(CtrlDesignUtil.ParamRelationFullName));
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        DefaultArgInput argUI = new DefaultArgInput(paramRelationFullName, sourceReportOrgID);
        List params = this.model.getCommonQuery().getParameters();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (!isVisible && params != null) {
            for (int i = 0; i < params.size(); ++i) {
                DesignParameter dp = (DesignParameter)((Object)params.get(i));
                InputType inputType = dp.getInputType();
                if (inputType == InputType.Separator || inputType == InputType.EMPTY || dp.getInputState() != InputState.HIDDEN) continue;
                dp.setInputState(InputState.READONLY);
                indexes.add(i);
            }
        }
        argUI.createParametersUI(params);
        ReportCommonFilterUI commonFilterUI = new ReportCommonFilterUI((JPanel)((Object)argUI), DesignUI.getInstance().getEditID(), this.solutionID, this.parameterXmlString, this.shareType);
        if (isVisible) {
            ReportDialog.showDialog((CoreUIObject)commonFilterUI, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label35"), true, false, SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            new KDDialog().add((Component)((Object)commonFilterUI));
            commonFilterUI.onLoad();
            commonFilterUI.btnConfirm_actionPerformed(null);
            for (Integer i : indexes) {
                ((DesignParameter)((Object)params.get(i))).setInputState(InputState.HIDDEN);
            }
        }
        if (commonFilterUI.isOk()) {
            this.solutionID = commonFilterUI.getSolutionID();
            this.parameterXmlString = commonFilterUI.getParameterXmlString();
            this.shareType = commonFilterUI.getShareType();
        } else {
            isContinue = false;
        }
        return isContinue;
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    private void clearRows() {
        this.tblContent.removeColumns();
    }

    public static final int addResultSet(KDTable tblContent, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        PreviewKSQLPanelUI.setTaleHeader(tblContent, rs, model);
        return PreviewKSQLPanelUI.bindResultSet(tblContent, rs);
    }

    public boolean showFilterDialog() throws Exception {
        boolean isContinue = true;
        List lstParam = this.model.getCommonQuery().getParameters();
        if (ExecuteKSQLUI.isAllParamsHidden(lstParam)) {
            isContinue = this.isContineSearch(false);
            this.parameterXmlString = CtrlDesignUtil.toFilterSolutionXmlByDesignParameter((ArrayList)lstParam);
        } else if (null != lstParam && !lstParam.isEmpty()) {
            isContinue = this.isContineSearch(true);
        }
        return isContinue;
    }

    static HashMap getExecuteParam(CtrlDesignQueryModel model, String parameterXmlString) throws JDOMException, IOException {
        HashMap mapDesignParameter = RunReportParam.ChangWhereValueToMapParams(parameterXmlString);
        if (!mapDesignParameter.isEmpty()) {
            List currentList = model.getCommonQuery().getParameters();
            RunReportParam.getExecuteParam(currentList, mapDesignParameter);
        }
        InnerParam.putClientDefalutListParamsMap(mapDesignParameter);
        return mapDesignParameter;
    }

    public boolean preview(boolean isRefresh, boolean isFromDesign) {
        try {
            SQLCustomType customType;
            if (!isRefresh && !this.showFilterDialog()) {
                if (isFromDesign) {
                    this.isShowPreviewUI = false;
                }
                return false;
            }
            HashMap mapDesignParameter = PreviewKSQLPanelUI.getExecuteParam(this.model, this.parameterXmlString);
            this.clearRows();
            int rowCount = this.getTopNumber();
            if (this.macro != null) {
                rowCount = -1;
                if (this.macro.getMacro() != null && this.macro.getMacro().vType() == ExtRptMacroType.VType.SINGLE) {
                    rowCount = 1;
                }
            }
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            IRowSet rs = null;
            try {
                HashMap mapResult = CtrlDesignDataExecutor.execute(null, this.model, mapDesignParameter, this.logMap, 0, rowCount, false, null);
                rs = (IRowSet)mapResult.get("6xx8xxRowset");
            }
            catch (CtrlReportException e) {
                if (isFromDesign) {
                    this.getUIContext().put("report_ui_error", e);
                } else {
                    MessageUtil.showDetailAndOK(null, e.getMessage(), e);
                }
                return false;
            }
            PreviewKSQLPanelUI.addResultSet(this.tblContent, (ResultSet)rs, this.model);
            HashMap mapRepeatName = new HashMap();
            ResultSetMetaData rsmd = rs.getMetaData();
            String repeatName = null;
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i + 1).toUpperCase();
                if (mapRepeatName.containsKey(name)) {
                    repeatName = name;
                    break;
                }
                mapRepeatName.put(name, null);
            }
            if ((customType = DesignUI.getInstance().getCustomType()).equals(SQLCustomType.PROCEDURE) || customType.equals(SQLCustomType.JAVA)) {
                OutputFieldsUI.setOutputColumns(this.model, (ResultSet)rs, false);
            } else {
                IQuery quer = this.model.getQuery();
                if (quer.getQueryType() == QueryType.SQL_CUSTOM) {
                    OutputFieldsUI.setOutputColumns(this.model, (ResultSet)rs, false);
                }
            }
            if (rs != null) {
                rs.close();
            }
            this.isTextErrVisible(false);
            if (repeatName != null) {
                String msg1 = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label170");
                String msg2 = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label171");
                String msg = msg1 + repeatName + msg2;
                this.lbMsg.setText(msg);
            }
        }
        catch (Exception e) {
            if (isFromDesign) {
                this.getUIContext().put("report_ui_error", CtrlReportException.makeException(MessageUtil.getMsgInfo("label186"), e));
            }
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label186"), e);
        }
        return true;
    }

    public static OutputColumns parseRSMD(ResultSetMetaData rsmd) throws SQLException {
        OutputColumns columns = new OutputColumns();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i + 1);
            DataType dt = DataType.fromJdbcType((int)rsmd.getColumnType(i + 1));
            Column oc = new Column();
            oc.setName(name);
            PreviewKSQLPanelUI.setDefMulLangMap((DefObj)oc, "alias", name);
            oc.setDataType(dt);
            columns.add((Object)oc);
        }
        return columns;
    }

    public static final void setDefMulLangMap(DefObj def, String keyName, String currentName) {
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo li = lc.get(i);
            String localString = li.getLocaleString();
            def.setProperty(keyName + "." + localString, (Object)currentName);
        }
        def.setProperty(keyName, (Object)"#1");
    }

    public static final void setTaleHeader(KDTable table, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        int cols = rs.getMetaData().getColumnCount();
        ArrayList<StyleAttributes> colums = new ArrayList<StyleAttributes>();
        ArrayList<Integer> columsWidth = new ArrayList<Integer>();
        for (int i = 0; i < cols; ++i) {
            if (table.getColumn(i) != null) {
                colums.add(table.getColumn(i).getStyleAttributes());
                columsWidth.add(table.getColumn(i).getWidth());
                continue;
            }
            colums.add(null);
            columsWidth.add(null);
        }
        table.removeColumns();
        table.addColumns(cols);
        HashMap oldNameAlisaMap = OutputFieldsUI.getNameAlisaMapFromModel(model);
        String[] colFields = new String[cols];
        IRow headRow = table.addHeadRow();
        int headRowHeight = table.getHead().getHeight();
        headRow.setHeight(headRowHeight);
        for (int i = 0; i < cols; ++i) {
            String rowHeader = rs.getMetaData().getColumnName(i + 1);
            if (oldNameAlisaMap.containsKey(rowHeader.toUpperCase())) {
                Column oc = (Column)oldNameAlisaMap.get(rowHeader.toUpperCase());
                rowHeader = oc.getAlias();
            }
            headRow.getCell(i).setValue((Object)rowHeader);
            colFields[i] = rowHeader;
            table.getColumn(i).setKey(rowHeader);
            if (colums.get(i) != null) {
                table.getColumn(i).setStyleAttributes((StyleAttributes)colums.get(i));
            }
            if (columsWidth.get(i) == null) continue;
            table.getColumn(i).setWidth((Integer)columsWidth.get(i) == 0 ? 1 : (Integer)columsWidth.get(i));
        }
        table.putBindContents("member", colFields);
        table.checkParsed();
    }

    public static final int bindResultSet(KDTable table, ResultSet rs) throws SQLException {
        int bindRow = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int row = 0;
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            IRow irow = table.addRow();
            for (int col = 0; col < cols; ++col) {
                Object value = rs.getObject(col + 1);
                int type = rsmd.getColumnType(col + 1);
                if (type == 2004) {
                    value = BlobBO.readBlob(rs, col + 1);
                }
                value = RunReportParam.getOracleDateValue(value);
                table.getCell(row, col).setValue(value);
                map.put(rsmd.getColumnName(col + 1).toLowerCase(), value);
            }
            irow.setUserObject(map);
            ++row;
            ++bindRow;
        }
        return bindRow;
    }

    private void isTextErrVisible(boolean isShowErr) {
        this.kDScrollPane1.setVisible(isShowErr);
        this.tblContent.setVisible(!isShowErr);
    }

    public boolean isShowPreviewUI() {
        return this.isShowPreviewUI;
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }

    public void configBtn4MacroPreview() {
        ICell cll;
        this.remove((Component)this.btnSQL);
        this.remove((Component)this.btnRefresh);
        this.remove((Component)this.btnSettingArgs);
        this.remove((Component)this.kDLabel1);
        this.remove((Component)this.spnTop);
        this.remove((Component)this.tblContent);
        IRow row = this.tblContent.getHeadRow(0);
        if (row != null && (cll = row.getCell(0)) != null) {
            cll.setValue((Object)(String.valueOf(cll.getValue()) + "\uff08\u5b8f\u503c\uff09"));
        }
        this.tblContent.setBounds(new Rectangle(8, 8, 783, 520));
        this.add((Component)this.tblContent, new KDLayout.Constraints(0, 0, 788, 546, 15));
    }
}

