/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.bos.ctrl.semantic.use.client.SemanticUseEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OrderUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutDBTabUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.Semantic2Model;

public class SemanticUI
extends BaseTabUIImp {
    private static SemanticUI MY_INST;
    private SemanticUseEditor _editor;
    private CtrlDesignQueryModel _model;
    private boolean _isDirty;

    public static final SemanticUI getInstance() {
        if (MY_INST == null) {
            MY_INST = new SemanticUI();
            SemanticUI.MY_INST._model = DesignUI.getInstance().getModel();
        }
        return MY_INST;
    }

    public static final void destroy() {
        MY_INST = null;
    }

    @Override
    public KDPanel getPanel() {
        if (this._editor == null) {
            this._editor = new SemanticUseEditor();
            this._editor.setCommunicatingBridge(new CommunicatingBridge());
        }
        return this._editor;
    }

    @Override
    public void syncModel2Ui() {
        SemanticUsetimeModel model = this._model.getCommonQuery().getSemanticModel();
        if (model != null) {
            this._editor.setEditData(model);
        }
        this._isDirty = false;
    }

    @Override
    public void syncUi2Model() {
        SemanticUsetimeModel semanticModel = this._editor.getEditResult();
        if (semanticModel == null) {
            return;
        }
        if (semanticModel.isInvalid()) {
            if (this._isDirty) {
                semanticModel.setInvalid(false);
            } else {
                return;
            }
        }
        Semantic2Model.trans(semanticModel, this._editor.getEditResultsMetas(), this._model);
        if (this._isDirty) {
            OutputFieldsUI.getInstance().syncModel2Ui();
            this._isDirty = false;
        }
    }

    private class CommunicatingBridge
    implements SemanticUseEditor.IBridge {
        private CommunicatingBridge() {
        }

        @Override
        public void contentChanged() {
            SemanticUI.this._isDirty = true;
            this.dirtyOthers();
        }

        @Override
        public void schemaChanged(SchemaBriefModel newSchema) {
            this.dirtyOthers();
            if (newSchema.isCurrentDs()) {
                OutDBTabUI.getInstance().updateData(null);
            } else {
                OutDBTabUI.getInstance().updateData(newSchema.getOutsideDb());
            }
        }

        private void dirtyOthers() {
            FilterUI.refreshFromModel(true);
            OrderUI.refreshFromModel(true);
            SqlUI.refreshFromModel(true);
        }

        @Override
        public String getOutsideDb() {
            return ((CtrlDesignKsqlQuery)SemanticUI.this._model.getQuery()).getOutDB();
        }
    }
}

