/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractSetupAloneBoxUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.AloneBoxSelectedState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputCtrlImpl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SetupAloneBoxUI
extends AbstractSetupAloneBoxUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SetupAloneBoxUI.class);
    private boolean isCancel = false;
    private InputType inputType;
    InputCtrlImpl inputCtrl;
    DesignDataType dataType;
    private KDComboBox kDComboBox = new KDComboBox((Object[])AloneBoxSelectedState.State_TYPES);

    public void setValueFromParam(DesignParameter p) throws Exception {
        this.dataType = p.getDesignDataType();
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (inputCtrl != null) {
            DefObj defValue = inputCtrl.getDefValue();
            this.txtSelectedValue.setText(defValue.getName());
            this.txtSelectedAlias.setText(defValue.getAlias());
            DefObj defDisplay = inputCtrl.getDefDisplay();
            this.txtNoSelectedValue.setText(defDisplay.getName());
            this.txtNoSelectedAlias.setText(defDisplay.getAlias());
            if (!StringUtil.isEmptyString((String)p.getDefaultValue())) {
                this.kDComboBox.setSelectedIndex(StringUtil.equals((String)String.valueOf(1), (String)p.getDefaultValue()) ? 0 : 1);
            }
        }
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String selectedValue = this.txtSelectedValue.getText().trim();
        String noSelectedValue = this.txtNoSelectedValue.getText().trim();
        if (!selectedValue.equals("")) {
            if (this.dataType.equals(DesignDataType.NUMERICAL)) {
                if (!selectedValue.matches("(-|\\+)?\\d+\\.?\\d*")) {
                    MessageUtil.showInfo("label415", true);
                    this.txtSelectedValue.requestFocus();
                    return;
                }
            } else if (this.dataType.equals(DesignDataType.BOOLEAN) && !selectedValue.equalsIgnoreCase("true") && !selectedValue.equalsIgnoreCase("false")) {
                MessageUtil.showInfo("label422", true);
                this.txtSelectedValue.requestFocus();
                return;
            }
        }
        if (!noSelectedValue.equals("")) {
            if (this.dataType.equals(DesignDataType.NUMERICAL)) {
                if (!noSelectedValue.matches("(-|\\+)?\\d+\\.?\\d*")) {
                    MessageUtil.showInfo("label415", true);
                    this.txtNoSelectedValue.requestFocus();
                    return;
                }
            } else if (this.dataType.equals(DesignDataType.BOOLEAN) && !noSelectedValue.equalsIgnoreCase("true") && !noSelectedValue.equalsIgnoreCase("false")) {
                MessageUtil.showInfo("label422", true);
                this.txtNoSelectedValue.requestFocus();
                return;
            }
        }
        this.inputCtrl = new InputCtrlImpl();
        this.inputCtrl.setInputType(this.inputType);
        DefObj defValue = new DefObj();
        defValue.setName(selectedValue);
        defValue.setAlias(this.txtSelectedAlias.getText().trim());
        DefObj defDisplay = new DefObj();
        defDisplay.setName(noSelectedValue);
        defDisplay.setAlias(this.txtNoSelectedAlias.getText().trim());
        this.inputCtrl.setDefValue(defValue);
        this.inputCtrl.setDefDisplay(defDisplay);
        this.isCancel = false;
        this.closeWin();
    }

    public InputCtrlImpl getInputCtrl() {
        return this.inputCtrl;
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public AloneBoxSelectedState getDefaultValue() {
        return (AloneBoxSelectedState)this.kDComboBox.getSelectedItem();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 486, 295));
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 486, 295));
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "\u6570\u636e\u6765\u6e90"));
        this.btnOK.setBounds(new Rectangle(324, 241, 73, 21));
        this.add((Component)this.btnOK, new KDLayout.Constraints(324, 241, 73, 21, 0));
        this.btnCancel.setBounds(new Rectangle(400, 241, 73, 21));
        this.add((Component)this.btnCancel, new KDLayout.Constraints(400, 241, 73, 21, 0));
        this.kDSeparator4.setBounds(new Rectangle(-3, 233, 491, 8));
        this.add((Component)this.kDSeparator4, new KDLayout.Constraints(-3, 233, 491, 8, 0));
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        panel.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "\u9ed8\u8ba4\u503c"));
        panel.setBounds(new Rectangle(5, 140, 474, 85));
        this.add((Component)panel, new KDLayout.Constraints(5, 140, 474, 85, 0));
        KDLabelContainer lc = new KDLabelContainer("\u9ed8\u8ba4\u503c   ", (JComponent)this.kDComboBox);
        lc.setBoundLabelUnderline(true);
        lc.setBounds(new Rectangle(18, 36, 209, 19));
        panel.add((Component)lc);
    }
}

