/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.AbstractSetupSpinnerUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputCtrlImpl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SetupSpinnerUI
extends AbstractSetupSpinnerUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SetupSpinnerUI.class);
    private boolean isCancel = false;
    private InputType inputType;
    InputCtrlImpl inputCtrl;
    private KDTextField defaultValueField = new KDTextField();

    public void setValueFromParam(DesignParameter p) throws Exception {
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (inputCtrl != null) {
            DefObj def = inputCtrl.getDefValue();
            String value = def.getName();
            String[] valueArr = value.split(";");
            this.txtUpperLimit.setText(valueArr[0]);
            this.txtLowerLimit.setText(valueArr[1]);
            this.txtStep.setText(valueArr[2]);
            if (!StringUtil.isEmptyString((String)p.getDefaultValue())) {
                this.defaultValueField.setText(p.getDefaultValue());
            } else {
                this.defaultValueField.setText(valueArr[1]);
            }
        }
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal def;
        String upperLimit = this.txtUpperLimit.getText().trim();
        if (!this.isNumber(upperLimit)) {
            return;
        }
        String lowerLimit = this.txtLowerLimit.getText().trim();
        if (!this.isNumber(lowerLimit)) {
            return;
        }
        String step = this.txtStep.getText().trim();
        if (!this.isNumber(step)) {
            return;
        }
        String num = this.defaultValueField.getText().trim();
        if (!StringUtil.isEmptyString((String)num) && !this.isNumber(num)) {
            return;
        }
        BigDecimal max = new BigDecimal(upperLimit);
        BigDecimal min = new BigDecimal(lowerLimit);
        if (!(StringUtil.isEmptyString((String)num) || max.compareTo(def = new BigDecimal(Double.valueOf(num))) >= 0 && min.compareTo(def) <= 0)) {
            MessageUtil.showInfo("\u9ed8\u8ba4\u503c\u8d85\u9650\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01", false);
            this.defaultValueField.requestFocus();
            return;
        }
        String name = upperLimit + ";" + lowerLimit + ";" + step;
        this.inputCtrl = new InputCtrlImpl();
        this.inputCtrl.setInputType(this.inputType);
        DefObj def2 = new DefObj();
        def2.setName(name);
        this.inputCtrl.setDefValue(def2);
        this.isCancel = false;
        this.closeWin();
    }

    private boolean isNumber(String value) {
        if (value == null) {
            return false;
        }
        if (!value.matches("(-|\\+)?\\d+\\.?\\d*")) {
            MessageUtil.showInfo("label415", true);
            this.defaultValueField.requestFocus();
            return false;
        }
        return true;
    }

    public InputCtrlImpl getInputCtrl() {
        return this.inputCtrl;
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getSpinnerValue() {
        return NumberUtil.cutZero((String)CtrlReportUtil.getObjectString(this.defaultValueField.getText().trim()));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 286, 295));
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 286, 295));
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "\u6570\u636e\u6765\u6e90"));
        this.btnOK.setBounds(new Rectangle(124, 241, 73, 21));
        this.add((Component)this.btnOK, new KDLayout.Constraints(124, 241, 73, 21, 0));
        this.btnCancel.setBounds(new Rectangle(200, 241, 73, 21));
        this.add((Component)this.btnCancel, new KDLayout.Constraints(200, 241, 73, 21, 0));
        this.kDSeparator4.setBounds(new Rectangle(-3, 233, 291, 8));
        this.add((Component)this.kDSeparator4, new KDLayout.Constraints(-3, 233, 291, 8, 0));
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        panel.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "\u9ed8\u8ba4\u503c"));
        panel.setBounds(new Rectangle(5, 140, 274, 85));
        this.add((Component)panel, new KDLayout.Constraints(5, 140, 274, 85, 0));
        KDLabelContainer lc = new KDLabelContainer("\u9ed8\u8ba4\u503c\uff1a   ", (JComponent)this.defaultValueField);
        lc.setBoundLabelUnderline(true);
        lc.setBounds(new Rectangle(35, 36, 209, 19));
        panel.add((Component)lc);
    }
}

