/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.wizard.common.CustomTextEditor;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.pd.SystemParameterSelectUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SqlUI
extends BaseTabUIImp {
    private static SqlUI sqlUI = null;
    private CtrlDesignQueryModel model = null;
    private ContentPane contentPane = new ContentPane(this);

    private SqlUI() {
        this.contentPane.addUpdateSQLListener(new UpdateSQLHandler());
    }

    public static final SqlUI getInstance() {
        if (sqlUI == null) {
            sqlUI = new SqlUI();
        }
        SqlUI.sqlUI.model = DesignUI.getInstance().getModel();
        return sqlUI;
    }

    public static final SqlUI getNewInstance(CtrlDesignQueryModel model) {
        SqlUI ui = new SqlUI();
        ui.model = model;
        return ui;
    }

    public static final void destroy() {
        sqlUI = null;
    }

    public static void refreshFromModel(boolean isRefreshFromModel) {
        if (sqlUI != null) {
            sqlUI.setRefreshFromModel(isRefreshFromModel);
        }
    }

    @Override
    public KDPanel getPanel() {
        return this.contentPane;
    }

    public void config4MacroUI() {
        this.contentPane.config4MacroUI();
    }

    @Override
    public void syncUi2Model() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        ksqlQuery.setRegular(!this.contentPane.isCustom());
        ksqlQuery.setDistinct(this.contentPane.isDistinct());
        if (this.contentPane.isCustom()) {
            ksqlQuery.setContent(this.contentPane.getEditorData());
        }
    }

    public boolean isSqlCustom() {
        return this.contentPane.isCustom();
    }

    @Override
    public void syncModel2Ui() {
        if (DesignUI.getInstance().isNoFoundQuery()) {
            this.contentPane.showValue(this.model.getQuery());
            return;
        }
        try {
            this.updateSQL();
        }
        catch (BOSException e) {
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label258") + "\r\n" + e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.contentPane.showValue(this.model.getQuery());
    }

    private void updateSQL() throws BOSException {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        if (ksqlQuery.isRegular()) {
            String sql = CtrlDesignQueryModel.makeSQL(this.model);
            this.model.getQuery().setContent(sql);
        }
    }

    static class ContentPane
    extends KDPanel {
        private static final long serialVersionUID = -9018141010951919050L;
        private ResultEditor editor;
        private KDCheckBox chkCustom;
        private KDCheckBox chkDistinct;
        private KDWorkButton btnGetFromWizard;
        private KDWorkButton btnDialect;
        private KDWorkButton insertInnerParam;
        private KDPanel panCard;
        private CardLayout cardLayout;
        private SqlUI ui;
        KDPanel bottomPanel;
        private SystemParameterSelectUI systemParameterSelectUI;

        public ContentPane(SqlUI ui) {
            this.ui = ui;
            this.init();
            this.installListener();
        }

        private void init() {
            this.setOpaque(false);
            this.chkCustom = new KDCheckBox(QueryResource.getString((String)"res_7"));
            this.btnGetFromWizard = new KDWorkButton(QueryResource.getString((String)"res_8"));
            this.chkDistinct = new KDCheckBox(QueryResource.getString((String)"res_9"));
            this.btnDialect = new KDWorkButton(MessageUtil.getMsgInfo("label373"));
            this.insertInnerParam = new KDWorkButton(MessageUtil.getMsgInfo("label448"));
            this.cardLayout = new CardLayout();
            this.panCard = new KDPanel((LayoutManager)this.cardLayout);
            this.panCard.setOpaque(false);
            this.panCard.add((Component)this.btnGetFromWizard, (Object)"custom");
            this.panCard.add((Component)this.chkDistinct, (Object)"wizard");
            this.editor = new ResultEditor((JTextComponent)new ScriptQLStyledEditor());
            this.editor.getWizardButton().setVisible(false);
            this.editor.addButton((JComponent)this.panCard);
            TableLayout tl = TableLayout.splitRow((int)2);
            tl.defaultStyle().setHeight(20);
            tl.rowStyle(0).setPriY(1);
            this.bottomPanel = new KDPanel();
            this.bottomPanel.setLayout((LayoutManager)new FlowLayout(0, 0, 0));
            this.bottomPanel.add((Component)this.chkCustom);
            this.bottomPanel.add((Component)new KDLabel("   "));
            this.bottomPanel.add((Component)this.btnDialect);
            this.bottomPanel.add((Component)new KDLabel("   "));
            this.bottomPanel.add((Component)this.insertInnerParam);
            this.setLayout((LayoutManager)tl);
            this.add((Component)((Object)this.editor), tl.cell(0));
            this.add((Component)this.bottomPanel, tl.cell(1));
            this.syncSelfDef(false);
        }

        private void installListener() {
            this.chkDistinct.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (chkDistinct.isSelected()) {
                        this.addDistinct();
                    } else {
                        this.removeDistinct();
                    }
                }
            });
            this.btnGetFromWizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MessageUtil.showConfirm((Component)((Object)this), QueryResource.getString((String)"res_10"))) {
                        editor.setContent(this.fireUpdateSQLEvent());
                    }
                }
            });
            this.chkCustom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!chkCustom.isSelected()) {
                        if (MessageUtil.showConfirm((Component)((Object)this), QueryResource.getString((String)"res_11"))) {
                            CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)ui.model.getQuery();
                            ksqlQuery.setRegular(true);
                            editor.setContent(this.fireUpdateSQLEvent());
                        } else {
                            chkCustom.setSelected(true);
                        }
                    }
                    this.syncSelfDef(chkCustom.isSelected());
                }
            });
            this.btnDialect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sql = editor.getContent();
                    String sqlTemp = sql.toLowerCase();
                    if (sqlTemp.indexOf("dialect") != -1) {
                        return;
                    }
                    int iSelect = sqlTemp.indexOf("select");
                    if (iSelect == -1) {
                        return;
                    }
                    String before = sql.substring(0, iSelect);
                    String after = sql.substring(iSelect);
                    sql = before.length() > 0 && !before.endsWith("\r\n") ? before + "\r\n/*dialect*/\r\n" + after : before + "/*dialect*/\r\n" + after;
                    editor.setContent(sql);
                }
            });
            this.insertInnerParam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Object data;
                        systemParameterSelectUI = new SystemParameterSelectUI();
                        systemParameterSelectUI.initLayoutSelector();
                        systemParameterSelectUI.onLoadSelector();
                        systemParameterSelectUI.showSelector();
                        systemParameterSelectUI.setSize(new Dimension(systemParameterSelectUI.getWidthSelector(), systemParameterSelectUI.getHeightSelector()));
                        ReportDialog.showDialog(systemParameterSelectUI, Resources.getResourceString("\u6dfb\u52a0\u53d8\u91cf"), true, true, SwingUtilities.getWindowAncestor((Component)((Object)systemParameterSelectUI)));
                        if (!systemParameterSelectUI.isCanceled() && (data = systemParameterSelectUI.getData()) instanceof DefObj) {
                            DefObj innerParam = (DefObj)data;
                            String name = innerParam.getName();
                            JTextComponent area = editor.getTextArea();
                            if (area instanceof ScriptQLStyledEditor) {
                                ScriptQLStyledEditor sqlEditor = (ScriptQLStyledEditor)area;
                                sqlEditor.insertStringAtCurrent(name);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }

        private void addDistinct() {
            String sql = this.editor.getContent();
            if (sql.indexOf("SELECT") != 0) {
                return;
            }
            sql = "SELECT DISTINCT" + sql.substring(6);
            this.editor.setContent(sql);
        }

        private void removeDistinct() {
            String sql = this.editor.getContent();
            sql = sql.replaceFirst("DISTINCT", "");
            this.editor.setContent(sql);
        }

        private void syncSelfDef(boolean isSelfDef) {
            if (isSelfDef) {
                this.cardLayout.show((Container)this.panCard, "custom");
            } else {
                this.cardLayout.show((Container)this.panCard, "wizard");
            }
            this.editor.setResultEditable(isSelfDef);
            this.btnDialect.setEnabled(isSelfDef);
            this.insertInnerParam.setEnabled(isSelfDef);
        }

        public void setEditorData(String content) {
            this.editor.setContent(content);
        }

        public String getEditorData() {
            return this.editor.getContent();
        }

        public void showValue(IQuery query) {
            this.editor.setContent(query.getContent());
            this.chkDistinct.setSelected(query.isDistinct());
            this.chkCustom.setSelected(query.getQueryType() == QueryType.SQL_CUSTOM);
            this.syncSelfDef(this.chkCustom.isSelected());
        }

        public boolean isDistinct() {
            return this.chkDistinct.isSelected();
        }

        public boolean isCustom() {
            return this.chkCustom.isSelected();
        }

        public void addUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.add(UpdateSQLListener.class, l);
        }

        public void removeUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.remove(UpdateSQLListener.class, l);
        }

        protected String fireUpdateSQLEvent() {
            UpdateSQLEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != UpdateSQLListener.class) continue;
                if (event == null) {
                    event = new UpdateSQLEvent((Object)this);
                }
                return ((UpdateSQLListener)listeners[i + 1]).update(event);
            }
            return "";
        }

        void config4MacroUI() {
            this.chkCustom.setVisible(false);
            this.chkCustom.setEnabled(false);
            this.chkCustom.setSelected(true);
            this.bottomPanel.removeAll();
            this.bottomPanel.setLayout((LayoutManager)new FlowLayout(0, 3, 8));
            this.bottomPanel.add((Component)this.btnDialect);
            this.btnDialect.setEnabled(true);
            this.panCard.remove((Component)this.chkDistinct);
            this.panCard.remove((Component)this.btnGetFromWizard);
            this.editor.setResultEditable(true);
        }

        public class UpdateSQLEvent
        extends EventObject {
            private static final long serialVersionUID = 8383157176869550273L;

            public UpdateSQLEvent(Object source) {
                super(source);
            }
        }

        public static interface UpdateSQLListener
        extends EventListener {
            public String update(UpdateSQLEvent var1);
        }

        private class ResultEditor
        extends CustomTextEditor {
            private static final long serialVersionUID = -8296250629667563404L;

            public ResultEditor(JTextComponent txtComp) {
                super(txtComp);
                this.setTitle("SQL:");
            }

            public ResultEditor() {
                this.setTitle("SQL:");
            }

            public FormulaWizardEditor getFormulaEditor() {
                return this.formula;
            }
        }
    }

    private class UpdateSQLHandler
    implements ContentPane.UpdateSQLListener {
        private UpdateSQLHandler() {
        }

        @Override
        public String update(ContentPane.UpdateSQLEvent event) {
            try {
                return CtrlDesignQueryModel.makeSQL(SqlUI.this.model);
            }
            catch (BOSException e) {
                MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label258") + "\r\n" + e.getMessage(), (Exception)((Object)e));
                return "";
            }
        }
    }
}

