/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.BaseTabUISelectorImp;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FieldUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FilterBosTypeUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.FilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.JoinUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.OrderUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.SqlUI;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.NoFoundQueryException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TableUI
extends BaseTabUISelectorImp {
    private static final long serialVersionUID = -4648949465604252137L;
    private static Logger log = LogUtil.getPackageLogger(TableUI.class);
    private KDTreeView kDTreeView1;
    private KDTree kDTree1;
    private KDWorkButton wbFilter;
    private ActionRename actionRename;
    private HashMap mapFilter;
    private DefaultKingdeeTreeNode newRootOriSelected = null;
    private static CtrlDesignQueryModel model = null;
    private static KsqlObjectSelector selector = null;
    private static TableUI tableUI = null;

    private TableUI() {
        this.initCtrl();
        this.installListener();
        this.initTree();
    }

    public static final TableUI getInstance() {
        if (tableUI == null) {
            model = DesignUI.getInstance().getModel();
            selector = model.getObjectSelector();
            tableUI = new TableUI();
        }
        return tableUI;
    }

    public static final void destroy() {
        tableUI = null;
    }

    @Override
    public KDPanel getPanel() {
        KDPanel panTemp = new KDPanel((LayoutManager)new BorderLayout());
        panTemp.setOpaque(false);
        panTemp.add((Component)((Object)tableUI));
        return panTemp;
    }

    private void initCtrl() {
        this.actionRename = new ActionRename();
        this.getSelected().addButton((Action)this.actionRename, "edit");
        this.getSelected().syncBtn();
        this.enableSelect(false);
        this.enableSelectAll(false);
        this.kDTreeView1 = new KDTreeView();
        this.kDTreeView1.setMinimumSize(new Dimension(10, 10));
        this.kDTreeView1.setName("kDTreeView1");
        this.wbFilter = new KDWorkButton((Icon)Resource.ICON_FILTER);
        this.wbFilter.setToolTipText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label45"));
        this.kDTreeView1.getControlPane().add((Component)this.wbFilter);
        this.kDTree1 = new KDTree();
        this.kDTree1.setName("kDTree1");
        this.kDTreeView1.setTree(this.kDTree1);
        this.setSupplyTitle(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label48"));
        this.setSelectedTitle(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label49"));
        this.setSupplyCtrlNoScroll((JComponent)this.kDTreeView1);
        this.mapFilter = new HashMap();
        this.mapFilter.put("name", "");
        this.mapFilter.put("alias", "");
        this.mapFilter.put("joinQuery", "true");
        this.mapFilter.put("unionQuery", "true");
        this.mapFilter.put("dataTable", "true");
        this.mapFilter.put("F7", "false");
    }

    private void installListener() {
        this.kDTree1.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableUI.this.kDTree1_mouseClicked(e);
            }
        });
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TableUI.this.setSelectBtn();
            }
        });
        this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableUI.this.actionRename.editTable();
                    return;
                }
                Object obj = ((KDList)e.getSource()).getSelectedValue();
                if (obj instanceof ITable) {
                    String expr = ((ITable)obj).getExpr();
                    expr = CtrlDesignUtil.getDesignTableExp(expr);
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)TableUI.this.kDTree1.getModel().getRoot();
                    TableUI.this.expandSelected(root, expr);
                }
            }
        });
        this.wbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUI.this.btnFilter_actionPerformed();
            }
        });
    }

    private void initTree() {
        DefaultKingdeeTreeNode nodeRoot = CtrlDesignFinal.getDesignRoot();
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(true);
        this.kDTree1.getSelectionModel().setSelectionMode(4);
        this.kDTree1.setAutoscrolls(true);
    }

    private boolean expandSelected(DefaultKingdeeTreeNode nodeRoot, String selectedPath) {
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)repNode.getUserObject();
            if (bvNode.getFullName().equals(selectedPath)) {
                Object[] pathtoRoot = repNode.getPath();
                TreePath path = new TreePath(pathtoRoot);
                this.kDTree1.expandPath(path);
                this.kDTree1.setSelectionPath(path);
                this.kDTree1.scrollPathToVisible(path);
                flag = false;
                break;
            }
            flag = this.expandSelected(repNode, selectedPath);
            if (flag) continue;
            break;
        }
        return flag;
    }

    private void kDTree1_mouseClicked(MouseEvent e) {
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            try {
                this.addNodeToList();
            }
            catch (BOSException be) {
                log.error((Object)be);
            }
        }
    }

    private void setSelectBtn() {
        boolean flag = true;
        TreePath[] paths = this.kDTree1.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
            BOSObjectType type = bvNode.getMetaDataType();
            if (!CtrlDesignFinal.isMetaDataTypes(type)) {
                flag = false;
                break;
            }
            flag = true;
        }
        this.enableSelect(flag);
    }

    private void btnFilter_actionPerformed() {
        try {
            FilterBosTypeUI typeUI = new FilterBosTypeUI(this.mapFilter);
            ReportDialog.showDialog((CoreUIObject)typeUI, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label45"), true, false);
            if (typeUI.isOk()) {
                this.mapFilter = typeUI.getMapData();
                FilterNode filterNode = FilterNode.getInstance();
                filterNode.setCondition(this.mapFilter);
                DefaultKingdeeTreeNode oldRoot = CtrlDesignFinal.getDesignRoot();
                DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
                newRoot.setText(oldRoot.getText());
                newRoot.setCustomIcon(oldRoot.getCustomIcon());
                newRoot.setAllowsChildren(oldRoot.getAllowsChildren());
                newRoot.setUserObject(oldRoot.getUserObject());
                TreePath path = this.kDTree1.getSelectionPath();
                DefaultKingdeeTreeNode nodeOriSelected = null;
                String strOriSelected = null;
                if (path != null) {
                    nodeOriSelected = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    IBriefViewTreeNode bvOriSelected = (IBriefViewTreeNode)nodeOriSelected.getUserObject();
                    strOriSelected = bvOriSelected.getFullName();
                }
                this.newRootOriSelected = null;
                this.doFilter(oldRoot, newRoot, strOriSelected);
                ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)newRoot);
                this.kDTree1.setSelectionNode(this.newRootOriSelected);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    private void doFilter(DefaultKingdeeTreeNode oldRoot, DefaultKingdeeTreeNode newRoot, String strOriSelected) {
        int nodeCount = oldRoot.getChildCount();
        for (int j = 0; j < nodeCount; ++j) {
            DefaultKingdeeTreeNode newNode;
            DefaultKingdeeTreeNode oldNode = (DefaultKingdeeTreeNode)oldRoot.getChildAt(j);
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)oldNode.getUserObject();
            if (bvNode.isPackage()) {
                newNode = new DefaultKingdeeTreeNode();
                newNode.setText(oldNode.getText());
                newNode.setCustomIcon(oldNode.getCustomIcon());
                newNode.setAllowsChildren(oldNode.getAllowsChildren());
                newNode.setUserObject(oldNode.getUserObject());
                newRoot.add((MutableTreeNode)newNode);
                if (bvNode.getFullName().equals(strOriSelected)) {
                    this.newRootOriSelected = newNode;
                }
                this.doFilter(oldNode, newNode, strOriSelected);
                continue;
            }
            if (FilterNode.getInstance().isHiden(bvNode)) continue;
            newNode = new DefaultKingdeeTreeNode();
            newNode.setText(oldNode.getText());
            newNode.setCustomIcon(oldNode.getCustomIcon());
            newNode.setAllowsChildren(oldNode.getAllowsChildren());
            newNode.setUserObject(oldNode.getUserObject());
            newRoot.add((MutableTreeNode)newNode);
            if (!bvNode.getFullName().equals(strOriSelected)) continue;
            this.newRootOriSelected = newNode;
        }
        if (newRoot.isLeaf() && !newRoot.isRoot()) {
            newRoot.removeFromParent();
        }
    }

    private void addNodeToList() throws BOSException {
        TreePath[] paths = this.kDTree1.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
            if (bvNode.isPackage()) {
                return;
            }
            this.enableSelect(true);
            BOSObjectType bosType = bvNode.getMetaDataType();
            MetaClass mc = null;
            try {
                mc = selector.createMetaClass(bosType, bvNode.getFullName());
            }
            catch (NoFoundQueryException e) {
                MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label270") + e.getMessage(), e);
                continue;
            }
            if (mc == null) continue;
            Table table = new Table();
            table.copy((IDefObj)mc);
            table.setName(FullPath.cutCategory((String)mc.getName()));
            table.setExpr(mc.getExpr() + "." + bvNode.getMetaDataType());
            int n = 1;
            while (TableUI.isUserColumn(table.getName())) {
                String name = table.getName() + "_" + n;
                table.setName(name);
            }
            WizardUtil.makeSureDefObjUnique((KDList)this.getSelectedList(), (IDefObj)table);
            selector.cacheTable2MetaClass(table.getName(), mc);
            this.getSelectedList().addElement((Object)table);
            this.getSelectedList().setSelectedValue((Object)table, true);
            this.setRefreshTab();
        }
    }

    protected static boolean isUserColumn(String name) {
        IColumnList list = model.getQuery().getColumns();
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                String fieldName = column.getName();
                if (!fieldName.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void setRefreshTab() {
        JoinUI.refreshFromModel(true);
        FieldUI.refreshFromModel(true);
        FilterUI.refreshFromModel(true);
        OrderUI.refreshFromModel(true);
        SqlUI.refreshFromModel(true);
    }

    @Override
    public void syncUi2Model() {
        ITableList queryTables = model.getQuery().getTables();
        queryTables.clear();
        int c = this.getSelectedList().getElementCount();
        for (int i = 0; i < c; ++i) {
            ITable table = (ITable)this.getSelectedList().getElement(i);
            queryTables.add(i, (Object)table);
        }
        IJoinList queryJoins = model.getQuery().getJoins();
        for (int i = queryJoins.size() - 1; i >= 0; --i) {
            Join join = (Join)queryJoins.get(i);
            if (!this.isTableExist(join.getLeftTable(), queryTables)) {
                queryJoins.remove(i);
                continue;
            }
            if (this.isTableExist(join.getRightTable(), queryTables)) continue;
            queryJoins.remove(i);
        }
    }

    @Override
    public void syncModel2Ui() {
        this.getSelectedList().removeAllElements();
        ITableList queryTables = model.getQuery().getTables();
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable table = (ITable)queryTables.get(i);
            this.getSelectedList().addElement((Object)table);
        }
    }

    private boolean isTableExist(String id, ITableList queryTables) {
        for (int i = queryTables.size() - 1; i >= 0; --i) {
            ITable table = (ITable)queryTables.get(i);
            if (!StringUtil.equals((String)table.getName(), (String)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onSelect() {
        try {
            this.addNodeToList();
        }
        catch (BOSException e) {
            log.error((Object)e);
        }
    }

    protected boolean onDelete() {
        int[] idxs = this.lvSelected.getList().getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label268"));
        if (!confirm) {
            return false;
        }
        for (int i = idxs.length - 1; i >= 0; --i) {
            Table table = (Table)this.lvSelected.getList().getElement(idxs[i]);
            String currentName = table.getName();
            this.lvSelected.getList().removeElementAt(idxs[i]);
            this.setRefreshTab();
            IColumnList queryColumns = model.getQuery().getColumns();
            Iterator it = queryColumns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String expr = column.getExpr();
                if (expr.toLowerCase().indexOf("[" + currentName.toLowerCase() + "]") == -1) continue;
                it.remove();
            }
            FilterUI.reWriteFilterConditionForDelete(model.getQuery(), currentName);
        }
        if (idxs[0] < this.lvSelected.getList().getElementCount()) {
            this.lvSelected.getList().setSelectedIndex(idxs[0]);
        } else {
            this.lvSelected.getList().setSelectedIndex(this.lvSelected.getList().getElementCount() - 1);
        }
        return true;
    }

    protected boolean onDeleteAll() {
        int[] idxs = this.lvSelected.getList().getSelectedIndices();
        if (idxs.length == 0) {
            return false;
        }
        boolean confirm = MessageUtil.showConfirm(null, MessageUtil.getMsgInfo("label268"));
        if (!confirm) {
            return false;
        }
        this.lvSelected.getList().removeAllElements();
        this.setRefreshTab();
        IColumnList queryColumns = model.getQuery().getColumns();
        queryColumns.clear();
        FilterUI.removeAllFilter(model.getQuery());
        return true;
    }

    protected void syncListViewButton() {
        super.syncListViewButton();
        if (this.getSelectedList().getSelectedIndex() == -1 || this.getSelectedList().getSelectedIndices().length > 1) {
            this.lvSelected.getButton("edit").setEnabled(false);
            this.lvSelected.getButton("editSubQuery").setEnabled(false);
        } else {
            this.lvSelected.getButton("edit").setEnabled(true);
            this.lvSelected.getButton("editSubQuery").setEnabled(true);
        }
    }

    private static class FilterNode {
        String name;
        String alias;
        String type;
        boolean F7;
        private static final FilterNode instance = new FilterNode();

        private FilterNode() {
        }

        public static final FilterNode getInstance() {
            return instance;
        }

        public void setCondition(HashMap mapFilter) {
            this.name = CtrlReportUtil.getObjectString(mapFilter.get("name")).toLowerCase();
            this.alias = CtrlReportUtil.getObjectString(mapFilter.get("alias")).toLowerCase();
            this.F7 = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("F7")));
            boolean joinQuery = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("joinQuery")));
            boolean unionQuery = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("unionQuery")));
            boolean dataTable = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("dataTable")));
            StringBuffer sb = new StringBuffer();
            if (joinQuery) {
                sb.append("jqye,");
            }
            if (unionQuery) {
                sb.append("uqye,");
            }
            if (dataTable) {
                sb.append("datb,");
            }
            this.type = sb.toString();
        }

        public boolean isHiden(IBriefViewTreeNode bvNode) {
            boolean isNameHidden = false;
            boolean isAliasHidden = false;
            boolean isTypeHidden = false;
            boolean isF7Hidden = false;
            String nodeName = CtrlReportUtil.getObjectString(bvNode.getName()).toLowerCase();
            String nodeAlias = CtrlReportUtil.getObjectString(bvNode.getAlias()).toLowerCase();
            String nodeType = CtrlReportUtil.getObjectString(bvNode.getMetaDataType().toString());
            if (this.name.length() > 0 && nodeName.indexOf(this.name) == -1) {
                isNameHidden = true;
            }
            if (this.alias.length() > 0 && nodeAlias.indexOf(this.alias) == -1) {
                isAliasHidden = true;
            }
            if (this.F7 && (nodeName.indexOf("f7") != -1 || nodeAlias.indexOf("f7") != -1)) {
                isF7Hidden = true;
            }
            if (this.type.indexOf(nodeType) == -1) {
                isTypeHidden = true;
            }
            return isNameHidden || isAliasHidden || isTypeHidden || isF7Hidden;
        }
    }

    public static class TableEditorDialog
    extends TypicalDialog {
        private static final long serialVersionUID = 3283146024355519842L;
        private EventListenerList listenerList = new EventListenerList();
        private KDTextField txtID;
        private KDTextField txtAlias;
        private KDTextField txtDesc;
        private KDTextField txtExpr;

        public TableEditorDialog() {
        }

        public TableEditorDialog(Frame frame) {
            super(frame);
        }

        public TableEditorDialog(Dialog dialog) {
            super(dialog);
        }

        protected void todoInit() {
            this.setSize(480, 180);
            this.txtID = new KDTextField();
            this.txtAlias = new KDTextField();
            this.txtDesc = new KDTextField();
            this.txtExpr = new KDTextField();
            this.txtExpr.setEnabled(false);
            this.txtID.setPreferredSize(new Dimension(370, 19));
            this.txtAlias.setPreferredSize(new Dimension(370, 19));
            this.txtExpr.setPreferredSize(new Dimension(370, 19));
            KDLabelContainer lbcID = new KDLabelContainer((JComponent)this.txtID);
            lbcID.setBoundLabelText(QueryResource.getString((String)"res_40"));
            lbcID.setBoundLabelLength(80);
            lbcID.setBoundLabelUnderline(true);
            KDLabelContainer lbcAlias = new KDLabelContainer((JComponent)this.txtAlias);
            lbcAlias.setBoundLabelText(QueryResource.getString((String)"res_41"));
            lbcAlias.setBoundLabelLength(80);
            lbcAlias.setBoundLabelUnderline(true);
            KDLabelContainer lbcDesc = new KDLabelContainer((JComponent)this.txtDesc);
            lbcDesc.setBoundLabelText(QueryResource.getString((String)"res_42"));
            lbcDesc.setBoundLabelLength(80);
            lbcDesc.setBoundLabelUnderline(true);
            KDLabelContainer lbcExpr = new KDLabelContainer((JComponent)this.txtExpr);
            lbcExpr.setBoundLabelText(QueryResource.getString((String)"res_16"));
            lbcExpr.setBoundLabelLength(80);
            lbcExpr.setBoundLabelUnderline(true);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            com.kingdee.bos.ctrl.common.layout.table.Table layout = thisCell.split(5, 1);
            for (int i = 0; i < 4; ++i) {
                layout.rowStyle(i).setHeight(19);
                layout.rowStyle(i).setMarginBottom(3);
            }
            layout.rowStyle(4).setPriY(1);
            parent.add((Component)this.txtID.getLabelContainer(), layout.cell(0, 0));
            parent.add((Component)this.txtAlias.getLabelContainer(), layout.cell(1, 0));
            parent.add((Component)this.txtDesc.getLabelContainer(), layout.cell(2, 0));
            parent.add((Component)this.txtExpr.getLabelContainer(), layout.cell(3, 0));
        }

        protected void todoActionPerformed(ActionEvent e) {
        }

        protected void todoKeyAction(int keyCode) {
        }

        public void setBosQueryMode(boolean isBosQueryMode) {
            this.txtID.setEnabled(!isBosQueryMode);
            this.txtAlias.setEnabled(!isBosQueryMode);
            this.txtDesc.setEnabled(!isBosQueryMode);
        }

        protected void onOk() {
            if (TableUI.isUserColumn(this.getID())) {
                MessageUtil.showInfo("label254", true);
                return;
            }
            if (this.fireVerifEvent((Object)this, this.getAlias(), this.getID())) {
                super.onOk();
            }
        }

        public void addVerifyListener(VerifyListener l) {
            this.listenerList.add(VerifyListener.class, l);
        }

        public void removeVerifyListener(VerifyListener l) {
            this.listenerList.remove(VerifyListener.class, l);
        }

        protected boolean fireVerifEvent(Object source, String alias, String id) {
            Object[] listeners = this.listenerList.getListenerList();
            VerifyEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != VerifyListener.class) continue;
                if (evt == null) {
                    evt = new VerifyEvent(source, alias, id);
                }
                return ((VerifyListener)listeners[i + 1]).isOK(evt);
            }
            return true;
        }

        public String getAlias() {
            return this.txtAlias.getText();
        }

        public void setAlias(String alias) {
            this.txtAlias.setText(alias);
        }

        public String getDesc() {
            return this.txtDesc.getText();
        }

        public void setDesc(String desc) {
            this.txtDesc.setText(desc);
        }

        public String getID() {
            return this.txtID.getText().trim();
        }

        public void setID(String ID) {
            this.txtID.setText(ID);
        }

        public String getExpr() {
            return this.txtExpr.getText();
        }

        public void setExpr(String expr) {
            this.txtExpr.setText(expr);
        }

        public static class VerifyEvent
        extends EventObject {
            private static final long serialVersionUID = 4034236438741034627L;
            private String alias;
            private String id;

            public VerifyEvent(Object source, String alias, String id) {
                super(source);
                this.alias = alias;
                this.id = id;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getId() {
                return this.id;
            }
        }

        public static interface VerifyListener
        extends EventListener {
            public boolean isOK(VerifyEvent var1);
        }
    }

    private class ActionRename
    extends AbstractAction {
        private static final long serialVersionUID = 2119051615174799205L;

        public ActionRename() {
            this.putValue("SmallIcon", Resource.ICON_RENAME);
            this.putValue("ShortDescription", MessageUtil.getMsgInfo("label240"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editTable();
        }

        private void editTable() {
            DefObj tbl = (DefObj)TableUI.this.getSelectedList().getSelectedValue();
            if (tbl == null) {
                return;
            }
            TableEditorDialog tableEditor = this.createTableEditor();
            tableEditor.setID(tbl.getName());
            tableEditor.setAlias(tbl.getAlias());
            tableEditor.setDesc(tbl.getDesc());
            if (tbl instanceof Table) {
                tableEditor.setExpr(((Table)tbl).getExpr());
            } else {
                tableEditor.setExpr("");
            }
            if (tableEditor.showDialog()) {
                if (!tableEditor.getAlias().equalsIgnoreCase(tbl.getAlias())) {
                    this.fireAliasChangedEvent(tbl, tbl.getAlias(), tableEditor.getAlias());
                }
                tbl.setAlias(tableEditor.getAlias());
                if (!tableEditor.getID().equalsIgnoreCase(tbl.getName())) {
                    this.activeFieldUI();
                    this.fireNameChangedEvent(tbl, tbl.getName(), tableEditor.getID());
                    FilterUI.reWriteFilterCondition(model.getQuery(), tbl.getName(), tableEditor.getID());
                }
                String oldName = tbl.getName();
                tbl.setName(tableEditor.getID());
                tbl.setDesc(tableEditor.getDesc());
                TableUI.this.getSelectedList().repaint();
                selector.changeCacheTable2MetaClass(oldName, tbl.getName());
                FieldUI.refreshFromModel(true);
            }
        }

        private TableEditorDialog createTableEditor() {
            TableEditorDialog tableEditor = (TableEditorDialog)((Object)WindowUtil.createWindow(TableEditorDialog.class, (Component)((Object)tableUI)));
            tableEditor.setTitle(Wizard2Resource.getString((String)"res_38"));
            tableEditor.addVerifyListener(new TableEditorDialog.VerifyListener(){

                @Override
                public boolean isOK(TableEditorDialog.VerifyEvent e) {
                    return true;
                }
            });
            return tableEditor;
        }

        private void fireNameChangedEvent(Object source, String oldName, String newName) {
            model.firePropertyChanged(source, "table name", oldName, newName);
        }

        private void fireAliasChangedEvent(Object source, String oldAlias, String newAlias) {
            model.firePropertyChanged(source, "table alias", oldAlias, newAlias);
        }

        private void activeFieldUI() {
            if (!DesignUI.getInstance().isNew()) {
                FieldUI.getInstance();
            }
        }
    }
}

