/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client.pd;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.IPopupSelector;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialogSelector;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.pd.IConstantValueSetterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.ArgInputComponentFactory;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

class CheckBoxGroupConstantValueSetterUI
implements IConstantValueSetterUI {
    private static Logger logger = CommonLogger.getLogger(CheckBoxGroupConstantValueSetterUI.class);
    private KDPanel kDPanelCB = new KDPanel();
    private List<KDCheckBox> cbList = new ArrayList<KDCheckBox>();
    private HashSet<String> values = new HashSet();
    private KDBizPromptBox kDBizPromptBox = new KDBizPromptBox();
    private int contentHeight = 10;
    private int colIndex = 0;
    private List<DesignParameter> parameters;

    CheckBoxGroupConstantValueSetterUI(List<DesignParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object getData() {
        ArrayList<Object> selections = new ArrayList<Object>();
        for (KDCheckBox cb : this.cbList) {
            if (!cb.isSelected()) continue;
            selections.add(cb.getUserObject());
        }
        return selections.toArray();
    }

    @Override
    public JComponent getUI() {
        this.kDBizPromptBox.setHistoryRecordEnabled(false);
        this.kDBizPromptBox.setEditable(false);
        return this.kDBizPromptBox;
    }

    @Override
    public void willShow(DesignParameter dp, String sourceReportOrgID) {
        this.configPromptBox(dp);
        this.kDBizPromptBox.setData((Object)this.initDefaultValues(dp));
        this.initSelector(dp, sourceReportOrgID);
    }

    private void configPromptBox(DesignParameter dp) {
        IInputCtrl inputCtrl = dp.getInputCtrl();
        if (inputCtrl == null) {
            return;
        }
        this.kDBizPromptBox.setDisplayFormat("$" + RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()) + "$");
        this.kDBizPromptBox.setEditFormat("$" + RunReportParam.getRealFieldName(inputCtrl.getDefValue()) + "$");
        String commitField = RunReportParam.getRealFieldName(inputCtrl.getDefCommit());
        if (!StringUtils.isEmpty((String)commitField)) {
            this.kDBizPromptBox.setCommitFormat("$" + commitField + "$");
        }
        this.kDBizPromptBox.setEnabledMultiSelection(inputCtrl.isAllowMultipleSelected());
    }

    private DefObj[] initDefaultValues(DesignParameter dp) {
        this.values.clear();
        DefObj[] datas = null;
        String defaultValues = dp.getDefaultValue();
        if (defaultValues != null) {
            String[] valueList = defaultValues.split("0xx1xx");
            datas = new DefObj[valueList.length];
            String defaultAlias = dp.getDefaultAlias();
            String[] aliasList = null;
            if (defaultAlias != null) {
                aliasList = defaultAlias.split("0xx1xx");
            }
            if (aliasList == null || aliasList.length != valueList.length) {
                aliasList = new String[valueList.length];
                System.arraycopy(valueList, 0, aliasList, 0, valueList.length);
                logger.warn((Object)("value and alias not compatiable,src alias\u3010" + defaultAlias + "\u3011replaced by value\u3010" + defaultValues + "\u3011"));
            }
            for (int i = 0; i < valueList.length; ++i) {
                this.values.add(valueList[i]);
                datas[i] = new DefObj();
                datas[i].setName(valueList[i]);
                datas[i].setAlias(aliasList[i]);
            }
        }
        return datas;
    }

    private void initSelector(DesignParameter dp, String sourceReportOrgID) {
        this.kDPanelCB.removeAll();
        this.cbList.clear();
        this.colIndex = 0;
        this.contentHeight = 10;
        IInputCtrl inputCtrl = dp.getInputCtrl();
        if (inputCtrl != null) {
            int bind = inputCtrl.getDataBind();
            if (bind == 0) {
                boolean isKSQL;
                String displayKey = "alias";
                String valueKey = "value";
                String tableFlag = inputCtrl.getDataSetType();
                boolean bl = isKSQL = !tableFlag.equals("6");
                if (isKSQL) {
                    displayKey = inputCtrl.getDefDisplay().getName();
                    valueKey = inputCtrl.getDefValue().getName();
                }
                DefObj def = inputCtrl.getDefDbsource();
                String fid = def.getName();
                if (isKSQL) {
                    String dbsourcename = def.getAlias();
                    String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                    if (!systemid.equals("")) {
                        fid = fid + "\\" + systemid + "\\" + dbsourcename;
                    }
                }
                String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                String orgName = SysContext.getSysContext().getCurrentOrgUnit().getName().toString();
                ArgInputComponentFactory.parseFirstData(this.parameters, 1, sourceReportOrgID, null);
                try {
                    ArrayList lst = RunReportParam.getBizDataList(null, isKSQL, fid, orgID, orgName, ArgInputComponentFactory.fetchSuppliers(null, dp, ArgInputComponentFactory.list2Map(this.parameters)));
                    for (HashMap mapitem : lst) {
                        this.addCheckBox(CtrlReportUtil.getObjectString(mapitem.get(valueKey.toLowerCase())), CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                    }
                }
                catch (Exception e) {
                    this.kDPanelCB.add((Component)new KDLabel(e.getMessage()));
                }
            } else if (bind == 1) {
                ArrayList selfList = inputCtrl.getSelfList();
                for (DefObj defItem : selfList) {
                    this.addCheckBox(defItem.getName(), defItem.getAlias());
                }
            } else if (bind == 6) {
                String displayKey = inputCtrl.getDefDisplay().getName();
                String valueKey = inputCtrl.getDefValue().getName();
                displayKey = displayKey != null ? displayKey : "name";
                valueKey = valueKey != null ? valueKey : "id";
                String systemVarType = inputCtrl.getDefDbsource().getName();
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                ArrayList<HashMap<String, String>> lst = OrgRangeManage.getOrgRangeList(null, userId, Integer.valueOf(systemVarType));
                for (HashMap<String, String> mapitem : lst) {
                    this.addCheckBox(CtrlReportUtil.getObjectString(mapitem.get(valueKey.toLowerCase())), CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                }
            } else if (bind == 7) {
                try {
                    MacroValue value = ExtRptMacroExecuteFacade.remoteExecute(null, inputCtrl.getDefDbsource().getName());
                    String displayKey = inputCtrl.getDefDisplay().getName();
                    String valueKey = inputCtrl.getDefValue().getName();
                    int displayIndex = -1;
                    int valueIndex = -1;
                    for (int i = 0; i < value.getColums().length; ++i) {
                        if (value.getColums()[i].equalsIgnoreCase(displayKey)) {
                            displayIndex = i;
                        }
                        if (value.getColums()[i].equalsIgnoreCase(valueKey)) {
                            valueIndex = i;
                        }
                        if (displayIndex != -1 && valueIndex != -1) break;
                    }
                    if (valueIndex == -1) {
                        valueIndex = 0;
                    }
                    if (displayIndex == -1) {
                        displayIndex = 0;
                    }
                    for (Variant[] row : value.getValues()) {
                        this.addCheckBox(CtrlReportUtil.getObjectString(row[valueIndex]), CtrlReportUtil.getObjectString(row[displayIndex]));
                    }
                }
                catch (MacroRuntimeException e) {
                    this.kDPanelCB.add((Component)new KDLabel(e.getMessage()));
                }
            }
        }
        this.kDPanelCB.setLayout(null);
        this.kDPanelCB.setPreferredSize(new Dimension(460, this.contentHeight));
        this.kDBizPromptBox.setSelector((KDPromptSelector)ReportDialogSelector.showDialog(new Selector(), Resources.getResourceString("\u591a\u9009\u6846\u7ec4\u9ed8\u8ba4\u503c"), true, false));
    }

    private void addCheckBox(String name, String alias) {
        DefObj o = new DefObj();
        o.setName(name);
        o.setAlias(alias);
        KDCheckBox cb = new KDCheckBox();
        cb.setText(o.getAlias());
        cb.setUserObject((Object)o);
        this.kDPanelCB.add((Component)cb);
        if (this.values.contains(o.getName())) {
            cb.setSelected(true);
        }
        cb.setBounds(30 + this.colIndex * 5 + 130 * this.colIndex, this.contentHeight, 130, 20);
        ++this.colIndex;
        if (this.colIndex % 3 == 0) {
            this.colIndex = 0;
            this.contentHeight += 30;
        }
        this.cbList.add(cb);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.kDBizPromptBox.setEnabled(isEnabled);
    }

    private class Selector
    implements IPopupSelector {
        private boolean isCanceled = true;
        private KDButton btnConfirm = new KDButton(Resources.getResourceString("\u786e\u5b9a"));
        private KDButton btnCancel = new KDButton(Resources.getResourceString("\u53d6\u6d88"));

        private Selector() {
        }

        @Override
        public Component getComponentSelector() {
            KDPanel panel = new KDPanel((LayoutManager)new BorderLayout());
            panel.add((Component)new KDScrollPane((Component)CheckBoxGroupConstantValueSetterUI.this.kDPanelCB));
            KDPanel southPanel = new KDPanel((LayoutManager)new BorderLayout());
            southPanel.add((Component)new KDSeparator(), (Object)"North");
            KDPanel controller = new KDPanel((LayoutManager)new FlowLayout(2));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == Selector.this.btnConfirm) {
                        Selector.this.isCanceled = false;
                    }
                    SwingUtilities.getWindowAncestor((Component)Selector.this.btnConfirm).dispose();
                }
            };
            this.btnConfirm.addActionListener(listener);
            this.btnCancel.addActionListener(listener);
            controller.add((Component)this.btnConfirm);
            controller.add((Component)this.btnCancel);
            southPanel.add((Component)controller);
            panel.add((Component)southPanel, (Object)"South");
            return panel;
        }

        @Override
        public Object getData() {
            return CheckBoxGroupConstantValueSetterUI.this.getData();
        }

        @Override
        public int getHeightSelector() {
            return 320;
        }

        @Override
        public int getWidthSelector() {
            return 490;
        }

        @Override
        public void initLayoutSelector() {
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        @Override
        public void onLoadSelector() throws Exception {
        }

        @Override
        public void showSelector() {
            this.isCanceled = true;
        }

        @Override
        public void setParamMap(HashMap paramMap) {
        }

        @Override
        public KDToolBar getToolBarSelector() {
            return null;
        }
    }
}

