/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.client.pd;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.ctrlreport.IPopupSelector;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroFilter;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.ExtRptMacroManageActionFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SystemMacroSelectedUI
extends KDPanel
implements IPopupSelector,
IExtRptMacroActionHost {
    private static final long serialVersionUID = 1L;
    private static Logger logger = CommonLogger.getLogger(SystemMacroSelectedUI.class);
    private KDToolBar toolBar;
    private KDButton btnConfirm;
    private KDButton btnCancel;
    private KDTable macroTable;
    private IExtRptMacroController controller;
    private boolean isCanceled = true;
    private IExtRptMacroFilter filter;
    private ArrayList<IExtRptMacroSelectionAware> actions = new ArrayList();

    public SystemMacroSelectedUI() throws Exception {
        this.controller = ExtRptMacroControllerFacade.getRemoteInst();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(560, 510));
        this.toolBar = new KDToolBar();
        this.toolBar.add(ExtRptMacroManageActionFactory.newSearchAction(this));
        this.toolBar.add(ExtRptMacroManageActionFactory.newPreviewAction(this, false));
        this.putClientProperty("ShowToolBar", this.toolBar);
    }

    @Override
    public Component getComponentSelector() {
        return this;
    }

    @Override
    public Object getData() {
        DefObj def = new DefObj();
        def.setName(this.getSelections()[0].getMacro().name());
        def.setAlias("$" + this.getSelections()[0].getMacro().name());
        def.setProperty("tableFlag", (Object)"");
        return def;
    }

    @Override
    public int getHeightSelector() {
        return this.getPreferredSize().height;
    }

    @Override
    public KDToolBar getToolBarSelector() {
        return this.toolBar;
    }

    @Override
    public int getWidthSelector() {
        return this.getPreferredSize().width;
    }

    @Override
    public void initLayoutSelector() {
        this.macroTable = new KDTable(2, 0, 0);
        IRow headRow0 = this.macroTable.addHeadRow();
        headRow0.getCell(0).setValue((Object)Resources.getResourceString("\u540d\u79f0"));
        headRow0.getCell(1).setValue((Object)Resources.getResourceString("\u63cf\u8ff0"));
        this.macroTable.getColumn(0).setWidth(240);
        this.macroTable.getColumn(1).setWidth(240);
        this.macroTable.setEditable(false);
        KDTSelectManager selectManager = this.macroTable.getSelectManager();
        selectManager.setSelectMode(2);
        selectManager.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                MacroVO[] selections = SystemMacroSelectedUI.this.getSelections();
                for (IExtRptMacroSelectionAware action : SystemMacroSelectedUI.this.actions) {
                    action.selectionChanged(selections);
                }
                SystemMacroSelectedUI.this.btnConfirm.setEnabled(selections == null ? false : selections.length > 0);
            }
        });
        this.macroTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    SystemMacroSelectedUI.this.isCanceled = false;
                    SystemMacroSelectedUI.this.close();
                }
            }
        });
        this.add((Component)this.macroTable);
        KDPanel controller = new KDPanel((LayoutManager)new BorderLayout());
        controller.add((Component)new KDLabel(" "), (Object)"North");
        controller.add((Component)new KDSeparator());
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        this.btnConfirm = new KDButton(Resources.getResourceString("\u786e\u5b9a"));
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMacroSelectedUI.this.isCanceled = false;
                SystemMacroSelectedUI.this.close();
            }
        });
        btnPanel.add((Component)this.btnConfirm);
        this.btnCancel = new KDButton(Resources.getResourceString("\u53d6\u6d88"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMacroSelectedUI.this.isCanceled = true;
                SystemMacroSelectedUI.this.close();
            }
        });
        btnPanel.add((Component)this.btnCancel);
        controller.add((Component)btnPanel, (Object)"South");
        this.add((Component)controller, "South");
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onLoadSelector() throws Exception {
        this.loadMacros();
    }

    @Override
    public void showSelector() {
        this.filter = null;
        this.isCanceled = true;
        this.afterAction();
    }

    @Override
    public void setParamMap(HashMap paramMap) {
    }

    @Override
    public void afterAction() {
        try {
            this.loadMacros();
        }
        catch (MacroDesignException e) {
            logger.error((Object)e);
            MessageUtil.msgboxWarning((Component)((Object)this), (String)Resources.getResourceString("\u52a0\u8f7d\u5b8f\u5217\u8868\u5931\u8d25\u3002"), (String)e.getMessage());
        }
    }

    private void loadMacros() throws MacroDesignException {
        MacroVO[] mList;
        this.macroTable.removeRows();
        for (MacroVO vo : mList = this.controller.l()) {
            String name = vo.getMacro().name();
            String description = vo.getDescription();
            ExtRptMacroType.VType vt = vo.getMacro().vType();
            if (this.filter != null) {
                boolean typeMatch = false;
                if (this.filter.vTypes() != null) {
                    for (ExtRptMacroType.VType type : this.filter.vTypes()) {
                        if (vt != type) continue;
                        typeMatch = true;
                        break;
                    }
                }
                if (!typeMatch) continue;
                String fDesc = this.filter.description();
                String fName = this.filter.name();
                boolean descMatch = StringUtil.isEmptyString((String)fDesc);
                boolean nameMatch = StringUtil.isEmptyString((String)fName);
                if (descMatch ? !nameMatch && name.indexOf(fName) < 0 : (nameMatch ? description.indexOf(fDesc) < 0 : name.indexOf(fName) < 0 && description.indexOf(fDesc) < 0)) continue;
            }
            IRow row = this.macroTable.addRow();
            row.setUserObject((Object)vo);
            row.getCell(0).setValue((Object)name);
            row.getCell(1).setValue((Object)description);
        }
        this.macroTable.getSelectManager().select(0, 0);
    }

    @Override
    public MacroVO[] getSelections() {
        ArrayList<MacroVO> ret = new ArrayList<MacroVO>();
        KDTSelectManager manager = this.macroTable.getSelectManager();
        for (int i = 0; i < manager.size(); ++i) {
            KDTSelectBlock block = manager.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow() && j >= 0; ++j) {
                ret.add((MacroVO)this.macroTable.getRow(j).getUserObject());
            }
        }
        return ret.toArray(new MacroVO[0]);
    }

    @Override
    public void register(IExtRptMacroSelectionAware action) {
        this.actions.add(action);
    }

    @Override
    public void setFilter(IExtRptMacroFilter filter) {
        this.filter = filter;
    }

    private void close() {
        Window parent = SwingUtilities.getWindowAncestor(this.getComponentSelector());
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    public CoreUI getCoreUI() {
        return null;
    }
}

