/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model.pr.comp;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.AloneBoxData;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ComponentValueResolverFacader {
    private static final Logger logger = CoreUIObject.getLogger(ComponentValueResolverFacader.class);

    public static String resolver(KDTextField txtField) {
        String value = txtField.getText();
        value = ExtStringUtil.replace(value, ";", "0xx1xx");
        return CtrlReportUtil.getObjectString(value);
    }

    public static String resolver(KDSpinner spinner) {
        String valueString = CtrlReportUtil.getObjectString(spinner.getDoubleVlaue());
        if (!valueString.equals("")) {
            valueString = NumberUtil.cutZero((String)valueString);
        }
        return valueString;
    }

    public static String resolver(KDDatePicker datePicker, DesignDataType ddt) {
        Object objValue = datePicker.getValue();
        String valueString = "";
        if (objValue instanceof Date) {
            int dataType = ddt.intValue();
            if (dataType == 2) {
                valueString = CtrlReportUtil.formatDate((Date)objValue);
            } else if (dataType == 4) {
                valueString = CtrlReportUtil.formatDateTime((Date)objValue);
            }
        }
        return valueString;
    }

    public static String resolver(KDTimePicker timePicker) {
        Object objValue = timePicker.getValue();
        String valueString = "";
        if (objValue instanceof Date) {
            valueString = CtrlReportUtil.formatTime((Date)objValue);
        }
        return valueString;
    }

    public static DefObj resolver(KDComboBox combo) {
        DefObj ret = null;
        Object valueObj = combo.getSelectedItem();
        if (valueObj instanceof DefObj) {
            DefObj def = (DefObj)combo.getSelectedItem();
            if (null != def) {
                ret = new DefObj();
                ret.setName(def.getName());
                ret.setAlias(def.getAlias());
            }
        } else if (valueObj instanceof String) {
            ret = new DefObj();
            ret.setName((String)valueObj);
            ret.setAlias((String)valueObj);
        }
        return ret;
    }

    public static DefObj resolver(KDRadioButton radio) {
        return (DefObj)radio.getUserObject();
    }

    public static DefObj resolver(KDCheckBox checkBox, ArrayList selectedCBList, HashMap noSelectedCBMap, DesignParameter p) {
        DefObj ret = null;
        Object userObject = checkBox.getUserObject();
        if (userObject instanceof AloneBoxData) {
            IInputCtrl inputCtrl = p.getInputCtrl();
            ret = new DefObj();
            if (checkBox.isSelected()) {
                ret.setName(CtrlReportUtil.getObjectString(inputCtrl.getDefValue().getName()));
                ret.setAlias(CtrlReportUtil.getObjectString(inputCtrl.getDefValue().getAlias()));
            } else {
                ret.setName(CtrlReportUtil.getObjectString(inputCtrl.getDefDisplay().getName()));
                ret.setAlias(CtrlReportUtil.getObjectString(inputCtrl.getDefDisplay().getAlias()));
            }
        } else {
            ComponentValueResolverFacader.putSelectedCBList(selectedCBList, noSelectedCBMap, p, checkBox);
        }
        return ret;
    }

    public static DefObj resolver(KDBizPromptBox promptBox, DesignParameter p) {
        DefObj ret = new DefObj();
        ret.setName("");
        ret.setAlias("");
        StringBuffer sbValue = new StringBuffer();
        StringBuffer sbAlias = new StringBuffer();
        Object returnValues = promptBox.getData();
        if (null != returnValues) {
            IInputCtrl inputCtrl = p.getInputCtrl();
            if (returnValues instanceof Object[]) {
                Object[] returnObjes = (Object[])returnValues;
                int size = returnObjes.length;
                for (int i = 0; i < size; ++i) {
                    String valueString;
                    Object returnObejc = returnObjes[i];
                    if (returnObejc instanceof IObjectValue) {
                        String entitytype;
                        DefObj def = inputCtrl.getDefValue();
                        String type = ((IObjectValue)returnObejc).getBOSType().toString();
                        String fieldNameReal = CtrlReportUtil.getObjectString(def.getProperty("entityfieldname"));
                        if (!fieldNameReal.equals("") && !type.equals(entitytype = CtrlReportUtil.getObjectString(def.getProperty("enetitytype")))) {
                            logger.error((Object)("entitytype = " + entitytype + ", currentEntity is " + type + ", so value is empty"));
                        }
                        String value = RunReportParam.getRealFieldName(def);
                        String alias = null;
                        alias = null != inputCtrl.getDefDisplay().getName() ? RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()) : value;
                        String valueString2 = CtrlReportUtil.getObjectString(((IObjectValue)returnObejc).get(value));
                        String aliasString = CtrlReportUtil.getObjectString(((IObjectValue)returnObejc).get(alias));
                        sbValue.append(valueString2);
                        sbAlias.append(aliasString);
                    } else if (returnObejc instanceof DefObj) {
                        valueString = ((DefObj)returnObejc).getName();
                        String aliasString = ((DefObj)returnObejc).getAlias();
                        sbValue.append(valueString);
                        sbAlias.append(aliasString);
                    } else if (returnObejc instanceof String) {
                        valueString = CtrlReportUtil.getObjectString(returnObejc);
                        sbValue.append(valueString);
                        sbAlias.append(valueString);
                    } else {
                        if (returnObejc == null) continue;
                        valueString = returnObejc.toString();
                        sbValue.append(CtrlReportUtil.getObjectString(valueString));
                        sbAlias.append(CtrlReportUtil.getObjectString(valueString));
                    }
                    if (i >= size - 1) continue;
                    sbValue.append("0xx1xx");
                    sbAlias.append("0xx1xx");
                }
            } else if (returnValues instanceof IObjectValue) {
                DefObj def = inputCtrl.getDefValue();
                String type = ((IObjectValue)returnValues).getBOSType().toString();
                String fieldNameReal = CtrlReportUtil.getObjectString(def.getProperty("entityfieldname"));
                if (!fieldNameReal.equals("")) {
                    String entitytype = CtrlReportUtil.getObjectString(def.getProperty("enetitytype"));
                    if (!type.equals(entitytype)) {
                        logger.error((Object)("entitytype is " + entitytype + ", currentEntity is " + type + ", so value is empty"));
                        DefObj defValue = inputCtrl.getDefCommit();
                        String name = defValue.getName();
                        if (name != null && name.indexOf(".") != -1) {
                            String[] ns = name.split("\\.");
                            String refField = ns[0];
                            String refVal = ns[1];
                            if (returnValues instanceof CoreBaseInfo) {
                                BOSObjectType bosType = ((CoreBaseInfo)returnValues).getBOSType();
                                BOSUuid bosUuid = ((CoreBaseInfo)returnValues).getId();
                                SelectorItemCollection sic = new SelectorItemCollection();
                                sic.add(new SelectorItemInfo(refField));
                                sic.add(new SelectorItemInfo(name));
                                try {
                                    IObjectValue objectValue = DynamicObjectFactory.getRemoteInstance().getValue(bosType, (IObjectPK)new ObjectUuidPK(bosUuid), sic);
                                    Object refEntity = objectValue.get(refField);
                                    Class<?> clazz = Class.forName(refEntity.getClass().getName());
                                    Method method = clazz.getMethod("get", String.class);
                                    String valueString = method.invoke(refEntity, refVal).toString();
                                    String alias = null;
                                    alias = null != inputCtrl.getDefDisplay().getName() ? RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()) : valueString;
                                    String aliasString = CtrlReportUtil.getObjectString(((IObjectValue)returnValues).get(alias));
                                    sbValue.append(valueString);
                                    sbAlias.append(aliasString);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    MessageDialog.show(null, (Object)e.getMessage(), (String)"\u4fe1\u606f\u63d0\u793a", (int)-1, (int)2, (String)e.getMessage());
                                }
                            }
                        }
                    }
                } else {
                    String value = RunReportParam.getRealFieldName(def);
                    String alias = null;
                    alias = null != inputCtrl.getDefDisplay().getName() ? RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()) : value;
                    String valueString = CtrlReportUtil.getObjectString(((IObjectValue)returnValues).get(value));
                    String aliasString = CtrlReportUtil.getObjectString(((IObjectValue)returnValues).get(alias));
                    sbValue.append(valueString);
                    sbAlias.append(aliasString);
                }
            } else if (returnValues instanceof DefObj) {
                String valueString = CtrlReportUtil.getObjectString(((DefObj)returnValues).getName());
                String aliasString = CtrlReportUtil.getObjectString(((DefObj)returnValues).getAlias());
                sbValue.append(valueString);
                sbAlias.append(aliasString);
            } else if (returnValues instanceof String) {
                String valueString = CtrlReportUtil.getObjectString(returnValues);
                sbValue.append(valueString);
                sbAlias.append(valueString);
            } else {
                String valueString = CtrlReportUtil.getObjectString(returnValues);
                sbValue.append(valueString);
                sbAlias.append(valueString);
            }
            ret.setName(sbValue.toString());
            ret.setAlias(sbAlias.toString());
        }
        return ret;
    }

    private static void putSelectedCBList(ArrayList selectedCBList, HashMap noSelectedCBMap, DesignParameter p, KDCheckBox cb) {
        if (cb.isSelected()) {
            boolean isFind = false;
            DefObj def = (DefObj)cb.getUserObject();
            String paramName = p.getName();
            noSelectedCBMap.remove(paramName);
            if (!def.getName().equals("")) {
                for (HashMap map : selectedCBList) {
                    String currentName = (String)map.get("name");
                    if (!paramName.equals(currentName)) continue;
                    String value = CtrlReportUtil.getObjectString(map.get("value"));
                    String valueAlias = CtrlReportUtil.getObjectString(map.get("valueAlias"));
                    String addValue = def.getName();
                    String addAlias = CtrlReportUtil.getObjectString(def.getAlias());
                    value = value + "0xx1xx" + addValue;
                    valueAlias = valueAlias + "0xx1xx" + addAlias;
                    map.put("value", value);
                    map.put("valueAlias", valueAlias);
                    isFind = true;
                    break;
                }
            }
            if (!isFind) {
                HashMap<String, String> map = new HashMap<String, String>();
                String value = CtrlReportUtil.getObjectString(def.getName());
                String alias = CtrlReportUtil.getObjectString(def.getAlias());
                if (!value.equals("")) {
                    map.put("name", paramName);
                    map.put("valueAlias", alias);
                    map.put("dataType", String.valueOf(p.getDesignDataType().intValue()));
                    map.put("value", value);
                    selectedCBList.add(map);
                }
            }
        } else {
            boolean isSelected = false;
            for (HashMap map : selectedCBList) {
                String currentName = (String)map.get("name");
                if (!currentName.equals(p.getName())) continue;
                isSelected = true;
                break;
            }
            if (!isSelected) {
                noSelectedCBMap.put(p.getName(), p);
            }
        }
    }
}

