/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.util.HMACUtil;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.SecretKeyUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.rpts.mobileService.rpt.ExtLightReportContentHandler;
import com.kingdee.eas.rpts.mobileService.runtime.Env;
import com.kingdee.eas.rpts.mobileService.util.OrgSwitchHelper;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ExtLightFilterDelayDataHandler
implements IResourceMethodHandler {
    protected static Pattern NumberPattern = Pattern.compile("\\d+");
    protected static Pattern XMLPattern = Pattern.compile("<CommonQuery .*>");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        String currentOrgId = ((OrgUnitInfo)easCtx.get((Object)"CurOU")).getId().toString();
        try {
            OrgSwitchHelper.switchOrg(easCtx, args[3]);
            String rptId = (String)Env.get(Env.Key.rptId);
            String xmlContent = args[0];
            String hmac = args[5];
            if (!StringUtil.isEmptyString((String)hmac)) {
                try {
                    if (!HMACUtil.genHMAC((byte[])xmlContent.getBytes("UTF-8"), (byte[])SecretKeyUtil.getInstance().getSecretKey().getBytes("UTF-8")).equals(hmac)) {
                        throw new IllegalArgumentException("hmac \u6821\u9a8c\u4e0d\u901a\u8fc7\u3002");
                    }
                    xmlContent = "false".equals(args[6]) ? URLDecoder.decode(xmlContent, "UTF-8") : new String(Base64.decode((String)xmlContent), "UTF-8");
                }
                catch (Exception e) {
                    throw ExtRptBizException.newIllegalArgumentException(e);
                }
            }
            MobileResult mobileResult = ExtLightFilterDelayDataHandler.gainSupplyValues(easCtx, xmlContent, rptId, args[2], args[4]);
            return mobileResult;
        }
        finally {
            OrgSwitchHelper.switchOrg(easCtx, currentOrgId);
        }
    }

    static MobileResult gainSupplyValues(Context easCtx, String datasetXml, String rptId, String paramValues, String paramName) throws ExtRptBizException {
        try {
            rptId = (String)Env.get(Env.Key.rptId);
            IExtRptMacroController controller = easCtx == null ? ExtRptMacroControllerFacade.getRemoteInst() : ExtRptMacroControllerFacade.getLocalInst(easCtx);
            if (NumberPattern.matcher(datasetXml).matches()) {
                return ExtLightFilterDelayDataHandler.exeSystem(easCtx, datasetXml, rptId);
            }
            if (XMLPattern.matcher(datasetXml.replaceAll("\\r", "").replaceAll("\\n", "")).matches()) {
                return ExtLightFilterDelayDataHandler.exeSQL(easCtx, rptId, paramName, datasetXml, paramValues);
            }
            if (controller.e(datasetXml, null)) {
                int i;
                HashMap<String, Cloneable> jsonRowset = new HashMap<String, Cloneable>();
                HashMap metaVO = new HashMap();
                ArrayList<String> colNamesVO = new ArrayList<String>();
                ArrayList rowsVO = new ArrayList();
                MacroValue mv = easCtx == null ? ExtRptMacroExecuteFacade.remoteExecute(DefaultExtStatisticsRunner.loadUsedMacros(easCtx, rptId), datasetXml) : ExtRptMacroExecuteFacade.localExecute(easCtx, DefaultExtStatisticsRunner.loadUsedMacros(easCtx, rptId), datasetXml);
                for (i = 0; i < mv.getColums().length; ++i) {
                    colNamesVO.add(mv.getColums()[i]);
                }
                for (i = 0; i < mv.getValues().length; ++i) {
                    ArrayList<String> row = new ArrayList<String>();
                    for (int j = 0; j < mv.getColums().length; ++j) {
                        row.add(mv.getValues()[i][j].toString());
                    }
                    rowsVO.add(row);
                }
                metaVO.put("colNames", colNamesVO);
                jsonRowset.put("meta", metaVO);
                jsonRowset.put("rows", rowsVO);
                return new MobileResult(jsonRowset);
            }
            return ExtLightFilterDelayDataHandler.exeQuery(easCtx, datasetXml);
        }
        catch (Exception e) {
            throw ExtRptBizException.newSupplyValuesVisitException(e);
        }
    }

    private static MobileResult exeQuery(Context easCtx, String queryName) throws Exception {
        int lastDot = queryName.lastIndexOf(".");
        MetaDataPK pk = new MetaDataPK(queryName.substring(0, lastDot), queryName.substring(lastDot + 1, queryName.length()));
        IQueryExecutor exe = QueryExecutorFactory.getLocalInstance((Context)easCtx, (IMetaDataPK)pk);
        return ExtLightFilterDelayDataHandler.translateRowset(exe.executeQuery());
    }

    private static MobileResult exeSQL(Context easCtx, String rptId, String paramName, String datasetXml, String paramValues) throws Exception {
        CtrlDesignQueryModel model = KSQLReportBO.initModelFromXml(easCtx, datasetXml);
        HashMap<String, DesignParameter> params = ExtLightReportContentHandler.parseParams(easCtx, rptId, paramValues);
        DesignParameter parameter = params.get(paramName);
        List sources = model.getCommonQuery().getParameters();
        DesignParameter[][] suppliers = parameter.getSupplierParams(easCtx);
        if (sources != null) {
            block0: for (DesignParameter[] supplier : suppliers) {
                if (supplier[0] == null || supplier[1] == null) continue;
                String disKey = supplier[0].getName();
                String sourceKey = supplier[1].getName();
                for (DesignParameter source : sources) {
                    if (!source.getName().equals(disKey)) continue;
                    DesignParameter d = params.get(sourceKey);
                    source.setCurentValue(d.getCurentValue());
                    source.setCurentValueAlias(d.getCurentValueAlias());
                    source.setDefaultValue(d.getDefaultValue());
                    source.setDefaultAlias(d.getDefaultAlias());
                    DesignParameter dp_text = new DesignParameter();
                    dp_text.setDesignDataType(DesignDataType.TXT);
                    dp_text.setName(source.getName() + "_text");
                    dp_text.setDataType(DataType.STRING);
                    dp_text.setCurentValue(source.getCurentValueAlias());
                    dp_text.setCurentValueAlias(source.getCurentValueAlias());
                    dp_text.setDefaultValue(source.getDefaultValue());
                    dp_text.setDefaultAlias(source.getDefaultAlias());
                    dp_text.setIgnoreNull(source.isIgnoreNull());
                    params.put(source.getName(), source);
                    params.put(dp_text.getName(), dp_text);
                    continue block0;
                }
            }
            for (DesignParameter source : sources) {
                ExtLightReportContentHandler.exeMacroValues(easCtx, source, params);
            }
        }
        return ExtLightFilterDelayDataHandler.translateRowset((IRowSet)CtrlDesignDataExecutor.execute(easCtx, model, params, null, 0, -1, true, null).get("6xx8xxRowset"));
    }

    private static MobileResult exeSystem(Context easCtx, String type, String rptId) throws Exception {
        String userId = ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString();
        ArrayList<HashMap<String, String>> orgs = OrgRangeManage.getOrgRangeList(easCtx, userId, Integer.parseInt(type), rptId);
        HashMap<String, Cloneable> jsonRowset = new HashMap<String, Cloneable>();
        HashMap metaVO = new HashMap();
        ArrayList<String> colNamesVO = new ArrayList<String>();
        ArrayList rowsVO = new ArrayList();
        if (orgs != null && !orgs.isEmpty()) {
            HashMap<String, String> item = orgs.get(0);
            ArrayList<String> row = new ArrayList<String>();
            for (String key : item.keySet()) {
                colNamesVO.add(key);
                row.add(item.get(key));
            }
            rowsVO.add(row);
            metaVO.put("colNames", colNamesVO);
            for (int i = 1; i < orgs.size(); ++i) {
                item = orgs.get(i);
                row = new ArrayList();
                for (String key : item.keySet()) {
                    row.add(item.get(key));
                }
                rowsVO.add(row);
            }
        }
        jsonRowset.put("meta", metaVO);
        jsonRowset.put("rows", rowsVO);
        return new MobileResult(jsonRowset);
    }

    protected static MobileResult translateRowset(IRowSet rs) throws Exception {
        HashMap<String, Cloneable> jsonRowset = new HashMap<String, Cloneable>();
        HashMap metaVO = new HashMap();
        ArrayList<String> colNamesVO = new ArrayList<String>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            colNamesVO.add(rsmd.getColumnName(i).toUpperCase());
        }
        metaVO.put("colNames", colNamesVO);
        ArrayList rowsVO = new ArrayList();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 1; i <= colCount; ++i) {
                Object d = rs.getObject(i);
                if (d instanceof Date) {
                    d = new java.util.Date(((Date)d).getTime());
                }
                if (d instanceof String) {
                    d = ((String)d).trim();
                }
                row.add(d);
            }
            rowsVO.add(row);
        }
        jsonRowset.put("meta", metaVO);
        jsonRowset.put("rows", rowsVO);
        return new MobileResult(jsonRowset);
    }

    @Override
    public String[] loadArgs(Map<String, String> params) {
        return new String[]{params.get("datasetXml"), params.get("reportId"), params.get("paramValues"), params.get("orgId"), params.get("paramName"), params.get("hmac"), params.get("base64Encoded")};
    }
}

