/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.dispatch.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.client.SendMailListUI;
import com.kingdee.eas.rpts.ctrlreport.email.SendMailInfo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.client.ReportDispatchUI;
import com.kingdee.eas.rpts.snapshot.dispatch.client.filterui.ReportDispatchFilterUI;
import com.kingdee.eas.rpts.snapshot.dispatch.codingrule.pojo.CodingRuleEntryInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.codingrule.pojo.CodingRuleInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.pojo.ReportDispatchInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.service.IReportDispatchService;
import com.kingdee.eas.rpts.snapshot.dispatch.service.impl.ReportDispatchServiceImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.util.ContextUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class ReportDispatchListUI
extends CoreUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportDispatchListUI.class);
    protected KDTable table;
    protected KDWorkButton btnSearch;
    protected KDWorkButton btnNew;
    protected KDWorkButton btnEdit;
    protected KDWorkButton btnView;
    protected KDWorkButton btnDel;
    protected KDWorkButton btnRelease;
    protected KDWorkButton btnUndoRelease;
    protected JToolBar.Separator separator1;
    protected KDWorkButton btnRefresh;
    protected KDSeparator kDSeparator2;
    protected KDMenuItem sendMail;
    private static final int DISPATCH_NAME = 0;
    private static final int TEMPLATE_NAME = 1;
    private static final int BACK_TRANSACTION_NAME = 2;
    private static final int CREATOR = 3;
    private static final int CREATOR_ORG_NAME = 4;
    private static final int LASTUPDATE_TIME = 5;
    private static final int DISPATCH_SERVER = 6;
    private ArrayList selectedIDList = new ArrayList();
    private IReportDispatchService dispatchService;
    private ReportDispatchFilterUI filter;
    String curUserId = EASUtil.getCurrentUserID();
    private final String defaultFilterCondition = " and s.fcodingruleid != 'null' and s.flastupdateuserid ='" + EASUtil.getCurrentUserID() + "'";

    public ReportDispatchListUI() throws Exception {
        this.init();
        this.initAction();
        this.initTable();
        this.installListeners();
        this.dispatchService = new ReportDispatchServiceImpl();
    }

    protected void init() throws Exception {
        this.setUITitle("\u8c03\u5ea6\u4e2d\u5fc3");
        this.table = new KDTable();
        this.btnSearch = new KDWorkButton();
        this.btnNew = new KDWorkButton();
        this.btnEdit = new KDWorkButton();
        this.btnView = new KDWorkButton();
        this.btnDel = new KDWorkButton();
        this.btnRelease = new KDWorkButton();
        this.btnUndoRelease = new KDWorkButton();
        this.separator1 = new JToolBar.Separator();
        this.btnRefresh = new KDWorkButton();
        this.kDSeparator2 = new KDSeparator();
        this.sendMail = new KDMenuItem();
        this.btnSearch.setText("\u67e5\u627e");
        this.btnSearch.setToolTipText("\u67e5\u627e");
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnNew.setText("\u65b0\u589e");
        this.btnNew.setToolTipText("\u65b0\u589e");
        this.btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnEdit.setText("\u4fee\u6539");
        this.btnEdit.setToolTipText("\u4fee\u6539");
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.btnView.setText("\u67e5\u770b");
        this.btnView.setToolTipText("\u67e5\u770b");
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnDel.setText("\u5220\u9664");
        this.btnDel.setToolTipText("\u5220\u9664");
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRelease.setText("\u53d1\u5e03\u8c03\u5ea6");
        this.btnRelease.setToolTipText("\u53d1\u5e03\u8c03\u5ea6");
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
        this.btnUndoRelease.setText("\u64a4\u9500\u53d1\u5e03");
        this.btnUndoRelease.setToolTipText("\u64a4\u9500\u53d1\u5e03");
        this.btnUndoRelease.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.btnRefresh.setText("\u5237\u65b0");
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setToolTipText("\u5237\u65b0");
        this.sendMail.setText("\u90ae\u4ef6\u5e10\u6237\u7ba1\u7406");
    }

    protected void initAction() {
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnQuery_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnNew_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnEdit_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnView_actionPerformed(null);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnDel_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnRelease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnRelease_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnUndoRelease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnUndoRelease_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.btnRefresh_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
        this.sendMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportDispatchListUI.this.sendMail_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportDispatchListUI.this.handUIException(exc);
                }
            }
        });
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.sendMail);
        this.menuFile.add((Component)this.kDSeparator2);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.btnSearch);
        this.toolBar.add((Component)this.btnRefresh);
        this.toolBar.add((Component)this.btnNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnView);
        this.toolBar.add((Component)this.btnDel);
        this.toolBar.add((Component)this.btnRelease);
        this.toolBar.add((Component)this.btnUndoRelease);
        this.toolBar.add((Component)this.separator1);
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.table.setBounds(new Rectangle(10, 10, 996, 610));
        this.add((Component)this.table, new KDLayout.Constraints(10, 10, 996, 610, 15));
    }

    protected void initTable() {
        int[] columnWidth = new int[]{128, 128, 260, 200, 200, 128, 260};
        String[] columnName = new String[]{"\u8c03\u5ea6\u540d\u79f0", "\u62a5\u8868\u6a21\u677f", "\u540e\u53f0\u4e8b\u52a1\u540d\u79f0", "\u521b\u5efa\u4eba", "\u521b\u5efa\u7ec4\u7ec7", "\u4fee\u6539\u65f6\u95f4", "\u6267\u884c\u670d\u52a1\u5668"};
        ControlDataLoadUtil.initTableHeader(this.table, 7, columnWidth, columnName);
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(10);
        this.table.getColumn(5).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
    }

    protected void installListeners() {
        this.table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ReportDispatchInfo info = null;
                KDTSelectBlock sb = e.getSelectBlock();
                int bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    info = (ReportDispatchInfo)ReportDispatchListUI.this.table.getRow(j).getUserObject();
                    if (!ReportDispatchListUI.this.curUserId.equals(info.getCreatorId())) {
                        ReportDispatchListUI.this.setButtonState(false);
                        return;
                    }
                    List dispatchInfoList = ReportDispatchListUI.this.getSelectedRecord();
                    if (dispatchInfoList == null) {
                        ReportDispatchListUI.this.setButtonState(true);
                        return;
                    }
                    int dsSize = dispatchInfoList.size();
                    for (int w = 0; w < dsSize; ++w) {
                        info = (ReportDispatchInfo)dispatchInfoList.get(w);
                        if (ReportDispatchListUI.this.curUserId.equals(info.getCreatorId())) continue;
                        ReportDispatchListUI.this.setButtonState(false);
                        return;
                    }
                    ReportDispatchListUI.this.setButtonState(true);
                }
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    KDTSelectBlock sb = null;
                    int size = ReportDispatchListUI.this.table.getSelectManager().size();
                    if (size == 1) {
                        sb = ReportDispatchListUI.this.table.getSelectManager().get(0);
                        ReportDispatchInfo info = (ReportDispatchInfo)ReportDispatchListUI.this.table.getRow(sb.getTop()).getUserObject();
                        ReportDispatchListUI.this.btnView_actionPerformed(info);
                    }
                } else if (e.getClickCount() == 1 && e.getType() == 1) {
                    KDTSelectBlock sb = null;
                    int size = ReportDispatchListUI.this.table.getSelectManager().size();
                    ReportDispatchInfo info = null;
                    for (int i = 0; i < size; ++i) {
                        sb = ReportDispatchListUI.this.table.getSelectManager().get(i);
                        int bottom = sb.getBottom();
                        for (int j = sb.getTop(); j <= bottom; ++j) {
                            info = (ReportDispatchInfo)ReportDispatchListUI.this.table.getRow(j).getUserObject();
                            if (!ReportDispatchListUI.this.curUserId.equals(info.getCreatorId())) {
                                ReportDispatchListUI.this.setButtonState(false);
                                return;
                            }
                            List dispatchInfoList = ReportDispatchListUI.this.getSelectedRecord();
                            if (dispatchInfoList == null) {
                                ReportDispatchListUI.this.setButtonState(true);
                                return;
                            }
                            int dsSize = dispatchInfoList.size();
                            for (int w = 0; w < dsSize; ++w) {
                                info = (ReportDispatchInfo)dispatchInfoList.get(w);
                                if (ReportDispatchListUI.this.curUserId.equals(info.getCreatorId())) continue;
                                ReportDispatchListUI.this.setButtonState(false);
                                return;
                            }
                        }
                    }
                    ReportDispatchListUI.this.setButtonState(true);
                }
            }
        });
    }

    private void setButtonState(boolean isEnable) {
        this.btnEdit.setEnabled(isEnable);
        this.btnDel.setEnabled(isEnable);
        this.btnRelease.setEnabled(isEnable);
        this.btnUndoRelease.setEnabled(isEnable);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshTable(this.defaultFilterCondition);
    }

    public void refreshTable(String whereSql) throws BOSException, IOException {
        List dispatchList = this.dispatchService.getReportDispatchList(whereSql);
        this.table.removeRows();
        if (dispatchList == null || dispatchList.size() == 0) {
            return;
        }
        ReportDispatchInfo info = null;
        CodingRuleInfo ruleInfo = null;
        SendMailInfo mailInfo = null;
        CodingRuleEntryInfo entryInfo = null;
        String curUserId = EASUtil.getCurrentUserID();
        HashMap<String, String> idMap = new HashMap<String, String>();
        String dispatchId = null;
        int size = dispatchList.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)dispatchList.get(i);
            dispatchId = (String)map.get("fid");
            if (!idMap.containsKey(dispatchId)) {
                Object fisenabledispatchplan;
                info = new ReportDispatchInfo();
                ruleInfo = new CodingRuleInfo();
                ruleInfo.setCodingRuleEntryInfoList(new ArrayList(size));
                idMap.put(dispatchId, dispatchId);
                IRow row = this.table.addRow();
                row.getCell(0).setValue((Object)((String)map.get("dispatchname")));
                row.getCell(1).setValue((Object)((String)map.get("reportname")));
                row.getCell(2).setValue((Object)CtrlReportUtil.getObjectString(map.get("ftitle")));
                row.getCell(3).setValue((Object)CtrlReportUtil.getObjectString(map.get("username")));
                row.getCell(4).setValue(map.get("orgname"));
                row.getCell(5).setValue(map.get("dispatchupdatetime"));
                row.getCell(6).setValue(map.get("dispatchserver"));
                String creatorId = (String)map.get("fcreatorid");
                String orgUnitId = (String)map.get("orgunitid");
                if (!curUserId.equals(creatorId)) {
                    row.getStyleAttributes().setBackground(EASUtil.PINK);
                }
                if ((fisenabledispatchplan = map.get("fisenabledispatchplan")) != null && "1".equals(fisenabledispatchplan.toString())) {
                    row.getStyleAttributes().setBackground(EASUtil.LIGHT_BLUE);
                }
                info.setId(dispatchId);
                info.setJobProcessDefID((String)map.get("fjobprocessdefid"));
                info.setCreatorId((String)map.get("fcreatorid"));
                info.setName((String)map.get("dispatchname"), EASUtil.gelLoginLocal());
                info.setReportId((String)map.get("freportid"));
                info.setFilterXML(DispatchCommonUtil.clob2String(map.get("ffilterxml")));
                info.setScheduleXML(DispatchCommonUtil.clob2String(map.get("fschedulexml")));
                info.setSendMail((String)map.get("fsendmail"));
                info.setEmail((String)map.get("femail"));
                info.setExcelPath((String)map.get("fexcelpath"));
                info.setFoldType(((Number)map.get("foldtype")).intValue());
                info.setSaveHyplink(((Number)map.get("fsavehyplink")).intValue() == 1);
                info.setFoldPath((String)map.get("ffoldpath"));
                info.setMsgSendType(((Number)map.get("fmsgsendtype")).intValue());
                info.setSnapShotSaveType(((Number)map.get("fsnapshotsavetype")).intValue());
                int isTakeAttach = ((Number)map.get("fistakeattachment")).intValue();
                if (0 == isTakeAttach) {
                    info.setIsTakeAttachment(false);
                } else if (1 == isTakeAttach) {
                    info.setIsTakeAttachment(true);
                }
                info.setCreatorId(creatorId);
                info.setOrgUnitId(orgUnitId);
                ruleInfo.setId((String)map.get("coderuleid"));
                ruleInfo.setLastUpdateUserId((String)map.get("ruleupdateUserid"));
                info.setCodingRuleInfo(ruleInfo);
                mailInfo = new SendMailInfo();
                mailInfo.setMailAddress((String)map.get("fmailaddress"));
                mailInfo.setMailHost((String)map.get("fmailhost"));
                mailInfo.setMailUser((String)map.get("fmailuser"));
                mailInfo.setMailPassword((String)map.get("fmailpassword"));
                info.setMailInfo(mailInfo);
                info.setMailTitle((String)map.get("mailtitle"));
                info.setMailContent((String)map.get("mailcontent"));
                info.setDispatchServer((String)map.get("dispatchserver"));
                row.setUserObject((Object)info);
            }
            String entryCodingRuleId = (String)map.get("entrycoderuleid");
            if (ruleInfo.getId() == null || entryCodingRuleId == null || !ruleInfo.getId().equals(entryCodingRuleId)) continue;
            List codingEntryList = ruleInfo.getCodingRuleEntryInfoList();
            entryInfo = new CodingRuleEntryInfo();
            entryInfo.setId((String)map.get("entryid"));
            entryInfo.setAttributeValue((String)map.get("fattributevalue"));
            entryInfo.setIndex(((Number)map.get("findex")).intValue());
            entryInfo.setPrefix((String)map.get("fprefix"));
            entryInfo.setSeparator((String)map.get("fseparator"));
            entryInfo.setSuffix((String)map.get("fsuffix"));
            entryInfo.setType(((Number)map.get("ftype")).intValue());
            codingEntryList.add(entryInfo);
        }
    }

    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        Frame owner = (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (this.filter == null) {
            this.filter = new ReportDispatchFilterUI(owner, "\u8c03\u5ea6\u8fc7\u6ee4", true, false, this);
        }
        this.filter.setLocationRelativeTo(null);
        this.filter.setVisible(true);
    }

    public void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.filter != null) {
            this.refreshTable(this.filter.getWhereSql());
        } else {
            this.refreshTable(this.defaultFilterCondition);
        }
    }

    protected List getSelectedRecord() {
        ArrayList<ReportDispatchInfo> dispatchInfoList = new ArrayList<ReportDispatchInfo>();
        KDTSelectBlock sb = null;
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                dispatchInfoList.add((ReportDispatchInfo)this.table.getRow(j).getUserObject());
            }
        }
        return dispatchInfoList;
    }

    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EASUtil.IS_SEND, (Object)Boolean.FALSE);
        uiContext.put((Object)ContextUtil.REPORT_DISPATCH_INFO, null);
        uiContext.put((Object)"cacheState", (Object)OprtState.ADDNEW);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportDispatchUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        window.show();
    }

    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!DispatchCommonUtil.isSelectRecord(this.table)) {
            return;
        }
        List dispatchInfoList = this.getSelectedRecord();
        if (dispatchInfoList != null && dispatchInfoList.size() > 1) {
            MessageUtil.showInfo("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", false);
            return;
        }
        ReportDispatchInfo info = (ReportDispatchInfo)dispatchInfoList.get(0);
        String curUserId = EASUtil.getCurrentUserID();
        UIContext uiContext = new UIContext((Object)this);
        if (curUserId.equals(info.getCreatorId())) {
            uiContext.put((Object)"cacheState", (Object)OprtState.EDIT);
        } else {
            uiContext.put((Object)"cacheState", (Object)OprtState.VIEW);
        }
        uiContext.put((Object)ContextUtil.REPORT_DISPATCH_INFO, (Object)info);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportDispatchUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    protected void btnView_actionPerformed(ReportDispatchInfo info) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"cacheState", (Object)OprtState.VIEW);
        if (info == null) {
            if (!DispatchCommonUtil.isSelectRecord(this.table)) {
                return;
            }
            List dispatchInfoList = this.getSelectedRecord();
            if (dispatchInfoList != null && dispatchInfoList.size() > 1) {
                MessageUtil.showInfo("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", false);
                return;
            }
            uiContext.put((Object)ContextUtil.REPORT_DISPATCH_INFO, dispatchInfoList.get(0));
        } else {
            uiContext.put((Object)ContextUtil.REPORT_DISPATCH_INFO, (Object)info);
        }
        try {
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportDispatchUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        if (!DispatchCommonUtil.isSelectRecord(this.table)) {
            return;
        }
        List dispatchInfoList = this.getSelectedRecord();
        if (dispatchInfoList == null || dispatchInfoList.size() == 0) {
            return;
        }
        ReportDispatchInfo info = null;
        StringBuffer msg = new StringBuffer();
        String locale = EASUtil.gelLoginLocal();
        boolean isDelete = true;
        boolean isShowMsg = false;
        String confirmMsg = "";
        ArrayList<ReportDispatchInfo> deleteList = new ArrayList<ReportDispatchInfo>(dispatchInfoList.size());
        int size = dispatchInfoList.size();
        for (int i = 0; i < size; ++i) {
            info = (ReportDispatchInfo)dispatchInfoList.get(i);
            if (!this.curUserId.equals(info.getCreatorId())) {
                if (i == 0) {
                    msg.append(info.getName(locale));
                    continue;
                }
                msg.append(",").append(info.getName(locale));
                continue;
            }
            String fjobprocessdefid = info.getJobProcessDefID();
            deleteList.add(info);
            if (StringUtil.isEmptyString((String)fjobprocessdefid) || isShowMsg) continue;
            confirmMsg = "\u5b58\u5728\u5df2\u53d1\u5e03\u4e3a\u540e\u53f0\u4e8b\u52a1\u7684\u8c03\u5ea6\uff0c\u5982\u679c\u5220\u9664\uff0c\u5c06\u540c\u65f6\u5220\u9664\u5bf9\u5e94\u7684\u540e\u53f0\u4e8b\u52a1\uff0c\u786e\u5b9a\u5220\u9664\uff1f";
            isDelete = MessageUtil.showConfirm(null, confirmMsg);
            isShowMsg = true;
        }
        if (isDelete) {
            if (StringUtil.isEmptyString((String)confirmMsg)) {
                if (MessageUtil.showConfirm(null, "\u786e\u5b9a\u5220\u9664\u9009\u62e9\u7684\u8c03\u5ea6\u5417\uff1f")) {
                    if (msg.length() > 0) {
                        MessageUtil.showInfo("\u4ee5\u4e0b\u8c03\u5ea6\uff1a" + msg.toString() + " \u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u56e0\u4e3a\u60a8\u6ca1\u6709\u5220\u9664\u8fd9\u4e9b\u8c03\u5ea6\u7684\u6743\u9650", false);
                    }
                    this.dispatchService.deleteDispatch(deleteList);
                } else {
                    isDelete = false;
                }
            } else {
                this.dispatchService.deleteDispatch(deleteList);
                if (msg.length() > 0) {
                    MessageUtil.showInfo("\u4ee5\u4e0b\u8c03\u5ea6\uff1a" + msg.toString() + " \u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u56e0\u4e3a\u60a8\u6ca1\u6709\u5220\u9664\u8fd9\u4e9b\u8c03\u5ea6\u7684\u6743\u9650", false);
                }
            }
        }
        if (isDelete) {
            this.btnRefresh_actionPerformed(null);
        }
    }

    protected void btnRelease_actionPerformed(ActionEvent e) throws Exception {
        if (!DispatchCommonUtil.isSelectRecord(this.table)) {
            return;
        }
        List dispatchInfoList = this.getSelectedRecord();
        if (dispatchInfoList == null || dispatchInfoList.size() == 0) {
            return;
        }
        if (!MessageUtil.showConfirm(null, "\u786e\u5b9a\u53d1\u5e03\u5417\uff1f")) {
            return;
        }
        ArrayList<ReportDispatchInfo> releaseList = new ArrayList<ReportDispatchInfo>(dispatchInfoList.size());
        int size = dispatchInfoList.size();
        for (int i = 0; i < size; ++i) {
            ReportDispatchInfo info = (ReportDispatchInfo)dispatchInfoList.get(i);
            if (!StringUtil.isEmptyString((String)info.getJobProcessDefID())) continue;
            releaseList.add(info);
        }
        if (releaseList.size() == 0) {
            MessageUtil.showInfo("\u60a8\u9009\u62e9\u7684\u8c03\u5ea6\u5747\u5df2\u53d1\u5e03\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03", false);
            return;
        }
        this.dispatchService.release(releaseList);
        MessageUtil.showInfo("\u53d1\u5e03\u6210\u529f\uff0c\u8bf7\u5728\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u8868\u4e2d\u7ef4\u62a4\u8c03\u5ea6\u5b9e\u4f8b", false);
        this.btnRefresh_actionPerformed(null);
    }

    protected void btnUndoRelease_actionPerformed(ActionEvent e) throws Exception {
        if (!DispatchCommonUtil.isSelectRecord(this.table)) {
            return;
        }
        List dispatchInfoList = this.getSelectedRecord();
        if (dispatchInfoList == null || dispatchInfoList.size() == 0) {
            return;
        }
        ArrayList<ReportDispatchInfo> undoReleaseList = new ArrayList<ReportDispatchInfo>(dispatchInfoList.size());
        int size = dispatchInfoList.size();
        for (int i = 0; i < size; ++i) {
            ReportDispatchInfo info = (ReportDispatchInfo)dispatchInfoList.get(i);
            if (StringUtil.isEmptyString((String)info.getJobProcessDefID())) continue;
            undoReleaseList.add(info);
        }
        if (undoReleaseList.size() == 0) {
            MessageUtil.showInfo("\u60a8\u9009\u62e9\u7684\u8c03\u5ea6\u5168\u90fd\u6ca1\u6709\u53d1\u5e03\u8fc7\uff0c\u4e0d\u80fd\u64a4\u9500\u53d1\u5e03", false);
            return;
        }
        this.dispatchService.undoRelease(dispatchInfoList);
        this.btnRefresh_actionPerformed(null);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.btnEdit_actionPerformed(null);
            return;
        }
        if (e.getClickCount() == 1 && e.getType() == 1) {
            ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.table);
            this.selectedIDList.clear();
            String strRowIndex = lstIndex.get(lstIndex.size() - 1).toString();
            HashMap mapInfo = (HashMap)this.table.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fid = mapInfo.get("fid").toString();
            this.selectedIDList.add(fid);
        }
    }

    protected void sendMail_actionPerformed(ActionEvent e) throws Exception {
        Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)((Object)this));
        UIContext uiContext = new UIContext((Object)mainFrame);
        uiContext.put("checkLicense", "true");
        uiContext.put("MainMenuName", MessageUtil.getMsgInfo("label441"));
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
            IUIWindow uiWindow = uiFactory.create(SendMailListUI.class.getName(), (Map)uiContext, null, null);
            if (uiWindow != null) {
                uiWindow.show();
            }
        }
        catch (UIException ex) {
            this.handUIException(ex);
        }
    }
}

