/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.ds.ui;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotPartInfo;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotQueryModel;
import com.kingdee.eas.rpts.snapshot.ds.ui.SnapshotFilterUI;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.rpts.snapshot.manage.client.mview.complete.ImageCellRender;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.SSManageTree;
import com.kingdee.eas.rpts.snapshot.manage.consta.FolderType;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PersonalFolder;
import com.kingdee.eas.rpts.snapshot.manage.service.ISnapshotRelativeService;
import com.kingdee.eas.rpts.snapshot.manage.service.SnapshotRelativeService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ChooseSnapshotUI
extends KDDialog {
    protected static final String TITLE = "\u9009\u62e9\u5feb\u7167";
    private SSManageTree _treeMgr;
    private KDTable _table;
    private KDTable _chooseds;
    private KDWorkButton _chooseBtn;
    private KDWorkButton _unChooseBtn;
    protected boolean _cancel;
    private static final String COL_SNAPSHOT_NAME = "\u5feb\u7167\u540d\u79f0";
    private static final String COL_REPORT_NAME = "\u6a21\u677f\u540d\u79f0";
    private static final int COL_SNAPSHOT = 0;
    private static final int COL_REPORT = 1;
    private Set _entities;
    private int _folderType;
    private String _branch;
    private SnapshotFilterUI _filterUI;

    public ChooseSnapshotUI(Frame frame) {
        super(frame, true);
        this.init();
        this.installListeners();
        this.initToolBar();
    }

    private void installListeners() {
        this._table.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ChooseSnapshotUI.this._chooseBtn.setEnabled(ChooseSnapshotUI.this._table.getSelectManager().size() > 0);
            }
        });
        this._chooseds.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ChooseSnapshotUI.this._unChooseBtn.setEnabled(ChooseSnapshotUI.this._chooseds.getSelectManager().size() > 0);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChooseSnapshotUI.this._cancel = true;
            }
        });
    }

    private void initToolBar() {
        KDWorkButton btnQuery = new KDWorkButton();
        btnQuery.setText("\u67e5\u627e");
        btnQuery.setIcon((Icon)SSIcons.createIcon("tbtn_Filter.gif"));
        btnQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSnapshotUI.this.actionQuery();
            }
        });
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)btnQuery);
        this.addToolBar((JToolBar)toolBar);
    }

    protected void actionQuery() {
        if (this._filterUI == null) {
            this._filterUI = new SnapshotFilterUI((Dialog)((Object)this));
        }
        this._filterUI.setLocationRelativeTo(null);
        this._filterUI.setVisible(true);
        if (this._filterUI._cancel) {
            return;
        }
        SnapshotQueryModel model = this._filterUI.getModel();
        try {
            ISnapshotRelativeService serv = SnapshotRelativeService.getInst();
            List lst = serv.queryPhantomSnapshots(model, this._branch, this._folderType);
            this._table.removeRows();
            if (lst != null && lst.size() > 0) {
                int size = lst.size();
                for (int i = 0; i < size; ++i) {
                    this.addTableRow(this._table, (SnapshotPartInfo)lst.get(i));
                }
            }
        }
        catch (SnapshotException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u67e5\u627e\u5feb\u7167\u5217\u8868\u5931\u8d25", e.toString());
        }
    }

    public ChooseSnapshotUI(Dialog dialog) {
        super(dialog, true);
        this.init();
        this.installListeners();
        this.initToolBar();
    }

    private void init() {
        this.setTitle(TITLE);
        this.setDefaultCloseOperation(1);
        this._table = this.initTable();
        this._chooseds = this.initTable();
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                    ChooseSnapshotUI.this.chooseSnapshots();
                }
            }
        });
        this._chooseds.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                    ChooseSnapshotUI.this.unChooseSnapshots();
                }
            }
        });
        this._chooseBtn = new KDWorkButton();
        this._chooseBtn.setText("\u6dfb\u52a0");
        this._chooseBtn.setEnabled(false);
        this._chooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_movedown.gif"));
        this._chooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSnapshotUI.this.chooseSnapshots();
            }
        });
        this._unChooseBtn = new KDWorkButton();
        this._unChooseBtn.setText("\u79fb\u9664");
        this._unChooseBtn.setEnabled(false);
        this._unChooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_movetop.gif"));
        this._unChooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSnapshotUI.this.unChooseSnapshots();
            }
        });
        KDButton btnOK = new KDButton("\u786e\u5b9a");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSnapshotUI.this.actionOK();
            }
        });
        KDButton btnCancel = new KDButton("\u53d6\u6d88");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseSnapshotUI.this._cancel = true;
                ChooseSnapshotUI.this.setVisible(false);
            }
        });
        this._treeMgr = new SSManageTree((Dialog)((Object)this));
        this._treeMgr.setTreeBuilder2();
        this._treeMgr.setFolderChangeObserver(new FolderTypeChangeObserver());
        this._treeMgr.setSelectionObserver(new TreeSelectionObserver());
        this._treeMgr.buildTree();
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(247);
        ((KDTreeView)this._treeMgr.getUI()).setShowButton(false);
        sppLeftRight.setLeftComponent(this._treeMgr.getUI());
        KDSplitPane sppTopButtom = new KDSplitPane(0);
        sppTopButtom.setDividerLocation(200);
        sppTopButtom.setTopComponent((Component)this._table);
        KDContainer ctn = new KDContainer();
        ctn.setEnableActive(false);
        ctn.setTitle("\u5df2\u9009\u62e9\u5feb\u7167");
        TableLayout2 ly = new TableLayout2(2, 3);
        ly.setFixedHeight(0, 21);
        ly.setRatableHeight(1, 300);
        ly.setFixedWidth(TableLayout2.ALL, 74);
        ly.setRatableWidth(0, 300);
        ly.setColsSpacing(TableLayout2.ALL, 3);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        KDPanel bottomPanel = new KDPanel((LayoutManager)ly);
        bottomPanel.add((Component)this._chooseBtn, (Object)TableLayout2.param((int)0, (int)1));
        bottomPanel.add((Component)this._unChooseBtn, (Object)TableLayout2.param((int)0, (int)2));
        bottomPanel.add((Component)this._chooseds, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        ctn.setContentPane((Container)bottomPanel);
        sppTopButtom.setBottomComponent((Component)ctn);
        sppLeftRight.setRightComponent((Component)sppTopButtom);
        TableLayout2 ly2 = new TableLayout2(3, 3);
        ly2.setFixedHeight(1, 3);
        ly2.setRatableHeight(0, 500);
        ly2.setFixedHeight(2, 21);
        ly2.setFixedWidth(TableLayout2.ALL, 74);
        ly2.setRatableWidth(0, 300);
        ly2.setColsSpacing(TableLayout2.ALL, 3);
        ly2.setRowsSpacing(TableLayout2.ALL, 9);
        KDPanel board = new KDPanel((LayoutManager)ly2);
        board.setCustomInsets(new Insets(10, 10, 10, 10));
        board.add((Component)sppLeftRight, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)2));
        board.add((Component)new KDSeparator(), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        board.add((Component)btnOK, (Object)TableLayout2.param((int)2, (int)1));
        board.add((Component)btnCancel, (Object)TableLayout2.param((int)2, (int)2));
        this.setContentPane((Container)board);
        this.setSize(780, 520);
        this._entities = new HashSet();
    }

    protected KDTable initTable() {
        KDTable table = new KDTable();
        table.addColumns(2);
        table.getStyleAttributes().setLocked(true);
        table.getColumn(0).setWidth(231);
        table.getColumn(1).setWidth(213);
        table.getColumn(1).setSortable(true);
        IRow header = table.addHeadRow();
        header.getCell(0).setValue((Object)COL_SNAPSHOT_NAME);
        header.getCell(1).setValue((Object)COL_REPORT_NAME);
        table.getSelectManager().setSelectMode(10);
        table.putDefaultRenderers(SnapshotPartInfo.class, (IBasicRender)ImageCellRender.getInst());
        KDTSortManager sortManager = new KDTSortManager(table);
        sortManager.setSortAuto(true);
        table.setSortMange(sortManager);
        return table;
    }

    protected void addTableRow(KDTable table, SnapshotPartInfo info) {
        IRow row = table.addRow();
        row.getCell(0).setValue((Object)info);
        row.getCell(1).setValue((Object)info.getReportName());
        row.setUserObject((Object)info);
    }

    protected void actionOK() {
        if (this._entities == null || this._entities.size() == 0) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u5df2\u9009\u62e9\u5feb\u7167\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5feb\u7167\u3002");
            return;
        }
        this._cancel = false;
        this.setVisible(false);
    }

    protected void unChooseSnapshots() {
        int[] rows = TableManager.getSelectedTableIndexs2(this._chooseds);
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            IRow row = this._chooseds.getRow(rows[i]);
            this._chooseds.removeRow(rows[i]);
            this._entities.remove(row.getUserObject());
        }
    }

    protected void chooseSnapshots() {
        int[] rows = TableManager.getSelectedTableIndexs2(this._table);
        for (int i = 0; i < rows.length; ++i) {
            Object obj = this._table.getRow(rows[i]).getUserObject();
            if (this._entities.contains(obj)) continue;
            this._entities.add(obj);
            this.addTableRow(this._chooseds, (SnapshotPartInfo)obj);
        }
    }

    public Set getEntities() {
        return this._entities;
    }

    protected void loadTableData(int folderType, Object uo) {
        ISnapshotRelativeService serv;
        List lst = null;
        if (folderType == FolderType.PERSONAL_FOLDER) {
            PersonalFolder folder = (PersonalFolder)uo;
            try {
                serv = SnapshotRelativeService.getInst();
                this._branch = folder.getLongNumber();
                lst = serv.getPhantomSnapshotNotLimited(EASUtil.getCurrentUserID(), this._branch);
            }
            catch (SnapshotException e) {
                ExtMsgBox.showError((Component)((Object)this), "\u67e5\u8be2\u5feb\u7167\u5217\u8868\u5931\u8d25", e.toString());
            }
        } else if (folderType == FolderType.COMMON_FOLDER) {
            IBriefViewTreeNode branch = (IBriefViewTreeNode)uo;
            try {
                serv = SnapshotRelativeService.getInst();
                this._branch = branch.getFullName();
                lst = serv.getSnapshotsNotLimited(EASUtil.getCurrentOrgID(), branch.getFullName());
            }
            catch (SnapshotException e) {
                ExtMsgBox.showError((Component)((Object)this), "\u67e5\u8be2\u5feb\u7167\u5217\u8868\u5931\u8d25", e.toString());
            }
        }
        this._table.removeRows();
        if (lst != null && lst.size() > 0) {
            int size = lst.size();
            for (int i = 0; i < size; ++i) {
                this.addTableRow(this._table, (SnapshotPartInfo)lst.get(i));
            }
        }
    }

    public boolean isCancel() {
        return this._cancel;
    }

    public void setCancel(boolean cancel) {
        this._cancel = cancel;
    }

    protected class TreeSelectionObserver
    implements SSManageTree.ITreeSelectionObserver {
        protected TreeSelectionObserver() {
        }

        @Override
        public void update(int folderType, Object userObject) {
            ChooseSnapshotUI.this.loadTableData(folderType, userObject);
        }
    }

    protected class FolderTypeChangeObserver
    implements SSManageTree.IFolderTypeChangeObserver {
        protected FolderTypeChangeObserver() {
        }

        @Override
        public void update(int folderType) {
            ChooseSnapshotUI.this._folderType = folderType;
            ChooseSnapshotUI.this._table.removeRows();
        }
    }
}

