/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client;

import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.base.execution.SnapExecutor;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.sumreport.client.common.LoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class SnapshotRunUI
extends CoreUI {
    private byte[] _data;
    private IExistenceCheck _existenceChecker;
    public static final String SNAPSHOT_DATA = "SNAPSHOT_DATA";
    public static final String FRONT_TASK = "FRONT_TASK";
    private Action[] _extraActions;
    private SpreadContext _spreadContext;
    private FrontTask _frontTask;

    public void onLoad() throws Exception {
        this._data = (byte[])this.getUIContext().get(SNAPSHOT_DATA);
        this.preCheck();
        if (this._frontTask == null) {
            this._frontTask = (FrontTask)this.getUIContext().get(FRONT_TASK);
        }
        super.onLoad();
        this.setUITitle(String.valueOf(this.getUIContext().get("MainMenuName")));
    }

    public void runEXT() {
        SnapshotRunner worker = new SnapshotRunner();
        worker.start();
    }

    private void preCheck() {
        EXTLicenseService licSrsv = new EXTLicenseService(null);
        try {
            if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                MessageUtil.showInfo("\u6ca1\u6709EAS\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u7684License\uff1b\u8bf7\u5148\u8d2d\u4e70\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u3002", false);
                this.selfDestruction();
            }
        }
        catch (EXTLicenseException e) {
            MessageUtil.showDetailAndOK(null, "\u5931\u8d25", e);
            this.selfDestruction();
        }
        if (!(this._data != null && this._existenceChecker == null || this._data != null && this._existenceChecker.check())) {
            MessageUtil.showInfo("\u5feb\u7167\u5df2\u7ecf\u88ab\u5220\u9664", false);
        }
    }

    private void selfDestruction() {
        this.abort();
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.rpts.ctrlreport.client", "ReportStudioUI");
    }

    public void setExistenceChecker(IExistenceCheck existenceChecker) {
        this._existenceChecker = existenceChecker;
    }

    public void setExtraActions(Action[] actions) {
        this._extraActions = actions;
    }

    public SpreadContext getSpreadContext() {
        return this._spreadContext;
    }

    public FrontTask getFrontTask() {
        return this._frontTask;
    }

    public void setFrontTask(FrontTask frontTask) {
        this._frontTask = frontTask;
        System.out.println(frontTask.toString());
    }

    public static interface FrontTask {
        public void deal(SnapExecutor var1) throws Exception;
    }

    private class SnapshotRunner
    extends LongTaskWorker {
        private SnapExecutor _executor;
        private SnapshotRunUI ui;

        private SnapshotRunner() {
            this.ui = SnapshotRunUI.this;
        }

        public Object construct() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnapshotRunner.this.ui.setLayout(new BorderLayout());
                    SnapshotRunner.this.ui.add(new LoadingPanel(), "Center");
                    SnapshotRunner.this.ui.revalidate();
                }
            });
            try {
                this.load();
                if (SnapshotRunUI.this._frontTask != null) {
                    SnapshotRunUI.this._frontTask.deal(this._executor);
                } else {
                    System.out.println("\u6211\u662f\u7a7a");
                }
                if (!this._executor.execute()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotRunner.this.ui.getUIWindow().close();
                        }
                    });
                    return null;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageUtil.showDetailAndOK(null, "\u6267\u884c\u62a5\u8868\u51fa\u9519", e);
                    }
                });
                return null;
            }
        }

        private void load() throws Exception {
            this._executor = new SnapExecutor(this.ui._data);
        }

        public void finished() {
            Object obj = this.get();
            if (obj != null && obj == Boolean.TRUE) {
                this.displayReport();
            }
        }

        private void displayReport() {
            Action[] actions = this._executor.getContextualActions(4);
            Window cr = SwingUtilities.getWindowAncestor((Component)((Object)this.ui));
            if (null != cr) {
                if (SnapshotRunUI.this._extraActions != null) {
                    for (int j = 0; j < SnapshotRunUI.this._extraActions.length; ++j) {
                        this.ui.toolBar.add(SnapshotRunUI.this._extraActions[j]);
                    }
                    this.ui.toolBar.addSeparator();
                }
                for (int i = 0; i < actions.length; ++i) {
                    this.ui.toolBar.add(actions[i]);
                }
                SnapshotRunUI.this._spreadContext = this._executor.getSpreadContext();
                this.ui.removeAll();
                this.ui.add((Component)SnapshotRunUI.this._spreadContext, "Center");
                Object owner = SnapshotRunUI.this.getUIContext().get("Owner");
                ExtReportRunUI.setShowLinkage(SnapshotRunUI.this._spreadContext, owner);
                cr.validate();
                cr.repaint();
            }
        }
    }

    public static interface IExistenceCheck {
        public boolean check();
    }
}

