/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.mview.action.ui;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.service.ISnapshotRelativeService;
import com.kingdee.eas.rpts.snapshot.manage.service.SnapshotRelativeService;
import com.kingdee.eas.rpts.sumreport.client.task.algorithm.PeriodSettingPanel;
import com.kingdee.eas.rpts.sumreport.model.DefaultInfo;
import com.kingdee.eas.rpts.sumreport.model.IInfo;
import com.kingdee.eas.rpts.sumreport.model.InfoMessagePanel;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ModifyPropsUI
extends KDDialog {
    private KDTextField _tfName;
    private KDCheckBox _cbPeriodSum;
    private PeriodSettingPanel _periodSetting;
    private KDComboBox _cmbPeriod;
    private KDContainer _crPeriod;
    private KDPanel _board;
    private KDPanel _innerPanel;
    private KDWorkButton _btnSave;
    private KDWorkButton _btnClose;
    private PhantomSnapshot _value;
    private InfoMessagePanel _tipPanel;
    private boolean _bePersonalFolder;
    private ISnapshotRelativeService _serv;

    public ModifyPropsUI(Frame owner, boolean bePersonalFolder) {
        super(owner, true);
        this._bePersonalFolder = bePersonalFolder;
        this.initUI();
        this.installToolBar();
        this.installListener();
    }

    public ModifyPropsUI(Dialog owner) {
        super(owner, true);
        this.initUI();
        this.installToolBar();
        this.installListener();
    }

    private void installToolBar() {
        KDToolBar toolBar = new KDToolBar(0);
        toolBar.add((Component)this._btnSave);
        toolBar.add((Component)this._btnClose);
        this.addToolBar((JToolBar)toolBar);
    }

    private void installListener() {
        this._cmbPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ModifyPropsUI.this._periodSetting == null) {
                    return;
                }
                ModifyPropsUI.this._periodSetting.removeAll();
                ModifyPropsUI.this._innerPanel.remove((Component)((Object)ModifyPropsUI.this._periodSetting));
                ModifyPropsUI.this._periodSetting = null;
                ModifyPropsUI.this._periodSetting = PeriodSettingPanel.getPeriodSettingPanel(ModifyPropsUI.this._cmbPeriod.getSelectedIndex(), (TableLayout2)ModifyPropsUI.this._innerPanel.getLayout(), 1, "\u6ce8\u610f\uff1a\u5feb\u7167\u671f\u95f4");
                ModifyPropsUI.this._periodSetting.setPreferredSize(new Dimension(672, 45));
                ModifyPropsUI.this._innerPanel.add((Component)((Object)ModifyPropsUI.this._periodSetting), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
                ModifyPropsUI.this._innerPanel.doLayout();
                ModifyPropsUI.this._innerPanel.revalidate();
                ModifyPropsUI.this._innerPanel.repaint();
            }
        });
        this._cbPeriodSum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enable = ModifyPropsUI.this._cbPeriodSum.isSelected();
                ModifyPropsUI.this._cmbPeriod.setEnabled(enable);
                Component[] cs = ModifyPropsUI.this._periodSetting.getComponents();
                for (int i = 0; i < cs.length; ++i) {
                    cs[i].setEnabled(enable);
                }
            }
        });
        this._cbPeriodSum.setSelected(false, true);
    }

    private void initUI() {
        this.setTitle("\u5c5e\u6027");
        this.setDefaultCloseOperation(2);
        Dimension leftSize = new Dimension(84, 21);
        KDLabelContainer lc1 = new KDLabelContainer();
        lc1.setBoundLabelText("\u5feb\u7167\u540d\u79f0\uff1a");
        lc1.setBoundLabelUnderline(true);
        lc1.setPreferredSize(leftSize);
        KDLabelContainer lc2 = new KDLabelContainer();
        lc2.setBoundLabelText("\u4fdd\u5b58\u4f4d\u7f6e\uff1a");
        lc2.setBoundLabelUnderline(true);
        lc2.setPreferredSize(leftSize);
        KDLabelContainer lc3 = new KDLabelContainer();
        lc3.setBoundLabelText("\u7c7b\u578b\uff1a");
        lc3.setBoundLabelUnderline(true);
        lc3.setPreferredSize(leftSize);
        this._cbPeriodSum = new KDCheckBox("\u662f\u5426\u671f\u95f4\u6c47\u603b", true);
        this._cbPeriodSum.setPreferredSize(leftSize);
        Dimension rightSize = new Dimension(242, 21);
        this._tfName = new KDTextField();
        this._tfName.setPreferredSize(rightSize);
        this._cmbPeriod = new KDComboBox(new Object[]{"\u5176\u4ed6", "\u5e74", "\u534a\u5e74", "\u5b63\u5ea6", "\u6708", "\u534a\u6708", "\u65e5"});
        this._cmbPeriod.setPreferredSize(rightSize);
        this._periodSetting = PeriodSettingPanel.getPeriodSettingPanel(ReportSnapType.UNKNOW);
        this._periodSetting.setPreferredSize(new Dimension(672, 117));
        this._crPeriod = new KDContainer();
        this._crPeriod.setTitle("\u671f\u95f4");
        this._crPeriod.setEnableActive(false);
        this._crPeriod.setPreferredSize(new Dimension(326, 141));
        TableLayout2 ly = new TableLayout2(3, 2);
        ly.setFixedHeight(new int[]{0, 1}, 21);
        ly.setRatableHeight(2, 117);
        ly.setFixedWidth(0, 84);
        ly.setRatableWidth(1, 242);
        ly.setColSpacing(0, 0);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        this._board = new KDPanel((LayoutManager)ly);
        this._board.setCustomInsets(new Insets(10, 10, 10, 10));
        this._board.setPreferredSize(new Dimension(346, 272));
        this._board.add((Component)lc1, (Object)TableLayout2.param((int)0, (int)0));
        this._board.add((Component)this._tfName, (Object)TableLayout2.param((int)0, (int)1));
        this._board.add((Component)this._cbPeriodSum, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        TableLayout2 ly2 = new TableLayout2(3, 2);
        ly2.setFixedHeight(0, 21);
        ly2.setFixedHeight(1, 69);
        ly2.setRatableHeight(2, 117);
        ly2.setRowsSpacing(TableLayout2.ALL, 3);
        ly2.setFixedWidth(0, 84);
        ly2.setRatableWidth(1, 242);
        ly2.setColsSpacing(TableLayout2.ALL, 0);
        this._innerPanel = new KDPanel((LayoutManager)ly2);
        this._innerPanel.add((Component)lc3, (Object)TableLayout2.param((int)0, (int)0));
        this._innerPanel.add((Component)this._cmbPeriod, (Object)TableLayout2.param((int)0, (int)1));
        this._innerPanel.add((Component)((Object)this._periodSetting), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        this._innerPanel.add((Component)new KDPanel(), (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)1));
        this._crPeriod.setContentPane((Container)this._innerPanel);
        this._crPeriod.setBackground(this._innerPanel.getBackground());
        this._board.add((Component)this._crPeriod, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)1));
        this.getContentPane().setLayout((LayoutManager)new SpreadBorderLayout());
        this.getContentPane().add((Component)this._board, "Center");
        ActionDispatch action = new ActionDispatch();
        this._btnSave = new KDWorkButton();
        this._btnSave.setText("\u4fdd\u5b58");
        this._btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this._btnSave.addActionListener((ActionListener)action);
        this._btnClose = new KDWorkButton();
        this._btnClose.setText("\u5173\u95ed");
        this._btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this._btnClose.addActionListener((ActionListener)action);
        this.setSize(346, 272);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CtrlUIEnv.setKingdeeLAF();
                final KDFrame frame = new KDFrame("\u6d4b\u8bd5");
                frame.getContentPane().setLayout(new BorderLayout());
                KDButton btn = new KDButton("Click me for poping up a dialog.");
                btn.setPreferredSize(new Dimension(84, 21));
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModifyPropsUI dialog = new ModifyPropsUI((Frame)frame, false);
                        dialog.pack();
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                    }
                });
                frame.getContentPane().add((Component)btn, "Center");
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public void actionQuit() {
        this._value = null;
        this.dispose();
    }

    public void actionSave() {
        boolean sum;
        boolean changeName;
        IInfo info = this.verifyUnempty();
        if (info != null) {
            this.handleInfoTips(info);
            return;
        }
        String newName = this._tfName.getText().trim();
        if (this._serv == null) {
            try {
                this._serv = SnapshotRelativeService.getInst();
            }
            catch (SnapshotException e) {
                ExtMsgBox.showError((Component)((Object)this), "\u521b\u5efa\u5feb\u7167\u670d\u52a1\u5f02\u5e38", e.toString());
                return;
            }
        }
        boolean bl = changeName = !this._value.getName().equals(newName);
        if (changeName) {
            try {
                PhantomSnapshot ps = (PhantomSnapshot)this._value.clone();
                List conflictLst = new ArrayList<PhantomSnapshot>();
                ps.setName(newName);
                conflictLst.add(ps);
                conflictLst = this._bePersonalFolder ? this._serv.findNameConflictByUser(conflictLst, this._value.getLocationPath(), EASUtil.getCurrentUserID()) : this._serv.findNameConflictByOrg(conflictLst, this._value.getLocationPath(), EASUtil.getCurrentOrgID());
                if (conflictLst != null && conflictLst.size() > 0) {
                    this.handleInfoTips(new DefaultInfo("\u8bf7\u4fee\u6539\u540d\u79f0\uff0c\u5df2\u5b58\u5728\u540c\u540d\u7684\u5feb\u7167"));
                    return;
                }
                this._value.setName(newName);
            }
            catch (SnapshotException e) {
                ExtMsgBox.showError((Component)((Object)this), "\u68c0\u67e5\u540d\u79f0\u662f\u5426\u51b2\u7a81\u65f6\u5f02\u5e38", e.toString());
                return;
            }
        }
        if (sum = this._cbPeriodSum.isSelected()) {
            this._value.setBeginDate(new Timestamp(this._periodSetting.getPeriodFrom().getTime()));
            this._value.setEndDate(new Timestamp(this._periodSetting.getPeriodTo().getTime()));
            this._value.setWeekBegin(this._periodSetting.getWeekBegin());
            this._value.setReportPeriod(this._cmbPeriod.getSelectedIndex());
        } else {
            this._value.setReportPeriod(-1);
            this._value.setBeginDate(null);
            this._value.setEndDate(null);
            this._value.setWeekBegin(-1);
        }
        this.dispose();
    }

    private void handleInfoTips(IInfo e) {
        if (this._tipPanel == null) {
            this._tipPanel = new InfoMessagePanel(e.getInfo(), this.getContentPane(), this._board);
        }
        this._tipPanel.setTipString(e.getInfo());
        this.getContentPane().add((Component)((Object)this._tipPanel), "center_north");
        this._tipPanel.showTip();
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
    }

    public PhantomSnapshot getValue() {
        return this._value;
    }

    private IInfo verifyUnempty() {
        DefaultInfo info = null;
        if (StringUtil.isEmptyString((String)this._tfName.getText()) || StringUtil.isEmptyString((String)this._tfName.getText().trim())) {
            this._tfName.setText(null);
            this.requestFocus((JComponent)this._tfName);
            info = new DefaultInfo("\u8bf7\u586b\u5199\u5feb\u7167\u540d\u79f0\uff0c\u5feb\u7167\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return info;
    }

    protected void requestFocus(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp.requestFocus();
            }
        });
    }

    public void setValue(PhantomSnapshot value) {
        this._value = value;
        this._tfName.setText(value.getName());
        if (value.getReportPeriod() == -1) {
            return;
        }
        this._cbPeriodSum.setSelected(true);
        this._cmbPeriod.setSelectedIndex(value.getReportPeriod(), true);
        this._periodSetting.removeAll();
        this._innerPanel.remove((Component)((Object)this._periodSetting));
        this._periodSetting = null;
        this._periodSetting = PeriodSettingPanel.getPeriodSettingPanel(this._cmbPeriod.getSelectedIndex(), (TableLayout2)this._innerPanel.getLayout(), 1, "\u6ce8\u610f\uff1a\u5feb\u7167\u671f\u95f4");
        this._periodSetting.setPreferredSize(new Dimension(672, 45));
        this._periodSetting.revert(value.getBeginDate(), value.getEndDate(), value.getWeekBegin());
        this._innerPanel.add((Component)((Object)this._periodSetting), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        this._innerPanel.doLayout();
        this._innerPanel.revalidate();
        this._innerPanel.repaint();
    }

    public class ActionDispatch
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == ModifyPropsUI.this._btnSave) {
                ModifyPropsUI.this.actionSave();
            } else if (obj == ModifyPropsUI.this._btnClose) {
                ModifyPropsUI.this.actionQuit();
            }
        }
    }
}

