/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.mview.action.ui;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.client.MapMessageInfoUI;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.rpts.snapshot.manage.client.usergroup.CustomListCellRender;
import com.kingdee.eas.rpts.snapshot.manage.client.usergroup.SSUserGroupListUI;
import com.kingdee.eas.rpts.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.SSUserInfo;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.UserGroupInfo;
import com.kingdee.eas.rpts.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.rpts.snapshot.manage.service.mailbox.SSExpressDeliveryService;
import com.kingdee.eas.rpts.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.KMP;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShortcutExpressDeliveryUI
extends KDDialog {
    private KDTable _table;
    private KDList _userAndGroups;
    private KDList _receivers;
    private List _phantoms;
    private KDTextField _tfSearch;
    private KDWorkButton _unChooseBtn;
    private boolean _cancel;
    private KDWorkButton _chooseBtn;
    private SSUserGroupListUI _groupUI;
    private List _groupDatas;
    private List _userDatas;
    private boolean _unComplete;
    private KDWorkButton _sendBtn;
    private Set _receiverCache = new HashSet();

    public ShortcutExpressDeliveryUI(List phantoms, Frame owner) {
        super(owner, true);
        this._phantoms = phantoms;
        this.initUI();
        this.installListeners();
        this.initUIData();
    }

    private void initUI() {
        this.setTitle("\u53d1\u9001\u5feb\u7167");
        KDContainer lc = new KDContainer();
        lc.setTitle("\u4e3b\u9898\u8bbe\u7f6e");
        lc.setEnableActive(false);
        lc.setPreferredSize(new Dimension(400, 400));
        this._table = new KDTable();
        this._table.addColumns(1);
        this._table.getColumn(0).setWidth(257);
        IRow headRow = this._table.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u4e3b\u9898");
        this._table.setEditable(true);
        KDContainer lc2 = new KDContainer();
        lc2.setTitle("\u6dfb\u52a0\u6536\u4ef6\u4eba");
        lc2.setEnableActive(false);
        lc2.setPreferredSize(new Dimension(400, 400));
        this._userAndGroups = new KDList(new DefaultListModel());
        this._userAndGroups.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this._receivers = new KDList(new DefaultListModel());
        this._receivers.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this._chooseBtn = new KDWorkButton();
        this._chooseBtn.setText(null);
        this._chooseBtn.setEnabled(false);
        this._chooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_move_left.gif"));
        this._chooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.chooseUserOrGroup();
            }
        });
        this._unChooseBtn = new KDWorkButton();
        this._unChooseBtn.setText(null);
        this._unChooseBtn.setEnabled(false);
        this._unChooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_move_right.gif"));
        this._unChooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.unChooseUserOrGroup();
            }
        });
        KDWorkButton groupMgrBtn = new KDWorkButton();
        groupMgrBtn.setText(null);
        groupMgrBtn.setToolTipText("\u7528\u6237\u7ec4\u7ba1\u7406");
        groupMgrBtn.setIcon((Icon)SSIcons.createIcon("tbtn_usermanage.gif"));
        groupMgrBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.groupManage();
            }
        });
        KDWorkButton searchBtn = new KDWorkButton();
        searchBtn.setToolTipText("\u8fc7\u6ee4");
        searchBtn.setText(null);
        searchBtn.setIcon((Icon)SSIcons.createIcon("tbtn_search.png"));
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.searchUserOrGroup();
            }
        });
        this._tfSearch = new KDTextField();
        this._tfSearch.setPreferredSize(new Dimension(120, 21));
        this._tfSearch.setFocusTraversalKeysEnabled(false);
        this._tfSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ShortcutExpressDeliveryUI.this.searchUserOrGroup();
                }
            }
        });
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(308);
        KDLabel hadChoosedLb = new KDLabel("\u5df2\u9009\u6536\u4ef6\u4eba");
        hadChoosedLb.setUnderline(true);
        this._sendBtn = new KDWorkButton();
        this._sendBtn.setText("\u53d1\u9001");
        this._sendBtn.setIcon((Icon)SSIcons.createIcon("tbtn_sendmail.png"));
        this._sendBtn.setEnabled(false);
        this._sendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.actionSend();
                ShortcutExpressDeliveryUI.this.dispose();
                ShortcutExpressDeliveryUI.this._cancel = false;
            }
        });
        KDWorkButton cancelBtn = new KDWorkButton();
        cancelBtn.setText(null);
        cancelBtn.setIcon((Icon)SSIcons.createIcon("tbtn_quit.gif"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutExpressDeliveryUI.this.dispose();
                ShortcutExpressDeliveryUI.this._cancel = true;
            }
        });
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)this._sendBtn);
        toolBar.addSeparator();
        toolBar.add((Component)cancelBtn);
        this.addToolBar((JToolBar)toolBar);
        lc.setMinimumSize(new Dimension(0, 0));
        KDPanel left = new KDPanel((LayoutManager)new BorderLayout());
        left.setCustomInsets(new Insets(10, 10, 0, 10));
        left.add((Component)this._table, (Object)"Center");
        lc.setContentPane((Container)left);
        sppLeftRight.setLeftComponent((Component)lc);
        TableLayout2 ly = new TableLayout2(5, 5);
        ly.setFixedHeight(new int[]{0, 2, 3}, 21);
        ly.setRatableHeight(new int[]{1, 4}, 100);
        ly.setFixedWidth(new int[]{1, 2, 3}, 21);
        ly.setRatableWidth(new int[]{0, 4}, 100);
        ly.setColsSpacing(TableLayout2.ALL, 6);
        ly.setRowsSpacing(TableLayout2.ALL, 6);
        KDScrollPane ugPane = new KDScrollPane((Component)this._userAndGroups);
        KDScrollPane addresseePane = new KDScrollPane((Component)this._receivers);
        this._userAndGroups.setAutoscrolls(true);
        this._receivers.setAutoscrolls(true);
        KDPanel right = new KDPanel((LayoutManager)ly);
        right.add((Component)this._tfSearch, (Object)TableLayout2.param((int)0, (int)0));
        right.add((Component)searchBtn, (Object)TableLayout2.param((int)0, (int)1));
        right.add((Component)groupMgrBtn, (Object)TableLayout2.param((int)0, (int)2));
        right.add((Component)hadChoosedLb, (Object)TableLayout2.param((int)0, (int)4));
        right.add((Component)ugPane, (Object)TableLayout2.param((int)1, (int)0, (int)4, (int)2));
        right.add((Component)addresseePane, (Object)TableLayout2.param((int)1, (int)4, (int)4, (int)4));
        right.add((Component)this._chooseBtn, (Object)TableLayout2.param((int)2, (int)3));
        right.add((Component)this._unChooseBtn, (Object)TableLayout2.param((int)3, (int)3));
        right.setCustomInsets(new Insets(10, 10, 0, 10));
        lc2.setContentPane((Container)right);
        sppLeftRight.setRightComponent((Component)lc2);
        KDPanel board = new KDPanel((LayoutManager)new BorderLayout());
        board.add((Component)sppLeftRight, (Object)"Center");
        this.setContentPane((Container)board);
        this.setSize(780, 520);
    }

    private void installListeners() {
        this._receivers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ShortcutExpressDeliveryUI.this._receivers.getSelectedIndices().length > 0) {
                    ShortcutExpressDeliveryUI.this._unChooseBtn.setEnabled(true);
                    return;
                }
                ShortcutExpressDeliveryUI.this._unChooseBtn.setEnabled(false);
            }
        });
        this._receivers.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ShortcutExpressDeliveryUI.this.unChooseUserOrGroup();
                }
            }
        });
        this._receivers.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                boolean able = ShortcutExpressDeliveryUI.this._receiverCache.size() > 0;
                ShortcutExpressDeliveryUI.this._sendBtn.setEnabled(able);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                boolean able = ShortcutExpressDeliveryUI.this._receiverCache.size() > 0;
                ShortcutExpressDeliveryUI.this._sendBtn.setEnabled(able);
            }
        });
        this._userAndGroups.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ShortcutExpressDeliveryUI.this._userAndGroups.getSelectedIndices().length > 0) {
                    ShortcutExpressDeliveryUI.this._chooseBtn.setEnabled(true);
                    return;
                }
                ShortcutExpressDeliveryUI.this._chooseBtn.setEnabled(false);
            }
        });
        this._userAndGroups.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ShortcutExpressDeliveryUI.this.chooseUserOrGroup();
                }
            }
        });
    }

    private void initUIData() {
        this._table.removeRows();
        int size = this._phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)this._phantoms.get(i);
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)ps.getName());
            row.setUserObject((Object)ps);
        }
        new UsersAndGroupsLoader((Window)((Object)this), 0){

            @Override
            public void finished() {
                super.finished();
                ShortcutExpressDeliveryUI.this._table.getEditManager().editCellAt(0, 0);
            }
        }.start();
    }

    private void searchUserOrGroup() {
        int i;
        int size;
        String name = MixUtil.toString(this._tfSearch.getText()).trim().toLowerCase();
        if (StringUtil.isEmptyString((String)name)) {
            if (this._unComplete) {
                this.reloadData();
            }
            return;
        }
        boolean change = false;
        DefaultListModel<Cloneable> model = new DefaultListModel<Cloneable>();
        if (this._groupDatas != null && this._groupDatas.size() > 0) {
            size = this._groupDatas.size();
            for (i = 0; i < size; ++i) {
                UserGroupInfo group = (UserGroupInfo)this._groupDatas.get(i);
                String groupName = MixUtil.toString(group.getName()).toLowerCase();
                if (!KMP.kmp(groupName, name)) continue;
                model.addElement(group);
            }
            change = true;
        }
        if (this._userDatas != null && this._userDatas.size() > 0) {
            size = this._userDatas.size();
            for (i = 0; i < size; ++i) {
                SSUserInfo userName = (SSUserInfo)this._userDatas.get(i);
                if (!KMP.kmp(userName.getUserName().toLowerCase(), name)) continue;
                model.addElement(userName);
            }
            change = true;
        }
        if (change) {
            ((DefaultListModel)this._userAndGroups.getModel()).clear();
            this._userAndGroups.setModel(model);
            this._unComplete = true;
        }
    }

    private void reloadData() {
        int i;
        int isize;
        DefaultListModel model = (DefaultListModel)this._userAndGroups.getModel();
        model.clear();
        int size = this._groupDatas == null ? 0 : this._groupDatas.size();
        model.ensureCapacity(size += this._userDatas == null ? 0 : this._userDatas.size());
        if (this._groupDatas != null) {
            isize = this._groupDatas.size();
            for (i = 0; i < isize; ++i) {
                model.addElement(this._groupDatas.get(i));
            }
        }
        if (this._userDatas != null) {
            isize = this._userDatas.size();
            for (i = 0; i < isize; ++i) {
                model.addElement(this._userDatas.get(i));
            }
        }
        this._unComplete = false;
    }

    private void chooseUserOrGroup() {
        Object[] seleds = this._userAndGroups.getSelectedValues();
        if (seleds != null && seleds.length > 0) {
            DefaultListModel model = (DefaultListModel)this._receivers.getModel();
            model.ensureCapacity(seleds.length);
            for (int i = 0; i < seleds.length; ++i) {
                if (this._receiverCache.contains(seleds[i])) continue;
                this._receiverCache.add(seleds[i]);
                model.addElement(seleds[i]);
            }
        }
    }

    private void unChooseUserOrGroup() {
        Object[] seleds = this._receivers.getSelectedValues();
        if (seleds != null && seleds.length > 0) {
            DefaultListModel model = (DefaultListModel)this._receivers.getModel();
            model.ensureCapacity(seleds.length);
            for (int i = 0; i < seleds.length; ++i) {
                this._receiverCache.remove(seleds[i]);
                model.removeElement(seleds[i]);
            }
        }
    }

    private void groupManage() {
        List groupData;
        if (this._groupUI == null) {
            this._groupUI = new SSUserGroupListUI((Dialog)((Object)this));
            this._groupUI.setLocationRelativeTo(null);
        }
        this._groupUI.setVisible(true);
        if (this._groupUI.isElemInsDel() && (groupData = this._groupUI.getGroupsData()) != null) {
            int i;
            DefaultListModel model = new DefaultListModel();
            int isize = groupData.size();
            for (i = 0; i < isize; ++i) {
                model.addElement(groupData.get(i));
            }
            this._groupDatas = groupData;
            if (this._userDatas != null) {
                isize = this._userDatas.size();
                for (i = 0; i < isize; ++i) {
                    model.addElement(this._userDatas.get(i));
                }
            }
            this._userAndGroups.setModel(model);
            this._groupUI.setElemInsDel(false);
            this.searchUserOrGroup();
        }
    }

    private void actionSend() {
        this._table.getEditManager().stopEditing();
        int size = this._table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this._table.getRow(i);
            PhantomSnapshot ps = (PhantomSnapshot)row.getUserObject();
            String newName = (String)row.getCell(0).getValue();
            if (StringUtil.isEmptyString((String)newName) || StringUtil.isEmptyString((String)newName.trim())) continue;
            ps.setName(newName.trim());
        }
        DefaultListModel model = (DefaultListModel)this._receivers.getModel();
        Object[] addressees = new Object[model.size()];
        model.copyInto(addressees);
        try {
            ISSExpressDeliveryService mailService = SSExpressDeliveryService.getInst();
            Map msgMap = mailService.deliveryMails(this._phantoms, addressees);
            if (msgMap == null || msgMap.size() == 0) {
                ExtMsgBox.showInfo((Component)((Object)this), "\u53d1\u9001\u6210\u529f");
            } else {
                MapMessageInfoUI infoUI = new MapMessageInfoUI(msgMap, (Dialog)((Object)this), "\u53d1\u9001\u5931\u8d25\u4fe1\u606f");
                infoUI.setLocationRelativeTo(null);
                infoUI.setVisible(true);
            }
        }
        catch (ShortcutMailboxException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u53d1\u9001\u5feb\u7167\u90ae\u4ef6\u5f02\u5e38", e.toString());
        }
    }

    public boolean isCancel() {
        return this._cancel;
    }

    private class UsersAndGroupsLoader
    extends AbstractUILongTask {
        private Window _window;

        public UsersAndGroupsLoader(Window targetWindow, int mode) {
            super(targetWindow, mode);
            this._window = targetWindow;
        }

        @Override
        public void doTask() {
            try {
                ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
                ShortcutExpressDeliveryUI.this._groupDatas = serv.queryGroups();
                ShortcutExpressDeliveryUI.this._userDatas = serv.queryAllUser();
                if (!(ShortcutExpressDeliveryUI.this._groupDatas != null && ShortcutExpressDeliveryUI.this._groupDatas.size() != 0 || ShortcutExpressDeliveryUI.this._userDatas != null && ShortcutExpressDeliveryUI.this._userDatas.size() != 0)) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShortcutExpressDeliveryUI.this.reloadData();
                    }
                });
            }
            catch (ShortcutMailboxException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(UsersAndGroupsLoader.this._window, "\u52a0\u8f7d\u7528\u6237\u548c\u7528\u6237\u7ec4\u5931\u8d25", e.toString());
                    }
                });
            }
        }
    }
}

