/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.mview.complete;

import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotPartInfo;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;

public class ImageCellRender
extends AbstractBasicRender {
    private static final Icon SNAPSHOT_ICON = SSIcons.createIcon("snapshot.png");
    private static final Icon SHORTCUT_ICON = SSIcons.createIcon("shortcut.png");
    private TextRender _textRender = new TextRender();
    private static ImageCellRender _render;

    private ImageCellRender() {
    }

    public static ImageCellRender getInst() {
        if (_render == null) {
            _render = new ImageCellRender();
        }
        return _render;
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof PhantomSnapshot) {
            Rectangle rect = clip.getBounds();
            int x = rect.x + 8;
            int y = rect.y + (rect.height - 16) / 2;
            if (y < rect.y) {
                y = rect.y;
            }
            this.drawImage(graphics, x, y, (PhantomSnapshot)object);
            int space = 3;
            rect.setRect(x + space + 16, rect.y, rect.getWidth() - (double)space, rect.getHeight());
            this._textRender.draw(graphics, (Shape)rect, ((PhantomSnapshot)object).getName(), cellStyle);
        } else if (object instanceof SnapshotPartInfo) {
            Rectangle rect = clip.getBounds();
            int x = rect.x + 8;
            int y = rect.y + (rect.height - 16) / 2;
            if (y < rect.y) {
                y = rect.y;
            }
            this.drawImage(graphics, x, y, (SnapshotPartInfo)object);
            int space = 3;
            rect.setRect(x + space + 16, rect.y, rect.getWidth() - (double)space, rect.getHeight());
            this._textRender.draw(graphics, (Shape)rect, ((SnapshotPartInfo)object).getSnapshotName(), cellStyle);
        }
    }

    public float getPreferredWidth(Graphics g, Shape clip, String text, Style style, Object extObj) {
        return super.getPreferredWidth(g, clip, text, style, null) + 30.0f;
    }

    private void drawImage(Graphics g, int x, int y, PhantomSnapshot ps) {
        Graphics2D g2d = (Graphics2D)g;
        if (ps.isFake()) {
            SHORTCUT_ICON.paintIcon(null, g2d, x, y);
        } else {
            SNAPSHOT_ICON.paintIcon(null, g2d, x, y);
        }
    }

    private void drawImage(Graphics g, int x, int y, SnapshotPartInfo ps) {
        Graphics2D g2d = (Graphics2D)g;
        if (ps.isFake()) {
            SHORTCUT_ICON.paintIcon(null, g2d, x, y);
        } else {
            SNAPSHOT_ICON.paintIcon(null, g2d, x, y);
        }
    }
}

