/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.tree;

import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.rpts.cloud.model.RptCategoryVO;
import com.kingdee.eas.rpts.cloud.service.ExtCloudRptCategoryControllerFacade;
import com.kingdee.eas.rpts.cloud.service.IExtCloudRptCategoryController;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.ShortcutMailNode;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.SubSystemBuilder;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.action.AbstractFolderAction;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.action.DelFolderAction;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.action.NewFolderAction;
import com.kingdee.eas.rpts.snapshot.manage.client.tree.action.RenameFolderAction;
import com.kingdee.eas.rpts.snapshot.manage.consta.FolderType;
import com.kingdee.eas.rpts.snapshot.manage.exception.PersonalFolderException;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PersonalFolder;
import com.kingdee.eas.rpts.snapshot.manage.service.IPersonalFolderService;
import com.kingdee.eas.rpts.snapshot.manage.service.ISnapshotRelativeService;
import com.kingdee.eas.rpts.snapshot.manage.service.PersonalFolderService;
import com.kingdee.eas.rpts.snapshot.manage.service.SnapshotRelativeService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SSManageTree {
    private KDTree _tree;
    private KDTreeView _treeView;
    private IPersonalFolderService _srsv;
    private ISnapshotRelativeService _snapshotSrsv;
    private LongTaskWorker _builder;
    private int _currentFolderType = FolderType.NONE;
    private DefaultKingdeeTreeNode _personalRoot;
    private DefaultKingdeeTreeNode _commonRoot;
    private DefaultKingdeeTreeNode _mailboxNode;
    private IFolderTypeChangeObserver _folderChangeObserver;
    private ITreeSelectionObserver _selectionObserver;
    private AbstractFolderAction _newFolderAction;
    private AbstractFolderAction _renameFolderAction;
    private AbstractFolderAction _delFolderAction;
    private ShortcutMailNode _mailNodeUserObj;
    private Logger _log = CommonLogger.getLogger(SSManageTree.class);
    private Component _owner;

    public SSManageTree(Component owner) {
        this._owner = owner;
        this.init();
        this.initCtrlPane();
    }

    public SSManageTree(Dialog owner) {
        this._owner = owner;
        this.init();
    }

    private void init() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u52a0\u8f7d\u4e2d...");
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        this._tree = new KDTree((TreeModel)model);
        this._tree.setShowCheckBox(false);
        this._treeView = new KDTreeView(this._tree);
    }

    public void buildTree() {
        if (this._builder == null) {
            this._builder = new TreeBuilder();
        }
        this._builder.start();
    }

    public void setTreeBuilder2() {
        this._builder = new TreeBuilder2();
    }

    DefaultKingdeeTreeNode createMyTreeNode(PersonalFolder foler) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)foler);
        newNode.setText(foler.getName());
        newNode.setUserObject((Object)foler);
        Vector children = foler.getChildren();
        if (null != children && children.size() > 0) {
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                newNode.add((MutableTreeNode)this.createMyTreeNode((PersonalFolder)itor.next()));
            }
        }
        if (newNode.getChildCount() == 0) {
            newNode.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
        }
        return newNode;
    }

    private void initCtrlPane() {
        this._treeView.setShowButton(false);
        this._newFolderAction = new NewFolderAction(this);
        KDWorkButton btn = new KDWorkButton((Action)this._newFolderAction);
        btn.setToolTipText(btn.getText());
        btn.setText(null);
        this._treeView.getControlPane().add((Component)btn);
        this._renameFolderAction = new RenameFolderAction(this);
        KDWorkButton renameBtn = new KDWorkButton((Action)this._renameFolderAction);
        renameBtn.setToolTipText(renameBtn.getText());
        renameBtn.setText(null);
        this._treeView.getControlPane().add((Component)renameBtn);
        this._delFolderAction = new DelFolderAction(this);
        KDWorkButton delBtn = new KDWorkButton((Action)this._delFolderAction);
        delBtn.setToolTipText(delBtn.getText());
        delBtn.setText(null);
        this._treeView.getControlPane().add((Component)delBtn);
    }

    public KDTree getTree() {
        return this._tree;
    }

    public DefaultKingdeeTreeNode getSelectNode() {
        TreePath selPath = this._tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultKingdeeTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public Component getUI() {
        return this._treeView;
    }

    public IFolderTypeChangeObserver getFolderChangeObserver() {
        return this._folderChangeObserver;
    }

    public void setFolderChangeObserver(IFolderTypeChangeObserver folderChangeObserver) {
        this._folderChangeObserver = folderChangeObserver;
    }

    public ITreeSelectionObserver getSelectionObserver() {
        return this._selectionObserver;
    }

    public void setSelectionObserver(ITreeSelectionObserver selectionObserver) {
        this._selectionObserver = selectionObserver;
    }

    public int getCurrentFolderType() {
        return this._currentFolderType;
    }

    public void setCurrentFolderType(int currentFolderType) {
        this._currentFolderType = currentFolderType;
    }

    public ShortcutMailNode getMailUINode() {
        return this._mailNodeUserObj;
    }

    public static interface ITreeSelectionObserver {
        public void update(int var1, Object var2);
    }

    public static interface IFolderTypeChangeObserver {
        public void update(int var1);
    }

    private class SSTreeSelectionListener
    implements TreeSelectionListener {
        private SSTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = SSManageTree.this._tree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            if (SSManageTree.this._newFolderAction != null) {
                SSManageTree.this._newFolderAction.setEnabled(true);
                SSManageTree.this._renameFolderAction.setEnabled(true);
                SSManageTree.this._delFolderAction.setEnabled(true);
            }
            for (int i = 0; i < paths.length; ++i) {
                boolean personalFolderSeled;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                TreeNode[] path = node.getPath();
                int folderType = this.determineSelectedFolderType(path[1]);
                boolean bl = personalFolderSeled = folderType == FolderType.PERSONAL_FOLDER;
                if (node != SSManageTree.this._personalRoot && !personalFolderSeled && SSManageTree.this._newFolderAction != null) {
                    SSManageTree.this._newFolderAction.setEnabled(false);
                    SSManageTree.this._renameFolderAction.setEnabled(false);
                    SSManageTree.this._delFolderAction.setEnabled(false);
                }
                if (node == SSManageTree.this._personalRoot && SSManageTree.this._newFolderAction != null) {
                    SSManageTree.this._renameFolderAction.setEnabled(false);
                    SSManageTree.this._delFolderAction.setEnabled(false);
                }
                if (folderType != SSManageTree.this._currentFolderType) {
                    SSManageTree.this._folderChangeObserver.update(folderType);
                    SSManageTree.this._currentFolderType = folderType;
                }
                SSManageTree.this._selectionObserver.update(SSManageTree.this._currentFolderType, node.getUserObject());
            }
        }

        private int determineSelectedFolderType(TreeNode node) {
            if (node == SSManageTree.this._personalRoot) {
                return FolderType.PERSONAL_FOLDER;
            }
            if (node == SSManageTree.this._commonRoot) {
                return FolderType.COMMON_FOLDER;
            }
            if (node == SSManageTree.this._mailboxNode) {
                return FolderType.MAILBOX;
            }
            return FolderType.NONE;
        }
    }

    private class TreeBuilder
    extends LongTaskWorker {
        private TreeBuilder() {
        }

        public Object construct() {
            ReturnValue rv = new ReturnValue();
            try {
                if (SSManageTree.this._srsv == null) {
                    SSManageTree.this._srsv = PersonalFolderService.getInst();
                }
                rv._personalRoot = SSManageTree.this._srsv.loadMyFolder();
            }
            catch (PersonalFolderException e) {
                if (SSManageTree.this._log.isDebugEnabled()) {
                    SSManageTree.this._log.debug((Object)"\u52a0\u8f7d\u4e2a\u4eba\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(SSManageTree.this._owner, "\u52a0\u8f7d\u4e2a\u4eba\u5939\u5931\u8d25", e.toString());
                    }
                });
                return null;
            }
            rv._commonRoot = EASUtil.getCommonTree();
            try {
                if (SSManageTree.this._snapshotSrsv == null) {
                    SSManageTree.this._snapshotSrsv = SnapshotRelativeService.getInst();
                }
                rv._filter = SSManageTree.this._snapshotSrsv.getCommonTreeFilterSet(EASUtil.getCurrentOrgID());
            }
            catch (SnapshotException e) {
                if (SSManageTree.this._log.isDebugEnabled()) {
                    SSManageTree.this._log.debug((Object)"\u52a0\u8f7d\u516c\u5171\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(SSManageTree.this._owner, "\u52a0\u8f7d\u516c\u5171\u6587\u4ef6\u5939\u5931\u8d25", e.toString());
                    }
                });
                return null;
            }
            return rv;
        }

        public void finished() {
            ReturnValue rv = (ReturnValue)this.getValue();
            if (rv != null && !rv.empty() && rv._personalRoot != null) {
                SSManageTree.this._personalRoot = SSManageTree.this.createMyTreeNode(rv._personalRoot);
                SSManageTree.this._personalRoot.setCustomIcon((Icon)SSIcons.createIcon("tree_mycollection.gif"));
                SSManageTree.this._commonRoot = SubSystemBuilder.getInst(rv._commonRoot, rv._filter).build();
                SSManageTree.this._commonRoot.setText("\u516c\u5171\u6587\u4ef6\u5939");
                SSManageTree.this._mailboxNode = new DefaultKingdeeTreeNode();
                SSManageTree.this._mailNodeUserObj = new ShortcutMailNode(SSManageTree.this._mailboxNode, SSManageTree.this._tree);
                SSManageTree.this._mailboxNode.setUserObject((Object)SSManageTree.this._mailNodeUserObj);
                SSManageTree.this._mailboxNode.setCustomIcon((Icon)SSIcons.createIcon("tree_mailbox.gif"));
                DefaultKingdeeTreeNode sumReportedNode = this.createSumUploadFolderNode();
                SSManageTree.this._commonRoot.add((MutableTreeNode)sumReportedNode);
                DefaultKingdeeTreeNode cloudReportedNode = this.createCloudRptCenterFolderNode(rv._filter);
                SSManageTree.this._commonRoot.add((MutableTreeNode)cloudReportedNode);
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)"");
                node.add((MutableTreeNode)SSManageTree.this._personalRoot);
                node.add((MutableTreeNode)SSManageTree.this._commonRoot);
                node.add((MutableTreeNode)SSManageTree.this._mailboxNode);
                KingdeeTreeModel newModel = new KingdeeTreeModel((TreeNode)node);
                SSManageTree.this._tree.setShowsRootHandles(true);
                SSManageTree.this._tree.setRootVisible(false);
                SSManageTree.this._tree.setModel((TreeModel)newModel);
                TreePath treePath = new TreePath(SSManageTree.this._personalRoot.getPath());
                SSManageTree.this._tree.expandPath(treePath);
                SSManageTree.this._tree.addTreeSelectionListener((TreeSelectionListener)new SSTreeSelectionListener());
                SSManageTree.this._tree.setSelectionPath(treePath);
                SSManageTree.this._tree.invalidate();
                SSManageTree.this._tree.repaint();
            }
        }

        DefaultKingdeeTreeNode createCloudRptCenterFolderNode(Set _filter) {
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)FolderType.CLOUD_REPORT_CENTER_STR);
            newNode.setText(FolderType.CLOUD_REPORT_CENTER_STR);
            try {
                IExtCloudRptCategoryController controller = ExtCloudRptCategoryControllerFacade.getRemoteInst();
                List<RptCategoryVO> list = controller.getList();
                for (RptCategoryVO categoryVO : list) {
                    if (!_filter.contains(categoryVO.getId())) continue;
                    DefaultKingdeeTreeNode categoryVONode = new DefaultKingdeeTreeNode();
                    categoryVONode.setText(categoryVO.getName());
                    categoryVONode.setUserObject((Object)categoryVO);
                    categoryVONode.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
                    newNode.add((MutableTreeNode)categoryVONode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageUtil.showInfo("\u83b7\u53d6\u4e91\u62a5\u8868\u76ee\u5f55\u5931\u8d25\uff01", false);
            }
            if (newNode.getChildCount() == 0) {
                newNode.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
            }
            return newNode;
        }

        DefaultKingdeeTreeNode createSumUploadFolderNode() {
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)FolderType.SUM_UPLOAD_STR);
            newNode.setText(FolderType.SUM_UPLOAD_STR);
            if (newNode.getChildCount() == 0) {
                newNode.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
            }
            return newNode;
        }
    }

    private class ReturnValue {
        IBriefViewTreeNode _commonRoot;
        PersonalFolder _personalRoot;
        Set _filter;

        private ReturnValue() {
        }

        boolean empty() {
            return this._commonRoot == null && this._personalRoot == null;
        }
    }

    private class TreeBuilder2
    extends LongTaskWorker {
        public Object construct() {
            ReturnValue rv = new ReturnValue();
            try {
                if (SSManageTree.this._srsv == null) {
                    SSManageTree.this._srsv = PersonalFolderService.getInst();
                }
                rv._personalRoot = SSManageTree.this._srsv.loadMyFolder();
            }
            catch (PersonalFolderException e) {
                if (SSManageTree.this._log.isDebugEnabled()) {
                    SSManageTree.this._log.debug((Object)"\u52a0\u8f7d\u4e2a\u4eba\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(SSManageTree.this._owner, "\u52a0\u8f7d\u4e2a\u4eba\u5939\u5931\u8d25", e.toString());
                    }
                });
                return null;
            }
            rv._commonRoot = EASUtil.getCommonTree();
            try {
                if (SSManageTree.this._snapshotSrsv == null) {
                    SSManageTree.this._snapshotSrsv = SnapshotRelativeService.getInst();
                }
                rv._filter = SSManageTree.this._snapshotSrsv.getCommonTreeFilterSetBySnapshot(EASUtil.getCurrentOrgID());
            }
            catch (SnapshotException e) {
                if (SSManageTree.this._log.isDebugEnabled()) {
                    SSManageTree.this._log.debug((Object)"\u52a0\u8f7d\u516c\u5171\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(SSManageTree.this._owner, "\u52a0\u8f7d\u516c\u5171\u6587\u4ef6\u5939\u5931\u8d25", e.toString());
                    }
                });
                return null;
            }
            return rv;
        }

        public void finished() {
            ReturnValue rv = (ReturnValue)this.getValue();
            if (rv != null && !rv.empty() && rv._personalRoot != null) {
                SSManageTree.this._personalRoot = SSManageTree.this.createMyTreeNode(rv._personalRoot);
                SSManageTree.this._personalRoot.setCustomIcon((Icon)SSIcons.createIcon("tree_mycollection.gif"));
                SSManageTree.this._commonRoot = SubSystemBuilder.getInst(rv._commonRoot, rv._filter).build();
                SSManageTree.this._commonRoot.setText("\u516c\u5171\u6587\u4ef6\u5939");
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)"");
                node.add((MutableTreeNode)SSManageTree.this._personalRoot);
                node.add((MutableTreeNode)SSManageTree.this._commonRoot);
                KingdeeTreeModel newModel = new KingdeeTreeModel((TreeNode)node);
                SSManageTree.this._tree.setShowsRootHandles(true);
                SSManageTree.this._tree.setRootVisible(false);
                SSManageTree.this._tree.setModel((TreeModel)newModel);
                TreePath treePath = new TreePath(SSManageTree.this._personalRoot.getPath());
                SSManageTree.this._tree.expandPath(treePath);
                SSManageTree.this._tree.addTreeSelectionListener((TreeSelectionListener)new SSTreeSelectionListener());
                SSManageTree.this._tree.setSelectionPath(treePath);
                SSManageTree.this._tree.invalidate();
                SSManageTree.this._tree.repaint();
            }
        }
    }
}

