/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.tree;

import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.MutableTreeNode;

public class SubSystemBuilder {
    private IBriefViewTreeNode _viewNode;
    private TreeMap _tree;
    private ObjectStack _stack;
    private DefaultKingdeeTreeNode _node;
    private IBriefViewTreeNode _curViewNode;
    private Set _filter;

    private SubSystemBuilder(IBriefViewTreeNode node, Set filter) {
        this._curViewNode = this._viewNode = node;
        this._filter = filter;
        this._stack = new ObjectStack();
        this._tree = new TreeMap();
    }

    public static SubSystemBuilder getInst(IBriefViewTreeNode node, Set filter) {
        return new SubSystemBuilder(node, filter);
    }

    public DefaultKingdeeTreeNode build() {
        this.travalAndBuild();
        this.adjust();
        this._stack.clear();
        this._tree.clear();
        this._stack = null;
        this._tree = null;
        return this._node;
    }

    private DefaultKingdeeTreeNode travalAndBuild() {
        this._stack.push((Object)this._curViewNode);
        if (this._filter.contains(this._curViewNode.getFullName())) {
            this._build();
        }
        Enumeration enumer = this._curViewNode.children();
        while (enumer.hasMoreElements()) {
            this._curViewNode = (IBriefViewTreeNode)enumer.nextElement();
            this.travalAndBuild();
        }
        this._stack.pop();
        return this._node;
    }

    private void adjust() {
        for (DefaultKingdeeTreeNode node : this._tree.values()) {
            if (node.getChildCount() != 0) continue;
            node.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
        }
    }

    private void _build() {
        Object[] objs = this._stack.getArray();
        for (int i = 0; i < objs.length; ++i) {
            if (this._tree.containsKey(((IBriefViewTreeNode)objs[i]).getFullName())) continue;
            if (this._node == null) {
                this._node = new DefaultKingdeeTreeNode(objs[i]);
                this._node.setText(((IBriefViewTreeNode)objs[i]).getAlias());
                this._tree.put(((IBriefViewTreeNode)objs[i]).getFullName(), this._node);
                continue;
            }
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(objs[i]);
            node.setText(((IBriefViewTreeNode)objs[i]).getAlias());
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)this._tree.get(((IBriefViewTreeNode)objs[i - 1]).getFullName());
            parent.add((MutableTreeNode)node);
            this._tree.put(((IBriefViewTreeNode)objs[i]).getFullName(), node);
        }
    }
}

