/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.client.usergroup;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.rpts.snapshot.manage.client.usergroup.CustomListCellRender;
import com.kingdee.eas.rpts.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.SSUserInfo;
import com.kingdee.eas.rpts.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.rpts.snapshot.manage.service.mailbox.SSExpressDeliveryService;
import com.kingdee.eas.rpts.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.KMP;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SSUserListUI
extends KDDialog {
    private KDTextField _tfSearch;
    private KDList _users;
    private KDList _chooses;
    private KDWorkButton _chooseBtn;
    private KDWorkButton _unChooseBtn;
    protected boolean _cancel;
    private List _data;
    private List _returnData;
    private boolean _unComplete;
    private Set _userCache;

    public SSUserListUI(Dialog owner) {
        super(owner, true);
        this.initUI();
        this.installListeners();
        this.initUIData();
    }

    public SSUserListUI(Frame owner) {
        super(owner, true);
        this.initUI();
        this.installListeners();
        this.initUIData();
    }

    private void initUI() {
        this.setTitle("\u6dfb\u52a0\u7528\u6237");
        this.setDefaultCloseOperation(1);
        this._tfSearch = new KDTextField();
        this._userCache = new HashSet();
        KDWorkButton searchBtn = new KDWorkButton();
        searchBtn.setText(null);
        searchBtn.setIcon((Icon)SSIcons.createIcon("tbtn_search.png"));
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSUserListUI.this.searchUsers();
            }
        });
        this._tfSearch.setFocusTraversalKeysEnabled(false);
        this._tfSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SSUserListUI.this.searchUsers();
                }
            }
        });
        this._chooseBtn = new KDWorkButton();
        this._chooseBtn.setText(null);
        this._chooseBtn.setEnabled(false);
        this._chooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_move_left.gif"));
        this._chooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSUserListUI.this.chooseUsers();
            }
        });
        this._unChooseBtn = new KDWorkButton();
        this._unChooseBtn.setText(null);
        this._unChooseBtn.setEnabled(false);
        this._unChooseBtn.setIcon((Icon)SSIcons.createIcon("tbtn_move_right.gif"));
        this._unChooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSUserListUI.this.unChooseUsers();
            }
        });
        this._users = new KDList(new DefaultListModel());
        this._users.setAutoscrolls(true);
        this._users.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this._chooses = new KDList(new DefaultListModel());
        this._chooses.setAutoscrolls(true);
        this._chooses.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        KDLabel hadChoosedLb = new KDLabel("\u9009\u4e2d\u7528\u6237");
        hadChoosedLb.setUnderline(true);
        KDWorkButton btnOK = new KDWorkButton("\u786e\u5b9a");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSUserListUI.this.actionOK();
                SSUserListUI.this._cancel = false;
                SSUserListUI.this.setVisible(false);
            }
        });
        KDWorkButton btnCancel = new KDWorkButton("\u53d6\u6d88");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSUserListUI.this._cancel = true;
                SSUserListUI.this.setVisible(false);
            }
        });
        TableLayout2 ly = new TableLayout2(7, 6);
        ly.setFixedHeight(new int[]{0, 2, 3, 6}, 21);
        ly.setRatableHeight(new int[]{1, 4}, 100);
        ly.setFixedHeight(5, 3);
        ly.setFixedWidth(new int[]{1, 2}, 21);
        ly.setFixedWidth(new int[]{4, 5}, 74);
        ly.setRatableWidth(0, 100);
        ly.setRatableWidth(3, 20);
        ly.setColsSpacing(TableLayout2.ALL, 6);
        ly.setRowsSpacing(TableLayout2.ALL, 6);
        ly.setRowsSpacing(new int[]{4, 5}, 9);
        KDPanel broad = new KDPanel((LayoutManager)ly);
        broad.add((Component)this._tfSearch, (Object)TableLayout2.param((int)0, (int)0));
        broad.add((Component)searchBtn, (Object)TableLayout2.param((int)0, (int)1));
        broad.add((Component)hadChoosedLb, (Object)TableLayout2.param((int)0, (int)3, (int)0, (int)5));
        KDScrollPane userPane = new KDScrollPane((Component)this._users);
        KDScrollPane choosePane = new KDScrollPane((Component)this._chooses);
        broad.add((Component)userPane, (Object)TableLayout2.param((int)1, (int)0, (int)4, (int)1));
        broad.add((Component)choosePane, (Object)TableLayout2.param((int)1, (int)3, (int)4, (int)5));
        broad.add((Component)this._chooseBtn, (Object)TableLayout2.param((int)2, (int)2));
        broad.add((Component)this._unChooseBtn, (Object)TableLayout2.param((int)3, (int)2));
        broad.add((Component)new KDSeparator(), (Object)TableLayout2.param((int)5, (int)0, (int)5, (int)5));
        broad.add((Component)btnOK, (Object)TableLayout2.param((int)6, (int)4));
        broad.add((Component)btnCancel, (Object)TableLayout2.param((int)6, (int)5));
        broad.setCustomInsets(new Insets(10, 10, 10, 10));
        this.setContentPane((Container)broad);
        this.setSize(433, 500);
    }

    private void installListeners() {
        this._chooses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SSUserListUI.this._chooses.getSelectedIndices().length > 0) {
                    SSUserListUI.this._unChooseBtn.setEnabled(true);
                    return;
                }
                SSUserListUI.this._unChooseBtn.setEnabled(false);
            }
        });
        this._users.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SSUserListUI.this._users.getSelectedIndices().length > 0) {
                    SSUserListUI.this._chooseBtn.setEnabled(true);
                    return;
                }
                SSUserListUI.this._chooseBtn.setEnabled(false);
            }
        });
        this._users.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    SSUserListUI.this.chooseUsers();
                }
            }
        });
        this._chooses.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    SSUserListUI.this.unChooseUsers();
                }
            }
        });
    }

    private void initUIData() {
        new UsersLoader((Window)((Object)this), 0){

            @Override
            public void finished() {
                super.finished();
            }
        }.start();
    }

    protected void actionOK() {
        if (this._returnData == null) {
            this._returnData = new ArrayList();
        } else {
            this._returnData.clear();
        }
        DefaultListModel model = (DefaultListModel)this._chooses.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            this._returnData.add(model.get(i));
        }
    }

    protected void searchUsers() {
        if (this._data != null && this._data.size() > 0) {
            String name = MixUtil.toString(this._tfSearch.getText()).trim().toLowerCase();
            if (StringUtil.isEmptyString((String)name)) {
                if (this._unComplete) {
                    this.reloadData();
                }
                return;
            }
            DefaultListModel<SSUserInfo> model = new DefaultListModel<SSUserInfo>();
            int size = this._data.size();
            for (int i = 0; i < size; ++i) {
                SSUserInfo userName = (SSUserInfo)this._data.get(i);
                if (!KMP.kmp(userName.getUserName().toLowerCase(), name)) continue;
                model.addElement(userName);
            }
            ((DefaultListModel)this._users.getModel()).clear();
            this._users.setModel(model);
            this._unComplete = true;
        }
    }

    protected void unChooseUsers() {
        Object[] seleds = this._chooses.getSelectedValues();
        if (seleds != null && seleds.length > 0) {
            DefaultListModel model = (DefaultListModel)this._chooses.getModel();
            model.ensureCapacity(seleds.length);
            for (int i = 0; i < seleds.length; ++i) {
                model.removeElement(seleds[i]);
                this._userCache.remove(seleds[i]);
            }
        }
    }

    protected void chooseUsers() {
        Object[] seleds = this._users.getSelectedValues();
        if (seleds != null && seleds.length > 0) {
            DefaultListModel model = (DefaultListModel)this._chooses.getModel();
            model.ensureCapacity(seleds.length);
            for (int i = 0; i < seleds.length; ++i) {
                if (this._userCache.contains(seleds[i])) continue;
                model.addElement(seleds[i]);
                this._userCache.add(seleds[i]);
            }
        }
    }

    private void reloadData() {
        DefaultListModel model = (DefaultListModel)this._users.getModel();
        model.clear();
        model.ensureCapacity(this._data.size());
        int size = this._data.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(this._data.get(i));
        }
        this._unComplete = false;
    }

    public List getReturnData() {
        ((DefaultListModel)this._chooses.getModel()).clear();
        this._tfSearch.setText(null);
        this.reloadData();
        if (this._userCache != null) {
            this._userCache.clear();
        }
        return this._returnData;
    }

    private class UsersLoader
    extends AbstractUILongTask {
        private Window _window;

        public UsersLoader(Window targetWindow, int mode) {
            super(targetWindow, mode);
            this._window = targetWindow;
        }

        @Override
        public void doTask() {
            try {
                ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
                SSUserListUI.this._data = serv.queryAllUser();
                if (SSUserListUI.this._data == null || SSUserListUI.this._data.size() == 0) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSUserListUI.this.reloadData();
                    }
                });
            }
            catch (ShortcutMailboxException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtMsgBox.showError(UsersLoader.this._window, "\u52a0\u8f7d\u7528\u6237\u5217\u8868\u5931\u8d25", e.toString());
                    }
                });
            }
        }
    }
}

