/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoService;
import com.kingdee.eas.rpts.statistics.IEASExtStatisticsInfoStub;
import com.kingdee.eas.rpts.statistics.client.HeartBeatThread;
import com.kingdee.eas.rpts.statistics.client.IHeartbeatRefresher;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.rpts.statistics.info.EnterpriseInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;

class CollectThread
extends Thread
implements IHeartbeatRefresher {
    private static Logger logger = CommonLogger.getLogger(CollectThread.class);
    private static String CLOUD_SERVER_URL;
    private HeartBeatThread heartBeatThread;
    private String clientUuid;
    private boolean isPostOK = true;
    private String easHome;
    private IEASExtStatisticsInfoStub stub;

    public CollectThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.initReportStatusUpdater()) {
                return;
            }
            if (this.connect() && this.upload()) {
                this.finished();
            }
        }
        catch (Exception e) {
            logger.error((Object)"----------failed to connect------------", (Throwable)e);
            try {
                this.stub().finished();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
                e.printStackTrace(writer);
                String errorStack = new String(out.toByteArray(), "UTF-8");
                String errorMessage = e.getMessage();
                String error = "{\"message\":\"" + errorMessage + "\",\"stack\":\"" + errorStack + "\"}";
                if (!this.isPostOK) {
                    this.getMethod(error, "reportException", "errorReport", true);
                } else {
                    PostMethod post = new PostMethod(CLOUD_SERVER_URL);
                    StringRequestEntity requestEntity = new StringRequestEntity("remoteMethod=reportException&" + this.buildEnterpriseQueryStr() + "&dataList=" + URLEncoder.encode(error, "UTF-8"), "application/x-www-form-urlencoded", "utf-8");
                    post.setRequestEntity((RequestEntity)requestEntity);
                    this.client().executeMethod((HttpMethod)post);
                    if (!StringUtil.isEmptyString((String)post.getResponseBodyAsString())) {
                        this.getMethod(error, "reportException", "errorReport", true);
                    }
                }
            }
            catch (Throwable th) {
                logger.error((Object)"---------------failed to report error message---------------", th);
            }
        }
        finally {
            if (this.heartBeatThread != null) {
                this.heartBeatThread.finished();
            }
        }
    }

    private boolean initReportStatusUpdater() throws SalmonBizException {
        boolean sync;
        JSONObject jData;
        JSONObject status;
        String addr = System.getProperty("UPDATE_SERVER").replace("http://", "").replace("/easWebClient/", "").replace("/easWebClient", "");
        this.easHome = "http://" + addr + "/mobile/lightapp/extRpt/resources";
        GetMethod get = new GetMethod(this.easHome);
        get.setQueryString("remoteMethod=extLightProperties");
        try {
            this.client().executeMethod((HttpMethod)get);
        }
        catch (HttpException e) {
            throw new SalmonBizException("[HttpException]gui client failed to query properties.", e);
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]gui client failed to query properties.", e);
        }
        try {
            status = new JSONObject(new String(get.getResponseBody(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SalmonBizException("[UnsupportedEncodingException]gui client failed to init properties.", e);
        }
        catch (JSONException e) {
            throw new SalmonBizException("[JSONException]gui client failed to init properties.", e);
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]gui client failed to init json string properties.", e);
        }
        try {
            jData = new JSONObject(status.getString("data"));
        }
        catch (JSONException e) {
            throw new SalmonBizException("[JSONException]gui client failed to init salmon all properties.", e);
        }
        try {
            sync = jData.getBoolean("sync2Cloud");
        }
        catch (JSONException e) {
            throw new SalmonBizException("[JSONException]gui client failed to init salmon sync properties.", e);
        }
        if (sync) {
            try {
                CLOUD_SERVER_URL = jData.getString("cloudUrl");
            }
            catch (JSONException e) {
                throw new SalmonBizException("[JSONException]gui client failed to init salmon cloudUrl properties.", e);
            }
        }
        return sync;
    }

    private boolean connect() throws SalmonBizException {
        boolean isOk;
        if (!this.heartBeat()) {
            return false;
        }
        this.stub().startCreateZipFile();
        GetMethod get = new GetMethod(CLOUD_SERVER_URL);
        String queryString = this.buildEnterpriseQueryStr() + "&remoteMethod=connect";
        get.setQueryString(queryString);
        try {
            this.client().executeMethod((HttpMethod)get);
        }
        catch (HttpException e) {
            throw new SalmonBizException("[HttpException]gui client failed to connect cloud.", e);
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]gui client failed to connect cloud.", e);
        }
        if (get.getStatusCode() != 200) {
            throw new SalmonBizException("[StatusException]gui client failed to connect cloud.", null);
        }
        try {
            isOk = get.getResponseBodyAsString().equals("null({'data':'START'});");
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]gui client connect to cloud with wrong server ret.", e);
        }
        return isOk && get.getStatusCode() == 200;
    }

    private void finished() throws SalmonBizException {
        this.stub().finished();
    }

    private boolean upload() throws SalmonBizException {
        this.heartBeatThread = new HeartBeatThread(this);
        this.heartBeatThread.setDaemon(true);
        this.heartBeatThread.start();
        return this.uploadAllPacket2Cloud();
    }

    private boolean uploadAllPacket2Cloud() throws SalmonBizException {
        Map<String, Object> data = this.stub().fetchAllStatisticsInfoPacket();
        if (StringUtil.equals((String)((String)data.get("status")), (String)"CREATING")) {
            return false;
        }
        Boolean isEnd = (Boolean)data.get("isEnd");
        long start = (Long)data.get("start");
        int size = (Integer)data.get("byteSize");
        if (isEnd == null) {
            return false;
        }
        while (!isEnd.booleanValue()) {
            this.report2Cloud(false, (String)data.get("data"), (String)data.get("fileName"), "uploadAllStatisticsInfoPacket", start, size);
            data = this.stub().fetchAllStatisticsInfoPacket();
            start = (Long)data.get("start");
            size = (Integer)data.get("byteSize");
            isEnd = (Boolean)data.get("isEnd");
        }
        this.report2Cloud(true, (String)data.get("data"), (String)data.get("fileName"), "uploadAllStatisticsInfoPacket", start, size);
        return true;
    }

    private void report2Cloud(boolean isEnd, String all, String fileName, String remoteMethod, long start, int size) throws SalmonBizException {
        if (all == null) {
            return;
        }
        if (this.isPostOK) {
            try {
                String queryString = this.buildEnterpriseQueryStr();
                queryString = queryString + "&isEnd=" + URLEncoder.encode(String.valueOf(isEnd), "UTF-8");
                queryString = queryString + "&fileName=" + URLEncoder.encode(fileName, "UTF-8");
                queryString = queryString + "&dataList=" + URLEncoder.encode(all, "UTF-8");
                queryString = queryString + "&from=" + start;
                queryString = queryString + "&size=" + size;
                queryString = queryString + "&isGuiClient=true";
                PostMethod post = new PostMethod(CLOUD_SERVER_URL);
                StringRequestEntity requestEntity = new StringRequestEntity("remoteMethod=" + remoteMethod + "&" + queryString, "application/x-www-form-urlencoded", "utf-8");
                post.setRequestEntity((RequestEntity)requestEntity);
                this.client().executeMethod((HttpMethod)post);
                boolean bl = this.isPostOK = post.getStatusCode() == 200;
                if (!this.isPostOK) {
                    throw new SalmonBizException(post.getResponseBodyAsString(), null);
                }
                this.isPostOK = post.getResponseBodyAsString().equals("null({'data':true});");
            }
            catch (IOException th) {
                this.isPostOK = false;
            }
        }
        if (!this.isPostOK) {
            throw new SalmonBizException("post method not allowed.", null);
        }
        EASExtStatisticsInfoService.uploadFinished(null, start, size);
    }

    private void getMethod(String all, String remoteMethod, String fileName, boolean isEnd) throws SalmonBizException {
        int from = 0;
        int to = all.length();
        do {
            String body;
            String queryString = this.buildEnterpriseQueryStr();
            GetMethod get = new GetMethod(CLOUD_SERVER_URL);
            try {
                if (to - from <= 256) {
                    queryString = queryString + "&dataList=" + URLEncoder.encode(all.substring(from, to), "UTF-8");
                    from = to;
                } else {
                    queryString = queryString + "&dataList=" + URLEncoder.encode(all.substring(from, from += 256), "UTF-8");
                }
                queryString = queryString + "&isEnd=" + URLEncoder.encode(String.valueOf(isEnd), "UTF-8");
                queryString = queryString + "&fileName=" + URLEncoder.encode(fileName, "UTF-8");
                queryString = queryString + "&isFinish=" + URLEncoder.encode(String.valueOf(from == to), "UTF-8");
                queryString = queryString + "&from=" + URLEncoder.encode(String.valueOf(from), "UTF-8");
                queryString = queryString + "&to=" + URLEncoder.encode(String.valueOf(to), "UTF-8");
                queryString = queryString + "&all=" + URLEncoder.encode(String.valueOf(all.length()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SalmonBizException("[UnsupportedEncodingException]gui client failed to build get queryString.", e);
            }
            String data = "remoteMethod=" + remoteMethod + "&" + queryString;
            get.setQueryString(data);
            try {
                this.client().executeMethod((HttpMethod)get);
                body = get.getResponseBodyAsString();
            }
            catch (HttpException e) {
                throw new SalmonBizException("[HttpException]gui client failed to commit data by get.", null);
            }
            catch (IOException e) {
                throw new SalmonBizException("[IOException]gui client failed to commit data by get.", null);
            }
            if (get.getStatusCode() == 200) continue;
            throw new SalmonBizException(body, null);
        } while (from != to);
    }

    private HttpClient client() {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF8");
        client.getParams().setCookiePolicy("compatibility");
        client.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (Windows NT 6.1; rv:8.0.1) Gecko/20100101 Firefox/8.0.1");
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Cookie", "lang=CH; load_balancer=dcd47a65-d505-4de2-a521-d9ca7145da5a; JSESSIONID=981453C8B9516E0DFCA183C1F7F15E0C.node16"));
        headers.add(new Header("Connection", "keep-alive"));
        client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        return client;
    }

    private String buildEnterpriseQueryStr() throws SalmonBizException {
        String queryString;
        EnterpriseInfo info = EASExtStatisticsInfoService.fetchEnterpriseInfo(null);
        try {
            queryString = "eUuid=" + URLEncoder.encode(info.getUuid(), "UTF-8");
            queryString = queryString + "&eName=" + URLEncoder.encode(info.getName(), "UTF-8");
            queryString = queryString + "&dbCode=" + URLEncoder.encode(info.getDbCode(), "UTF-8");
            queryString = queryString + "&dbType=" + URLEncoder.encode(info.getDbType(), "UTF-8");
            queryString = queryString + "&eVersion=" + URLEncoder.encode(info.getVersion(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SalmonBizException("[UnsupportedEncodingException]gui client failed to build enterprise info.", e);
        }
        return queryString;
    }

    @Override
    public boolean heartBeat() throws SalmonBizException {
        this.clientUuid = this.stub().heartbeat(this.clientUuid);
        return this.clientUuid != null;
    }

    private IEASExtStatisticsInfoStub stub() throws SalmonBizException {
        if (this.stub == null) {
            try {
                this.stub = (IEASExtStatisticsInfoStub)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoStub", IEASExtStatisticsInfoStub.class);
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]gui client failed to create remote stub.", e);
            }
        }
        return this.stub;
    }
}

