/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rpts.ctrlreport.email.MailInfo;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.rpts.sumreport.client.EmailTemplateUI;
import com.kingdee.eas.rpts.sumreport.client.TaskManageSendMailEditUI;
import com.kingdee.eas.rpts.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.rpts.sumreport.data.MessageTemplateinfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.enumtype.TempletType;
import com.kingdee.eas.rpts.sumreport.exceptions.SumTaskException;
import com.kingdee.eas.rpts.sumreport.model.ModeEnum;
import com.kingdee.eas.rpts.sumreport.model.StatusEngine;
import com.kingdee.eas.rpts.sumreport.service.SumTaskUploadService;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class UrgeCommitReportUI
extends BaseListUI {
    Logger log = CommonLogger.getLogger(UrgeCommitReportUI.class);
    protected KDLabelContainer kDLabelContainer1;
    protected KDTable _table;
    protected KDLabel lblTitle;
    protected KDTextField txtReceiveAddr;
    private KDWorkButton _btnEmailTemplateEdit;
    private KDWorkButton _btnRestoreDefaultTemplate;
    private KDWorkButton _btnEmailUrge;
    private KDWorkButton _btnEmailPreview;
    private KDWorkButton _btnEmailServerSet;
    protected static final int COL_SELECT = 0;
    protected static final int COL_UPLOADCOMPANY_NUMBER = 1;
    protected static final int COL_UPLOADCOMPANY_NAME = 2;
    protected static final int COL_SUMUNIT_NUMBER = 3;
    protected static final int COL_SUMUNIT_NAME = 4;
    protected static final int COL_REPORTNAME = 5;
    protected static final int COL_STATE = 6;
    protected static final int COL_TEMPLATETYPE = 7;
    protected static final int COL_UPLOADCOMPANY_ID = 8;
    private static final String INITIALID = "eveea6QXzGi8NhK0mMi5Q5_N_ABL7tzTCcuZSpyrpVvO";
    private static final String TEMPLATEID_FOR_USER = "vkM4Gr95072mLKBV3UXbqWakktyeAC6T6OWigIFRrly3";
    protected SumTaskUploadService sumTaskUploadService;
    private String[] columnName = new String[]{"\u9009\u62e9", "\u7ec4\u7ec7\u7f16\u7801", "\u7ec4\u7ec7\u540d\u79f0", "\u6c47\u603b\u5355\u5143\u7f16\u7801", "\u6c47\u603b\u5355\u5143\u540d\u79f0", "\u62a5\u8868\u540d\u79f0", "\u72b6\u6001", "\u62a5\u8868\u7c7b\u578b", "unitId"};
    private static final String COMPANY_NAME = "\u516c\u53f8\u540d\u79f0";
    private String templateContent;
    private Timestamp curServerTime;
    Map isSelectMap = new HashMap();
    MailInfo mailInfo;

    public UrgeCommitReportUI() throws Exception {
        this.initControl();
        this.initTable();
        this.setUITitle("\u62a5\u8868\u50ac\u62a5");
        String sql = this.assembleWhereSql();
        this.loadData(sql, sql);
        this.initTableValueChangedListener();
    }

    private void initTableValueChangedListener() {
        this._table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                ArrayList selectList = UrgeCommitReportUI.this._table.getSelectManager().getBlocks();
                if (selectList == null || selectList.size() == 0) {
                    return;
                }
                KDTSelectBlock block = (KDTSelectBlock)selectList.get(0);
                if (0 == block.getLeft()) {
                    IRow row = UrgeCommitReportUI.this._table.getRow(block.getTop());
                    Object select = row.getCell(0).getValue();
                    String orgId = ((TaskDetailInfo)row.getUserObject()).getUnitId();
                    String rowIndex = Integer.toString(row.getRowIndex());
                    if (!((Boolean)select).booleanValue()) {
                        if (UrgeCommitReportUI.this.isSelectMap.size() == 0) {
                            UrgeCommitReportUI.this.isSelectMap.put(rowIndex, orgId);
                        }
                        if (!UrgeCommitReportUI.this.isSelectMap.containsValue(orgId)) {
                            UrgeCommitReportUI.this._table.getCellEditor(KDTableUtil.getSelectedRow((KDTable)UrgeCommitReportUI.this._table).getRowIndex(), 0).stopCellEditing();
                            row.getCell(0).setValue((Object)Boolean.FALSE);
                            UrgeCommitReportUI.this._table.getEditManager().editCellAt(row.getRowIndex(), 0);
                            ExtMsgBox.showInfo("\u8bf7\u9009\u62e9\u76f8\u540c\u516c\u53f8\u7684\u62a5\u8868\u8fdb\u884c\u4e0a\u62a5");
                        } else if (!UrgeCommitReportUI.this.isSelectMap.containsKey(rowIndex)) {
                            UrgeCommitReportUI.this.isSelectMap.put(rowIndex, orgId);
                        }
                        UrgeCommitReportUI.this.disableRow(rowIndex);
                    } else {
                        UrgeCommitReportUI.this.isSelectMap.remove(rowIndex);
                        UrgeCommitReportUI.this.enableRow(rowIndex);
                    }
                    UrgeCommitReportUI.this._table.getCellEditor(KDTableUtil.getSelectedRow((KDTable)UrgeCommitReportUI.this._table).getRowIndex(), 0).stopCellEditing();
                    UrgeCommitReportUI.this._table.getEditManager().editCellAt(row.getRowIndex(), 0);
                }
            }
        });
    }

    private void disableRow(String rowIndex) {
        String selectOrgId = (String)this.isSelectMap.get(rowIndex);
        if (!StringUtil.isEmptyString((String)selectOrgId) && this.isSelectMap.size() > 0) {
            String orgId = null;
            IRow row = null;
            int size = this._table.getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this._table.getRow(i);
                orgId = ((TaskDetailInfo)row.getUserObject()).getUnitId();
                if (selectOrgId.equals(orgId)) continue;
                row.getCell(0).getStyleAttributes().setLocked(true);
                row.getCell(0).getStyleAttributes().setBackground(Color.gray);
            }
        }
    }

    private void enableRow(String rowIndex) {
        if (this.isSelectMap.size() == 0) {
            IRow row = null;
            int size = this._table.getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this._table.getRow(i);
                row.getCell(0).getStyleAttributes().setLocked(false);
                row.getCell(0).getStyleAttributes().setBackground(Color.white);
            }
        }
    }

    private void initControl() throws Exception {
        this.toolBar = new KDToolBar();
        this.menuBar = new KDMenuBar();
        this.kDLabelContainer1 = new KDLabelContainer();
        this._table = new KDTable();
        this.lblTitle = new KDLabel();
        this.txtReceiveAddr = new KDTextField();
        this.kDLabelContainer1.setBoundLabelText("\u63a5\u6536\u4eba");
        this.kDLabelContainer1.setBoundLabelLength(60);
        this.kDLabelContainer1.setBoundLabelUnderline(true);
        this.txtReceiveAddr.setEditable(true);
        this.txtReceiveAddr.setRequired(true);
        this.lblTitle.setText("\u50ac\u62a5\u5217\u8868(\u8bf7\u9009\u62e9\u76f8\u540c\u516c\u53f8\u7684\u62a5\u8868\u8fdb\u884c\u50ac\u62a5)");
        this.lblTitle.setToolTipText("\u50ac\u62a5\u5217\u8868");
        BaseListUI.ActionDispatch action = new BaseListUI.ActionDispatch(this);
        this._btnEmailTemplateEdit = this.initWBTN("\u90ae\u4ef6\u6a21\u677f\u7f16\u8f91", "imgTbtn_messagetopicedit", action);
        this._btnRestoreDefaultTemplate = this.initWBTN("\u6062\u590d\u7f3a\u7701\u6a21\u677f", "imgTbtn_reset", action);
        this._btnEmailUrge = this.initWBTN("\u53d1\u9001", "imgTbtn_dispose", action);
        this._btnEmailPreview = this.initWBTN("\u90ae\u4ef6\u9884\u89c8", "imgTbtn_preview2", action);
        this._btnEmailServerSet = this.initWBTN("\u90ae\u4ef6\u5e10\u6237\u6d4b\u8bd5", "imgTbtn_initializeappserver", action);
        this.sumTaskUploadService = new SumTaskUploadService();
    }

    protected void initTable() {
        int[] columnWidth = new int[]{65, 128, 128, 128, 128, 128, 128, 128, 128};
        ControlDataLoadUtil.initTableHeader(this._table, 9, columnWidth, this.columnName);
        this._table.getColumn(0).getStyleAttributes().setLocked(false);
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getColumn(3).getStyleAttributes().setLocked(true);
        this._table.getColumn(4).getStyleAttributes().setLocked(true);
        this._table.getColumn(5).getStyleAttributes().setLocked(true);
        this._table.getColumn(6).getStyleAttributes().setLocked(true);
        this._table.getColumn(7).getStyleAttributes().setLocked(true);
        this._table.getColumn(8).getStyleAttributes().setHided(true);
        this._table.getSelectManager().setSelectMode(2);
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1016, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1016, 600));
        this.kDLabelContainer1.setBounds(new Rectangle(10, 10, 280, 19));
        this.add((Component)this.kDLabelContainer1, new KDLayout.Constraints(10, 10, 280, 19, 385));
        this._table.setBounds(new Rectangle(10, 60, 996, 530));
        this.add((Component)this._table, new KDLayout.Constraints(10, 60, 996, 530, 387));
        this.lblTitle.setBounds(new Rectangle(10, 35, 477, 19));
        this.add((Component)this.lblTitle, new KDLayout.Constraints(10, 35, 477, 19, 385));
        this.kDLabelContainer1.setBoundEditor((JComponent)this.txtReceiveAddr);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnEmailTemplateEdit);
        this.toolBar.add((Component)this._btnEmailPreview);
        this.toolBar.add((Component)this._btnRestoreDefaultTemplate);
        this.toolBar.add((Component)this._btnEmailUrge);
        this.toolBar.add((Component)this._btnEmailServerSet);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuTool.remove((JMenuItem)this.menuItemSendMessage);
    }

    @Override
    public void dispatchAction(ActionEvent e) throws IOException, BOSException {
        if (e.getSource() == this._btnEmailTemplateEdit) {
            this.actionTemplateEdit();
        }
        if (e.getSource() == this._btnEmailPreview) {
            this.actionEmailPreview();
        }
        if (e.getSource() == this._btnRestoreDefaultTemplate) {
            this.actionRestoreDefaultTemplate();
        }
        if (e.getSource() == this._btnEmailUrge) {
            this.actionEmailUrge();
        }
        if (e.getSource() == this._btnEmailServerSet) {
            this.actionEmailServerSet();
        }
    }

    private void actionEmailServerSet() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EASUtil.IS_SEND, (Object)Boolean.FALSE);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TaskManageSendMailEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        if (window.getUIObject() != null) {
            window.getUIObject().setUITitle("\u90ae\u4ef6\u8d26\u6237\u6d4b\u8bd5");
        }
        window.show();
    }

    private void actionRestoreDefaultTemplate() {
        try {
            this.sumTaskUploadService.updateMessageTemplateContent(TEMPLATEID_FOR_USER, INITIALID, EASUtil.getCurrentUserID());
            this.getTemplateContent();
            ExtMsgBox.showInfo("\u5df2\u7ecf\u6062\u590d\u6210\u521d\u59cb\u6a21\u677f");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (IOException e) {
            this.handUIException(e);
        }
    }

    private void actionTemplateEdit() throws IOException, BOSException {
        boolean isHasError = this.isHasTemplateContent();
        if (isHasError) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isFromPreview", (Object)Boolean.FALSE);
        uiContext.put((Object)"content", (Object)this.templateContent);
        uiContext.put((Object)"owner", (Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmailTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        if (window.getUIObject() != null) {
            window.getUIObject().setUITitle("\u90ae\u4ef6\u6a21\u677f\u7f16\u8f91");
        }
        window.show();
    }

    private boolean isHasTemplateContent() throws IOException, BOSException {
        if (!StringUtil.isEmptyString((String)this.templateContent)) {
            return false;
        }
        return this.getTemplateContent();
    }

    private boolean getTemplateContent() throws BOSException, IOException {
        MessageTemplateinfo info = new MessageTemplateinfo();
        info.setId(TEMPLATEID_FOR_USER);
        Map message = (Map)this.sumTaskUploadService.getMessageTemplateInfoById(info);
        boolean isHasError = false;
        if (message == null || message.size() == 0) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u6ca1\u6709\u627e\u5230\u90ae\u4ef6\u6a21\u7248");
            isHasError = true;
        } else {
            this.curServerTime = (Timestamp)message.get("curServerTime");
            Object msg = message.get("femailcontent");
            this.templateContent = DispatchCommonUtil.clob2String(msg);
        }
        return isHasError;
    }

    private void actionEmailPreview() throws IOException, BOSException {
        boolean isHasError = this.isHasTemplateContent();
        if (isHasError) {
            return;
        }
        StringBuffer finalContent = new StringBuffer();
        boolean isSelectRecord = this.assembleEmail(finalContent, true);
        if (isSelectRecord) {
            try {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"isFromPreview", (Object)Boolean.TRUE);
                uiContext.put((Object)"content", (Object)finalContent.toString());
                IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmailTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                if (window.getUIObject() != null) {
                    window.getUIObject().setUITitle("\u90ae\u4ef6\u9884\u89c8");
                }
                window.show();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private boolean assembleEmail(StringBuffer content, boolean isPreview) throws SumTaskException {
        if (KDTableUtil.getSelectedRow((KDTable)this._table) != null) {
            this._table.getCellEditor(KDTableUtil.getSelectedRow((KDTable)this._table).getRowIndex(), 0).stopCellEditing();
        }
        String companyName = null;
        StringBuffer reportAndState = new StringBuffer();
        int size = this._table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this._table.getRow(i);
            Boolean isSelect = (Boolean)row.getCell(0).getValue();
            if (isSelect == null || !isSelect.booleanValue()) continue;
            TaskDetailInfo info = (TaskDetailInfo)row.getUserObject();
            companyName = info.getUnitName();
            reportAndState.append(info.getReportName()).append("\u2014\u2014").append(StatusEngine.getTaskAStatus(info.getState())).append("\n");
        }
        boolean isSelectRecord = true;
        if (StringUtil.isEmptyString(companyName)) {
            ExtMsgBox.showInfo("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
            isSelectRecord = false;
        } else {
            String finalContent = this.templateContent;
            StringBuffer regex = new StringBuffer("\\[" + this.columnName[5] + "\\s" + this.columnName[6] + "\\]");
            finalContent = finalContent.replaceAll(regex.toString(), reportAndState.toString());
            regex.setLength(0);
            regex.append("\\[\u516c\u53f8\u540d\u79f0\\]");
            finalContent = finalContent.replaceAll(regex.toString(), companyName);
            if (this.curServerTime != null && isPreview) {
                regex.setLength(0);
                regex.append("\\[\u5f53\u524d\u670d\u52a1\u5668\u7cfb\u7edf\u65f6\u95f4\\]");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm");
                this.curServerTime = this.sumTaskUploadService.getSystemTime();
                String curTime = dateFormat.format(this.curServerTime);
                finalContent = finalContent.replaceAll(regex.toString(), curTime);
            }
            content.append(finalContent);
        }
        return isSelectRecord;
    }

    private void actionEmailUrge() throws IOException, BOSException {
        boolean isHasError = this.isHasTemplateContent();
        StringBuffer finalContent = new StringBuffer();
        boolean isSelectRecord = this.assembleEmail(finalContent, false);
        if (!isSelectRecord || isHasError) {
            return;
        }
        try {
            Map email = (Map)this.sumTaskUploadService.getCurUserEmail(EASUtil.getCurrentUserID());
            if (email == null || StringUtil.isEmptyString((String)((String)email.get("femail")))) {
                ExtMsgBox.showInfo("\u5f53\u524d\u7528\u6237" + SysContext.getSysContext().getCurrentUserInfo().getName() + "\u6ca1\u6709\u90ae\u7bb1\uff0c\u8bf7\u8bbe\u7f6e\u90ae\u7bb1");
                return;
            }
            String sendEmail = (String)email.get("femail");
            this.sendEmail(sendEmail.trim(), this.txtReceiveAddr.getText(), finalContent.toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void sendEmail(String sendEmail, String femail, String content) throws BOSException, IOException {
        if (StringUtil.isEmptyString((String)femail)) {
            ExtMsgBox.showInfo("\u8bf7\u586b\u5199\u63a5\u6536\u4eba");
            return;
        }
        femail = femail.trim();
        femail = ExtStringUtil.replace(femail, "\r", "");
        femail = ExtStringUtil.replace(femail, "\n", "");
        femail = ExtStringUtil.replace(femail, "\uff0c", ";");
        femail = ExtStringUtil.replace(femail, ",", ";");
        femail = ExtStringUtil.replace(femail, "\uff1b", ";");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EASUtil.IS_SEND, (Object)Boolean.TRUE);
        uiContext.put((Object)EASUtil.SEND_EMAL, (Object)sendEmail);
        uiContext.put((Object)EASUtil.FEMAIL, (Object)femail);
        uiContext.put((Object)EASUtil.MAIL_CONTENT, (Object)content);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TaskManageSendMailEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    private String assembleWhereSql() {
        StringBuffer sql = new StringBuffer(" and detail.fstate in (");
        sql.append(ModeEnum.TASK_DISTRIBUTED).append(",").append(ModeEnum.TASK_MADE).append(",");
        sql.append(ModeEnum.TASK_AUDIT).append(")");
        return sql.toString();
    }

    public void loadData(String orgWhereSql, String unitWhereSql) {
        String curOrgID = EASUtil.getCurrentOrgID();
        String localString = EASUtil.gelLoginLocal();
        try {
            List uploadReportList = this.sumTaskUploadService.getUrgeCommitReportList(curOrgID, localString, orgWhereSql, unitWhereSql);
            this.actionRefresh(uploadReportList);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void actionRefresh(List uploadReportList) {
        this._table.removeRows();
        if (uploadReportList == null || uploadReportList.size() == 0) {
            return;
        }
        int size = uploadReportList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)uploadReportList.get(i);
            TaskDetailInfo info = new TaskDetailInfo();
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)Boolean.FALSE);
            String manageOrgNumber = (String)rowData.get("manageorgnum");
            String orgNumber = (String)rowData.get("orgnumber");
            if (!StringUtil.isEmptyString((String)orgNumber)) {
                manageOrgNumber = orgNumber;
            }
            row.getCell(1).setValue((Object)manageOrgNumber);
            String unitNumber = (String)rowData.get("unitnumber");
            String unitName = (String)rowData.get("unitname");
            if (!StringUtil.isEmptyString((String)unitNumber)) {
                row.getCell(3).setValue((Object)unitNumber);
                info.setUnitNumber(unitNumber);
            }
            if (!StringUtil.isEmptyString((String)unitName)) {
                row.getCell(4).setValue((Object)unitName);
                info.setUnitName((String)rowData.get("unitname"));
            } else {
                info.setUnitName((String)rowData.get("manageorgname"));
            }
            row.getCell(2).setValue(rowData.get("manageorgname"));
            row.getCell(5).setValue(rowData.get("reportname"));
            info.setReportName((String)rowData.get("reportname"));
            row.getCell(6).setValue(rowData.get("detailstate"));
            this.setState(rowData.get("detailstate"), row, info, 6);
            Number templateType = (Number)rowData.get("templatetype");
            row.getCell(7).setValue((Object)TempletType.getTempletType(templateType.intValue()).getName());
            info.setId((String)rowData.get("detailid"));
            info.setUnitId((String)rowData.get("unitid"));
            row.setUserObject((Object)info);
        }
    }

    protected void setState(Object state, IRow row, TaskDetailInfo info, int columnName) {
        if (state == null) {
            return;
        }
        Number stateObj = (Number)state;
        int stateInt = stateObj.intValue();
        row.getCell(columnName).setValue((Object)StatusEngine.getTaskAStatus(stateInt));
        info.setState(stateInt);
    }

    public void setTemplateContent(String content) {
        this.templateContent = content;
    }
}

