/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.execution;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.rpts.sumreport.client.execution.SNRRExecutor;
import com.kingdee.eas.rpts.sumreport.client.execution.action.Approve;
import com.kingdee.eas.rpts.sumreport.client.execution.action.Delete;
import com.kingdee.eas.rpts.sumreport.client.execution.action.JumpBack;
import com.kingdee.eas.rpts.sumreport.client.execution.action.Report;
import com.kingdee.eas.rpts.sumreport.client.execution.action.RevokeApprove;
import com.kingdee.eas.rpts.sumreport.client.execution.action.RevokeReport;
import com.kingdee.eas.rpts.sumreport.client.execution.action.RevokeSubmit;
import com.kingdee.eas.rpts.sumreport.client.execution.action.Save;
import com.kingdee.eas.rpts.sumreport.client.execution.action.Submit;
import com.kingdee.eas.rpts.sumreport.data.ExecuteContext;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import javax.swing.Action;

class ExecutorUIHelper {
    ExecutorUIHelper() {
    }

    public static void setUpToolBar(KDToolBar toolBar, int state, SNRRExecutor executor) {
        switch (state) {
            case 0: {
                ExecutorUIHelper.whenDistributed(toolBar, executor);
                break;
            }
            case 1: {
                ExecutorUIHelper.whenEnbrished(toolBar, executor);
                break;
            }
            case 2: {
                ExecutorUIHelper.whenApprovaled(toolBar, executor);
                break;
            }
            case 3: {
                ExecutorUIHelper.whenReported(toolBar, executor);
                break;
            }
            case 4: {
                ExecutorUIHelper.whenReceived(toolBar, executor);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void whenDistributed(KDToolBar toolBar, SNRRExecutor executor) {
        Approve approve = new Approve(executor);
        toolBar.add((Action)approve, 1);
        Report report = new Report(executor);
        toolBar.add((Action)report, 1);
        approve.setEnabled(false);
        report.setEnabled(false);
        Save save = new Save(executor);
        ExecuteContext ctx = executor.getContext();
        save.addObserver(ctx.getObserver());
        toolBar.add((Action)save, 1);
        Delete del = new Delete(executor);
        toolBar.add((Action)del, 1);
        Submit submit = new Submit(executor);
        toolBar.add((Action)submit, 1);
    }

    private static void whenEnbrished(KDToolBar toolBar, SNRRExecutor executor) {
        Save save = new Save(executor);
        toolBar.add((Action)save, 1);
        Delete del = new Delete(executor);
        toolBar.add((Action)del, 1);
        Report report = new Report(executor);
        toolBar.add((Action)report, 1);
        save.setEnabled(false);
        del.setEnabled(false);
        report.setEnabled(false);
        RevokeSubmit revokeSubmit = new RevokeSubmit(executor);
        toolBar.add((Action)revokeSubmit, 1);
        Approve approve = new Approve(executor);
        toolBar.add((Action)approve, 1);
        JumpBack jump = new JumpBack(executor);
        toolBar.add((Action)jump, 1);
    }

    private static void whenApprovaled(KDToolBar toolBar, SNRRExecutor executor) {
        Save save = new Save(executor);
        toolBar.add((Action)save, 1);
        Delete del = new Delete(executor);
        toolBar.add((Action)del, 1);
        RevokeSubmit revokeSubmit = new RevokeSubmit(executor);
        toolBar.add((Action)revokeSubmit, 1);
        save.setEnabled(false);
        del.setEnabled(false);
        revokeSubmit.setEnabled(false);
        RevokeApprove revokeApprove = new RevokeApprove(executor);
        toolBar.add((Action)revokeApprove, 1);
        Report report = new Report(executor);
        TaskDetailInfo info = executor.getValue();
        if (info != null && StringUtil.isEmptyString((String)info.getParentID()) && !executor.getContext().isUpload()) {
            report.putValue("Name", "\u5b8c\u6210");
        }
        toolBar.add((Action)report, 1);
    }

    private static void whenReported(KDToolBar toolBar, SNRRExecutor executor) {
        Save save = new Save(executor);
        toolBar.add((Action)save, 1);
        Delete del = new Delete(executor);
        toolBar.add((Action)del, 1);
        RevokeSubmit revokeSubmit = new RevokeSubmit(executor);
        toolBar.add((Action)revokeSubmit, 1);
        RevokeApprove revokeApprove = new RevokeApprove(executor);
        toolBar.add((Action)revokeApprove, 1);
        RevokeReport revokeReport = new RevokeReport(executor);
        toolBar.add((Action)revokeReport, 1);
        save.setEnabled(false);
        del.setEnabled(false);
        revokeSubmit.setEnabled(false);
        revokeApprove.setEnabled(false);
    }

    private static void whenReceived(KDToolBar toolBar, SNRRExecutor executor) {
        Save save = new Save(executor);
        toolBar.add((Action)save, 1);
        Delete del = new Delete(executor);
        toolBar.add((Action)del, 1);
        RevokeSubmit revokeSubmit = new RevokeSubmit(executor);
        toolBar.add((Action)revokeSubmit, 1);
        RevokeApprove revokeApprove = new RevokeApprove(executor);
        toolBar.add((Action)revokeApprove, 1);
        RevokeReport revokeReport = new RevokeReport(executor);
        toolBar.add((Action)revokeReport, 1);
        save.setEnabled(false);
        del.setEnabled(false);
        revokeSubmit.setEnabled(false);
        revokeApprove.setEnabled(false);
        revokeReport.setEnabled(false);
    }
}

