/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.execution;

import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.rpts.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.rpts.sumreport.client.execution.SNRRExecutor;
import com.kingdee.eas.rpts.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.exceptions.ExecutorException;
import com.kingdee.eas.rpts.sumreport.service.ExecutorService;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TransitionLowerUI
extends KDFrame {
    private SNRRExecutor _mainUI;
    private KDToolBar _tbar;
    private ActivityTree _tree;
    private TaskDetailInfo _parentEntity;
    private DisplayPanel _panel;
    private ExecutorService _srsv;

    public TransitionLowerUI(SNRRExecutor execUI) {
        this._mainUI = execUI;
        this._parentEntity = this._mainUI.getValue();
        this.initUI();
    }

    private void initUI() {
        this._tree = new ActivityTree();
        this._panel = new DisplayPanel();
        this._srsv = new ExecutorService();
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(260);
        sppLeftRight.setLeftComponent((Component)this._tree.getUI());
        this._panel.setMinimumSize(new Dimension(0, 0));
        sppLeftRight.setRightComponent((Component)((Object)this._panel));
        sppLeftRight.setOneTouchExpandable(true);
        KDPanel contentPane = new KDPanel();
        contentPane.setCustomInsets(new Insets(0, 0, 10, 0));
        this.setContentPane((Container)contentPane);
        contentPane.setLayout((LayoutManager)new BorderLayout());
        contentPane.add((Component)sppLeftRight, (Object)"Center");
        this._tree.addDoubleClickAction();
        this.setTitle("\u8054\u67e5\u4e2a\u522b\u62a5\u8868");
        this.setSize(800, 600);
        this.setExtendedState(6);
        this.setDefaultCloseOperation(1);
        this._tbar = new KDToolBar();
        this.initToolBar(null);
        this.addToolBar((JToolBar)this._tbar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TreeLoader treeLoader = new TreeLoader((Window)((Object)TransitionLowerUI.this), 1);
                treeLoader.start();
            }
        });
    }

    private void initToolBar(Action[] acs) {
        if (acs != null) {
            for (int i = 0; i < acs.length; ++i) {
                this._tbar.add((Action)new DelegateAction((AbstractAction)acs[i]));
            }
        }
        this._tbar.add((Component)new KDSeparator());
        this._tbar.add((Action)new CloseAction(this));
    }

    public void addReportActions(Action[] acs) {
        this._tbar.removeAllToolBarComponents();
        this.initToolBar(acs);
    }

    public void refreshDisplayPane(KDPanel displayComponent) {
        this._panel.refresh(displayComponent);
    }

    private KDPanel getDisplayPane() {
        return this._panel;
    }

    private void execSnapshot(ActivityEnity entity) {
        new SnapshotExecutor(entity).start();
    }

    private class ActivityEnity {
        String _id;
        String _name;

        public ActivityEnity(String id, String name) {
            this._id = id;
            this._name = name;
        }
    }

    private class TreeLoader
    extends AbstractUILongTask {
        public TreeLoader(Window targetWindow, int mode) {
            super(targetWindow, mode);
        }

        @Override
        public void doTask() {
            try {
                Map id2Names = TransitionLowerUI.this._srsv.getChildIDs(TransitionLowerUI.this._parentEntity.getTaskDistributeID(), TransitionLowerUI.this._parentEntity.getUnitOrOrgID());
                Iterator itor = id2Names.keySet().iterator();
                DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(null, (Icon)UploadSumIcons.createIcon("sum_unit.gif"));
                root.setText(TransitionLowerUI.this._parentEntity.getTaskName());
                while (itor.hasNext()) {
                    String id = (String)itor.next();
                    String name = (String)id2Names.get(id);
                    ActivityEnity entity = new ActivityEnity(id, name);
                    DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)entity);
                    node.setText(entity._name);
                    root.add((MutableTreeNode)node);
                }
                TransitionLowerUI.this._tree.refresh(new KingdeeTreeModel((TreeNode)root));
            }
            catch (ExecutorException e) {
                ExtMsgBox.showError((Component)((Object)TransitionLowerUI.this), "\u52a0\u8f7d\u5b50\u7ea7\u7ec4\u7ec7\u5217\u8868\u5931\u8d25", e.toString());
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private TransitionLowerUI _ui;

        public CloseAction(TransitionLowerUI ui) {
            this._ui = ui;
            this.putValue("SmallIcon", UploadSumIcons.createIcon("tbtn_quit.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._ui.setVisible(false);
        }
    }

    private class SnapshotExecutor
    extends LongTaskWorker {
        protected ExtGuiExecutor _executor;
        private ActivityEnity _childEntity;

        public SnapshotExecutor(ActivityEnity entity) {
            this._childEntity = entity;
        }

        public Object construct() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TransitionLowerUI.this.refreshDisplayPane(null);
                    TransitionLowerUI.this.getDisplayPane().revalidate();
                }
            });
            try {
                if (!this.load()) {
                    return null;
                }
            }
            catch (Exception e1) {
                ExtMsgBox.showError((Component)((Object)TransitionLowerUI.this), "\u52a0\u8f7d\u62a5\u8868\u5931\u8d25", e1.toString());
                return null;
            }
            try {
                if (!this._executor.execute()) {
                    return null;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                ExtMsgBox.showError((Component)((Object)TransitionLowerUI.this), "\u6267\u884c\u62a5\u8868\u51fa\u9519", e.toString());
                return null;
            }
        }

        protected boolean load() throws Exception {
            byte[] snapData = TransitionLowerUI.this._srsv.queryASnapshotData(this._childEntity._id);
            if (snapData == null || snapData.length == 0) {
                ExtMsgBox.showInfo((Component)((Object)TransitionLowerUI.this), "\u6ca1\u6709\u751f\u6210\u5feb\u7167\uff01");
                return false;
            }
            this._executor = new ExtGuiExecutor(snapData);
            return true;
        }

        public void finished() {
            Object returnObj = this.getValue();
            if (returnObj == Boolean.TRUE) {
                TransitionLowerUI.this.addReportActions(this._executor.getContextualActions(4));
                this._executor.getSpreadContext().setBorder(BorderFactory.createLineBorder(Color.GRAY));
                TransitionLowerUI.this.refreshDisplayPane((KDPanel)this._executor.getSpreadContext());
            } else {
                TransitionLowerUI.this.addReportActions(null);
                TransitionLowerUI.this.refreshDisplayPane(null);
            }
            TransitionLowerUI.this.invalidate();
            TransitionLowerUI.this.repaint();
        }
    }

    private class DelegateAction
    extends AbstractAction {
        private AbstractAction _action;

        public DelegateAction(AbstractAction action) {
            this._action = action;
            this.putValue("Name", this._action.getValue("Name"));
            this.putValue("SmallIcon", this._action.getValue("SmallIcon"));
            this.putValue("AcceleratorKey", this._action.getValue("AcceleratorKey"));
            Object o = this._action.getValue("ActionComponent");
            if (o != null) {
                this.putValue("ActionComponent", o);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._action.actionPerformed(e);
            JComponent comp = TransitionLowerUI.this._panel.getDisplayComponent();
            if (comp instanceof SpreadContext) {
                ((SpreadContext)comp).getSpread().setEditable(true);
            }
        }
    }

    private class DisplayPanel
    extends KDPanel {
        private KDLabel _noteLabel;
        private JComponent _displayComponent;

        public DisplayPanel() {
            this.initDefault();
        }

        private void initDefault() {
            this._noteLabel = new KDLabel("\u63d0\u793a\uff1a \u53cc\u51fb\u5de6\u8fb9\u6811\u7ed3\u70b9\u53ef\u67e5\u770b\u5feb\u7167\u3002");
            this._noteLabel.setIcon((Icon)UploadSumIcons.createIcon("info.gif"));
            this._noteLabel.setPreferredSize(new Dimension(300, 40));
            this._noteLabel.setHorizontalAlignment(0);
            this._displayComponent = this._noteLabel;
            this.setLayout(new BorderLayout());
            this.add((Component)this._noteLabel, "Center");
        }

        public void refresh(KDPanel reportPanel) {
            this._displayComponent = reportPanel;
            if (this._displayComponent == null) {
                this._displayComponent = this._noteLabel;
            }
            if (this._displayComponent instanceof SpreadContext) {
                ((SpreadContext)this._displayComponent).getSpread().setEditable(true);
            }
            this.removeAll();
            this.setLayout(new BorderLayout());
            this._displayComponent.setMinimumSize(new Dimension(400, 800));
            this.add(this._displayComponent, "Center");
            this.revalidate();
        }

        public JComponent getDisplayComponent() {
            return this._displayComponent;
        }
    }

    private class ActivityTree {
        private KDTree _tree;
        private KDTreeView _treeView;

        public ActivityTree() {
            this.initTree();
        }

        private void initTree() {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
            treeModel.setAsksAllowsChildren(true);
            this._tree = new KDTree();
            this._tree.setModel((TreeModel)treeModel);
            this._tree.setShowsRootHandles(true);
            this._tree.setRootVisible(false);
            this._tree.setCustomInsets(new Insets(0, 0, 0, 0));
            this._treeView = new KDTreeView(this._tree);
            this._treeView.setMinimumSize(new Dimension(0, 0));
            this._treeView.setShowButton(false);
            this._treeView.setShowFind(true);
        }

        public void addDoubleClickAction() {
            this._tree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        TreePath treePath = ActivityTree.this._tree.getSelectionPath();
                        if (treePath == null) {
                            return;
                        }
                        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                        TransitionLowerUI.this.execSnapshot((ActivityEnity)selectedNode.getUserObject());
                    }
                }
            });
        }

        public JComponent getUI() {
            return this._treeView;
        }

        public void refresh(KingdeeTreeModel treeModel) {
            this._tree.setModel((TreeModel)treeModel);
            this._tree.setRootVisible(false);
            if (treeModel != null) {
                this._tree.expandAllNodes(true, (TreeNode)treeModel.getRoot());
                this._tree.setCollapsePathDisabled(true);
            }
            this._tree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
            this._tree.revalidate();
        }
    }
}

