/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.sumrange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.ctrlreport.util.MultiLangUtil;
import com.kingdee.eas.rpts.sumreport.client.SumRangeListUI;
import com.kingdee.eas.rpts.sumreport.client.sumrange.base.BaseEditUI;
import com.kingdee.eas.rpts.sumreport.data.BaseDataInfo;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.debug.client.sumrange.DebugSumRangeListUI;
import com.kingdee.eas.rpts.sumreport.debug.service.DebugSumRangeService;
import com.kingdee.eas.rpts.sumreport.model.DefaultInfo;
import com.kingdee.eas.rpts.sumreport.model.IInfo;
import com.kingdee.eas.rpts.sumreport.model.IInfoHandler;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.model.InfoMessagePanel;
import com.kingdee.eas.rpts.sumreport.service.SumRangeService;
import com.kingdee.eas.rpts.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.EXTUIUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class SumRangeEditUI
extends BaseEditUI
implements IInfoHandler {
    public static final int MODE_NEW_VERSION = 3;
    public static final int MODE_VIEW = 4;
    private SumRangeInfo _info;
    private KDToolBar _toolBar;
    private KDLabelContainer _lcCode;
    private KDLabelContainer _lcName;
    private KDLabel _lDiscribe;
    private ISumRangeService _service;
    private CoreUI _parentUI;
    private KDPanel _board;
    private InfoMessagePanel _tipPanel;

    public SumRangeEditUI() {
        this(null, null, 1);
    }

    public SumRangeEditUI(Frame owner, CoreUI ui, int mode) {
        this(owner, ui, mode, false);
    }

    public SumRangeEditUI(Frame owner, CoreUI ui, int mode, boolean is4Debug) {
        super(owner, mode);
        this._flag = 1 << ++_index - 1;
        this.init();
        this.doUILayout();
        this.initToolbar();
        this._service = !is4Debug ? new SumRangeService() : new DebugSumRangeService();
        this._parentUI = ui;
    }

    private void doUILayout() {
        TableLayout2 ly = new TableLayout2(3, 5);
        ly.setFixedHeight(new int[]{0, 1}, 21);
        ly.setRatableHeight(2, 120);
        ly.setColsSpacing(new int[]{0, 2}, 0);
        ly.setRowsSpacing(new int[]{0, 1}, 3);
        ly.setColSpacing(1, 0);
        ly.setFixedWidth(new int[]{0, 3}, 60);
        ly.setRatableWidth(2, 10);
        ly.setFixedWidth(new int[]{1, 4}, 160);
        this._board = new KDPanel((LayoutManager)ly);
        this._board.setCustomInsets(new Insets(10, 10, 10, 10));
        this._board.add((Component)this._lcCode, (Object)TableLayout2.param((int)0, (int)0));
        this._board.add((Component)this._tfCode, (Object)TableLayout2.param((int)0, (int)1));
        this._board.add((Component)this._lcName, (Object)TableLayout2.param((int)0, (int)3));
        this._board.add((Component)this._mlbName, (Object)TableLayout2.param((int)0, (int)4));
        this._board.add((Component)this._lDiscribe, (Object)TableLayout2.param((int)1, (int)0));
        this._board.add((Component)this._mlaDiscribe, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)4));
        this.getContentPane().setLayout((LayoutManager)new SpreadBorderLayout());
        this.getContentPane().add((Component)this._board, "Center");
    }

    public KDPanel getBoard() {
        return this._board;
    }

    private void init() {
        BaseEditUI.ActionDispatch action = new BaseEditUI.ActionDispatch(this);
        this._btnNew = new KDWorkButton();
        this._btnNew.setText("\u65b0\u5efa");
        this._btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this._btnNew.addActionListener((ActionListener)action);
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText("\u4fee\u6539");
        this._btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this._btnEdit.addActionListener((ActionListener)action);
        this._btnSave = new KDWorkButton();
        this._btnSave.setText("\u4fdd\u5b58");
        this._btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this._btnSave.addActionListener((ActionListener)action);
        this._btnClose = new KDWorkButton();
        this._btnClose.setText("\u9000\u51fa");
        this._btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this._btnClose.addActionListener((ActionListener)action);
        this._lcCode = new KDLabelContainer();
        this._lcCode.setBoundLabelText("\u7f16\u7801\uff1a");
        this._lcCode.setBoundLabelUnderline(true);
        this._lcCode.setPreferredSize(new Dimension(60, 21));
        this._tfCode = new KDTextField();
        this._tfCode.setPreferredSize(new Dimension(160, 21));
        this._lcName = new KDLabelContainer();
        this._lcName.setBoundLabelText("\u540d\u79f0\uff1a");
        this._lcName.setBoundLabelUnderline(true);
        this._lcName.setPreferredSize(new Dimension(60, 21));
        this._mlbName = new KDBizMultiLangBox();
        this._mlbName.setPreferredSize(new Dimension(160, 21));
        this._lDiscribe = new KDLabel();
        this._lDiscribe.setText("\u5907\u6ce8\uff1a");
        this._lDiscribe.setPreferredSize(new Dimension(60, 21));
        this._mlaDiscribe = new KDBizMultiLangArea();
        this._mlaDiscribe.setPreferredSize(new Dimension(160, 120));
        EXTUIUtil.setDefalultLang(this._mlaDiscribe);
        EXTUIUtil.setDefalultLang(this._mlbName);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (SumRangeEditUI.this._tipPanel != null) {
                    SumRangeEditUI.this._tipPanel.setPreferredSize(new Dimension(0, 0));
                }
            }
        });
    }

    private void initToolbar() {
        this._toolBar = new KDToolBar(0);
        this._toolBar.add((Component)this._btnNew);
        this._toolBar.add((Component)this._btnEdit);
        this._toolBar.add((Component)this._btnSave);
        this._toolBar.addSeparator();
        this._toolBar.add((Component)this._btnClose);
        this.addToolBar((JToolBar)this._toolBar);
    }

    protected SumRangeEditUI storeValues() {
        if (this._mode == 1) {
            this._info = new SumRangeInfo();
        }
        this._info.setNumber(this._tfCode.getText().trim());
        super.storeBaseValues();
        return this;
    }

    protected void varifyUnempty() throws InfoException {
        if (StringUtil.isEmptyString((String)this._tfCode.getText()) || StringUtil.isEmptyString((String)this._tfCode.getText().trim())) {
            this._tfCode.setText(null);
            throw new InfoException("\u8bf7\u586b\u5199\u6c47\u603b\u8303\u56f4\u7f16\u7801\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", 2);
        }
        if (StringUtil.isEmptyString((String)((String)this._mlbName.getSelectedItemData())) || StringUtil.isEmptyString((String)((String)this._mlbName.getSelectedItemData()).trim())) {
            this._mlbName.setSelectedItemData(null);
            throw new InfoException("\u8bf7\u586b\u5199\u6c47\u603b\u8303\u56f4\u540d\u79f0\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", 3);
        }
    }

    protected void actionSave() {
        if (this._mode == 1) {
            this.actionNew();
        } else if (this._mode == 2) {
            this.updateInfo();
        } else if (this._mode == 3) {
            this.newVersion();
        }
        if (this._mode != 3) {
            this._btnEdit.setEnabled(true);
        }
    }

    protected void actionNew() {
        try {
            this.varifyUnempty();
            this._info.setId(UID.create((int)44));
            this._info.setCreator(EASUtil.getCurrentUserID());
            this._info.setCreateTime(new Timestamp(new Date().getTime()));
            this._service.newSumRange(this._info);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SumRangeEditUI.this._parentUI instanceof SumRangeListUI) {
                        ((SumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    } else {
                        ((DebugSumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    }
                }
            });
            this.handleInfoTips(new DefaultInfo("\u4fdd\u5b58\u6210\u529f\uff01"));
            this.setFlag(TXT_NAME | TXT_CODE | TXT_DEC | BTN_EDIT | 1);
        }
        catch (InfoException e) {
            this.handleInfoTips(e);
        }
        catch (BOSException e) {
            this._parentUI.handUIException((Throwable)e);
        }
    }

    public void requestFocus(int mode) {
        if (mode == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SumRangeEditUI.this._tfCode.requestFocus();
                }
            });
        } else if (mode == 3) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SumRangeEditUI.this._mlbName.requestFocus();
                }
            });
        }
    }

    @Override
    public void handleInfoTips(IInfo e) {
        if (this._tipPanel == null) {
            this._tipPanel = new InfoMessagePanel(e.getInfo(), this.getContentPane(), this._board);
        }
        this._tipPanel.setTipString(e.getInfo());
        this.getContentPane().add((Component)((Object)this._tipPanel), "center_north");
        this._tipPanel.showTip();
        this.requestFocus(e.getMode());
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
    }

    protected void actionEdit() {
        this.setTitle("\u4fee\u6539\u6c47\u603b\u8303\u56f4");
        if (this._tipPanel != null) {
            this._tipPanel.hideTip();
        }
        this.setFlag(BTN_EDIT | BTN_SAVE);
        this._mode = 2;
        this._tfCode.requestFocus();
    }

    protected void newVersion() {
        try {
            this.varifyUnempty();
            this._info.setCreator(EASUtil.getCurrentUserID());
            this._info.setCreateTime(new Timestamp(new Date().getTime()));
            this._service.newVersion(this._info, this._info.getId());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SumRangeEditUI.this._parentUI instanceof SumRangeListUI) {
                        ((SumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    } else {
                        ((DebugSumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    }
                }
            });
            ExtMsgBox.showInfo((Component)((Object)this), "\u5efa\u7acb\u65b0\u7248\u672c\u6210\u529f\uff01");
            this.dispose();
        }
        catch (InfoException e) {
            this.handleInfoTips(e);
        }
        catch (BOSException e) {
            this._parentUI.handUIException((Throwable)e);
        }
    }

    protected void updateInfo() {
        this._info.setUpdateUserId(EASUtil.getCurrentUserID());
        try {
            this.varifyUnempty();
            this._service.updateSumRange(this._info);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SumRangeEditUI.this._parentUI instanceof SumRangeListUI) {
                        ((SumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    } else {
                        ((DebugSumRangeListUI)SumRangeEditUI.this._parentUI).actionRefresh();
                    }
                }
            });
            this.setFlag(TXT_NAME | TXT_CODE | TXT_DEC | BTN_EDIT | 1);
            this.handleInfoTips(new DefaultInfo("\u4fdd\u5b58\u6210\u529f\uff01"));
        }
        catch (InfoException e) {
            this.handleInfoTips(e);
        }
        catch (BOSException e) {
            this._parentUI.handUIException((Throwable)e);
        }
    }

    public SumRangeEditUI setValues(SumRangeInfo info) {
        this._tfCode.setText(info.getNumber());
        MultiLangUtil.setMlbValue(this._mlbName, info.getName());
        MultiLangUtil.setMlbValue(this._mlaDiscribe, info.getDes());
        this._info = info;
        return this;
    }

    public SumRangeEditUI clearUI() {
        this.newAction();
        return this;
    }

    protected void newAction() {
        if (this._tipPanel != null) {
            this._tipPanel.hideTip();
        }
        this._tfCode.setText(null);
        this._tfCode.requestFocus();
        MultiLangUtil.clearMlbValue(this._mlbName);
        MultiLangUtil.clearMlbValue(this._mlaDiscribe);
        this.setFlag(1 | BTN_SAVE);
        this._mode = 1;
        this._info = null;
    }

    protected void closeAction() {
        this.dispose();
    }

    @Override
    public void setFlag(int flag) {
        super.setFlag(flag);
    }

    @Override
    public BaseDataInfo getValue() {
        return this._info;
    }

    @Override
    public void dispatchAction(ActionEvent e) {
        Object srcO = e.getSource();
        this.hideDynamicTips();
        if (srcO == this._btnSave) {
            this.storeValues().actionSave();
        } else if (srcO == this._btnEdit) {
            this.actionEdit();
        } else if (srcO == this._btnClose) {
            this.closeAction();
        } else if (srcO == this._btnNew) {
            this.setTitle("\u589e\u52a0\u6c47\u603b\u8303\u56f4");
            this.newAction();
        }
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    private void hideDynamicTips() {
        if (this._tipPanel != null) {
            Container container = this.getContentPane();
            this._tipPanel.setPreferredSize(new Dimension(0, 0));
            container.remove((Component)((Object)this._tipPanel));
            Dimension d = this._board.getPreferredSize();
            this._board.setPreferredSize(new Dimension(d.width, d.height + 20));
            this._board.doLayout();
            container.invalidate();
            container.repaint();
        }
    }
}

