/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.textfield.SearchTextField;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.rpts.base.ColorConst;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.IntList;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.KMP;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.rpts.sumreport.model.StatusEngine;
import com.kingdee.eas.rpts.sumreport.service.TaskService;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TaskDetailTable {
    private KDTable _table;
    public static final int COL_DISTRIBUTE_OBJ = 0;
    public static final int COL_DISTRIBUTE_NAME = 3;
    public static final int COL_DISTRIBUTE_TIME = 4;
    public static final int COL_STATUS = 1;
    public static final int COL_NEW_STATUS = 2;
    public static final int COL_ID = 0;
    private TaskService _taskSrsv;
    private KDContainer _container;
    private SearchTextField _tfSearch;
    private KDPanel _board;
    private KDComboBox _cmbState;
    public static final int SCENE_VIEW_TASK_DETAIL = 0;
    public static final int SCENE_STATUS_MANAGE = 1;
    private int _scene = 0;
    private static final String _niceNote = "\u8bf7\u8f93\u5165\u5206\u914d\u5bf9\u8c61\u540d\u79f0...";
    private IntList _displayRows;
    private String _lastQuery;

    public TaskDetailTable(int scene) {
        this._scene = scene;
        this.initUI();
        this.doUILayout();
    }

    private void initUI() {
        this._table = new KDTable();
        this._table.addColumns(5);
        this._table.getColumn(0).setWidth(192);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(4).setWidth(128);
        this._table.getColumn(1).setWidth(64);
        this._table.getColumn(2).setWidth(108);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u5206\u914d\u5bf9\u8c61\u540d\u79f0");
        header.getCell(3).setValue((Object)"\u5206\u914d\u4eba");
        header.getCell(4).setValue((Object)"\u5206\u914d\u65f6\u95f4");
        header.getCell(1).setValue((Object)"\u72b6\u6001");
        header.getCell(2).setValue((Object)"\u65b0\u72b6\u6001");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getColumn(4).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getSelectManager().setSelectMode(2);
        this._table.setPreferredSize(new Dimension(351, 336));
        this._container = new KDContainer();
        this._container.setTitle("\u5206\u914d\u5bf9\u8c61");
        this._board = new KDPanel(){

            public Insets getInsets() {
                return new Insets(10, 10, 0, 10);
            }
        };
        this._container.setContentPane((Container)this._board);
        this._tfSearch = new SearchTextField(_niceNote){

            public void clearAction(SearchTextField srcComp) {
                srcComp.setText(null);
            }

            public void searchAction(SearchTextField srcComp) {
                TaskDetailTable.this.filter(srcComp.getText());
            }
        };
        this._tfSearch.setPreferredSize(new Dimension(242, 21));
        this._taskSrsv = new TaskService();
        this._container.setEnableActive(false);
        this._container.getContentPane().setPreferredSize(new Dimension(600, 540));
        this.installCommon();
        this.installPersonality();
    }

    public JComponent getUI() {
        if (this._scene == 0) {
            return this._container;
        }
        return this._board;
    }

    private void doUILayout() {
        TableLayout2 ly = new TableLayout2(2, 2);
        ly.setRowsSpacing(TableLayout2.ALL, 8);
        ly.setColsSpacing(TableLayout2.ALL, 0);
        ly.setFixedWidth(0, 242);
        ly.setFixedHeight(0, 21);
        ly.setRatableWidth(1, 10);
        ly.setRatableHeight(1, 336);
        this._board.setLayout((LayoutManager)ly);
        this._board.add((Component)this._tfSearch, (Object)TableLayout2.param((int)0, (int)0));
        this._board.add((Component)this._table, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
    }

    private void installCommon() {
    }

    private void installPersonality() {
        if (this._scene == 1) {
            this._table.getSelectManager().setSelectMode(2);
            this._table.setEditable(true);
            this._table.getStyleAttributes().setLocked(false);
            if (this._cmbState == null) {
                this._cmbState = new KDComboBox();
            }
            this._table.getColumn(2).getStyleAttributes().setHided(false);
            this._cmbState.putClientProperty((Object)"jump", (Object)"false");
            KDTDefaultCellEditor ceTaskState = new KDTDefaultCellEditor((JComboBox)this._cmbState);
            this._table.getColumn(2).setEditor((ICellEditor)ceTaskState);
            this._table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    if (e.getColIndex() == 2) {
                        String status = (String)TaskDetailTable.this._table.getCell(e.getRowIndex(), 1).getValue();
                        TaskDetailTable.this._cmbState.removeAllItems();
                        TaskDetailTable.this._cmbState.addItems((Object[])StatusEngine.getPartOfTaskAStatus(status));
                    } else {
                        e.setCancel(true);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    String value = (String)e.getValue();
                    if (!StringUtil.isEmptyString((String)value)) {
                        TaskDetailTable.this._table.getCell(e.getRowIndex(), e.getColIndex()).getStyleAttributes().setBackground(new Color(255, 137, 141));
                    } else {
                        TaskDetailTable.this._table.getCell(e.getRowIndex(), e.getColIndex()).getStyleAttributes().setBackground(Color.WHITE);
                    }
                }
            });
            this._table.getColumn(0).getStyleAttributes().setBackground(ColorConst.UN_EDITABLE_COLOR);
            this._table.getColumn(3).getStyleAttributes().setBackground(ColorConst.UN_EDITABLE_COLOR);
            this._table.getColumn(1).getStyleAttributes().setBackground(ColorConst.UN_EDITABLE_COLOR);
            this._table.getColumn(4).getStyleAttributes().setBackground(ColorConst.UN_EDITABLE_COLOR);
        } else if (this._scene == 0) {
            this._table.getColumn(2).getStyleAttributes().setHided(true);
        }
    }

    public void LoadData(TaskDistributeInfo info) {
        try {
            final TaskDetailInfo rootDetail = this._taskSrsv.queryTaskDetail(info);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (rootDetail == null) {
                        return;
                    }
                    TaskDetailTable.this._table.getTreeColumn().setDepth(rootDetail.getTreeDepth() + 1);
                    TaskDetailTable.this._table.getTreeColumn().setOrientation(0);
                    TaskDetailTable.this.fillTable(rootDetail);
                }
            });
        }
        catch (BOSException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtMsgBox.showError(TaskDetailTable.this.getUI().getParent(), "\u52a0\u8f7d\u4efb\u52a1\u660e\u7ec6\u5217\u8868\u5931\u8d25\uff01", e.getCause().toString());
                }
            });
        }
    }

    private void fillTable(TaskDetailInfo info) {
        IRow row = this._table.addRow();
        row.getCell(0).setValue((Object)info.getName());
        row.getCell(0).setUserObject((Object)info.getId());
        row.getCell(1).setValue((Object)StatusEngine.getTaskAStatus(info.getState()));
        row.getCell(3).setValue((Object)info.getDistributeName());
        row.getCell(4).setValue((Object)info.getDistributeTime());
        row.setTreeLevel(info.getLevel());
        row.setUserObject((Object)info.getName());
        List childLst = info.getChilds();
        if (null != childLst && childLst.size() > 0) {
            int size = childLst.size();
            for (int i = 0; i < size; ++i) {
                TaskDetailInfo child = (TaskDetailInfo)childLst.get(i);
                this.fillTable(child);
            }
        }
    }

    private void filter(String text) {
        if (StringUtil.isEmptyString((String)text) || _niceNote.equals(text)) {
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this._table.getRow(i).getStyleAttributes().setHided(false);
            }
            this._lastQuery = null;
            this._displayRows = null;
        } else if (null != this._displayRows && KMP.kmp(text, this._lastQuery)) {
            IntList displayRows = new IntList(8);
            int size = this._displayRows.size();
            for (int i = size - 1; i > -1; --i) {
                String name = (String)this._table.getRow(this._displayRows.get(i)).getUserObject();
                boolean visible = KMP.kmp(name, text);
                if (!visible) {
                    String status;
                    if (this._scene == 1 && !StringUtil.isEmptyString((String)(status = (String)this._table.getCell(this._displayRows.get(i), 2).getValue()))) {
                        visible = true;
                    }
                    this._table.getRow(this._displayRows.get(i)).getStyleAttributes().setHided(!visible);
                }
                if (!visible) continue;
                displayRows.add(this._displayRows.get(i));
            }
            this._lastQuery = text;
            this._displayRows = null;
            this._displayRows = displayRows;
        } else {
            this._displayRows = new IntList(8);
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String status;
                String name = (String)this._table.getRow(i).getUserObject();
                boolean visible = KMP.kmp(name, text);
                if (visible) {
                    this._displayRows.add(i);
                }
                if (!visible && this._scene == 1 && !StringUtil.isEmptyString((String)(status = (String)this._table.getCell(i, 2).getValue()))) {
                    this._displayRows.add(i);
                    visible = true;
                }
                this._table.getRow(i).getStyleAttributes().setHided(!visible);
            }
            this._lastQuery = text;
        }
    }

    public ObjectArray getUpdateActivity() {
        int rowCount = this._table.getRowCount();
        ObjectArray updatees = null;
        for (int i = 0; i < rowCount; ++i) {
            String status = (String)this._table.getCell(i, 2).getValue();
            if (StringUtil.isEmptyString((String)status)) continue;
            if (updatees == null) {
                updatees = new ObjectArray(5);
            }
            String id = (String)this._table.getCell(i, 0).getUserObject();
            updatees.append((Object)id);
            updatees.append((Object)StatusEngine.getTaskAStatus(status));
        }
        return updatees;
    }

    public void focusMe() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskDetailTable.this._table.requestFocus();
                TaskDetailTable.this._table.reLayoutAndPaint();
            }
        });
    }
}

