/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.rpts.sumreport.client.TaskDistributeListUI;
import com.kingdee.eas.rpts.sumreport.client.task.TaskDistributeUI;
import com.kingdee.eas.rpts.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.rpts.sumreport.debug.client.task.DebugTaskDistributeListUI;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.service.DiffTaskStrategyFactory;
import com.kingdee.eas.rpts.sumreport.service.TaskService;
import com.kingdee.eas.rpts.sumreport.service.inf.ITaskService;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;

class TaskUpdator {
    private TaskDistributeUI _taskUI;

    private TaskUpdator(TaskDistributeUI taskUI) {
        this._taskUI = taskUI;
    }

    public static TaskUpdator getInst(TaskDistributeUI taskUI) {
        return new TaskUpdator(taskUI);
    }

    public void update() throws InfoException {
        Object obj;
        if (this._taskUI._4debug && (obj = this._taskUI._view.getTree().getUserObject()) != null) {
            this.updateDebugTask();
            return;
        }
        this.updateTask();
    }

    private void updateTask() throws InfoException {
        TaskDistributeInfo newInfo = new TaskDistributeInfo();
        newInfo.setQueryMap(new HashMap(8));
        this._taskUI.storeValues(newInfo);
        try {
            this._taskUI._taskSusrv.verifySame(newInfo, this._taskUI._info.getId());
            TaskService.addUpInfos(newInfo, true);
            HashSet updateSet = new HashSet();
            LinkedList insLst = new LinkedList();
            LinkedList delLst = new LinkedList();
            TreeModel treeModel = this._taskUI._view.getTree().getModel();
            if (treeModel != null) {
                DiffTaskStrategyFactory.getInst(this._taskUI._4debug).diff(this._taskUI._info, newInfo, this._taskUI._set, (DefaultKingdeeTreeNode)treeModel.getRoot(), updateSet, insLst, delLst, new HashSet());
            }
            HashMap<String, Serializable> infoMap = new HashMap<String, Serializable>(4);
            infoMap.put(ITaskService.TASK_STATE, new Boolean(this._taskUI._taskRunning));
            infoMap.put(ITaskService.UPDATE_ACTIVITY_LIST, updateSet);
            infoMap.put(ITaskService.DEL_ACTIVITY_LIST, delLst);
            infoMap.put(ITaskService.INSERT_ACTIVITY_LIST, insLst);
            this._taskUI._taskSusrv.updateTask(this._taskUI._info, newInfo, infoMap);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((TaskUpdator)TaskUpdator.this)._taskUI._owner instanceof TaskDistributeListUI) {
                        ((TaskDistributeListUI)((TaskUpdator)TaskUpdator.this)._taskUI._owner).refresh();
                    } else {
                        ((DebugTaskDistributeListUI)((TaskUpdator)TaskUpdator.this)._taskUI._owner).refresh();
                    }
                }
            });
            ExtMsgBox.showInfo("\u4fee\u6539\u4efb\u52a1\u6210\u529f\uff01");
            this._taskUI.actionClose();
        }
        catch (BOSException e) {
            ExtMsgBox.showError((Component)((Object)this._taskUI), "\u4fee\u6539\u4efb\u52a1\u5931\u8d25", e.getMessage() + e.toString());
        }
    }

    private void updateDebugTask() throws InfoException {
        TaskDistributeInfo newInfo = new TaskDistributeInfo();
        this._taskUI.storeValues(newInfo);
        try {
            this._taskUI._taskSusrv.updateTask(this._taskUI._info, newInfo, null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((TaskUpdator)TaskUpdator.this)._taskUI._owner instanceof TaskDistributeListUI) {
                        ((TaskDistributeListUI)((TaskUpdator)TaskUpdator.this)._taskUI._owner).refresh();
                    } else {
                        ((DebugTaskDistributeListUI)((TaskUpdator)TaskUpdator.this)._taskUI._owner).refresh();
                    }
                }
            });
            ExtMsgBox.showInfo("\u4fee\u6539\u4efb\u52a1\u6210\u529f\uff01");
            this._taskUI.actionClose();
        }
        catch (BOSException e) {
            ExtMsgBox.showError((Component)((Object)this._taskUI), "\u4fee\u6539\u4efb\u52a1\u5931\u8d25", e.getMessage());
        }
    }
}

