/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task.f7;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.textfield.SearchTextField;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.IntList;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.KMP;
import com.kingdee.eas.rpts.sumreport.data.F7VO;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExtReportF7
implements KDPromptSelector {
    private Logger _logger = CommonLogger.getLogger(ExtReportF7.class);
    private KDDialog _win;
    private boolean _isCancel;
    private KDTable _table;
    private KDWorkButton _btnOk;
    private KDWorkButton _btnCancel;
    private SearchTextField _tfSearch;
    private static final String _niceNote = "\u8f93\u5165\u6a21\u677f\u540d\u79f0\u641c\u7d22...";
    private IntList _displayRows;
    private String _lastQuery;
    private boolean _isForward;
    private KDPromptBox _host;

    public ExtReportF7(KDDialog _owner, boolean isForward, KDPromptBox host) {
        this._win = new KDDialog((Dialog)_owner);
        this._isForward = isForward;
        this._host = host;
        this.init();
        this.initLayout();
    }

    private void init() {
        if (this._isForward) {
            this._win.setTitle("\u9009\u62e9\u4e0a\u62a5\u6a21\u677f");
        } else {
            this._win.setTitle("\u9009\u62e9\u6c47\u603b\u6a21\u677f");
        }
        this._win.setModal(true);
        this._table = new KDTable();
        this._table.addColumns(1);
        this._table.getColumn(0).setWidth(295);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u540d\u79f0");
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._btnOk = new KDWorkButton("\u786e\u5b9a");
        this._btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtReportF7.this._isCancel = false;
                ExtReportF7.this._win.setVisible(false);
                ExtReportF7.this._host.setData(ExtReportF7.this.getData());
            }
        });
        this._btnCancel = new KDWorkButton("\u53d6\u6d88");
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtReportF7.this._isCancel = true;
                ExtReportF7.this._win.setVisible(false);
                ExtReportF7.this._host.setData(ExtReportF7.this.getData());
            }
        });
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExtReportF7.this._isCancel = true;
                    ExtReportF7.this._win.setVisible(false);
                    ExtReportF7.this._host.setData(ExtReportF7.this.getData());
                }
            }
        });
        this._tfSearch = new SearchTextField(_niceNote){

            public void clearAction(SearchTextField srcComp) {
                srcComp.setText(null);
            }

            public void searchAction(SearchTextField srcComp) {
                ExtReportF7.this.filter(srcComp.getText());
            }
        };
    }

    private void initLayout() {
        KDPanel contentPane = new KDPanel();
        contentPane.setPreferredSize(new Dimension(361, 479));
        this._win.setContentPane((Container)contentPane);
        KDPanel board = new KDPanel(new BorderLayout(0, 5)){

            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this._tfSearch.setSize(new Dimension(200, 20));
        board.add((Component)this._tfSearch, (Object)"North");
        board.add((Component)this._table, (Object)"Center");
        this._win.getContentPane().setLayout(new BorderLayout());
        this._win.getContentPane().add((Component)board, "Center");
        TableLayout2 ly = new TableLayout2(3, 5);
        ly.setRatableWidth(0, 100);
        ly.setFixedWidth(1, 74);
        ly.setFixedWidth(2, 3);
        ly.setFixedWidth(3, 74);
        ly.setFixedWidth(4, 10);
        ly.setFixedHeight(0, 10);
        ly.setFixedHeight(1, 21);
        ly.setFixedHeight(2, 10);
        KDPanel bottom = new KDPanel((LayoutManager)ly);
        KDSeparator separator = new KDSeparator();
        bottom.add((Component)separator, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)4));
        bottom.add((Component)this._btnOk, (Object)TableLayout2.param((int)1, (int)1));
        bottom.add((Component)this._btnCancel, (Object)TableLayout2.param((int)1, (int)3));
        this._win.getContentPane().add((Component)bottom, "South");
        this._win.setLocationRelativeTo(null);
    }

    public Object getData() {
        if (this._table.getRowCount() == 0) {
            return new F7VO();
        }
        KDTSelectBlock block = this._table.getSelectManager().get(0);
        int row = null == block ? 0 : block.getBeginRow();
        F7VO vo = (F7VO)this._table.getRow(row).getUserObject();
        return vo;
    }

    public boolean isCanceled() {
        return this._isCancel;
    }

    public void show() {
        this._win.pack();
        this._win.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtReportF7.this._table.requestFocus();
                ExtReportF7.this.refresh();
            }
        });
        this._win.setVisible(true);
    }

    private void filter(String text) {
        if (StringUtil.isEmptyString((String)text) || _niceNote.equals(text)) {
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this._table.getRow(i).getStyleAttributes().setHided(false);
            }
            this._lastQuery = null;
            this._displayRows = null;
        } else if (null != this._displayRows && KMP.kmp(text, this._lastQuery)) {
            IntList displayRows = new IntList(8);
            int size = this._displayRows.size();
            for (int i = size - 1; i > -1; --i) {
                String name = ((F7VO)this._table.getRow(this._displayRows.get(i)).getUserObject()).getName();
                boolean visible = KMP.kmp(name, text);
                if (!visible) {
                    this._table.getRow(this._displayRows.get(i)).getStyleAttributes().setHided(!visible);
                    continue;
                }
                displayRows.add(this._displayRows.get(i));
            }
            this._lastQuery = text;
            this._displayRows = null;
            this._displayRows = displayRows;
        } else {
            this._displayRows = new IntList(8);
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String name = ((F7VO)this._table.getRow(i).getUserObject()).getName();
                boolean visible = KMP.kmp(name, text);
                if (visible) {
                    this._displayRows.add(i);
                }
                this._table.getRow(i).getStyleAttributes().setHided(!visible);
            }
            this._lastQuery = text;
        }
    }

    private void refresh() {
        int type = this._isForward ? 0 : 1;
        try {
            ArrayList rsL = DefineReportBO.getReportList(type);
            this._table.removeRows();
            int size = rsL.size();
            for (int i = 0; i < size; ++i) {
                HashMap iMap = (HashMap)rsL.get(i);
                F7VO vo = new F7VO();
                vo.setId(MixUtil.toString(iMap.get("id")));
                vo.setName(MixUtil.toString(iMap.get("name")));
                IRow row = this._table.addRow();
                row.getCell(0).setValue((Object)vo.getName());
                row.setUserObject((Object)vo);
            }
        }
        catch (Exception e) {
            this._logger.info((Object)"\u83b7\u5f97\u6c47\u603b\u4e0a\u62a5\u6a21\u677f\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }
}

