/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.AbstractTableDataLoad;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.SelectDataList;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.model.CommonReportInfo;
import com.kingdee.eas.rpts.sumreport.service.SumTaskUploadService;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractTaskNameLoad
extends AbstractTableDataLoad {
    private Logger _logger = CommonLogger.getLogger(AbstractTaskNameLoad.class);
    protected static final int TASKID = 0;
    protected static final int TASK_NUMBER = 1;
    protected static final int TASK_NAME = 2;
    protected SumTaskUploadService sumTaskUploadService;

    @Override
    public void initTable() {
        if (this._table == null) {
            return;
        }
        this._dispColumnNames = new String[]{"\u4efb\u52a1\u7f16\u7801", "\u4efb\u52a1\u540d\u79f0"};
        this._allColumnNames = new String[]{"taskID", "\u4efb\u52a1\u7f16\u7801", "\u4efb\u52a1\u540d\u79f0"};
        int[] columnWidth = new int[]{128, 128, 130};
        ControlDataLoadUtil.initTableHeader(this._table, 3, columnWidth, this._allColumnNames);
        this._table.getColumn(0).getStyleAttributes().setHided(true);
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(10);
    }

    protected abstract List getReportData();

    @Override
    public void tableDataLoad() {
        List dataList = this.getReportData();
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        this._table.removeRows();
        HashMap uniqMap = new HashMap();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)dataList.get(i);
            String reportId = (String)rowData.get("taskid");
            if (uniqMap.containsKey(reportId)) continue;
            uniqMap.put(reportId, null);
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)reportId);
            row.getCell(1).setValue(rowData.get("tasknumber"));
            row.getCell(2).setValue(rowData.get("taskname"));
        }
    }

    @Override
    public List getSelectedData() {
        SelectDataList selectDataList = new SelectDataList();
        int size = this._table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this._table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                IRow row = this._table.getRow(j);
                CommonReportInfo info = new CommonReportInfo();
                info.reportId = (String)row.getCell(0).getValue();
                info.reportName = (String)row.getCell(1).getValue();
                info.uploadPeriodName = (String)row.getCell(2).getValue();
                selectDataList.add(info);
            }
        }
        return selectDataList;
    }
}

