/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.AbstractTableDataLoad;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.SelectDataList;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.model.CommonReportInfo;
import com.kingdee.eas.rpts.sumreport.service.SumTaskUploadService;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class UploadBaseReportDataLoad
extends AbstractTableDataLoad {
    private Logger _logger = CommonLogger.getLogger(UploadBaseReportDataLoad.class);
    private static final int REPORTID = 0;
    private static final int REPORT_NAME = 1;
    private static final int UPLOADED_PERIOD_NAME = 2;
    private static final int UPLOADED_PERIOD_VALUE = 3;
    protected SumTaskUploadService sumTaskUploadService;

    @Override
    public void initTable() {
        if (this._table == null) {
            return;
        }
        this._dispColumnNames = new String[]{"\u62a5\u8868\u540d\u79f0", "\u4e0a\u62a5\u5468\u671f"};
        this._allColumnNames = new String[]{"reportID", "\u62a5\u8868\u540d\u79f0", "\u4e0a\u62a5\u5468\u671f", "uploadPeriodValue"};
        int[] columnWidth = new int[]{128, 128, 128, 128};
        ControlDataLoadUtil.initTableHeader(this._table, 4, columnWidth, this._allColumnNames);
        this._table.getColumn(0).getStyleAttributes().setHided(true);
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getColumn(3).getStyleAttributes().setHided(true);
        this._table.getSelectManager().setSelectMode(10);
    }

    protected void setReportPeriod(IRow row, Number reportPeriod) {
        switch (reportPeriod.intValue()) {
            case -1: {
                row.getCell(2).setValue((Object)"\u672a\u8bbe\u7f6e");
                break;
            }
            case 0: {
                row.getCell(2).setValue((Object)"\u672a\u8bbe\u7f6e");
                break;
            }
            case 1: {
                row.getCell(2).setValue((Object)"\u5e74\u62a5");
                break;
            }
            case 2: {
                row.getCell(2).setValue((Object)"\u534a\u5e74\u62a5");
                break;
            }
            case 3: {
                row.getCell(2).setValue((Object)"\u5b63\u62a5");
                break;
            }
            case 4: {
                row.getCell(2).setValue((Object)"\u6708\u62a5");
                break;
            }
            case 5: {
                row.getCell(2).setValue((Object)"\u534a\u6708\u62a5");
                break;
            }
            case 7: {
                row.getCell(2).setValue((Object)"\u5468\u62a5");
                break;
            }
            case 6: {
                row.getCell(2).setValue((Object)"\u65e5\u62a5");
            }
        }
    }

    protected abstract List getReportData();

    @Override
    public void tableDataLoad() {
        List dataList = this.getReportData();
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        this._table.removeRows();
        HashMap uniqMap = new HashMap();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)dataList.get(i);
            String reportId = (String)rowData.get("freportid");
            if (uniqMap.containsKey(reportId)) continue;
            uniqMap.put(reportId, null);
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)reportId);
            row.getCell(1).setValue(rowData.get("reportname"));
            Number reportPeriod = (Number)rowData.get("freportperiod");
            row.getCell(3).setValue((Object)reportPeriod);
            if (reportPeriod != null) {
                this.setReportPeriod(row, reportPeriod);
                continue;
            }
            row.getCell(2).setValue((Object)"\u672a\u8bbe\u7f6e");
        }
    }

    @Override
    public List getSelectedData() {
        SelectDataList selectDataList = new SelectDataList();
        int size = this._table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this._table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                IRow row = this._table.getRow(j);
                CommonReportInfo info = new CommonReportInfo();
                info.reportId = (String)row.getCell(0).getValue();
                info.reportName = (String)row.getCell(1).getValue();
                info.uploadPeriodName = (String)row.getCell(2).getValue();
                info.uploadPeriodValue = (Number)row.getCell(3).getValue();
                selectDataList.add(info);
            }
        }
        return selectDataList;
    }
}

