/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.AbstractTableDataLoad;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.SelectDataList;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitInfo;
import com.kingdee.eas.rpts.sumreport.service.SumTaskUploadService;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UploadManageUploadCompaDataLoad
extends AbstractTableDataLoad {
    Logger _logger = CommonLogger.getLogger(UploadManageUploadCompaDataLoad.class);
    private static final int SUMUNITID = 0;
    private static final int SUMUNIT_NUMBER = 1;
    private static final int SUMUNIT_NAME = 2;
    private static final int IS_SUMUNIT_DISPLAY = 3;
    private static final int IS_SUMUNIT = 4;
    private List sumRangeInfoList;

    @Override
    public List getSelectedData() {
        SelectDataList selectDataList = new SelectDataList();
        int size = this._table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this._table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                IRow row = this._table.getRow(j);
                SumUnitInfo info = new SumUnitInfo();
                info.setId((String)row.getCell(0).getValue());
                info.setNumber((String)row.getCell(1).getValue());
                info.setName((String)row.getCell(2).getValue());
                Boolean isSumUnit = (Boolean)row.getCell(4).getValue();
                if (isSumUnit.booleanValue()) {
                    info.setSumUnit(true);
                } else {
                    info.setSumUnit(false);
                }
                selectDataList.add(info);
            }
        }
        return selectDataList;
    }

    @Override
    public void initTable() {
        if (this._table == null) {
            return;
        }
        this._dispColumnNames = new String[]{"\u6c47\u603b\u5355\u5143\u7f16\u7801", "\u6c47\u603b\u5355\u5143\u540d\u79f0", "\u662f\u5426\u662f\u6c47\u603b\u5355\u5143"};
        this._allColumnNames = new String[]{"sumUnitId", "\u6c47\u603b\u5355\u5143\u7f16\u7801", "\u6c47\u603b\u5355\u5143\u540d\u79f0", "\u662f\u5426\u662f\u6c47\u603b\u5355\u5143", "isSumUnit"};
        int[] columnWidth = new int[]{128, 128, 128, 128, 128};
        ControlDataLoadUtil.initTableHeader(this._table, 5, columnWidth, this._allColumnNames);
        this._table.getColumn(0).getStyleAttributes().setHided(true);
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getColumn(4).getStyleAttributes().setHided(true);
        this._table.getSelectManager().setSelectMode(2);
    }

    @Override
    public void tableDataLoad() {
        List dataList = this.getData();
        this._table.removeRows();
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        HashMap uniqMap = new HashMap();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)dataList.get(i);
            String unitId = (String)rowData.get("unitid");
            if (unitId == null || uniqMap.containsKey(unitId)) continue;
            uniqMap.put(unitId, null);
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)unitId);
            String unitNumber = null;
            if (rowData.get("unitnumber") != null) {
                unitNumber = (String)rowData.get("unitnumber");
                row.getCell(3).setValue((Object)"\u662f");
                row.getCell(4).setValue((Object)Boolean.TRUE);
            } else {
                unitNumber = (String)rowData.get("orgnumber");
                row.getCell(3).setValue((Object)"\u5426");
                row.getCell(4).setValue((Object)Boolean.FALSE);
            }
            row.getCell(1).setValue((Object)unitNumber);
            row.getCell(2).setValue(rowData.get("unitname"));
        }
    }

    private List getData() {
        SumTaskUploadService sumTaskUploadService = new SumTaskUploadService();
        String localString = EASUtil.gelLoginLocal();
        String curOrgId = EASUtil.getCurrentOrgID();
        List userList = null;
        List selectList = this.getSumRangeInfoList();
        SumRangeInfo sumRangeInfo = (SumRangeInfo)selectList.get(0);
        if (sumRangeInfo == null || StringUtil.isEmptyString((String)sumRangeInfo.getId())) {
            return null;
        }
        StringBuffer orgWhereSql = new StringBuffer(" and range.fid ='").append(sumRangeInfo.getId()).append("'");
        String unitWhereSql = orgWhereSql.toString();
        try {
            userList = sumTaskUploadService.getUploadManageList(curOrgId, localString, unitWhereSql, unitWhereSql);
        }
        catch (BOSException e) {
            this._logger.info((Object)"\u67e5\u8be2\u62a5\u8868\u6a21\u677f\u62a5\u9519", (Throwable)e);
        }
        return userList;
    }

    public List getSumRangeInfoList() {
        return this.sumRangeInfoList;
    }

    public void setSumRangeInfoList(List sumRangeInfoList) {
        this.sumRangeInfoList = sumRangeInfoList;
    }
}

