/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.AbstractTableDataLoad;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.SelectDataList;
import com.kingdee.eas.rpts.sumreport.client.task.f7.f7dataLoad.model.UploadUserInfo;
import com.kingdee.eas.rpts.sumreport.service.SumTaskUploadService;
import com.kingdee.eas.rpts.sumreport.util.ControlDataLoadUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UploadManageUploaderDataLoad
extends AbstractTableDataLoad {
    private Logger _logger = CommonLogger.getLogger(UploadManageUploaderDataLoad.class);
    protected static final int USER_ID = 0;
    protected static final int USER_NUMBER = 1;
    protected static final int USER_NAME = 2;

    @Override
    public List getSelectedData() {
        SelectDataList selectDataList = new SelectDataList();
        int size = this._table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this._table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                IRow row = this._table.getRow(j);
                UploadUserInfo info = new UploadUserInfo();
                info.setId((String)row.getCell(0).getValue());
                info.setNumber((String)row.getCell(1).getValue());
                info.setName((String)row.getCell(2).getValue());
                selectDataList.add(info);
            }
        }
        return selectDataList;
    }

    @Override
    public void initTable() {
        if (this._table == null) {
            return;
        }
        this._dispColumnNames = new String[]{"\u7528\u6237\u7f16\u7801", "\u7528\u6237\u540d\u79f0"};
        this._allColumnNames = new String[]{"userId", "\u7528\u6237\u7f16\u7801", "\u7528\u6237\u540d\u79f0"};
        int[] columnWidth = new int[]{128, 128, 128};
        ControlDataLoadUtil.initTableHeader(this._table, 3, columnWidth, this._allColumnNames);
        this._table.getColumn(0).getStyleAttributes().setHided(true);
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(10);
    }

    private List getData() {
        SumTaskUploadService sumTaskUploadService = new SumTaskUploadService();
        String localString = EASUtil.gelLoginLocal();
        String curOrgId = EASUtil.getCurrentOrgID();
        List userList = null;
        try {
            userList = sumTaskUploadService.getUploadManageList(curOrgId, localString, null, null);
        }
        catch (BOSException e) {
            this._logger.info((Object)"\u67e5\u8be2\u62a5\u8868\u6a21\u677f\u62a5\u9519", (Throwable)e);
        }
        return userList;
    }

    @Override
    public void tableDataLoad() {
        List dataList = this.getData();
        this._table.removeRows();
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        HashMap uniqMap = new HashMap();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)dataList.get(i);
            String userId = (String)rowData.get("useruploadid");
            if (userId == null || uniqMap.containsKey(userId)) continue;
            IRow row = this._table.addRow();
            uniqMap.put(userId, null);
            row.getCell(0).setValue((Object)userId);
            row.getCell(1).setValue(rowData.get("useruploadnumber"));
            row.getCell(2).setValue(rowData.get("uploadername"));
        }
    }
}

