/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.client.sumrange;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.sumreport.client.sumrange.SumRangeEditUI;
import com.kingdee.eas.rpts.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.rpts.sumreport.client.sumrange.query.SumRangeQueryModel;
import com.kingdee.eas.rpts.sumreport.client.sumrange.unit.SumUnitManagerUI;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.debug.client.sumrange.DebugSumRangeQueryUI;
import com.kingdee.eas.rpts.sumreport.debug.client.sumrange.importexport.DebugExportXML;
import com.kingdee.eas.rpts.sumreport.debug.client.sumrange.importexport.DebugImportXML;
import com.kingdee.eas.rpts.sumreport.debug.service.DebugSumRangeService;
import com.kingdee.eas.rpts.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.rpts.sumreport.model.DefaultInfo;
import com.kingdee.eas.rpts.sumreport.model.DefaultInfoHandler;
import com.kingdee.eas.rpts.sumreport.model.IInfoHandler;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.ExtMsgBox;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class DebugSumRangeListUI
extends BaseListUI {
    private static final int COL_CODE = 0;
    private static final int COL_NAME = 1;
    private static final int COL_DISCRIBE = 2;
    private static final int COL_CREATOR = 3;
    private static final int COL_CREATETIME = 4;
    private static final int COL_EDITEDPERSON = 5;
    private static final int COL_EDITEDTIME = 6;
    private static IInfoHandler _infoHandler = new DefaultInfoHandler();
    private KDWorkButton _btnNew;
    private KDWorkButton _btnView;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private KDWorkButton _btnRefresh;
    private KDWorkButton _btnQuery;
    private KDWorkButton _btnSumUnit;
    private KDWorkButton _btnNewVersion;
    private KDWorkButton _btnExport;
    private KDWorkButton _btnImport;
    private SumRangeEditUI _editUI;
    private DebugSumRangeService _srsv = new DebugSumRangeService();
    private SumRangeInfo _activeRowData;
    private DebugSumRangeQueryUI _queryUI;

    public DebugSumRangeListUI() throws Exception {
        this.init();
        this.installListeners();
        this.actionRefresh();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setLayout(new BorderLayout());
        this.add((Component)this._table, "Center");
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnView);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnDel);
        this.toolBar.add((Component)this._btnRefresh);
        this.toolBar.add((Component)this._btnQuery);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnSumUnit);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnNewVersion);
        this.toolBar.add((Component)this._btnExport);
        this.toolBar.add((Component)this._btnImport);
    }

    @Override
    public void dispatchAction(ActionEvent e) throws Exception {
        Object srcO = e.getSource();
        try {
            if (srcO == this._btnNew) {
                this.actionNew();
                return;
            }
            if (srcO == this._btnRefresh) {
                this.actionRefresh();
                return;
            }
            if (srcO == this._btnImport) {
                this.actionImport();
                return;
            }
            if (srcO == this._btnQuery) {
                this.actionQuery();
                return;
            }
            if (!this.verifySelection()) {
                ExtMsgBox.showWarning("\u8bf7\u9009\u62e9\u4e00\u6761\u6c47\u603b\u8303\u56f4");
                return;
            }
            if (srcO == this._btnEdit) {
                this.actionEdit();
            } else if (srcO == this._btnView) {
                this.actionView();
            } else if (srcO == this._btnDel) {
                this.actionDel();
            } else if (srcO == this._btnNewVersion) {
                this.actionNewVersion();
            } else if (srcO == this._btnExport) {
                this.actionExport();
            } else if (srcO == this._btnSumUnit) {
                this.actionSumUnit();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void installEditUI(int mode) {
        this._editUI = new SumRangeEditUI((Frame)((KDFrame)ComponentUtil.getCurrentActiveWindow()), this, mode, true);
        this._editUI.setSize(new Dimension(500, 250));
        this._editUI.setModal(true);
        this._editUI.setDefaultCloseOperation(2);
        this._editUI.setLocationRelativeTo((Component)((Object)this));
    }

    private void actionNew() {
        this.installEditUI(1);
        this._editUI.setTitle("\u589e\u52a0\u6c47\u603b\u8303\u56f4");
        this._editUI.clearUI().requestFocus(2);
        this._editUI.setFlag(1 | SumRangeEditUI.BTN_SAVE);
        this._editUI.setMode(1);
        this._editUI.setVisible(true);
        this._table.getSelectManager().setActiveRowIndex(0);
    }

    private void actionSumUnit() {
        SumUnitManagerUI managerUI = new SumUnitManagerUI((KDFrame)ComponentUtil.getCurrentActiveWindow(), this._activeRowData.getId(), true);
        managerUI.setModal(true);
        managerUI.setEnableUI(true);
        managerUI.setVisible(true);
    }

    private void actionExport() {
        ArrayList ranges = this.retrieveRanges();
        if (ranges == null || ranges.size() == 0) {
            MessageUtil.msgboxWarning(null, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6c47\u603b\u8303\u56f4");
            return;
        }
        ArrayList<SumRangeInfo> sumRangeInfoList = new ArrayList<SumRangeInfo>(1);
        sumRangeInfoList.add((SumRangeInfo)ranges.get(0));
        DebugExportXML importExportXML = new DebugExportXML(sumRangeInfoList, this);
        importExportXML.exportData();
    }

    private void actionNewVersion() {
        this.installEditUI(3);
        this._editUI.setTitle("\u5efa\u7acb\u6c47\u603b\u8303\u56f4\u65b0\u7248\u672c");
        this._editUI.clearUI().requestFocus(3);
        this._editUI.setFlag(SumRangeEditUI.BTN_SAVE);
        this._editUI.setValues((SumRangeInfo)this._activeRowData.clone());
        this._editUI.setMode(3);
        this._editUI.setVisible(true);
    }

    protected ArrayList retrieveRanges() {
        ArrayList selectedList = TableManager.getSelectedTableIndexs(this._table);
        ArrayList<SumRangeInfo> rangeIDs = new ArrayList<SumRangeInfo>();
        int size = selectedList.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)this._table.getRow(Integer.parseInt((String)selectedList.get(i))).getUserObject();
            rangeIDs.add(item);
        }
        return rangeIDs;
    }

    private void actionDel() {
        if (!ExtMsgBox.showConfirm2("\u786e\u5b9a\u5220\u9664\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u5417\uff1f")) {
            return;
        }
        ArrayList ranges = this.retrieveRanges();
        try {
            ArrayList<String> own = new ArrayList<String>();
            String currentUser = EASUtil.getCurrentUserID();
            StringBuffer errMsg = new StringBuffer();
            int size = ranges.size();
            for (int i = 0; i < size; ++i) {
                SumRangeInfo item = (SumRangeInfo)ranges.get(i);
                if (currentUser.equals(item.getCreator())) {
                    own.add(item.getId());
                    continue;
                }
                errMsg.append("\u3010").append(item.getName()).append("\u3011").append("\r\n");
            }
            if (!StringUtil.isEmptyString((String)errMsg.toString())) {
                ExtMsgBox.showInfo((Component)((Object)this), errMsg.toString() + "\u4e0d\u80fd\u5220\u9664\uff01\u53ea\u6709\u6c47\u603b\u8303\u56f4\u7684\u521b\u5efa\u7ec4\u7ec7\u624d\u53ef\u4ee5\u5220\u9664\u3002");
            }
            if (own.size() > 0) {
                this._srsv.deleteSumRange(own);
                this.actionRefresh();
                _infoHandler.handleInfoTips(new DefaultInfo("\u5220\u9664\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u6210\u529f\uff01"));
            }
        }
        catch (SumRangeException e) {
            this.handUIException((Throwable)((Object)e));
        }
    }

    private void actionView() {
        this.installEditUI(4);
        this._editUI.setTitle("\u67e5\u770b\u6c47\u603b\u8303\u56f4");
        this._editUI.clearUI().setValues(this._activeRowData).setFlag(SumRangeEditUI.TXT_NAME | SumRangeEditUI.TXT_CODE | SumRangeEditUI.TXT_DEC | SumRangeEditUI.BTN_EDIT);
        this._editUI.setMode(4);
        this._editUI.setVisible(true);
    }

    private void actionEdit() {
        int activeRow = this._table.getSelectManager().getActiveRowIndex();
        this.installEditUI(2);
        this._editUI.setTitle("\u4fee\u6539\u6c47\u603b\u8303\u56f4");
        this._editUI.clearUI().requestFocus(3);
        this._editUI.setFlag(SumRangeEditUI.BTN_EDIT | SumRangeEditUI.BTN_SAVE);
        this._editUI.setValues(this._activeRowData);
        this._editUI.setMode(2);
        this._editUI.setVisible(true);
        this._table.getSelectManager().setActiveRowIndex(activeRow);
    }

    private boolean verifySelection() {
        return this._activeRowData != null;
    }

    private void actionQuery() {
        if (this._queryUI == null) {
            this._queryUI = new DebugSumRangeQueryUI((Frame)((KDFrame)ComponentUtil.getCurrentActiveWindow()), this);
            this._queryUI.setDefaultCloseOperation(1);
            this._queryUI.setLocationRelativeTo(null);
        }
        this._queryUI.setVisible(true);
    }

    public void filter(SumRangeQueryModel model) {
        int rowCount = this._table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this._table.getRow(i);
            SumRangeInfo info = (SumRangeInfo)row.getUserObject();
            boolean visible = model.meet(info.getName(), info.getNumber(), Integer.MIN_VALUE);
            row.getStyleAttributes().setHided(!visible);
        }
    }

    private void actionImport() {
        DebugImportXML importXML = new DebugImportXML(this, (KDFrame)ComponentUtil.getCurrentActiveWindow());
        importXML.importData();
    }

    private void init() {
        this.setUITitle("\u8c03\u8bd5\u6a21\u5f0f / \u6c47\u603b\u8303\u56f4\u7ba1\u7406");
        BaseListUI.ActionDispatch action = new BaseListUI.ActionDispatch();
        this._btnNew = this.initWBTN("\u65b0\u5efa", "imgTbtn_new", action);
        this._btnView = this.initWBTN("\u67e5\u770b", "imgTbtn_view", action);
        this._btnEdit = this.initWBTN("\u4fee\u6539", "imgTbtn_edit", action);
        this._btnDel = this.initWBTN("\u5220\u9664", "imgTbtn_delete", action);
        this._btnRefresh = this.initWBTN("\u5237\u65b0", "imgTbtn_refresh", action);
        this._btnQuery = this.initWBTN("\u67e5\u8be2", "imgTbtn_filter", action);
        this._btnSumUnit = this.initWBTN("\u6c47\u603b\u5355\u5143", "imgTbtn_collect", action);
        this._btnNewVersion = this.initWBTN("\u589e\u52a0\u65b0\u7248\u672c", "imgTbtn_copy", action);
        this._btnExport = this.initWBTN("\u5bfc\u51fa", "imgTbtn_output", action);
        this._btnImport = this.initWBTN("\u5bfc\u5165", "imgTbtn_input", action);
        this.initTable();
    }

    private void initTable() {
        this._table = new KDTable();
        this._table.addColumns(7);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(0).setSortable(true);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(4).setWidth(128);
        this._table.getColumn(5).setWidth(128);
        this._table.getColumn(6).setWidth(128);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u7f16\u7801");
        header.getCell(1).setValue((Object)"\u540d\u79f0");
        header.getCell(2).setValue((Object)"\u63cf\u8ff0");
        header.getCell(3).setValue((Object)"\u521b\u5efa\u4eba");
        header.getCell(4).setValue((Object)"\u521b\u5efa\u65f6\u95f4");
        header.getCell(5).setValue((Object)"\u4fee\u6539\u4eba");
        header.getCell(6).setValue((Object)"\u4fee\u6539\u65f6\u95f4");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(4).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getColumn(6).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        KDTSortManager sortManager = new KDTSortManager(this._table);
        sortManager.setSortAuto(true);
        this._table.setSortMange(sortManager);
    }

    private void installListeners() {
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ArrayList blocks;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getType() == 1) {
                    DebugSumRangeListUI.this.actionView();
                    return;
                }
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getType() == 1 && !(blocks = DebugSumRangeListUI.this._table.getSelectManager().getBlocks()).isEmpty()) {
                    KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    if (bottom - top == 0) {
                        DebugSumRangeListUI.this._activeRowData = (SumRangeInfo)DebugSumRangeListUI.this._table.getRow(top).getUserObject();
                    }
                }
            }
        });
    }

    public synchronized void actionRefresh() {
        this._table.removeRows();
        try {
            String local = EASUtil.gelLoginLocal();
            List lst = this._srsv.queryAllSumRange(local);
            if (lst != null) {
                for (SumRangeInfo vo : lst) {
                    IRow row = this._table.addRow();
                    row.getCell(0).setValue((Object)vo.getNumber());
                    row.getCell(1).setValue((Object)vo.getName(local));
                    row.getCell(2).setValue((Object)vo.getDes(local));
                    row.getCell(3).setValue((Object)vo.getCreatorName());
                    row.getCell(4).setValue((Object)vo.getCreateTime());
                    row.getCell(5).setValue((Object)vo.getLastUpdateUser());
                    row.getCell(6).setValue((Object)vo.getLastUpdateTime());
                    row.setUserObject((Object)vo);
                }
            }
        }
        catch (SumRangeException e) {
            this.handUIException((Throwable)((Object)e));
        }
    }
}

