/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.client.task.main;

import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.rpts.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.ActivityTreeCellRender;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.UserOrgSettingUI;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.AbstractDebugUIAction;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.BatchDelSnapshotAction;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.DelSnapshotAction;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.ExecuteSnapshotAction;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.ExecuteTemplateAction;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.action.UpdateSnapshotAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DebugTaskMainUI
extends KDFrame {
    private String _taskId;
    private ActivityTree _tree;
    private DisplayPanel _panel;
    private KDToolBar _tbar;
    private boolean _openIndentifySettingEachTime;
    private TaskDetailInfo _panelOwnerEntity;
    private SettingAction _settingAction;

    public DebugTaskMainUI(String taskId) {
        this._taskId = taskId;
        this.initUI();
    }

    private void initUI() {
        this._tree = new ActivityTree();
        this._panel = new DisplayPanel();
        this._settingAction = new SettingAction(this);
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(260);
        sppLeftRight.setLeftComponent((Component)this._tree.getUI());
        this._panel.setMinimumSize(new Dimension(0, 0));
        sppLeftRight.setRightComponent((Component)((Object)this._panel));
        sppLeftRight.setOneTouchExpandable(true);
        KDPanel contentPane = new KDPanel();
        contentPane.setCustomInsets(new Insets(0, 0, 10, 0));
        this.setContentPane((Container)contentPane);
        contentPane.setLayout((LayoutManager)new BorderLayout());
        contentPane.add((Component)sppLeftRight, (Object)"Center");
        this._tree.addDoubleClickAction(new ExecuteSnapshotAction(this));
        this.setTitle("\u6c47\u603b\u4e0a\u62a5\u8c03\u8bd5\u4e3b\u754c\u9762");
        this.setSize(800, 600);
        this.setExtendedState(6);
        this.setDefaultCloseOperation(2);
        this._tbar = new KDToolBar();
        this.initToolBar(null);
        this.addToolBar((JToolBar)this._tbar);
    }

    private void initToolBar(Action[] acs) {
        if (acs != null) {
            UpdateSnapshotAction action = new UpdateSnapshotAction(this);
            this._tbar.add((Action)action);
            this._tbar.add((Component)new KDSeparator());
            for (int i = 0; i < acs.length; ++i) {
                this._tbar.add((Action)new DelegateAction((AbstractAction)acs[i]));
            }
        }
        this._tbar.add((Component)new KDSeparator());
        this._tbar.add((Action)this._settingAction);
        this._tbar.add((Component)new KDSeparator());
        this._tbar.add((Action)new CloseAction(this));
    }

    public void addReportActions(Action[] acs) {
        this._tbar.removeAllToolBarComponents();
        this.initToolBar(acs);
    }

    public void refreshTree(KingdeeTreeModel treeModel) {
        this._tree.refresh(treeModel);
    }

    public void refreshTreeControlPane() {
        this._tree.refreshControlPane();
    }

    public void refreshDisplayPane(KDPanel displayComponent) {
        this._panel.refresh(displayComponent);
    }

    public String getTaskID() {
        return this._taskId;
    }

    public KDPanel getDisplayPane() {
        return this._panel;
    }

    public Book getBook() {
        JComponent comp = this._panel.getDisplayComponent();
        if (comp instanceof SpreadContext) {
            return ((SpreadContext)comp).getBook();
        }
        return null;
    }

    public void commitPanelEdit() {
        JComponent comp = this._panel.getDisplayComponent();
        if (comp instanceof SpreadContext) {
            ((SpreadContext)comp).getStateManager().stopEditing();
        }
    }

    public final KDTree getTreeUI() {
        return this._tree.getTreeUI();
    }

    public TaskDetailInfo getPanelOwnerEntity() {
        return this._panelOwnerEntity;
    }

    public TaskDetailInfo getSelectedTreeItem() {
        return this._tree.getEntity();
    }

    public boolean isOpenIndentifySettingEachTime() {
        return this._openIndentifySettingEachTime;
    }

    public void setOpenIndentifySettingEachTime(boolean openIndentifySettingEachTime) {
        this._openIndentifySettingEachTime = openIndentifySettingEachTime;
    }

    public void showSettingUI() {
        this._settingAction.actionPerformed(null);
    }

    public void setPanelOwnerEntity(TaskDetailInfo panelOwnerEntity) {
        this._panelOwnerEntity = panelOwnerEntity;
    }

    private class SettingAction
    extends AbstractAction {
        private DebugTaskMainUI _ui;
        private UserOrgSettingUI _identifySettingUI;

        public SettingAction(DebugTaskMainUI ui) {
            this._ui = ui;
            this._identifySettingUI = new UserOrgSettingUI(this._ui);
            this.putValue("SmallIcon", UploadSumIcons.createIcon("tbtn_userSetting.gif"));
            this.putValue("Name", "\u8bbe\u7f6e\u62a5\u8868\u8fd0\u884c\u7528\u6237");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._identifySettingUI.setLocationRelativeTo(null);
            this._identifySettingUI.setVisible(true);
        }
    }

    private class CloseAction
    extends AbstractAction {
        private DebugTaskMainUI _ui;

        public CloseAction(DebugTaskMainUI ui) {
            this._ui = ui;
            this.putValue("SmallIcon", UploadSumIcons.createIcon("tbtn_quit.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._ui.setVisible(false);
            this._ui.dispose();
        }
    }

    private class DelegateAction
    extends AbstractAction {
        private AbstractAction _action;

        public DelegateAction(AbstractAction action) {
            this._action = action;
            this.putValue("Name", this._action.getValue("Name"));
            this.putValue("SmallIcon", this._action.getValue("SmallIcon"));
            this.putValue("AcceleratorKey", this._action.getValue("AcceleratorKey"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._action.actionPerformed(e);
            JComponent comp = DebugTaskMainUI.this._panel.getDisplayComponent();
            if (comp instanceof SpreadContext) {
                ((SpreadContext)comp).getSpread().setEditable(true);
            }
        }
    }

    private class DisplayPanel
    extends KDPanel {
        private KDLabel _noteLabel;
        private JComponent _displayComponent;

        public DisplayPanel() {
            this.initDefault();
        }

        private void initDefault() {
            this._noteLabel = new KDLabel("\u63d0\u793a\uff1a \u53cc\u51fb\u5de6\u8fb9\u6811\u7ed3\u70b9\u53ef\u67e5\u770b\u5feb\u7167\u3002");
            this._noteLabel.setIcon((Icon)UploadSumIcons.createIcon("info.gif"));
            this._noteLabel.setPreferredSize(new Dimension(300, 40));
            this._noteLabel.setHorizontalAlignment(0);
            this._displayComponent = this._noteLabel;
            this.setLayout(new BorderLayout());
            this.add((Component)this._noteLabel, "Center");
        }

        public void refresh(KDPanel reportPanel) {
            this._displayComponent = reportPanel;
            if (this._displayComponent == null) {
                this._displayComponent = this._noteLabel;
            }
            if (this._displayComponent instanceof SpreadContext) {
                ((SpreadContext)this._displayComponent).getSpread().setEditable(true);
            }
            this.removeAll();
            this.setLayout(new BorderLayout());
            this._displayComponent.setMinimumSize(new Dimension(400, 800));
            this.add(this._displayComponent, "Center");
            this.revalidate();
        }

        public JComponent getDisplayComponent() {
            return this._displayComponent;
        }
    }

    private class ActivityTree {
        private KDTree _tree;
        private KDTreeView _treeView;
        private TaskDetailInfo _entity;
        private AbstractAction _exeSnapshotAction;
        private AbstractAction _delSnapshotAction;

        public ActivityTree() {
            this.initTree();
        }

        private void initTree() {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
            treeModel.setAsksAllowsChildren(true);
            this._tree = new KDTree();
            this._tree.setModel((TreeModel)treeModel);
            this._tree.setShowsRootHandles(true);
            this._tree.setRootVisible(false);
            this._tree.setCellRenderer((TreeCellRenderer)((Object)new ActivityTreeCellRender()));
            this._tree.setCustomInsets(new Insets(0, 0, 0, 0));
            this._treeView = new KDTreeView(this._tree);
            this._treeView.setMinimumSize(new Dimension(0, 0));
            this._treeView.setShowButton(false);
            this._treeView.setShowFind(false);
            BatchDelSnapshotAction batchDelAction = new BatchDelSnapshotAction(DebugTaskMainUI.this);
            KDWorkButton btn = new KDWorkButton((Action)batchDelAction);
            btn.setToolTipText(btn.getText());
            btn.setText(null);
            this._treeView.getControlPane().add((Component)btn);
            this._exeSnapshotAction = new ExecuteTemplateAction(DebugTaskMainUI.this);
            btn = new KDWorkButton((Action)this._exeSnapshotAction);
            btn.setToolTipText(btn.getText());
            btn.setText(null);
            this._treeView.getControlPane().add((Component)btn);
            this._exeSnapshotAction.setEnabled(false);
            this._delSnapshotAction = new DelSnapshotAction(DebugTaskMainUI.this);
            btn = new KDWorkButton((Action)this._delSnapshotAction);
            btn.setToolTipText(btn.getText());
            btn.setText(null);
            this._treeView.getControlPane().add((Component)btn);
        }

        private void addClickAction() {
            this._tree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                        ActivityTree.this.refreshControlPane();
                    }
                }
            });
        }

        public void addDoubleClickAction(final AbstractDebugUIAction ac) {
            this._tree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        TreePath treePath = ActivityTree.this._tree.getSelectionPath();
                        if (treePath == null) {
                            return;
                        }
                        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                        DebugTaskMainUI.this._panelOwnerEntity = (TaskDetailInfo)selectedNode.getUserObject();
                        ac.actionPerformed(null);
                    }
                }
            });
            this._tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ActivityTree.this._exeSnapshotAction.setEnabled(ActivityTree.this._tree.getSelectionCount() != 0);
                }
            });
        }

        public JComponent getUI() {
            return this._treeView;
        }

        public KDTree getTreeUI() {
            return this._tree;
        }

        public void refresh(KingdeeTreeModel treeModel) {
            this._tree.setModel((TreeModel)treeModel);
            this._tree.setRootVisible(true);
            if (treeModel != null && treeModel.getRoot() != null) {
                this._tree.expandAllNodes(true, (TreeNode)treeModel.getRoot());
                this._tree.setCollapsePathDisabled(true);
            }
            this._tree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
            this._tree.setCellRenderer((TreeCellRenderer)((Object)new ActivityTreeCellRender()));
            this.addClickAction();
            this._tree.revalidate();
        }

        public TaskDetailInfo getEntity() {
            return this._entity;
        }

        public void refreshControlPane() {
            TreePath treePath = this._tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            this._entity = (TaskDetailInfo)selectedNode.getUserObject();
            boolean visible = this._entity == null ? true : this._entity.isHavedSnapshot();
            this._delSnapshotAction.setEnabled(visible);
        }
    }
}

