/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.client.task.main.action;

import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.eas.rpts.sumreport.client.common.LoadingPanel;
import com.kingdee.eas.rpts.sumreport.debug.client.task.main.DebugTaskMainUI;
import com.kingdee.eas.rpts.sumreport.debug.service.DebugTaskService;
import com.kingdee.eas.rpts.sumreport.service.ExecutorService;
import java.awt.event.ActionEvent;
import java.net.SocketException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class AbstractDebugUIAction
extends AbstractAction {
    protected DebugTaskMainUI _mainUI;
    protected DebugTaskService _srsv;
    protected ExecutorService _executorSrsv;
    protected static LoadingPanel _loadingPanel = new LoadingPanel();

    public AbstractDebugUIAction(DebugTaskMainUI ui) {
        this._mainUI = ui;
        this._mainUI.setGlassPane(_loadingPanel);
        this._srsv = new DebugTaskService();
        this._executorSrsv = new ExecutorService();
    }

    protected void setText(String text) {
        this.putValue("Name", text);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setQuickKey(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
    }

    protected void dealSessionException(Exception ex) {
        Throwable ori = ex.getCause();
        if (ori instanceof IllegalStateException) {
            throw (IllegalStateException)ori;
        }
        if (ori instanceof SocketException) {
            throw new IllegalStateException(ori.getCause().toString());
        }
    }

    protected void preAction() {
        LoadingPanel lp = (LoadingPanel)this._mainUI.getGlassPane();
        lp.setNote(this.getLoadingMsg());
        this._mainUI.getGlassPane().setVisible(true);
        this._mainUI.invalidate();
        this._mainUI.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.preAction();
        LongTaskWorker worker = new LongTaskWorker(){

            public Object construct() {
                try {
                    return AbstractDebugUIAction.this.doAction();
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractDebugUIAction.this.dealSessionException(e);
                        }
                    });
                    return null;
                }
            }

            public void finished() {
                AbstractDebugUIAction.this._mainUI.getGlassPane().setVisible(false);
                AbstractDebugUIAction.this._mainUI.invalidate();
                AbstractDebugUIAction.this._mainUI.repaint();
                AbstractDebugUIAction.this.afterAction(this.getValue());
            }
        };
        worker.start();
    }

    public abstract String getLoadingMsg();

    public abstract Object doAction();

    public void afterAction(Object returnObj) {
    }
}

