/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.sumreport.data.SumRangeInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitInfo;
import com.kingdee.eas.rpts.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.rpts.sumreport.debug.server.IDebugSumUnitBOFacade;
import com.kingdee.eas.rpts.sumreport.debug.server.impl.DebugSumUnitBOFacade;
import com.kingdee.eas.rpts.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.service.inf.ISumUnitService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class DebugSumUnitService
implements ISumUnitService {
    private IDebugSumUnitBOFacade _facade;
    private String _local = EASUtil.gelLoginLocal();

    private IDebugSumUnitBOFacade getFacade() throws SumRangeException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (IDebugSumUnitBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)DebugSumUnitBOFacade.class.getName(), IDebugSumUnitBOFacade.class);
            }
            catch (BOSException e) {
                throw SumRangeException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    @Override
    public void newSumUnit(SumUnitInfo info) throws SumRangeException {
        this.getFacade().insertSumUnit(info);
    }

    @Override
    public void updateSumUnit(SumUnitInfo oVo, SumUnitInfo nVo) throws SumRangeException, InfoException {
        nVo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        if (this.getFacade().isExistUnitName(nVo.getId(), nVo.getName(), this._local, oVo.getSumRangeID())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
        if (this.getFacade().isExistUnitNumber(nVo.getId(), nVo.getNumber(), oVo.getSumRangeID())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        this.getFacade().updateSumUnit(nVo, oVo);
    }

    @Override
    public void delSumUnit(SumUnitInfo vo) throws SumRangeException {
        this.getFacade().deleteSumUnit(vo);
    }

    @Override
    public String addCompany(SumUnitOrgInfo[] infos) throws SumRangeException {
        ArrayList<SumUnitOrgInfo> unRef = new ArrayList<SumUnitOrgInfo>();
        StringBuffer msgBuf = new StringBuffer();
        boolean msgFlag = false;
        for (int i = 0; i < infos.length; ++i) {
            if (!this.getFacade().isOrgImport(infos[i])) {
                unRef.add(infos[i]);
                continue;
            }
            msgBuf.append("\u3010").append(infos[i].getOrgName()).append("\u3011").append(StringUtil.RETURN);
            msgFlag = true;
        }
        this.getFacade().insertUnitOrg(unRef);
        if (msgFlag) {
            msgBuf.append("\u4e4b\u524d\u5df2\u7ecf\u88ab\u5f15\u5165\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u5165\uff01");
        }
        return msgBuf.toString();
    }

    @Override
    public void delCompany(SumUnitOrgInfo info) throws SumRangeException {
        this.getFacade().deleteUnitOrg(info.getOrgID(), info.getSumUnitID());
    }

    @Override
    public boolean isExistUnitName(SumUnitInfo info) throws SumRangeException {
        return this.getFacade().isExistUnitName(info.getId(), info.getName(), this._local, info.getSumRangeID());
    }

    @Override
    public boolean isExistUnitNumber(SumUnitInfo info) throws SumRangeException {
        return this.getFacade().isExistUnitNumber(info.getId(), info.getNumber(), info.getSumRangeID());
    }

    @Override
    public SumUnitInfo buildSumUnitTree(String rangeId) throws SumRangeException {
        List rsL = this.getFacade().getCurrentOrgUnitListByRangeID(rangeId, this._local);
        SumUnitInfo rootUnit = null;
        if (null != rsL && rsL.size() >= 1) {
            rootUnit = (SumUnitInfo)rsL.get(0);
            HashMap<String, SumUnitInfo> cache = new HashMap<String, SumUnitInfo>();
            cache.put(rootUnit.getId(), rootUnit);
            int size = rsL.size();
            for (int i = 1; i < size; ++i) {
                SumUnitInfo uItem = (SumUnitInfo)rsL.get(i);
                if (cache.containsKey(uItem.getParentID())) {
                    SumUnitInfo pUnit = (SumUnitInfo)cache.get(uItem.getParentID());
                    pUnit.addChild(uItem);
                }
                cache.put(uItem.getId(), uItem);
            }
        }
        return rootUnit;
    }

    @Override
    public SumUnitInfo buildSumUnitTreeIncluOrg(SumRangeInfo params) throws SumRangeException {
        List rsL = this.getFacade().queryfullUnitTree(params.getId(), this._local);
        SumUnitInfo rootUnit = null;
        if (null != rsL && rsL.size() >= 1) {
            Object obj = rsL.get(0);
            if (!(obj instanceof SumUnitInfo)) {
                return null;
            }
            rootUnit = (SumUnitInfo)obj;
            HashMap<String, Serializable> cache = new HashMap<String, Serializable>();
            cache.put(rootUnit.getId(), rootUnit);
            int size = rsL.size();
            for (int i = 1; i < size; ++i) {
                SumUnitInfo pUnit;
                Serializable uItem;
                obj = rsL.get(i);
                if (obj instanceof SumUnitInfo) {
                    uItem = (SumUnitInfo)obj;
                    if (cache.containsKey(((SumUnitInfo)uItem).getParentID())) {
                        pUnit = (SumUnitInfo)cache.get(((SumUnitInfo)uItem).getParentID());
                        pUnit.addChild((SumUnitInfo)uItem);
                    }
                    cache.put(((SumUnitInfo)uItem).getId(), uItem);
                    continue;
                }
                uItem = (SumUnitOrgInfo)obj;
                if (!cache.containsKey(((SumUnitOrgInfo)uItem).getSumUnitID())) continue;
                pUnit = (SumUnitInfo)cache.get(((SumUnitOrgInfo)uItem).getSumUnitID());
                pUnit.addOrgChild((SumUnitOrgInfo)uItem);
            }
        }
        return rootUnit;
    }

    @Override
    public Vector querySumUnitOrg(String sumUnitID) throws SumRangeException {
        List rsL = this.getFacade().querySumUnitOrgByID(sumUnitID, this._local);
        Vector rs = new Vector(rsL.size());
        rs.addAll(rsL);
        return rs;
    }

    @Override
    public Vector querySumUnitOrgIncluSub(String rangeID, String sumUnitNumber) throws SumRangeException {
        List rsL = this.getFacade().querySumUnitOrgIncluSubByID(rangeID, sumUnitNumber, this._local);
        Vector rs = new Vector(rsL.size());
        rs.addAll(rsL);
        return rs;
    }
}

