/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.use.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.sumreport.debug.service.DebugTaskService;
import com.kingdee.eas.rpts.sumreport.exceptions.DataSourceException;
import com.kingdee.eas.rpts.sumreport.service.ExecutorService;
import com.kingdee.eas.rpts.sumreport.use.model.ExtCallBackConst;
import com.kingdee.eas.rpts.sumreport.use.model.RunType;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class DataSourceService {
    private static Logger log = CommonLogger.getLogger(DataSourceService.class);
    public static final String ID = "rZns4x88ShmCrA4shCy6yENOfX0=\u3010\u6c47\u603b\u4e0a\u62a5\u4e13\u7528\u3011";

    public void persistDS(String systemID, CtrlDesignCommonQuery model) throws DataSourceException {
        if (this.isExistDS(systemID)) {
            throw new DataSourceException("\u5df2\u7ecf\u5b58\u5728\u6c47\u603b\u4e0a\u62a5\u6570\u636e\u96c6\uff01");
        }
        HashMap<String, String> names = new HashMap<String, String>(2);
        names.put("l2", "\u6c47\u603b\u4e0a\u62a5\u6570\u636e\u96c6");
        names.put("l3", "\u532f\u7e3d\u4e0a\u5831\u6578\u64da\u96c6");
        IQuery query = model.getQuery();
        Element xml = CtrlDesignUtil.toXml(model, query);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XmlUtil.saveXmlStream((OutputStream)out, (Element)xml);
            byte[] data = out.toByteArray();
            KSQLReportBO.saveKSQL(data, null, names, systemID, true, 6, null);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw DataSourceException.wrap(e);
        }
    }

    public boolean isExistDS(String systemID) throws DataSourceException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "exitsRecordBySQL");
        try {
            String sql = "SELECT fid FROM T_BAS_KSQLReport WHERE fcustomtype = 6  And fOrgID = ? and fsystemid = ?";
            pr.setString("sql", sql);
            ArrayList<String> queryValue = new ArrayList<String>(2);
            queryValue.add(EASUtil.getCurrentOrgID());
            queryValue.add(systemID);
            pr.setObject("lstValue", queryValue);
            RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
            return ps_r.getBoolean("flag");
        }
        catch (BOSException e) {
            log.debug((Object)e);
            throw DataSourceException.wrap((Exception)((Object)e));
        }
    }

    public boolean updateSumReportDataSet(ExtDataSet ds, Map sumReportedInfo) throws DataSourceException {
        if (sumReportedInfo == null) {
            return false;
        }
        try {
            Map id2Names = null;
            Map id2Data = null;
            if (sumReportedInfo.get(ExtCallBackConst.SUM_REPORT_RUN_TYPE) == RunType.DEBUG) {
                DebugTaskService srsv = new DebugTaskService();
                String activityID = (String)sumReportedInfo.get(ExtCallBackConst.TASK_ACTIVITY_ID);
                id2Names = srsv.getChildActivitysId2NameMap(activityID);
                id2Data = srsv.getChildActivitysId2DataMap(activityID);
            } else {
                ExecutorService srsv = new ExecutorService();
                id2Names = srsv.getChildIDs((String)sumReportedInfo.get(ExtCallBackConst.TASK_ID), (String)sumReportedInfo.get(ExtCallBackConst.SUM_UNIT_ORG_ID));
                id2Data = srsv.getChildSnapDatas(id2Names.keySet().toArray());
            }
            this.fillDataSet(ds, id2Data, id2Names);
            return true;
        }
        catch (Exception e) {
            throw DataSourceException.wrap(e);
        }
    }

    private void fillDataSet(ExtDataSet ds, Map id2Data, Map id2Names) {
        ds.addColumn(new ExtColumn(ds, "fid", 0, 12));
        ds.addColumn(new ExtColumn(ds, "fname", 1, 12));
        ds.addColumn(new ExtColumn(ds, "fcontent", 2, 2004));
        Iterator itor = id2Data.keySet().iterator();
        ObjectArray al = new ObjectArray();
        while (itor.hasNext()) {
            Variant[] rowData = new Variant[3];
            String id = (String)itor.next();
            rowData[0] = new Variant((Object)id, 11);
            String name = (String)id2Names.get(id);
            rowData[1] = new Variant((Object)name, 11);
            Object data = id2Data.get(id);
            rowData[2] = new Variant(data, 17);
            al.append((Object)rowData);
        }
        al.trimToSize();
        ds.setData(al);
        MiscUtil.log((int)4, (String)("\u8bb0\u5f55\u6570\uff1a" + al.size()));
        id2Names = null;
        id2Data = null;
    }
}

