/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.util;

import com.kingdee.eas.rpts.sumreport.util.ExtUuidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class BaseUuid
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7952004632150713063L;
    public static final int LENGTH = 36;
    private transient long mostSigBits;
    private transient long leastSigBits;
    private static volatile SecureRandom numberGenerator = null;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static synchronized BaseUuid create() throws ExtUuidException {
        return BaseUuid.randomUUID();
    }

    private BaseUuid() {
    }

    public byte[] toByteArray() {
        byte[] array = new byte[16];
        this.toBytes(this.mostSigBits, array, 0);
        this.toBytes(this.leastSigBits, array, 8);
        return array;
    }

    private void toBytes(long x, byte[] array, int startPos) {
        int bytePos = 8;
        while (--bytePos >= 0) {
            array[startPos + bytePos] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeLong(this.mostSigBits);
        s.writeLong(this.leastSigBits);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.mostSigBits = s.readLong();
        this.leastSigBits = s.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.mostSigBits);
        out.writeLong(this.leastSigBits);
    }

    public static BaseUuid read(DataInput in) throws IOException {
        long most = in.readLong();
        long least = in.readLong();
        return new BaseUuid(most, least);
    }

    public static BaseUuid read(String id) throws ExtUuidException {
        return BaseUuid.fromString(id);
    }

    private BaseUuid(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    private BaseUuid(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    public static BaseUuid randomUUID() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return new BaseUuid(randomBytes);
    }

    public static BaseUuid fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new BaseUuid(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(36);
        buf.append(BaseUuid.toHexString(this.mostSigBits >>> 32, 8)).append("-");
        buf.append(BaseUuid.toHexString(this.mostSigBits >>> 16, 4)).append("-");
        buf.append(BaseUuid.toHexString(this.mostSigBits, 4)).append("-");
        buf.append(BaseUuid.toHexString(this.leastSigBits >>> 48, 4)).append("-");
        buf.append(BaseUuid.toHexString(this.leastSigBits, 12));
        return buf.toString();
    }

    private static String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    public int hashCode() {
        int hashCode = (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseUuid)) {
            return false;
        }
        BaseUuid id = (BaseUuid)obj;
        return this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    public int compareTo(Object val) {
        if (val instanceof BaseUuid) {
            BaseUuid uuid = (BaseUuid)val;
            return this.mostSigBits < uuid.mostSigBits ? -1 : (this.mostSigBits > uuid.mostSigBits ? 1 : (this.leastSigBits < uuid.leastSigBits ? -1 : (this.leastSigBits > uuid.leastSigBits ? 1 : 0)));
        }
        return -1;
    }
}

