/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qingReport.server.dataProvider.AbstractDataProviderWrapper;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtBizData;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.tobi.util.AnalysisReportUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisReportDataProvider
extends AbstractDataProviderWrapper {
    private Context ctx;
    private Map<ExtDataSet, ExtBizData> extBizDataMap = new HashMap<ExtDataSet, ExtBizData>();
    private Map<String, Integer> dataIndex = new HashMap<String, Integer>();
    private List<String> columns = new ArrayList<String>();
    private ExecutionContext execCxt;
    private static Logger log = LogUtil.getPackageLogger(AnalysisReportDataProvider.class);

    public AnalysisReportDataProvider(Context ctx) {
        this.ctx = ctx;
    }

    public QingMeta getQingMeta(String tag) {
        QingMeta qingMeta = new QingMeta();
        try {
            this.init(tag);
            for (ExtDataSet ds : this.extBizDataMap.keySet()) {
                this.buildQingMeta(ds, qingMeta);
            }
            return qingMeta;
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u96c6\u5931\u8d25\uff1a" + e.getCause()));
            this.handleException(e);
            return null;
        }
    }

    public QingData getQingData(String tag, int startRow, int limit) {
        try {
            QingData qingData = new QingData();
            for (ExtDataSet ds : this.extBizDataMap.keySet()) {
                ResultSet rs = this.execute(ds, startRow, limit);
                this.buildQingData(rs, qingData);
            }
            return qingData;
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff1a" + e.getCause()));
            return null;
        }
    }

    public void disposeProvider(String tag) {
        this.extBizDataMap.clear();
        this.dataIndex.clear();
        this.columns.clear();
    }

    public String setQingFilter(String bizTag, String filter) {
        return null;
    }

    public String getQingFilter(String tag) throws EASBizException, BOSException {
        return null;
    }

    private Object getFilter(String tag) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        String userId = userInfo.getId().toString();
        String filter = AnalysisReportUtil.getFilterCache(userId, tag);
        return JSONObject.parse((String)filter);
    }

    private void init(String tag) throws Exception {
        Map filterMap = (Map)this.getFilter(tag);
        ExtReportImpl extReportImpl = (ExtReportImpl)PageManager.createExtReport((Context)this.ctx, (Map)filterMap);
        if (extReportImpl == null) {
            log.error((Object)"\u521b\u5efaExtReport\u5931\u8d25");
            throw new CtrlReportException("\u521b\u5efaExtReport\u5931\u8d25");
        }
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(this.ctx, tag);
        String jsonStr = (String)filterMap.get("oJson_param");
        this.initParam(paramAdapter, jsonStr);
    }

    private void initParam(WebParamAdapter paramAdapter, String jsonStr) throws Exception {
        Map paramMap = null;
        Map aliasMap = null;
        ArrayList allUnionParam = null;
        String strParams = null;
        if (!StringUtil.isEmptyString((String)jsonStr)) {
            Map oJson = (Map)JSONObject.parse((String)jsonStr);
            Object object = oJson.get("paramValues");
            strParams = object == null ? "[]" : object.toString();
        }
        paramAdapter.cacheDbSourceModel(true);
        allUnionParam = paramAdapter.getAllUnionParam();
        paramMap = WebReportDomain.getParamMap((List)allUnionParam, strParams, "value", false);
        aliasMap = WebReportDomain.getParamMap((List)allUnionParam, strParams, "text", false);
        HashMap mapDesignParam = WebParamAdapter.prepareParam(this.ctx, paramMap, aliasMap, allUnionParam, false);
        Book book = paramAdapter.getBook();
        Map transParam = paramAdapter.transParam(book, mapDesignParam);
        ExtDataSetManager dsManager = book.getDataSetManager();
        this.execCxt = dsManager.getExecutionContext();
        this.execCxt.attachDataSetParameters(transParam);
        this.initBizDataMap(dsManager);
    }

    private void initBizDataMap(ExtDataSetManager dsManager) throws CtrlReportException, SyntaxErrorException {
        for (int i = 0; i < dsManager.size(); ++i) {
            ExtDataSet ds = dsManager.getAt(i);
            this.extBizDataMap.put(ds, DataSetBaseFactory.createExtBizData(ds, this.execCxt));
        }
    }

    private ExtBizData getExtBizData(ExtDataSet ds) {
        return this.extBizDataMap.get(ds);
    }

    private void buildQingData(ResultSet rs, QingData qingdata) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<Object> rowList = new ArrayList<Object>();
        try {
            while (rs.next()) {
                for (String col : this.columns) {
                    Object object = rs.getObject(col);
                    if (object instanceof Timestamp) {
                        Timestamp time = (Timestamp)object;
                        rowList.add(time.getTime());
                        continue;
                    }
                    rowList.add(object);
                }
                dataList.add(rowList.toArray());
                rowList.clear();
            }
            qingdata.setDataindex(this.dataIndex);
            qingdata.setRows(dataList);
        }
        catch (SQLException e) {
            log.error((Object)"\u83b7\u53d6\u7ed3\u679c\u96c6\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field buildQingField(String alias, String name, int type, String entityName) {
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field field = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field();
        field.setName(name);
        field.setFieldType(type);
        field.setAlias(alias);
        field.setEntity(entityName);
        return field;
    }

    private void buildQingMeta(ExtDataSet ds, QingMeta qingMeta) {
        String dsName = ds.getName();
        ExtBizData ebd = this.getExtBizData(ds);
        List<Map<String, Object>> reportDBModelList = ebd.getReportDBModel();
        for (Map<String, Object> dbModel : reportDBModelList) {
            Object object = dbModel.get("model");
            if (!(object instanceof CtrlDesignQueryModel)) continue;
            CtrlDesignQueryModel model = (CtrlDesignQueryModel)object;
            Outputs outputs = model.getCommonQuery().getOutputs();
            this.buildOutputQingMeta(qingMeta, outputs, dsName);
        }
    }

    private void buildOutputQingMeta(QingMeta qingMeta, Outputs outputs, String dsName) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        int index = 0;
        OutputColumns ocs = (OutputColumns)outputs.get(0);
        for (int m = 0; m < ocs.size(); ++m) {
            OutputColumn column = (OutputColumn)ocs.get(m);
            String alias = CtrlReportUtil.getObjectString(column.getAlias());
            String name = CtrlReportUtil.getObjectString(column.getName());
            int qingType = this.getQingDataType(column.getDataType());
            com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field field = this.buildQingField(alias, name, qingType, dsName);
            qingMeta.addColumn((Field)field);
            this.dataIndex.put(name, index++);
            this.columns.add(name);
        }
    }

    private int getQingDataType(DataType dataType) {
        int type = DataType.toJdbcType((DataType)dataType);
        switch (type) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return QingFieldType.Number.toNumber();
            }
            case 91: {
                return QingFieldType.Date.toNumber();
            }
            case 92: 
            case 93: {
                return QingFieldType.DateTime.toNumber();
            }
            case 16: {
                return QingFieldType.Boolean.toNumber();
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return QingFieldType.Int.toNumber();
            }
            case -9: 
            case -1: 
            case 1: 
            case 9: 
            case 12: {
                return QingFieldType.String.toNumber();
            }
        }
        return QingFieldType.String.toNumber();
    }

    private ResultSet execute(ExtDataSet ds, int start, int length) throws Exception {
        ExtBizData ebd = this.getExtBizData(ds);
        String define = ds.getDefine();
        ebd.execute(define, start, length);
        return ebd.getRs();
    }

    private void handleException(Exception e) {
    }
}

