/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.man;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.sumreport.data.SnapDataBean;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class MobileReportImpl
extends ReportImpl {
    private String snapshotId;
    private Book book;

    private MobileReportImpl(Context easCtx, String rptId, String snapshotId) throws ExtRptBizException {
        super(rptId);
        this.snapshotId = snapshotId;
        this.book = MobileReportImpl.initSnapshotBook(easCtx, snapshotId);
        this.setbMobile(true);
    }

    private MobileReportImpl(Context easCtx, String rptId) {
        super(rptId);
        this.setbMobile(true);
    }

    public static Book initSnapshotBook(Context easCtx, String snapshotId) throws ExtRptBizException {
        try {
            IRowSet rs = DbUtil.executeQuery(easCtx, "select fblockIndex,fcontent,flength from T_EXT_SSDATA where fid =? order by FID,FBlockIndex", new Object[]{snapshotId});
            SnapDataBean[] beans = new SnapDataBean[rs.size()];
            int index = 0;
            while (rs.next()) {
                int length = rs.getInt("flength");
                byte[] block = new byte[length];
                try {
                    InputStream in = rs.getBlob("fcontent").getBinaryStream();
                    try {
                        in.read(block);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    block = rs.getBytes("fcontent");
                }
                beans[index++] = new SnapDataBean(block, length);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < beans.length; ++i) {
                out.write(beans[i].getBlock(), 0, beans[i].getSize());
                beans[i].GCBlock();
            }
            return BookIOUtil.unpack((byte[])out.toByteArray());
        }
        catch (Exception e) {
            throw ExtRptBizException.newSnapshotVisitException(e);
        }
    }

    @Override
    public Book getBook() {
        if (this.snapshotId != null) {
            return this.book;
        }
        return super.getBook();
    }

    @Override
    public String getFilePath(String fileName) {
        return "/mobile/lightapp/extRpt/resources?remoteMethod=extLightChartContent&tmpFileName=" + fileName;
    }

    public static MobileReportImpl createSnapshotImpl(Context easCtx, String rptId, String snapshotId) throws ExtRptBizException {
        return new MobileReportImpl(easCtx, rptId, snapshotId);
    }

    public static MobileReportImpl createTemplateImpl(Context easCtx, String rptId) {
        return new MobileReportImpl(easCtx, rptId);
    }
}

