/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.util;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.IPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.FlashHelper;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.rpts.ctrlreport.innerlink.LinkParamVo;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.model.AbstractEmbedObject;
import com.kingdee.eas.rpts.web.model.EmbedChart;
import com.kingdee.eas.rpts.web.model.EmbedSubReport;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.ImageGenerator;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import java.awt.Rectangle;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EmbedObjectHelper {
    public static List<AbstractEmbedObject> transformEmbedObject(SheetImpl sheetModel, Sheet sheet, Context ctx, ReportImpl reportImpl) {
        ArrayList<AbstractEmbedObject> embedChartList = new ArrayList<AbstractEmbedObject>();
        EmbedhLayer layer = sheet.getEmbedments(false);
        String fileName = "";
        if (layer != null) {
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject eo = layer.getEmbed(i);
                Rectangle rect = eo.getBounds();
                if (rect.width <= 0 || rect.height <= 0) continue;
                embedChartList.add(EmbedObjectHelper.buildEmbedObject(sheetModel, sheet, eo, ctx, reportImpl));
            }
        }
        if (sheetModel.getDiagonalCells() != null) {
            List<Cell> cellList = sheetModel.getDiagonalCells();
            for (Cell cell : cellList) {
                fileName = ImageGenerator.createAndPersistImage(sheet, cell.getDiagonalHeader(), cell, sheetModel);
                Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)sheet, (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
                embedChartList.add(EmbedObjectHelper.buildPic(fileName, rect, "diagonal" + cell.hashCode()));
            }
        }
        return embedChartList;
    }

    public static AbstractEmbedObject getEmbedChartByName(SheetImpl sheetModel, Sheet sheet, String chartName, Context ctx, ReportImpl reportImpl) {
        EmbedhLayer layer = sheet.getEmbedments(false);
        EmbedObject eo = null;
        AbstractEmbedObject chart = null;
        if (layer != null) {
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject tmp = layer.getEmbed(i);
                if (!tmp.getName().equals(chartName)) continue;
                eo = tmp;
                break;
            }
        }
        if (eo != null) {
            chart = EmbedObjectHelper.buildEmbedObject(sheetModel, sheet, eo, ctx, reportImpl);
        }
        return chart;
    }

    private static AbstractEmbedObject buildEmbedObject(SheetImpl sheetModel, Sheet sheet, EmbedObject eo, Context ctx, ReportImpl reportImpl) {
        Rectangle rect = eo.getBounds();
        String embedInnerName = eo.getName();
        if (eo instanceof FlashChart) {
            return EmbedObjectHelper.buildFlashChartWithHtml5(eo, rect, sheetModel, sheet);
        }
        if (eo instanceof EChart) {
            return EmbedObjectHelper.buildChartsWithHtml5(eo, rect, sheetModel, sheet);
        }
        if (eo instanceof SubReportEmbed) {
            return EmbedObjectHelper.buildEmbedSubReport(eo, rect, ctx, reportImpl);
        }
        String name = ImageGenerator.createAndPersistImage(sheet, eo, null, sheetModel);
        if (reportImpl.isbMobile() && eo instanceof EmbedImage) {
            EmbedImage ei = (EmbedImage)eo;
            ei.getModel().dispose();
        }
        return EmbedObjectHelper.buildPic(name, rect, embedInnerName);
    }

    private static EmbedChart buildPic(String name, Rectangle rect, String embedInnerName) {
        EmbedChart embedChart = new EmbedChart();
        embedChart.setEmbedType(EmbedChart.IMAGE_CHART);
        embedChart.setName(embedInnerName);
        embedChart.setDataSrc(name);
        Map<String, Integer> embedRect = EmbedObjectHelper.getRect(rect);
        embedChart.setLeft(embedRect.get("x"));
        embedChart.setTop(embedRect.get("y"));
        embedChart.setWidth(embedRect.get("width"));
        embedChart.setHeight(embedRect.get("height"));
        return embedChart;
    }

    private static EmbedChart buildFlashChartWithHtml5(EmbedObject eo, Rectangle rect, SheetImpl sheetModel, Sheet sheet) {
        FlashChart chart = (FlashChart)eo;
        FlashChartModel model = chart.getModel();
        String xml = chart.getXml();
        xml = EmbedObjectHelper.reBuildLinkProp(xml, eo.getName());
        FlashHelper.unpackSWF_SERVER(null, (FlashChartType)model.getChartType());
        String chartName = model.getBean().getChartType().getSWFFileName();
        String chartType = chartName.substring(0, chartName.lastIndexOf(".swf"));
        String dataSrc = sheetModel.getFilePrefixPath() + chartName;
        EmbedChart embedChart = new EmbedChart();
        embedChart.setEmbedType(EmbedChart.FLASH_CHART);
        embedChart.setName(eo.getName());
        embedChart.setType(chartType);
        embedChart.setDataSource(xml);
        embedChart.setDataSrc(dataSrc);
        Map<String, Integer> embedRect = EmbedObjectHelper.getRect(rect);
        embedChart.setLeft(embedRect.get("x"));
        embedChart.setTop(embedRect.get("y"));
        embedChart.setWidth(embedRect.get("width"));
        embedChart.setHeight(embedRect.get("height"));
        Object vo = sheet.getUserObjectValue(AbstractFusionBean.getFixedKey((String)sheet.getSheetName(), (String)embedChart.getName()));
        if (vo != null && vo instanceof Boolean) {
            System.out.println("==================buildFlashChartWithHtml5======Boolean\u7c7b\u578b:" + vo.toString());
            embedChart.setFrozenFixed((Boolean)vo);
        }
        if (vo != null && vo instanceof String) {
            try {
                embedChart.setFrozenFixed(new Boolean((String)vo));
            }
            catch (Exception e) {
                System.out.println("==================buildFlashChartWithHtml5======String\u7c7b\u578b:" + vo.toString());
                System.out.println(e.getMessage());
            }
        }
        return embedChart;
    }

    private static EmbedChart buildChartsWithHtml5(EmbedObject eo, Rectangle rect, SheetImpl sheetModel, Sheet sheet) {
        EChart chart = (EChart)eo;
        ETTargets extTargets = chart.getModel().getExtTargets();
        InnerLinkTargets innerTargets = chart.getModel().getInnerTargets();
        String js = chart.getLastExecutedScript();
        if (!TransferUtils.checkScriptSize((String)js)) {
            throw new IllegalArgumentException("\u6267\u884cjs\u811a\u672c\u8fc7\u5927\u8bf7\u68c0\u67e5\u56fe\u8868\u53d6\u6570\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002");
        }
        String b64 = Base64.encodeBytes((byte[])js.getBytes(StandardCharsets.UTF_8));
        EmbedChart embedChart = new EmbedChart();
        if (extTargets != null || innerTargets != null) {
            embedChart.setHasTargets(true);
        } else {
            embedChart.setHasTargets(false);
        }
        embedChart.setEmbedType(ChartFrameWorkType.ECHART.name());
        embedChart.setName(eo.getName());
        embedChart.setType("echarts");
        embedChart.setDataSource(b64);
        Map<String, Integer> embedRect = EmbedObjectHelper.getRect(rect);
        embedChart.setLeft(embedRect.get("x"));
        embedChart.setTop(embedRect.get("y"));
        embedChart.setWidth(embedRect.get("width"));
        embedChart.setHeight(embedRect.get("height"));
        Object vo = sheet.getUserObjectValue(AbstractFusionBean.getFixedKey((String)sheet.getSheetName(), (String)embedChart.getName()));
        if (vo instanceof Boolean) {
            System.out.println("==================buildFlashChartWithHtml5======Boolean\u7c7b\u578b:" + vo.toString());
            embedChart.setFrozenFixed((Boolean)vo);
        }
        if (vo instanceof String) {
            try {
                embedChart.setFrozenFixed(new Boolean((String)vo));
            }
            catch (Exception e) {
                System.out.println("==================buildFlashChartWithHtml5======String\u7c7b\u578b:" + vo.toString());
                System.out.println(e.getMessage());
            }
        }
        return embedChart;
    }

    public static String reBuildLinkProp(String xml, String linkSrc) {
        int indexPre = xml.indexOf(AbstractFusionBean.preSetLink);
        if (indexPre < 0) {
            return xml;
        }
        ArrayList linkValues = FlashChartModel.getLinkValues((String)xml);
        int indexEnd = 0;
        LinkParamVo dataJson = new LinkParamVo();
        String amp = "&amp;";
        Iterator<Object> iter = linkValues.iterator();
        HashMap<String, String> mapLinkValue = new HashMap<String, String>();
        while (iter.hasNext()) {
            int index;
            String value = "";
            String newLink = "javascript:ExtRptFusionChartLink('";
            String linkValue = (String)iter.next();
            indexPre = linkValue.indexOf("@categoryName");
            if (indexPre > 0) {
                indexEnd = linkValue.indexOf(amp);
                String categoryName = linkValue.substring(indexPre, indexEnd);
                index = categoryName.indexOf(61);
                value = categoryName.substring(index + 1, categoryName.length());
                dataJson.setCategoryName(value);
            }
            value = "";
            indexPre = linkValue.indexOf("@seriesName");
            if (indexPre > 0) {
                indexEnd = linkValue.indexOf(amp, indexPre);
                String seriesName = linkValue.substring(indexPre, indexEnd);
                index = seriesName.indexOf(61);
                value = seriesName.substring(index + 1, seriesName.length());
                indexEnd += amp.length();
                dataJson.setSeriesName(value);
            }
            value = "";
            indexPre = linkValue.indexOf("@seriesValue");
            if (indexPre > 0) {
                indexEnd = linkValue.indexOf(amp, indexPre);
                String seriesValue = linkValue.substring(indexPre, indexEnd);
                index = seriesValue.indexOf(61);
                value = seriesValue.substring(index + 1, seriesValue.length());
                dataJson.setSeriesValue(value);
            }
            dataJson.setLinkSrc(Utils.encodeBase64((String)linkSrc, (boolean)true));
            newLink = newLink + Utils.encodeBase64((String)new JSONObject((Object)dataJson).toString().replaceAll("\"", "'"), (boolean)true) + "')";
            mapLinkValue.put(linkValue, newLink);
        }
        for (String linkKey : mapLinkValue.keySet()) {
            xml = xml.replace(linkKey + AbstractFusionBean.endSetLink, (CharSequence)mapLinkValue.get(linkKey));
        }
        return xml;
    }

    private static Map<String, Integer> getRect(Rectangle rect) {
        HashMap<String, Integer> rectMap = new HashMap<String, Integer>();
        rectMap.put("x", rect.x + 1);
        rectMap.put("y", rect.y + 1);
        rectMap.put("width", rect.width);
        rectMap.put("height", rect.height);
        return rectMap;
    }

    private static EmbedSubReport buildEmbedSubReport(EmbedObject eo, Rectangle rect, Context ctx, ReportImpl reportImpl) {
        SubReportEmbed subReportEmbed = (SubReportEmbed)eo;
        SubReportInfo subReportInfo = subReportEmbed.getSubReportInfo();
        ReportProperties rptProps = subReportInfo.getReportProps();
        String rptId = rptProps != null ? rptProps.getId() : null;
        String pageId = reportImpl.getPageId();
        Cell cell = subReportEmbed.getCell();
        String name = cell != null ? EmbedObjectHelper.reNameSubReportId(pageId, cell.getName(false, true)) : subReportEmbed.getName();
        boolean isMobile = reportImpl.isbMobile();
        ReportImpl subReportImpl = null;
        if (!isMobile) {
            ExtReportImpl extReport = new ExtReportImpl(rptId, null);
            ExtReportPage reportPage = new ExtReportPage(name, (ExtReport)extReport);
            PageManager.cachePage((IPage)reportPage, (String)ctx.getCaller().toString());
            subReportImpl = extReport.getReport();
            subReportImpl.setPageId(name);
        } else {
            subReportImpl = MobileReportImpl.createTemplateImpl(ctx, rptId);
        }
        Book subBook = subReportInfo.getBook();
        subReportImpl.setBook(subBook);
        subReportImpl.setContext(ctx);
        subReportImpl.setCurrentSheetName(subBook.getSheet(0).getSheetName());
        subReportImpl.setLazyLoad(false);
        BeanFactory.makeupReportModelBhv().behaviour(subReportImpl);
        ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(subReportImpl);
        EmbedSubReport embedSubRpt = new EmbedSubReport();
        embedSubRpt.setReportInfo(reportInfo);
        embedSubRpt.setEmbedType(EmbedSubReport.SUB_REPORT);
        embedSubRpt.setName(name);
        Map<String, Integer> embedRect = EmbedObjectHelper.getRect(rect);
        embedSubRpt.setLeft(embedRect.get("x"));
        embedSubRpt.setTop(embedRect.get("y"));
        embedSubRpt.setWidth(embedRect.get("width") - 1);
        embedSubRpt.setHeight(embedRect.get("height") - 1);
        return embedSubRpt;
    }

    public static String reNameSubReportId(String pageId, String cellName) {
        if (StringUtil.isEmptyString((String)cellName)) {
            return cellName;
        }
        String subReportId = "";
        if (!StringUtil.isEmptyString((String)pageId)) {
            subReportId = pageId + "_";
        }
        return subReportId + cellName.replace("!", "_");
    }
}

