/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.util;

import com.kingdee.bos.ctrl.extcommon.util.ObjectCache;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.rpts.web.model.BorderStyle;
import com.kingdee.eas.rpts.web.model.StyleModel;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class StyleToCss {
    private static Map<Integer, String> textAlign = new HashMap<Integer, String>();
    private static Map<Integer, String> verticalMap;
    private static Map<Object, String> borderKeys;

    public static StyleModel getCssStyle(Style style) {
        int id = style.hashCode();
        StyleModel cssStyle = BeanFactory.getStyleMap().getStyle(id);
        if (null == cssStyle) {
            cssStyle = new StyleModel();
            cssStyle.setFontName(style.getFontName());
            cssStyle.setFontSize(style.getFontSize());
            cssStyle.setBold(style.isBold());
            cssStyle.setItalic(style.isItalic());
            cssStyle.setUnderLine(style.isUnderline());
            cssStyle.setLineThrough(style.isStrikeThrough());
            cssStyle.setColor(StyleParser.colorToHex((Color)style.getFontColor()));
            cssStyle.setBackgroundColor(StyleParser.colorToHex((Color)style.getBackground()));
            cssStyle.setTextAlign(textAlign.get(new Integer(style.getHorizontalAlign().getValue())));
            cssStyle.setVerticalAlign(verticalMap.get(new Integer(style.getVerticalAlign().getValue())));
            cssStyle.setWrapText(style.isWrapText());
            cssStyle.setIndentation(style.getIndentation());
            cssStyle.setRotation(style.getRotation());
            cssStyle.setShrinkText(style.isShrinkText());
            cssStyle.setVerticalText(style.isVerticalText());
            cssStyle.setId(id);
            BeanFactory.getStyleMap().putStyle(id, cssStyle);
        }
        return cssStyle;
    }

    public static BorderStyle getCssBorder(Style style) {
        int id = style.hashCode();
        BorderStyle cssBorder = BeanFactory.getStyleMap().getBorderStyle(id);
        if (null == cssBorder) {
            cssBorder = new BorderStyle();
            cssBorder.setLeftColor(StyleParser.colorToHex((Color)style.getBorderColor(Styles.Position.LEFT)));
            String leftName = StyleToCss.getBorderLineStyleName(style, Styles.Position.LEFT);
            if (leftName != null && leftName.equals("TrigramHollow")) {
                cssBorder.setLeftPen("double");
            } else {
                cssBorder.setLeftPen(borderKeys.get(style.getBorderPenStyle(Styles.Position.LEFT)));
            }
            cssBorder.setLeftWidth(style.getBorderLineStyle(Styles.Position.LEFT).getWidth());
            cssBorder.setRightColor(StyleParser.colorToHex((Color)style.getBorderColor(Styles.Position.RIGHT)));
            String rightName = StyleToCss.getBorderLineStyleName(style, Styles.Position.RIGHT);
            if (rightName != null && rightName.equals("TrigramHollow")) {
                cssBorder.setRightPen("double");
            } else {
                cssBorder.setRightPen(borderKeys.get(style.getBorderPenStyle(Styles.Position.RIGHT)));
            }
            cssBorder.setRightWidth(style.getBorderLineStyle(Styles.Position.RIGHT).getWidth());
            cssBorder.setTopColor(StyleParser.colorToHex((Color)style.getBorderColor(Styles.Position.TOP)));
            String topName = StyleToCss.getBorderLineStyleName(style, Styles.Position.TOP);
            if (topName != null && topName.equals("TrigramHollow")) {
                cssBorder.setTopPen("double");
            } else {
                cssBorder.setTopPen(borderKeys.get(style.getBorderPenStyle(Styles.Position.TOP)));
            }
            cssBorder.setTopWidth(style.getBorderLineStyle(Styles.Position.TOP).getWidth());
            cssBorder.setBottomColor(StyleParser.colorToHex((Color)style.getBorderColor(Styles.Position.BOTTOM)));
            String bottomName = StyleToCss.getBorderLineStyleName(style, Styles.Position.BOTTOM);
            if (bottomName != null && bottomName.equals("TrigramHollow")) {
                cssBorder.setBottomPen("double");
            } else {
                cssBorder.setBottomPen(borderKeys.get(style.getBorderPenStyle(Styles.Position.BOTTOM)));
            }
            cssBorder.setBottomWidth(style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth());
            cssBorder.setId(id);
            BeanFactory.getStyleMap().putBorderStyle(id, cssBorder);
        }
        return cssBorder;
    }

    private static String getBorderLineStyleName(Style style, Styles.Position position) {
        return style.getBorderLineStyle(position).getName();
    }

    static {
        textAlign.put(ObjectCache.getInteger((int)0), "left");
        textAlign.put(ObjectCache.getInteger((int)1), "left");
        textAlign.put(ObjectCache.getInteger((int)2), "center");
        textAlign.put(ObjectCache.getInteger((int)3), "right");
        verticalMap = new HashMap<Integer, String>();
        verticalMap.put(ObjectCache.getInteger((int)1), "top");
        verticalMap.put(ObjectCache.getInteger((int)2), "middle");
        verticalMap.put(ObjectCache.getInteger((int)3), "bottom");
        borderKeys = new HashMap<Object, String>();
        borderKeys.put(Styles.Position.LEFT, "border-left");
        borderKeys.put(Styles.Position.RIGHT, "border-right");
        borderKeys.put(Styles.Position.TOP, "border-top");
        borderKeys.put(Styles.Position.BOTTOM, "border-bottom");
        borderKeys.put(PenStyle.PS_SOLID, "solid");
        borderKeys.put(PenStyle.PS_DOT, "dotted");
        borderKeys.put(PenStyle.PS_CONTINUOUS, "dotted");
        borderKeys.put(PenStyle.PS_DASH, "dashed");
        borderKeys.put(PenStyle.PS_DASHDOTDOT, "dashed");
        borderKeys.put(PenStyle.PS_DASHDOT, "dotted");
    }
}

