/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.cust.client.AbstractWFOrgF7UI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class WFOrgF7UI
extends AbstractWFOrgF7UI {
    private static final Logger logger = CoreUIObject.getLogger(WFOrgF7UI.class);
    private static String resClassName = "com.kingdee.bos.workflow.cust.WFRoleResource";
    public boolean isCanceled = true;
    protected AdminOrgUnitInfo info;
    FilterInfo mainFilter = new FilterInfo();
    MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
    IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private static final Icon folderIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    private boolean isConditionChange = true;
    private String searchText = null;
    private List<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
    private int searchIndex = 0;

    public AdminOrgUnitInfo getInfo() {
        return this.info;
    }

    public void setInfo(AdminOrgUnitInfo info) {
        this.info = info;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void doLayout() {
        super.doLayout();
        this.comboField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WFOrgF7UI.this.isConditionChange = true;
            }
        });
        this.checkBlured.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WFOrgF7UI.this.isConditionChange = true;
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tOrgTree.setModel((TreeModel)new DefaultTreeModel(null));
        this.tOrgTree.setShowsRootHandles(true);
        this.rebuildOrgTree();
    }

    private void rebuildOrgTree() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (this.getUIContext().get("rootId") == null) {
            fi.getFilterItems().add(new FilterItemInfo("parent.id is null"));
            this.mainFilter.getFilterItems().add(new FilterItemInfo("parent.id is null"));
            fi.getFilterItems().add(new FilterItemInfo("Level = 2"));
            fi.setMaskString("#0 or #1");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id = '" + (String)this.getUIContext().get("rootId") + "' "));
            this.mainFilter.getFilterItems().add(new FilterItemInfo("id = '" + (String)this.getUIContext().get("rootId") + "' "));
            fi.getFilterItems().add(new FilterItemInfo("parent.id = '" + (String)this.getUIContext().get("rootId") + "' "));
            fi.setMaskString("#0 or #1");
        }
        viewInfo.setFilter(fi);
        this.queryExcu.setObjectView(viewInfo);
        IRowSet rows = this.queryExcu.executeQuery();
        KDTreeNode rootTreeNode = WFOrgF7UI.buildTreeNodeByRowSet(null, rows);
        this.tOrgTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootTreeNode));
        this.tOrgTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                try {
                    WFOrgF7UI.this.buildChildNode((KDTreeNode)e.getPath().getLastPathComponent());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)WFOrgF7UI.this.tOrgTree, (Throwable)exc);
                }
            }
        });
    }

    private static KDTreeNode buildTreeNodeByRowSet(KDTreeNode rootTreeNode, IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode subTreeNode = null;
        AdminOrgUnitInfo adminInfo = null;
        rows.beforeFirst();
        while (rows.next()) {
            adminInfo = WFOrgF7UI.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            if (!adminInfo.isIsLeaf()) {
                subTreeNode.setVirtual(true);
                subTreeNode.add((MutableTreeNode)new KDTreeNode((Object)""));
                subTreeNode.setCustomIcon(companyIcon);
            } else {
                subTreeNode.setCustomIcon(folderIcon);
            }
            rootTreeNode.add((MutableTreeNode)subTreeNode);
        }
        return rootTreeNode;
    }

    private void buildChildNode(KDTreeNode parentNode) throws Exception {
        if (parentNode.isVirtual()) {
            parentNode.setVirtual(false);
            parentNode.removeAllChildren();
            if (!(parentNode.getUserObject() instanceof AdminOrgUnitInfo)) {
                return;
            }
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)parentNode.getUserObject();
            String parentid = adminInfo.getId().toString();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if (parentid == null || "".equals(parentid)) {
                return;
            }
            fi.getFilterItems().add(new FilterItemInfo("parent.id = '" + parentid + "' "));
            viewInfo.setFilter(fi);
            this.queryExcu.setObjectView(viewInfo);
            IRowSet rows = this.queryExcu.executeQuery();
            WFOrgF7UI.buildTreeNodeByRowSet(parentNode, rows);
        }
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("ID")));
        adminInfo.setName(row.getString("Name"));
        adminInfo.setLongNumber(row.getString("LongNumber"));
        adminInfo.setIsLeaf(row.getBoolean("IsLeaf"));
        adminInfo.setLevel(row.getInt("Level"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setDisplayName(row.getString("displayName"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (StringUtils.isEmpty((String)row.getString("parent.id"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.tOrgTree.getLastSelectedPathComponent() != null && ((KDTreeNode)this.tOrgTree.getLastSelectedPathComponent()).getUserObject() instanceof AdminOrgUnitInfo) {
            this.info = (AdminOrgUnitInfo)((KDTreeNode)this.tOrgTree.getLastSelectedPathComponent()).getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"unselectData"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFieldValue.getText()) || this.tOrgTree.getModel() == null || this.tOrgTree.getModel().getRoot() == null) {
            return;
        }
        if (this.isConditionChange || !this.txtFieldValue.getText().equals(this.searchText)) {
            this.nodes.clear();
            this.searchIndex = 0;
            this.isConditionChange = false;
            this.searchText = this.txtFieldValue.getText();
            IRowSet rows = this.execSearchQuery();
            int rowCnt = 0;
            AdminOrgUnitInfo adminInfo = null;
            while (rows.next()) {
                adminInfo = WFOrgF7UI.createAdminUnitInfo(rows);
                KDTreeNode node = this.redirectToTree(adminInfo, (KDTreeNode)this.tOrgTree.getModel().getRoot());
                if (node == null) continue;
                this.nodes.add((DefaultKingdeeTreeNode)node);
                ++rowCnt;
            }
            if (rowCnt == 0) {
                MsgBox.showWarning((String)LanguageManager.getLangMessage((String)"searchFinish", (String)"com.kingdee.bos.ctrl.swing.KDTreeView", (String)"search result not found"));
            } else {
                this.selectNextSearchNode();
            }
        } else {
            this.selectNextSearchNode();
        }
    }

    private void selectNextSearchNode() {
        if (this.nodes.isEmpty()) {
            return;
        }
        if (this.searchIndex > this.nodes.size() - 1) {
            this.searchIndex = 0;
        }
        this.tOrgTree.setSelectionNode(this.nodes.get(this.searchIndex));
        this.tOrgTree.scrollPathToVisible(new TreePath(this.nodes.get(this.searchIndex).getPath()));
        ++this.searchIndex;
    }

    private IRowSet execSearchQuery() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String compareValue = this.txtFieldValue.getText();
        String compareExpr = null;
        compareExpr = this.comboField.getSelectedIndex() == 0 ? "name" : "number";
        CompareType compareType = null;
        if (Boolean.TRUE.booleanValue() == this.checkBlured.isSelected()) {
            compareType = CompareType.LIKE;
            compareValue = '%' + compareValue + '%';
        } else {
            compareType = CompareType.EQUALS;
        }
        fi.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)compareValue, compareType));
        viewInfo.setFilter(fi);
        this.queryExcu.setObjectView(viewInfo);
        IRowSet rows = this.queryExcu.executeQuery();
        return rows;
    }

    private KDTreeNode redirectToTree(AdminOrgUnitInfo adminInfo, KDTreeNode root) throws Exception {
        if (root == null) {
            return null;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)root.getUserObject();
            if (adminInfo.getId().equals((Object)info.getId())) {
                return root;
            }
            String longNumber = adminInfo.getLongNumber();
            String rootLongNumber = info.getLongNumber();
            if (!StringUtils.isEmpty((String)longNumber) && longNumber.startsWith(rootLongNumber + '!')) {
                this.buildChildNode(root);
                for (int i = 0; i < root.getChildCount(); ++i) {
                    KDTreeNode childNode = (KDTreeNode)root.getChildAt(i);
                    KDTreeNode node = this.redirectToTree(adminInfo, childNode);
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return null;
    }
}

