/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.cust.AbstractWFRoleInfo;
import com.kingdee.bos.workflow.cust.IWFRole;
import com.kingdee.bos.workflow.cust.WFRoleFactory;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleState;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.bos.workflow.cust.client.AbstractWFRoleListUI;
import com.kingdee.bos.workflow.cust.client.WFAdvanceRoleEditUI;
import com.kingdee.bos.workflow.cust.client.WFBatchAdminDialog;
import com.kingdee.bos.workflow.cust.client.WFPersonRoleQueryUI;
import com.kingdee.bos.workflow.cust.client.WFRoleClientUtils;
import com.kingdee.bos.workflow.cust.client.WFRoleCreateDialog;
import com.kingdee.bos.workflow.cust.client.WFRoleOrgEditUI;
import com.kingdee.bos.workflow.cust.client.WFRolePersonEditUI;
import com.kingdee.bos.workflow.cust.client.WFRolePositionEditUI;
import com.kingdee.bos.workflow.cust.client.WFRoleTreeUtil;
import com.kingdee.bos.workflow.cust.client.WFRoleUsageConditionUI;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.tree.NewOrgTreeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class WFRoleListUI
extends AbstractWFRoleListUI {
    private static final Logger logger = CoreUIObject.getLogger(WFRoleListUI.class);
    private int roleTypeValue;
    private String OprtState2 = null;
    private DefaultKingdeeTreeNode node = null;
    private static String resClassName = "com.kingdee.bos.workflow.cust.WFRoleResource";

    public WFRoleListUI() throws Exception {
        this.showAll.setVisible(false);
        this.checkPermission();
    }

    public void checkPermission() throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "wf_role_read");
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFRoleCreateDialog.class.getName(), this.getUIContext());
        uiWindow.show();
        if (((WFRoleCreateDialog)uiWindow.getUIObject()).isCancel()) {
            this.setRoleTypeValue(10086);
            this.OprtState2 = null;
            SysUtil.abort();
        }
        WFRoleType roleType = (WFRoleType)((Object)((WFRoleCreateDialog)uiWindow.getUIObject()).wfRoleType.getSelectedItem());
        this.setRoleTypeValue(roleType.getValue());
        this.OprtState2 = OprtState.ADDNEW;
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (treenode.getUserObject() != null && treenode.getUserObject() instanceof AdminOrgUnitInfo) {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)treenode.getUserObject();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("displayName"));
                sic.add(new SelectorItemInfo("number"));
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminInfo.getId()), sic);
                this.getUIContext().put("adminTree", adminInfo);
            } else {
                this.getUIContext().put("adminTree", null);
            }
        } else {
            this.getUIContext().put("adminTree", null);
        }
        super.actionAddNew_actionPerformed(e);
        this.OprtState2 = null;
        this.setRoleTypeValue(10086);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return WFRoleFactory.getRemoteInstance();
    }

    protected void initTree() throws Exception {
    }

    @Override
    public void actionPersonRoleQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(WFPersonRoleQueryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionAdvanceScriptRole_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(WFAdvanceRoleEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionUsageCondition_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 1 || this.tblMain.getSelectManager().get().getEndRow() - this.tblMain.getSelectManager().get().getBeginRow() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectOnlyOne"));
            SysUtil.abort();
        }
        String id = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(WFRoleUsageConditionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getEditUIName() {
        if (OprtState.ADDNEW.equals(this.OprtState2)) {
            if (this.getRoleTypeValue() == 0) {
                return WFRolePersonEditUI.class.getName();
            }
            if (this.getRoleTypeValue() == 1) {
                return WFRolePositionEditUI.class.getName();
            }
            if (this.getRoleTypeValue() == 2) {
                return WFRoleOrgEditUI.class.getName();
            }
            if (this.getRoleTypeValue() == 3) {
                return WFAdvanceRoleEditUI.class.getName();
            }
            return null;
        }
        String selectID = this.getSelectedKeyValue();
        AbstractWFRoleInfo info = null;
        try {
            if (selectID != null) {
                info = (WFRoleInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(selectID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        if (info == null) {
            return WFRolePersonEditUI.class.getName();
        }
        if (info.getRoleType().getValue() == 0) {
            return WFRolePersonEditUI.class.getName();
        }
        if (info.getRoleType().getValue() == 1) {
            return WFRolePositionEditUI.class.getName();
        }
        if (info.getRoleType().getValue() == 2) {
            return WFRoleOrgEditUI.class.getName();
        }
        if (info.getRoleType().getValue() == 3) {
            return WFAdvanceRoleEditUI.class.getName();
        }
        return null;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        super.onLoad();
        this.rebuildOrgTree(true, false);
        this.chkInclude.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    WFRoleListUI.this.chkInclude_itemStateChanged(e);
                }
                catch (Exception exc) {
                    WFRoleListUI.this.handUIException(exc);
                }
            }
        });
        this.showAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    WFRoleListUI.this.showAll_itemStateChanged(e);
                }
                catch (Exception exc) {
                    WFRoleListUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
            }
        });
        this.kDWorkButton3.setVisible(false);
        if (!WFRoleClientUtils.ADMINISTRATOR.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString())) {
            this.btnBatchAdmin.setVisible(false);
        }
    }

    private void rebuildOrgTree(boolean isFileterOrg, boolean isUserRange) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        this.treeMain.setModel(null);
        if (!isFileterOrg) {
            rootNode = NewOrgTreeHelper.createAllAdminTreeNode();
            DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
            this.treeMain.setModel((TreeModel)treeModel);
        } else {
            rootNode = WFRoleTreeUtil.createAdminTreeNodeByWFRole();
            String adminUnitId = null;
            if (rootNode != null) {
                String querySql = "select count(*) \"count(*)\" from T_WFR_WFROLE where ftreeid in (SELECT \"ADMINORGUNIT\".FID AS \"TREEID.ID\" FROM T_ORG_Admin AS \"ADMINORGUNIT\" WHERE \"ADMINORGUNIT\".FParentID is null AND \"ADMINORGUNIT\".FLEVEL = 1) ";
                SQLExecutor se = new SQLExecutor(querySql);
                IRowSet rows = se.executeSQL();
                if (rows.next()) {
                    if (rows.getBigDecimal(1).intValue() == 0) {
                        this.treeMain.setRootVisible(false);
                    } else {
                        this.treeMain.setRootVisible(true);
                    }
                }
                DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
                this.treeMain.setModel((TreeModel)treeModel);
                this.treeMain.setShowsRootHandles(true);
                String retAdminTree = (String)this.getUIContext().get("retAdminTree");
                if (!StringUtils.isEmpty((String)retAdminTree)) {
                    this.ExpandTreeNode(this.treeMain, retAdminTree);
                    return;
                }
                if (SysContext.getSysContext().getCurrentAdminUnit() != null) {
                    adminUnitId = SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
                }
                if (adminUnitId != null) {
                    this.ExpandTreeNode(this.treeMain, adminUnitId);
                }
            }
        }
    }

    public void ExpandTreeNode(KDTree tree, String adminUnitId) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model == null || model.getRoot() == null) {
            return;
        }
        this.node = null;
        this.findNodeByUnitID((DefaultKingdeeTreeNode)model.getRoot(), adminUnitId);
        if (this.node == null) {
            tree.setSelectionRow(0);
            return;
        }
        if (((AdminOrgUnitInfo)((DefaultKingdeeTreeNode)model.getRoot()).getUserObject()).getId().equals((Object)((AdminOrgUnitInfo)this.node.getUserObject()).getId()) && !tree.isRootVisible()) {
            tree.setSelectionRow(0);
            return;
        }
        Object[] nodes = this.node.getPath();
        TreePath path = new TreePath(nodes);
        tree.setSelectionPath(path);
    }

    private DefaultKingdeeTreeNode findNodeByUnitID(DefaultKingdeeTreeNode parentNode, String adminUnitId) {
        if (parentNode.getUserObject() instanceof AdminOrgUnitInfo && ((AdminOrgUnitInfo)parentNode.getUserObject()).getId().toString().equals(adminUnitId)) {
            this.node = parentNode;
        } else {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                this.findNodeByUnitID((DefaultKingdeeTreeNode)parentNode.getChildAt(i), adminUnitId);
            }
        }
        return null;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            FilterInfo nofilter = new FilterInfo();
            nofilter.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata"));
            this.mainQuery.setFilter(nofilter);
            this.tblMain.removeRows();
            return;
        }
        DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (treenode.getUserObject() != null && treenode.getUserObject() instanceof AdminOrgUnitInfo) {
            this.mainQuery = new EntityViewInfo();
            FilterInfo filter = this.getDefaultFilterForQuery();
            this.mainQuery.setFilter(filter);
            if (this.getDefaultEntityViewInfo() != null) {
                this.MergeCommonQuery(this.getDefaultEntityViewInfo());
            }
        }
        this.tblMain.removeRows();
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.rebuildOrgTree(true, false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1) {
            if (this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("State") != null) {
                Object state = ((BizEnumValueDTO)this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("State").getValue()).getValue();
                boolean isEnabled = String.valueOf(0).equals(state.toString());
                this.changeBTEnabeld(isEnabled);
            }
        } else {
            this.disabledBT();
        }
    }

    private void changeBTEnabeld(boolean isEnabled) {
        this.btnCancelCancel.setEnabled(!isEnabled);
        this.btnCancel.setEnabled(isEnabled);
    }

    private void disabledBT() {
        this.btnCancelCancel.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectRowTip"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                int begin = sb.getTop();
                int end = sb.getBottom();
                for (int j = begin; j <= end; ++j) {
                    String createId;
                    IRow row = this.tblMain.getRow(j);
                    ICell cell = row.getCell("State");
                    if (cell != null && cell.getValue() != null && String.valueOf(0).equals(((BizEnumValueDTO)cell.getValue()).getValue())) {
                        MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"enabledNotDel"));
                        SysUtil.abort();
                    }
                    ICell cell2 = row.getCell("creator");
                    ICell cell3 = row.getCell("admin");
                    if (cell2 == null || cell2.getValue() == null || (createId = cell2.getValue().toString()).equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || cell3.getValue().toString().equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals(WFRoleClientUtils.ADMINISTRATOR)) continue;
                    if (size == 1) {
                        MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"removePermTip"));
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selDataDelTip"));
                    }
                    SysUtil.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionCancelCancel_actionPerformed(e);
        List<Object> ids = this.getSelectedIdValues();
        ids = WFRoleClientUtils.filterEnableOrDisableRole((List<String>)ids, WFRoleState.disable);
        if (ids != null && ids.size() > 0) {
            ((IWFRole)this.getBizInterface()).updateWfRoleState(ids, WFRoleState.enabled);
        }
        this.treeMain_valueChanged(null);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (!this.confirmDialog(cancelMsg)) {
            return;
        }
        ArrayList list = this.getSelectedIdValues();
        if (list.size() == 1) {
            if (!StringUtils.isEmpty((String)list.get(0).toString())) {
                if (WFRoleClientUtils.checkRoleInGroup(list.get(0).toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"refInGroup"));
                    SysUtil.abort();
                }
                if (WFRoleClientUtils.checkRoleInProc(list.get(0).toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"refInProc"));
                    SysUtil.abort();
                }
                if (WFRoleClientUtils.checkRoleInStartScheme(list).size() > 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleQuotedBySS"));
                    SysUtil.abort();
                }
                ((IWFRole)this.getBizInterface()).updateWfRoleState(list, WFRoleState.disable);
            }
            this.treeMain_valueChanged(null);
            return;
        }
        Map<String, Integer> map = this.innerEnabledAndDisable(WFRoleState.disable);
        int retGroup = map.get("retGroup") == null ? 0 : map.get("retGroup");
        int retProc = map.get("retProc") == null ? 0 : map.get("retProc");
        int retStartScheme = map.get("retStartScheme") == null ? 0 : map.get("retStartScheme");
        StringBuffer msg = new StringBuffer(EASResource.getString((String)resClassName, (String)"selectedData"));
        if (retGroup > 0) {
            msg.append(retGroup);
            msg.append(EASResource.getString((String)resClassName, (String)"quotedByGroup"));
        }
        if (retProc > 0) {
            msg.append(retProc);
            msg.append(EASResource.getString((String)resClassName, (String)"quotedByProcess"));
        }
        if (retStartScheme > 0) {
            msg.append(retStartScheme);
            msg.append(EASResource.getString((String)resClassName, (String)"quotedBySS"));
        }
        msg.append("," + EASResource.getString((String)resClassName, (String)"cannotDisable"));
        if (retGroup > 0 || retProc > 0 || retStartScheme > 0) {
            MsgBox.showWarning((String)msg.toString());
        }
        this.treeMain_valueChanged(null);
    }

    private Map<String, Integer> innerEnabledAndDisable(WFRoleState t) throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<Object> pks = this.getSelectedIdValues();
        pks = WFRoleState.disable.equals((Object)t) ? WFRoleClientUtils.filterEnableOrDisableRole((List<String>)pks, WFRoleState.enabled) : WFRoleClientUtils.filterEnableOrDisableRole((List<String>)pks, WFRoleState.disable);
        if (pks == null || pks.size() == 0) {
            return map;
        }
        List<String> retGroup = WFRoleClientUtils.checkRoleInGroup(pks);
        for (String string : retGroup) {
            pks.remove(string);
        }
        List<String> retProc = WFRoleClientUtils.checkRoleInProc(pks);
        for (String pk : retProc) {
            pks.remove(pk);
        }
        List<String> list = WFRoleClientUtils.checkRoleInStartScheme(pks);
        for (String pk : list) {
            pks.remove(pk);
        }
        if (pks.size() > 0) {
            ((IWFRole)this.getBizInterface()).updateWfRoleState(pks, t);
        }
        map.put("retGroup", retGroup.size());
        map.put("retProc", retProc.size());
        map.put("retStartScheme", list.size());
        return map;
    }

    private ArrayList<WFRoleInfo> getSelectedMapping() {
        ArrayList<WFRoleInfo> list = new ArrayList<WFRoleInfo>();
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                int begin = sb.getTop();
                int end = sb.getBottom();
                for (int j = begin; j <= end; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    WFRoleInfo info = new WFRoleInfo();
                    ICell cell = row.getCell(this.getKeyFieldName());
                    ICell cel2 = row.getCell("State");
                    if (cell != null) {
                        info.setNumber((String)cell.getValue());
                    }
                    if (cel2 != null) {
                        info.setState((WFRoleState)((Object)cel2.getValue()));
                    }
                    list.add(info);
                }
            }
        }
        return list;
    }

    public void chkInclude_itemStateChanged(ItemEvent e) {
        try {
            this.treeMain_valueChanged(null);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public void showAll_itemStateChanged(ItemEvent e) {
        try {
            if (this.showAll.isSelected()) {
                this.rebuildOrgTree(false, false);
            } else {
                this.rebuildOrgTree(true, false);
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public int getRoleTypeValue() {
        return this.roleTypeValue;
    }

    public void setRoleTypeValue(int roleTypeValue) {
        this.roleTypeValue = roleTypeValue;
    }

    public void viewRole(ActionEvent e, String id, WFRoleType roleType) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? (WFRoleType.ORGROLE.equals((Object)roleType) ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFRoleOrgEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : (WFRoleType.PERSONROLE.equals((Object)roleType) ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFRolePersonEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFRolePositionEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW))) : (WFRoleType.ORGROLE.equals((Object)roleType) ? UIFactory.createUIFactory((String)this.getEditUIModal()).create(WFRoleOrgEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : (WFRoleType.PERSONROLE.equals((Object)roleType) ? UIFactory.createUIFactory((String)this.getEditUIModal()).create(WFRolePersonEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(WFRolePositionEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW)));
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.isModify = true;
            this.setLocatePre(false);
            this.refresh(e);
            this.setLocatePre(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectRowTip"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().size() > 1 || this.tblMain.getSelectManager().get().getEndRow() - this.tblMain.getSelectManager().get().getBeginRow() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"modifyOnlyOne"));
            SysUtil.abort();
        }
        String createId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("creator").getValue().toString();
        String adminId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("admin").getValue().toString();
        if (createId.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || adminId.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals(WFRoleClientUtils.ADMINISTRATOR)) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"modifyPermTip"));
        }
    }

    @Override
    protected void btnBatchAdmin_actionPerformed(ActionEvent e) throws Exception {
        UserInfo admin;
        this.checkSelected();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFBatchAdminDialog.class.getName(), this.getUIContext());
        uiWindow.show();
        if (((WFBatchAdminDialog)uiWindow.getUIObject()).isCancel()) {
            SysUtil.abort();
        }
        if ((admin = (UserInfo)((WFBatchAdminDialog)uiWindow.getUIObject()).kDBizPromptBox1.getValue()) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"adminNotNull"));
            SysUtil.abort();
        }
        ArrayList ids = this.getSelectedIdValues();
        ((IWFRole)this.getBizInterface()).batchAdmin(ids, admin.getId().toString());
        this.treeMain_valueChanged(null);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return filter;
        }
        DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (treenode.getUserObject() != null && treenode.getUserObject() instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)treenode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)adminInfo.getId().toString()));
            if (this.chkInclude.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("treeid.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        }
        return filter;
    }
}

