/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class WFRoleTreeUtil {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private static final Icon folderIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    private static boolean rebuildTree = false;
    private static final Comparator<KDTreeNode> comparator = new Comparator<KDTreeNode>(){

        @Override
        public int compare(KDTreeNode o1, KDTreeNode o2) {
            AdminOrgUnitInfo info1 = (AdminOrgUnitInfo)o1.getUserObject();
            AdminOrgUnitInfo info2 = (AdminOrgUnitInfo)o2.getUserObject();
            int a = info1.getLongNumber().compareTo(info2.getLongNumber());
            int b = info1.getSortCode().compareTo(info2.getSortCode());
            if (a != 0) {
                return a;
            }
            if (b != 0) {
                return b;
            }
            return 0;
        }
    };

    public static boolean isRebuildTree() {
        return rebuildTree;
    }

    public static KDTreeNode createAdminTreeNodeByWFRole() throws Exception {
        String querySql = "select *  from (  SELECT  DISTINCT \"WFROLE\".FTreeID AS \"TREEID.ID\", \"TREEID\".FLevel AS \"TREEID.LEVEL\", \"TREEID\".FIsLeaf AS \"TREEID.ISLEAF\", \"TREEID\".FLongNumber AS \"TREEID.LONGNUMBER\", \"TREEID\".FNumber AS \"TREEID.NUMBER\", \"TREEID\".FName_l2 AS \"TREEID.NAME\", \"TREEID\".FParentID AS \"PARENT.ID\",\"TREEID\".FSortCode AS \"TREEID.FSortCode\" FROM T_WFR_WFROLE AS \"WFROLE\" inner JOIN T_ORG_Admin AS \"TREEID\" ON \"WFROLE\".FTreeID = \"TREEID\".FID LEFT JOIN T_ORG_Admin AS \"PARENT\" ON \"TREEID\".FParentID = \"PARENT\".FID  union  SELECT \"ADMINORGUNIT\".FID AS \"TREEID.ID\", \"ADMINORGUNIT\".FLevel AS \"TREEID.LEVEL\", \"ADMINORGUNIT\".FIsLeaf AS \"ISLEAF\", \"ADMINORGUNIT\".FLongNumber AS \"LONGNUMBER\", \"ADMINORGUNIT\".FNumber AS \"NUMBER\", \"ADMINORGUNIT\".FName_l2 AS \"NAME\", \"ADMINORGUNIT\".FParentID AS \"PARENT.ID\",\"ADMINORGUNIT\".FSortCode AS \"TREEID.FSortCode\" FROM T_ORG_Admin AS \"ADMINORGUNIT\" WHERE \"ADMINORGUNIT\".FParentID is null AND \"ADMINORGUNIT\".FLEVEL = 1 ) as aa ORDER BY \"TREEID.LONGNUMBER\" ASC ,\"TREEID.Level\" ASC ,\"TREEID.FSortCode\" DESC ";
        SQLExecutor se = new SQLExecutor(querySql);
        IRowSet rows = se.executeSQL();
        List list = (List)rows.toCollection();
        KDTreeNode rootNode = null;
        rootNode = WFRoleTreeUtil.buildTreeNodeByRowSet2(list);
        return rootNode;
    }

    public static KDTreeNode createAdminTreeNodeByEnableWFRole() throws Exception {
        String querySql = "select *  from (  SELECT  DISTINCT \"WFROLE\".FTreeID AS \"TREEID.ID\", \"TREEID\".FLevel AS \"TREEID.LEVEL\", \"TREEID\".FIsLeaf AS \"TREEID.ISLEAF\", \"TREEID\".FLongNumber AS \"TREEID.LONGNUMBER\", \"TREEID\".FNumber AS \"TREEID.NUMBER\", \"TREEID\".FName_l2 AS \"TREEID.NAME\", \"TREEID\".FParentID AS \"PARENT.ID\",\"TREEID\".FSortCode AS \"TREEID.FSortCode\"  FROM T_WFR_WFROLE AS \"WFROLE\" inner JOIN T_ORG_Admin AS \"TREEID\" ON \"WFROLE\".FTreeID = \"TREEID\".FID LEFT JOIN T_ORG_Admin AS \"PARENT\" ON \"TREEID\".FParentID = \"PARENT\".FID where \"WFROLE\".fstate = 0  union  SELECT \"ADMINORGUNIT\".FID AS \"TREEID.ID\", \"ADMINORGUNIT\".FLevel AS \"TREEID.LEVEL\", \"ADMINORGUNIT\".FIsLeaf AS \"ISLEAF\", \"ADMINORGUNIT\".FLongNumber AS \"LONGNUMBER\", \"ADMINORGUNIT\".FNumber AS \"NUMBER\", \"ADMINORGUNIT\".FName_l2 AS \"NAME\", \"ADMINORGUNIT\".FParentID AS \"PARENT.ID\",\"ADMINORGUNIT\".FSortCode AS \"TREEID.FSortCode\"  FROM T_ORG_Admin AS \"ADMINORGUNIT\" WHERE \"ADMINORGUNIT\".FParentID is null AND \"ADMINORGUNIT\".FLEVEL = 1 ) as aa ORDER BY \"TREEID.LONGNUMBER\" ASC ,\"TREEID.Level\" ASC ,\"TREEID.FSortCode\" DESC ";
        SQLExecutor se = new SQLExecutor(querySql);
        IRowSet rows = se.executeSQL();
        List list = (List)rows.toCollection();
        KDTreeNode rootNode = null;
        rootNode = WFRoleTreeUtil.buildTreeNodeByRowSet2(list);
        return rootNode;
    }

    private static KDTreeNode buildTreeNodeByRowSet(List list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        KDTreeNode root = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        AdminOrgUnitInfo adminInfo2 = null;
        block0: for (int i = list.size() - 1; i > -1; --i) {
            adminInfo = WFRoleTreeUtil.createAdminUnitInfo((Vector)list.get(i));
            rootTreeNode = new KDTreeNode((Object)adminInfo);
            if (list.size() == 1) {
                rootTreeNode.setCustomIcon(groupIcon);
                rootTreeNode.setVirtual(true);
                return rootTreeNode;
            }
            if (adminInfo.getParent() == null) {
                root = (KDTreeNode)nodeMap.get(adminInfo.getId().toString());
                root.setCustomIcon(groupIcon);
            }
            rootTreeNode.setCustomIcon(folderIcon);
            if (i <= 0) continue;
            for (int j = i - 1; j > -1; --j) {
                adminInfo2 = WFRoleTreeUtil.createAdminUnitInfo((Vector)list.get(j));
                subTreeNode = new KDTreeNode((Object)adminInfo2);
                subTreeNode.setCustomIcon(companyIcon);
                if (adminInfo.getLongNumber().indexOf(adminInfo2.getLongNumber() + "!") <= -1 || adminInfo.getLongNumber().equals(adminInfo2.getLongNumber() + "!")) continue;
                if (nodeMap.containsKey(adminInfo2.getId().toString())) {
                    if (nodeMap.containsKey(adminInfo.getId().toString())) {
                        ((KDTreeNode)nodeMap.get(adminInfo2.getId().toString())).add((MutableTreeNode)((KDTreeNode)nodeMap.get(adminInfo.getId().toString())));
                        continue block0;
                    }
                    ((KDTreeNode)nodeMap.get(adminInfo2.getId().toString())).add((MutableTreeNode)rootTreeNode);
                    continue block0;
                }
                if (nodeMap.containsKey(adminInfo.getId().toString())) {
                    subTreeNode.add((MutableTreeNode)((KDTreeNode)nodeMap.get(adminInfo.getId().toString())));
                } else {
                    subTreeNode.add((MutableTreeNode)rootTreeNode);
                }
                nodeMap.put(adminInfo2.getId().toString(), subTreeNode);
                continue block0;
            }
        }
        WFRoleTreeUtil.sortTree(root);
        return root;
    }

    private static void sortTree(KDTreeNode root) {
        ArrayList<KDTreeNode> aList = Collections.list(root.children());
        Collections.sort(aList, comparator);
        root.removeAllChildren();
        for (KDTreeNode n : aList) {
            root.add((MutableTreeNode)n);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            WFRoleTreeUtil.sortTree((KDTreeNode)root.getChildAt(i));
        }
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(Vector vt) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        if (!StringUtils.isEmpty((String)((String)vt.get(0)))) {
            adminInfo.setId(BOSUuid.read((String)((String)vt.get(0))));
        }
        adminInfo.setName((String)vt.get(5));
        adminInfo.setNumber((String)vt.get(4));
        adminInfo.setLongNumber((String)vt.get(3));
        adminInfo.setLevel(Integer.parseInt(vt.get(1).toString()));
        adminInfo.setIsLeaf(Boolean.parseBoolean(vt.get(2).toString()));
        adminInfo.setSortCode(vt.get(7) == null ? "" : (String)vt.get(7));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (vt.get(6) == null || "".equals((String)vt.get(6))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)((String)vt.get(6))));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static KDTreeNode buildTreeNodeByRowSet2(List list) throws Exception {
        String orgid;
        AdminOrgUnitInfo adminInfo;
        if (list == null || list.size() == 0) {
            return null;
        }
        KDTreeNode root = null;
        HashMap<String, String> parentorg = new HashMap<String, String>();
        HashMap<String, AdminOrgUnitInfo> orgmap = new HashMap<String, AdminOrgUnitInfo>();
        for (int i = list.size() - 1; i > -1; --i) {
            adminInfo = WFRoleTreeUtil.createAdminUnitInfo((Vector)list.get(i));
            orgid = adminInfo.getId().toString();
            orgmap.put(orgid, adminInfo);
            String longnumber = adminInfo.getLongNumber() + "!";
            int num = 0;
            if (i > 0) {
                for (int j = list.size() - 2; j > -1; --j) {
                    AdminOrgUnitInfo adminInfo1 = WFRoleTreeUtil.createAdminUnitInfo((Vector)list.get(j));
                    String longnumber1 = adminInfo1.getLongNumber() + "!";
                    String parentid = adminInfo1.getId().toString();
                    if (longnumber.indexOf(longnumber1) <= -1 || longnumber.equals(longnumber1)) continue;
                    if (parentorg.containsKey(parentid)) {
                        orgid = parentorg.get(parentid) + ";" + orgid;
                        parentorg.put(parentid, orgid);
                    } else {
                        parentorg.put(parentid, orgid);
                    }
                    ++num;
                    break;
                }
            }
            if (num != 0 || parentorg.containsKey(orgid)) continue;
            parentorg.put(orgid, "");
        }
        for (int j = 0; j < list.size(); ++j) {
            adminInfo = WFRoleTreeUtil.createAdminUnitInfo((Vector)list.get(j));
            orgid = adminInfo.getId().toString();
            if (!parentorg.containsKey(orgid)) continue;
            KDTreeNode child = WFRoleTreeUtil.getchildmap(adminInfo, parentorg, "", orgmap);
            if (root == null) {
                root = child;
                root.setCustomIcon(groupIcon);
                continue;
            }
            root.add((MutableTreeNode)child);
        }
        return root;
    }

    private static KDTreeNode getchildmap(AdminOrgUnitInfo adminInfo, HashMap parentorg, String parentid, HashMap orgmap) {
        String id = adminInfo.getId().toString();
        KDTreeNode child = new KDTreeNode((Object)adminInfo);
        Boolean isopen = parentorg.containsKey(id) && !"".equals(parentorg.get(id));
        if (isopen.booleanValue()) {
            String adminids = parentorg.get(id).toString();
            for (int i = adminids.split(";").length - 1; i > -1; --i) {
                String unitid = adminids.split(";")[i];
                AdminOrgUnitInfo info = (AdminOrgUnitInfo)orgmap.get(unitid);
                KDTreeNode rootchild = WFRoleTreeUtil.getchildmap(info, parentorg, id, orgmap);
                child.add((MutableTreeNode)rootchild);
                child.setCustomIcon(companyIcon);
            }
            parentorg.remove(id);
        }
        return child;
    }
}

