/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.biz.trans.BillActivityPersonsData;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.WfProcessDiagram;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PostParticipantUtil {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_NUMBER = "number";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_ORG = "AdminOrgUnit.name";
    public static final String COLUMN_POS = "Position.name";
    public static final String COLUMN_ACTIVITY = "activityName";
    public static final String COLUMN_ACTDEFID = "activityID";
    public static final String COLUMN_KEY = "id";
    private static final String COLUMNS_ISPRIMARY = "PositionMember.isPrimary";
    public static final String COLUMNS = "id,number,name,AdminOrgUnit.name,PositionMember.isPrimary";
    public static final String COLUMNS_ALL = "id,number,name,AdminOrgUnit.name,PositionMember.isPrimary,Position.name";
    public static final String QUERY = "com.kingdee.eas.basedata.person.app.F7PersonQuery";

    public static ArrayList findPostParticipants(ActivityInstInfo actInst, ProcessDef processDef) throws BOSException, SQLException {
        return PostParticipantUtil.findPostParticipants(actInst, processDef, null);
    }

    public static ArrayList findPostParticipants(ActivityInstInfo actInst, ProcessDef processDef, Context ctx) throws BOSException, SQLException {
        WfProcessDiagram diag = ctx == null ? new WfProcessDiagram() : new WfProcessDiagram(ctx);
        HashMap[] postActivities = actInst != null ? diag.findNextManpownerActivities(new String[]{actInst.getActInstId()}, 2) : diag.findNextManpownerActivities(processDef, false);
        IEnactmentService svc = diag.getService();
        ArrayList activities = new ArrayList();
        PostParticipantUtil.transform(activities, postActivities);
        ArrayList persons = new ArrayList();
        Locale locale = ctx == null ? SysContext.getSysContext().getLocale() : ctx.getLocale();
        Map procContext = actInst != null ? svc.getProcessContext(actInst.getProcInstId()) : new HashMap();
        for (int i = 0; i < activities.size(); ++i) {
            ArrayList list;
            ManpowerActivityDef actDef = (ManpowerActivityDef)activities.get(i);
            ArrayList<String> personIds = new ArrayList<String>();
            String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef);
            personIds = (ArrayList<String>)procContext.get(key);
            if (personIds == null || personIds.size() == 0) {
                ArrayList<String> participantIds = new ArrayList<String>();
                List tmp = actDef.getParticipants().toList();
                for (int j = 0; j < tmp.size(); ++j) {
                    participantIds.add(((ParticipantDef)tmp.get(j)).getID());
                }
                List tempPersons = actInst != null ? svc.getPersonsByParticipants(actInst.getProcInstId(), actDef.getID(), participantIds) : svc.getPersonsByDefParticipants(processDef.getHashValue(), actDef.getID(), participantIds, svc.getContext().getCaller().toString());
                personIds = new ArrayList<String>();
                if (tempPersons != null) {
                    for (Person person : tempPersons) {
                        personIds.add(person.getEmployeeId());
                    }
                }
            }
            if ((list = PostParticipantUtil.queryPerson("id", COLUMNS_ALL, personIds, QUERY, "name,PositionMember.isPrimary desc", ctx)).size() == 0) {
                list.add(new HashMap());
            } else {
                PostParticipantUtil.mergeRows(list, "id", new String[0]);
            }
            for (int j = 0; j < list.size(); ++j) {
                HashMap p = (HashMap)list.get(j);
                p.put(COLUMN_ACTIVITY, actDef.getName(locale));
                p.put(COLUMN_ACTDEFID, actDef.getID());
            }
            persons.addAll(list);
        }
        return persons;
    }

    private static void transform(ArrayList manpowerActivities, HashMap[] postActivities) {
        for (int i = 0; i < postActivities.length; ++i) {
            HashMap item = postActivities[i];
            ActivityDef actDef = (ActivityDef)item.get("actDef");
            if (actDef instanceof ManpowerActivityDef) {
                manpowerActivities.add(actDef);
                continue;
            }
            HashMap[] subActivities = (HashMap[])item.get("subActivities");
            if (subActivities == null) continue;
            PostParticipantUtil.transform(manpowerActivities, subActivities);
        }
    }

    public static ArrayList queryPerson(String pkFieldName, String selector, ArrayList pkIds, String queryMetaData, String orderBy) throws BOSException, SQLException {
        return PostParticipantUtil.queryPerson(pkFieldName, selector, pkIds, queryMetaData, orderBy, null);
    }

    public static ArrayList queryPerson(String pkFieldName, String selector, ArrayList pkIds, String queryMetaData, String orderBy, Context ctx) throws BOSException, SQLException {
        SelectorItemCollection coll;
        if (pkIds == null || pkIds.size() == 0) {
            return new ArrayList(0);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet idList = new HashSet();
        for (int i = 0; i < pkIds.size(); ++i) {
            Object o = pkIds.get(i);
            if (o == null) continue;
            idList.add(o);
        }
        if (idList.size() == 0) {
            return new ArrayList(0);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(pkFieldName, idList, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        if (selector != null) {
            coll = new SelectorItemCollection();
            String[] tmp = selector.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                coll.add(tmp[i]);
            }
            viewInfo.setSelector(coll);
        }
        if (orderBy != null && orderBy.length() > 0) {
            coll = new SorterItemCollection();
            String[] array = orderBy.split(",");
            for (int j = 0; j < array.length; ++j) {
                SortType type;
                String field;
                String item = array[j];
                int i = item.indexOf(32);
                if (i < 0) {
                    field = item;
                    type = SortType.ASCEND;
                } else {
                    field = item.substring(0, i);
                    type = item.substring(i + 1).equals("desc") ? SortType.DESCEND : SortType.ASCEND;
                }
                SorterItemInfo info = new SorterItemInfo(field);
                info.setSortType(type);
                coll.add(info);
            }
            viewInfo.setSorter((SorterItemCollection)coll);
        }
        MetaDataPK query = new MetaDataPK(queryMetaData);
        IQueryExecutor exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)query) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(viewInfo);
        exec.option().isAutoTranslateEnum = true;
        IRowSet set = exec.executeQuery();
        ArrayList list = new ArrayList(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                for (int i = 1; i <= count; ++i) {
                    item.put(meta.getColumnName(i), set.getObject(i));
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    public static String checkNextParticipants(String actInstId, IEnactmentService svc) throws WfException {
        return PostParticipantUtil.checkNextParticipants(actInstId, svc, null);
    }

    public static String checkNextParticipants(String actInstId, IEnactmentService svc, String associationLine) throws WfException {
        String userId = svc.getContext().getCaller().toString();
        ActivityPersonsInfo[] allPostActPersons = svc.getPostActivitysPersonsByActInstID(actInstId, userId, true, associationLine);
        return PostParticipantUtil.checkPostActivityPersons(allPostActPersons);
    }

    private static String checkPostActivityPersons(ActivityPersonsInfo[] allPostActPersons) {
        if (allPostActPersons == null || allPostActPersons.length <= 0) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < allPostActPersons.length; ++i) {
            Person[] actPersons;
            ActivityPersonsInfo info = allPostActPersons[i];
            if (info == null || (actPersons = info.getPersons()) != null && actPersons.length > 0) continue;
            bf.append(info.getActDefName());
            bf.append(" - ");
            bf.append(info.getProcDefName());
            bf.append(",");
        }
        if (bf.toString().trim().length() > 0) {
            String mesg = bf.substring(0, bf.length() - 1);
            return mesg;
        }
        return null;
    }

    public static String checkNextParticipants(String[] assignmentIds, String[] actInstIds, IEnactmentService svc) throws WfException {
        String userId = svc.getContext().getCaller().toString();
        BillActivityPersonsData[] allPostActPersons = svc.getPostActivitysPersonsByAssignIDs(assignmentIds, actInstIds, userId);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < allPostActPersons.length; ++i) {
            BillActivityPersonsData info = allPostActPersons[i];
            String mesg = PostParticipantUtil.checkPostActivityPersons(info.getAcitivityPersonsInfo());
            if (mesg == null) continue;
            bf.append("\u5355\u636e[" + info.getBillId() + "]:" + mesg + "\n");
        }
        return bf.length() == 0 ? null : bf.toString();
    }

    public static String checkNextParticipants(IObjectValue bizObj, String boId, String wfFunction, String wfAction, Context ctx) throws BOSException {
        ProcessInstInfo[] procInsts;
        String userId;
        IEnactmentService svc = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignatePersonsInfo assignatePersons = svc.checkPostActivitiesPersonsResult(bizObj, userId = (ctx == null ? svc.getContext() : ctx).getCaller().toString(), boId, wfFunction, wfAction);
        if (assignatePersons == null) {
            return null;
        }
        Map perMap = new HashMap();
        String value = "";
        value = bizObj.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        if (!StringUtils.isEmpty((String)value)) {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            try {
                ObjectInputStream ois = new ObjectInputStream(bis);
                perMap = (Map)ois.readObject();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (boId != null && (procInsts = svc.getProcessInstanceByHoldedObjectId(boId)) != null && procInsts.length > 0) {
            Map proMap = svc.getProcessContext(procInsts[0].getProcInstId());
            perMap.putAll(proMap);
        }
        return PostParticipantUtil.checkPostActivityPersons(perMap, assignatePersons.getActivityPersons());
    }

    public static String checkNextParticipants(IObjectValue bizObj, String boId, AssignatePersonsInfo assignatePersons, Context ctx) throws BOSException {
        ProcessInstInfo[] procInsts;
        IEnactmentService svc = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
        String userId = (ctx == null ? svc.getContext() : ctx).getCaller().toString();
        if (assignatePersons == null) {
            return null;
        }
        Map perMap = new HashMap();
        String value = "";
        value = bizObj.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        if (!StringUtils.isEmpty((String)value)) {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            try {
                ObjectInputStream ois = new ObjectInputStream(bis);
                perMap = (Map)ois.readObject();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (boId != null && (procInsts = svc.getProcessInstanceByHoldedObjectId(boId)) != null && procInsts.length > 0) {
            Map proMap = svc.getProcessContext(procInsts[0].getProcInstId());
            perMap.putAll(proMap);
        }
        return PostParticipantUtil.checkPostActivityPersons(perMap, assignatePersons.getActivityPersons());
    }

    public static String checkPostActivityPersons(Map perMap, ActivityPersonsInfo[] allPostActPersons) {
        ActivityPersonsInfo[] persons = allPostActPersons;
        if (persons != null && perMap != null) {
            for (int i = 0; i < persons.length; ++i) {
                String key = "DP_" + persons[i].getProcDefHashValue() + "@" + persons[i].getActDefID();
                Object o = perMap.get(key);
                if (o == null || !(o instanceof ArrayList) || ((ArrayList)o).size() <= 0) continue;
                persons[i] = null;
            }
        }
        return PostParticipantUtil.checkPostActivityPersons(allPostActPersons);
    }

    public static ArrayList mergeRows(ArrayList rows, String keyField, String[] mergeFields) {
        if (rows == null) {
            return rows;
        }
        ArrayList<HashMap> array = new ArrayList<HashMap>();
        Object prior = null;
        StringBuffer[] mergedValues = new StringBuffer[mergeFields.length];
        for (int i = 0; i < rows.size(); ++i) {
            String s;
            int j;
            int j2;
            HashMap item = (HashMap)rows.get(i);
            Object value = item.get(keyField);
            Object[] tmp = new Object[mergeFields.length];
            for (j2 = 0; j2 < mergeFields.length; ++j2) {
                tmp[j2] = item.get(mergeFields[j2]);
                if (tmp[j2] != null) continue;
                tmp[j2] = "";
            }
            if (!value.equals(prior)) {
                array.add(item);
                for (j2 = 0; j2 < mergeFields.length; ++j2) {
                    mergedValues[j2] = new StringBuffer().append(tmp[j2]);
                    item.put(mergeFields[j2], mergedValues[j2]);
                }
                prior = value;
                continue;
            }
            boolean needMerge = false;
            for (j = 0; j < mergeFields.length; ++j) {
                s = (String)tmp[j];
                if (s == null || mergedValues[j].indexOf(s) >= 0) continue;
                needMerge = true;
                break;
            }
            if (!needMerge) continue;
            for (j = 0; j < mergeFields.length; ++j) {
                s = (String)tmp[j];
                if (s == null) {
                    s = "";
                }
                mergedValues[j].append(", ").append(s);
            }
        }
        rows.clear();
        rows.addAll(array);
        return array;
    }

    public static List<UserInfo> getUserList(List userIdList) {
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<String> idList = new HashSet<String>();
        for (int index = 0; index < userIdList.size(); ++index) {
            if (userIdList.get(index) instanceof String) {
                String userid = userIdList.get(index).toString();
                if (userid.length() < 28) continue;
                idList.add(userid);
                continue;
            }
            Person person = (Person)userIdList.get(index);
            idList.add(person.getUserId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idList, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CoreBaseCollection userCollection = null;
        try {
            userCollection = UserFactory.getRemoteInstance().getCollection(viewInfo);
        }
        catch (BOSException e) {
            return null;
        }
        for (int index = 0; index < userCollection.size(); ++index) {
            UserInfo userInfo = (UserInfo)userCollection.get(index);
            userList.add(userInfo);
        }
        return userList;
    }
}

