/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.monitor.client.AbstractActSelectorDialogUI;
import com.kingdee.bos.workflow.monitor.client.BillDigestEditConfigUI;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.cp.eip.mc.IJobDelegate;
import com.kingdee.eas.cp.eip.mc.JobDelegateFactory;
import com.kingdee.eas.cp.eip.mc.ProcSelectedInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ActSelectorDialogUI
extends AbstractActSelectorDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(ActSelectorDialogUI.class);
    private DefaultKingdeeTreeNode nodeRoot = null;
    private HashSet set = new HashSet();
    private String[] orgFliter = new String[0];
    private HashMap selectedActMap = null;
    HashMap allActMap = new HashMap();
    private boolean cancle = true;
    String tempProcDefId = null;
    String tempProcDefName = null;
    private List<ApproveActivityDef> actsList = new ArrayList<ApproveActivityDef>();

    public Object getData() {
        return this.selectedActMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.orgFliter == null) {
            this.orgFliter = (String[])this.getUIContext().get("orgFilter");
        }
        if (this.selectedActMap == null) {
            this.selectedActMap = (HashMap)this.getUIContext().get("selectedActMap");
        }
        this.tblProc.checkParsed();
        this.tblProc.getSelectManager().setSelectMode(10);
        this.tblProc.setEditable(false);
        this.tblSelectedAct.checkParsed();
        this.tblSelectedAct.getSelectManager().setSelectMode(10);
        this.tblSelectedAct.setEditable(false);
        this.initTree();
        this.getProcessDataAndFill(null);
        this.fillSelectedProcData();
    }

    private void fillSelectedProcData() {
        if (this.selectedActMap == null || this.selectedActMap.size() <= 0) {
            return;
        }
        for (String procId : this.selectedActMap.keySet()) {
            ProcSelectedInfo procInfo = (ProcSelectedInfo)this.selectedActMap.get(procId);
            IRow row = this.tblSelectedAct.addRow();
            ICell cell = row.getCell("procId");
            cell.setValue((Object)procInfo.getProcDefId());
            cell = row.getCell("procName");
            cell.setValue((Object)procInfo.getName());
            if (procInfo.getProcCode() == null && procInfo.getDescription() == null && this.allActMap != null && this.allActMap.containsKey(procId)) {
                procInfo = (ProcSelectedInfo)this.allActMap.get(procId);
                cell = row.getCell("procCode");
                cell.setValue((Object)procInfo.getProcCode());
                cell = row.getCell("description");
                cell.setValue((Object)procInfo.getDescription());
                this.selectedActMap.put(procId, procInfo);
            }
            cell = row.getCell("procCode");
            cell.setValue((Object)procInfo.getProcCode());
            cell = row.getCell("description");
            cell.setValue((Object)procInfo.getDescription());
        }
    }

    private boolean isSelected(String procId) {
        if (this.selectedActMap != null) {
            return this.selectedActMap.containsKey(procId);
        }
        this.selectedActMap = new HashMap();
        return false;
    }

    private void searchProcessDataAndFill(String[] searchParam) {
        IJobDelegate delegate = null;
        HashMap map = new HashMap();
        try {
            delegate = JobDelegateFactory.getRemoteInstance();
            map = delegate.getProcessNew(this.orgFliter, null, searchParam);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.fillProcData(map);
    }

    private void getProcessDataAndFill(String packageName) {
        IJobDelegate delegate = null;
        try {
            delegate = JobDelegateFactory.getRemoteInstance();
            this.allActMap = delegate.getProcessNew(this.orgFliter, packageName, null);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.fillProcData(this.allActMap);
    }

    private void fillProcData(HashMap map) {
        String procId2 = null;
        ProcSelectedInfo info = null;
        this.tblProc.removeRows();
        for (String procId2 : map.keySet()) {
            info = (ProcSelectedInfo)map.get(procId2);
            IRow row = this.tblProc.addRow();
            ICell cell = row.getCell("procId");
            cell.setValue((Object)procId2);
            cell = row.getCell("procCode");
            cell.setValue((Object)info.getProcCode());
            cell = row.getCell("procName");
            cell.setValue((Object)info.getName());
            cell = row.getCell("description");
            cell.setValue((Object)info.getDescription());
        }
    }

    private void getPackageName(IBriefViewTreeNode root, HashSet set) {
        String packageName = root.getPackageName();
        set.add(packageName);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode node = (IBriefViewTreeNode)enu.nextElement();
            this.getPackageName(node, set);
        }
    }

    private boolean isShowNode(String packageName) {
        for (String str : this.set) {
            if (!packageName.equalsIgnoreCase(str) && !str.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        nodeRoot.setText(root.getAlias());
        nodeRoot.setUserObject((Object)root);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            if (!this.isShowNode(bvNode.getPackageName())) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(bvNode.getAlias());
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        return nodeRoot;
    }

    public void initTree() {
        BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
        this.set.clear();
        this.getPackageName(root, this.set);
        this.nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        this.nodeRoot = this.convertToKingdeeTreeNode(root, this.nodeRoot);
        this.nodeRoot.setText(ReportResourceUtil.getReportMultiLanguageResource((String)"ALL_PROCESS_TREE"));
        this.flowPackTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeRoot));
        this.flowPackTree.getSelectionModel().setSelectionMode(1);
        this.flowPackTree.setAutoscrolls(true);
        this.flowPackTree.setSelectionNode(this.nodeRoot);
        this.flowPackTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object object = ActSelectorDialogUI.this.flowPackTree.getLastSelectedPathComponent();
                if (object != null && object instanceof DefaultKingdeeTreeNode) {
                    IBriefViewTreeNode currentNodeObject = (IBriefViewTreeNode)((DefaultKingdeeTreeNode)object).getUserObject();
                    ActSelectorDialogUI.this.getProcessDataAndFill(currentNodeObject.getPackageName());
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCancle() {
        return this.cancle;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String searchText = this.txtSearchProc.getText();
        String[] searchParam = new String[]{searchText, new Integer(this.cbSearchType.getSelectedIndex()).toString(), Boolean.toString(this.cbMoHu.isSelected())};
        this.searchProcessDataAndFill(searchParam);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.cancle = false;
        BillDigestEditConfigUI parent = (BillDigestEditConfigUI)((Object)this.getUIContext().get("parentUI"));
        parent.refreshData(this.getActs());
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancle = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblProc_tableClicked(KDTMouseEvent e) throws Exception {
        if (e != null && e.getType() != 0 && e.getClickCount() == 2) {
            this.btnAddProc_actionPerformed(null);
        }
    }

    protected void btnAddProc_actionPerformed(ActionEvent e) throws Exception {
        List rowIndex = BillDigestUtils.getTableSelectRow(this.tblProc);
        if (rowIndex.size() <= 0) {
            return;
        }
        for (Integer rowNum : rowIndex) {
            IRow row = this.tblProc.getRow(rowNum.intValue());
            String procDefId = (String)row.getCell("procId").getValue();
            BillDigestEditConfigUI parentui = (BillDigestEditConfigUI)((Object)this.getUIContext().get("parentUI"));
            if (!parentui.modifyProc(procDefId).booleanValue()) {
                MsgBox.showError((String)BillDigestUtils.getResString("procErr"));
                return;
            }
            String procDefName = (String)row.getCell("procName").getValue();
            if (procDefId.equals(this.tempProcDefId)) continue;
            this.actsList.clear();
            this.tblSelectedAct.removeRows();
            this.actsList = this.getActsByProcDefId(procDefId);
            this.tempProcDefId = procDefId;
            this.tempProcDefName = procDefName;
            int index = 0;
            for (ApproveActivityDef act : this.actsList) {
                row = this.tblSelectedAct.addRow();
                ICell cell = row.getCell("actDefId");
                cell.setValue((Object)act.getID());
                cell = row.getCell("actName");
                cell.setValue((Object)act.getName(new Locale("L2")));
                ++index;
            }
            this.selectAll(this.tblSelectedAct);
        }
    }

    protected void btnDeleteProc_actionPerformed(ActionEvent e) throws Exception {
        List rowIndex = BillDigestUtils.getTableSelectRow(this.tblSelectedAct);
        Collections.sort(rowIndex);
        if (rowIndex.size() <= 0) {
            return;
        }
        for (int i = rowIndex.size() - 1; i >= 0; --i) {
            Integer rowNum = (Integer)rowIndex.get(i);
            IRow row = this.tblSelectedAct.getRow(rowNum.intValue());
            String procDefId = (String)row.getCell("procId").getValue();
            this.tblSelectedAct.removeRow(rowNum.intValue());
            this.selectedActMap.remove(procDefId);
        }
    }

    public List<ApproveActivityDef> getActsByProcDefId(String procId) throws BOSException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        ProcessDefInfo procdefinfo = enactmentService.getProcessDefInfo(procId);
        ProcessDef def = enactmentService.getProcessDefByDefineHashValue(procdefinfo.getMd5HashValue());
        ActivityCollection actColl = def.getActivitys();
        ArrayList<ApproveActivityDef> actsList = new ArrayList<ApproveActivityDef>();
        for (int i = 0; i < actColl.size(); ++i) {
            ActivityDef actdef = actColl.get(i);
            if (!(actdef instanceof ApproveActivityDef)) continue;
            actsList.add((ApproveActivityDef)actdef);
        }
        return actsList;
    }

    public Map<String, String> getActs() throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblSelectedAct);
        if (rowIndex == null) {
            return null;
        }
        IRow row = null;
        HashMap<String, String> actsMap = new HashMap<String, String>();
        for (int i = 0; i < rowIndex.length; ++i) {
            row = this.tblSelectedAct.getRow(rowIndex[i]);
            actsMap.put((String)row.getCell("actDefId").getValue(), (String)row.getCell("actName").getValue());
        }
        actsMap.put("procDefId", this.tempProcDefId);
        actsMap.put("procDefName", this.tempProcDefName);
        return actsMap;
    }

    public void selectAll(KDTable table) {
        int rowcount = table.getRowCount();
        for (int row = 0; row < rowcount; ++row) {
            table.getSelectManager().setActiveRowIndex(row);
        }
        KDTSelectBlock block = new KDTSelectBlock();
        block.setTop(rowcount - 1);
        block.setBottom(0);
        block.setLeft(0);
        block.setRight(table.getColumnCount());
        block.setTable(table);
        table.getSelectManager().select(block, true);
    }
}

