/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.workflow.monitor.WfProcessImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AppendDiagramDialog
extends KDPanel {
    private JSONObject map;
    private HashMap id2node = new HashMap();
    private Map imageCache = new HashMap();
    JSONArray links;

    public AppendDiagramDialog(JSONObject map) {
        this.map = map;
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Icon getImage(String state) {
        if (this.imageCache.containsKey(state)) {
            return (Icon)this.imageCache.get(state);
        }
        String src = "icons/wf_audit";
        String url = state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked") ? src + "_suspend.png" : (state.equals("closed.completed") ? src + "_complete.png" : (state.equals("closed.aborted") ? src + "_abort.png" : (state.equals("closed.terminated") ? src + "_terminate.png" : (state.equals("not_start") ? src + ".png" : src + "_running.gif"))));
        Image image = Toolkit.getDefaultToolkit().createImage(WfProcessImage.class.getResource(url));
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            this.imageCache.put(state, icon);
        } else {
            this.imageCache.put(state, null);
        }
        return (Icon)this.imageCache.get(state);
    }

    private void initUI() throws JSONException {
        int width = (Integer)this.map.get("width");
        int height = (Integer)this.map.get("height");
        this.setPreferredSize(new Dimension(width + 20, height + 20));
        this.setSize(new Dimension(width + 20, height + 20));
        this.setLayout(null);
        JSONArray list = (JSONArray)this.map.get("nodes");
        for (int i = 0; i < list.length(); ++i) {
            JSONObject node = (JSONObject)list.get(i);
            String type = (String)node.get("type");
            this.add((Component)((Object)new NodePanel(node)));
        }
        this.links = (JSONArray)this.map.get("links");
    }

    private void draw(Graphics g, JSONObject link) throws JSONException {
        String fromId = (String)link.get("from");
        String toId = (String)link.get("to");
        NodePanel from = (NodePanel)((Object)this.id2node.get(fromId));
        NodePanel to = (NodePanel)((Object)this.id2node.get(toId));
        if (from == null || to == null) {
            return;
        }
        Rectangle r1 = from.getBounds();
        Rectangle r2 = to.getBounds();
        g.setColor(Color.BLACK);
        int s = 3;
        g.drawLine(r1.x + r1.width / 2, r1.y + r1.height, r2.x + r2.width / 2, r2.y - s);
        int x = r2.x + r2.width / 2;
        int y = r2.y - s;
        g.fillPolygon(new int[]{x - s, x - s, x + s, x + s}, new int[]{y + s, y - s, y - s, y + s}, 4);
    }

    public void paint(Graphics g) {
        super.paint(g);
        try {
            for (int i = 0; i < this.links.length(); ++i) {
                JSONObject node = (JSONObject)this.links.get(i);
                this.draw(g, node);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class NodePanel
    extends KDPanel {
        private String title;

        NodePanel(JSONObject node) throws JSONException {
            String type;
            String id = (String)node.get("id");
            AppendDiagramDialog.this.id2node.put(id, this);
            String state = null;
            try {
                state = (String)node.get("state");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.title = (String)node.get("title");
            int x = (Integer)node.get("x");
            int y = (Integer)node.get("y");
            int width = (Integer)node.get("width");
            int height = (Integer)node.get("height");
            KDLabel label = new KDLabel(this.title, 0);
            this.setLayout(new BorderLayout());
            this.add((Component)label, "South");
            if (state != null) {
                KDLabel imageLabel = new KDLabel(AppendDiagramDialog.this.getImage(state));
                imageLabel.setToolTipText(this.title);
                this.add((Component)imageLabel, "Center");
            }
            if (!"Activity".equals(type = (String)node.get("type"))) {
                ++x;
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            }
            if (width > 250) {
                x += (width - 250) / 2;
                width = 250;
            }
            this.setBounds(x, y, width, height);
        }
    }
}

