/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaFactory;
import com.kingdee.bos.workflow.monitor.IBillDigestSchema;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.client.AbstractBillDigestSchemaUI;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.eas.cp.eip.mc.ProcSelectedInfo;
import com.kingdee.eas.cp.eip.mc.client.NewProcF7DialogUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BillDigestSchemaUI
extends AbstractBillDigestSchemaUI {
    private static final Logger logger = CoreUIObject.getLogger(BillDigestSchemaUI.class);
    protected IUIWindow dialog = null;
    private Component owner;
    private String[] orgFilter = new String[0];
    private Boolean mutiSelect = false;
    private HashMap selectedProcMap = new HashMap();
    private String selectSchemId = null;
    private HashMap<String, List<ProcSelectedInfo>> distributedProcMap = new HashMap();
    private HashMap<String, List<String>> deletedMap = new HashMap();

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initAddProcBtn();
        this.initDelProcBtn();
        this.initValueTree();
        this.kDTreeView1.getControlPane().removeAll();
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillDigestSchemaUI.this.beforeActionPerformed(e);
                try {
                    BillDigestSchemaUI.this.btnConfirm_actionPerformed(e);
                }
                catch (Exception exc) {
                    BillDigestSchemaUI.this.handUIException(exc);
                }
                finally {
                    BillDigestSchemaUI.this.afterActionPerformed(e);
                }
            }
        });
        this.btnCancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillDigestSchemaUI.this.beforeActionPerformed(e);
                try {
                    BillDigestSchemaUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    BillDigestSchemaUI.this.handUIException(exc);
                }
                finally {
                    BillDigestSchemaUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    private void initAddProcBtn() {
        this.btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    TreePath path = BillDigestSchemaUI.this.valueTree.getSelectionPath();
                    if (path == null) {
                        MsgBox.showError((String)BillDigestUtils.getResString("selectErr"));
                        return;
                    }
                    Object obj = path.getLastPathComponent();
                    if (obj instanceof DefaultKingdeeTreeNode) {
                        Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                        BillDigestUtils.NodeType type = BillDigestUtils.getNodeType((DefaultKingdeeTreeNode)obj);
                        if (BillDigestUtils.NodeType.SCHEMA != type) {
                            MsgBox.showError((String)BillDigestUtils.getResString("selectErr"));
                            return;
                        }
                        BillDigestSchemaUI.this.showProcF7UI();
                        while (!BillDigestSchemaUI.this.checkProc((SummaryInfo)userObj)) {
                            BillDigestSchemaUI.this.showProcF7UI();
                        }
                        if (!BillDigestSchemaUI.this.isCanceled()) {
                            BillDigestSchemaUI.this.addShemaDitribute((SummaryInfo)userObj);
                        }
                    }
                }
                catch (Exception e1) {
                    logger.info((Object)e1);
                }
            }
        });
    }

    private void initDelProcBtn() {
        this.btnDel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                List rowIndex = BillDigestUtils.getTableSelectRow(BillDigestSchemaUI.this.configTable);
                ArrayList<String> deletedList = new ArrayList<String>();
                for (Object index : rowIndex) {
                    deletedList.add(BillDigestSchemaUI.this.configTable.getRow(((Integer)index).intValue()).getCell("procDefId").getValue().toString());
                    BillDigestSchemaUI.this.configTable.removeRow(((Integer)index).intValue());
                }
                BillDigestSchemaUI.this.deletedMap.put(BillDigestSchemaUI.this.selectSchemId, deletedList);
                ArrayList<ProcSelectedInfo> procDefInfos = new ArrayList<ProcSelectedInfo>();
                for (int i = 0; i < BillDigestSchemaUI.this.configTable.getRowCount(); ++i) {
                    IRow row = BillDigestSchemaUI.this.configTable.getRow(Integer.valueOf(i).intValue());
                    ICell cell = row.getCell("procDefId");
                    String procDefid = (String)cell.getValue();
                    String procDefName = (String)row.getCell("procDefName").getValue();
                    String procDefNum = (String)row.getCell("procDefNum").getValue();
                    ProcSelectedInfo info = new ProcSelectedInfo();
                    info.setProcDefId(procDefid);
                    info.setName(procDefName);
                    info.setProcCode(procDefNum);
                    procDefInfos.add(info);
                }
                BillDigestSchemaUI.this.distributedProcMap.put(BillDigestSchemaUI.this.selectSchemId, procDefInfos);
            }
        });
    }

    public void initValueTree() {
        this.valueTree.setModel((TreeModel)this.getUIContext().get("treemodel"));
        this.valueTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BillDigestSchemaUI.this.configTable.removeRows();
                TreePath path = BillDigestSchemaUI.this.valueTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object obj = path.getLastPathComponent();
                if (obj instanceof DefaultKingdeeTreeNode) {
                    BillDigestUtils.NodeType type = BillDigestUtils.getNodeType((DefaultKingdeeTreeNode)obj);
                    if (BillDigestUtils.NodeType.SCHEMA == type) {
                        BillDigestSchemaUI.this.setBtnControl(true);
                        Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                        SummaryInfo summary = (SummaryInfo)userObj;
                        BillDigestSchemaUI.this.selectSchemId = summary.getShcemaId();
                        if (BillDigestSchemaUI.this.distributedProcMap.get(BillDigestSchemaUI.this.selectSchemId) != null) {
                            BillDigestSchemaUI.this.fillConfigTable2(summary.getShcemaId(), (List)BillDigestSchemaUI.this.distributedProcMap.get(BillDigestSchemaUI.this.selectSchemId));
                        } else {
                            try {
                                IBillDigestSchema schema = BillDigestSchemaFactory.getRemoteInstance();
                                List procdefIds = schema.getShemaDistribute(summary.getMetadataPK(), BillDigestSchemaUI.this.selectSchemId);
                                BillDigestSchemaUI.this.fillConfigTable(summary.getShcemaId(), procdefIds);
                            }
                            catch (BOSException e1) {
                                logger.error((Object)e1.getMessage(), (Throwable)e1);
                            }
                        }
                    } else {
                        BillDigestSchemaUI.this.setBtnControl(false);
                    }
                }
            }
        });
    }

    public Object getData() {
        if (this.isCanceled()) {
            return null;
        }
        if (this.dialog != null) {
            return ((NewProcF7DialogUI)this.dialog.getUIObject()).getData();
        }
        return null;
    }

    public boolean isCanceled() {
        if (this.dialog != null) {
            boolean flag = ((NewProcF7DialogUI)this.dialog.getUIObject()).isCancle();
            return flag;
        }
        return true;
    }

    public void setFliter(String[] filter) {
        this.orgFilter = filter;
    }

    public void setMutiSelect(boolean flag) {
        this.mutiSelect = new Boolean(flag);
    }

    public void setSelectedProcMap(HashMap selectedProcMap) {
        this.selectedProcMap = selectedProcMap;
    }

    public void showProcF7UI() {
        try {
            this.getUIContext().put("orgFilter", this.orgFilter);
            this.getUIContext().put("mutiSelect", this.mutiSelect);
            this.selectedProcMap = new HashMap();
            this.getUIContext().put("selectedProcMap", this.selectedProcMap);
            this.dialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewProcF7DialogUI.class.getName(), this.getUIContext());
            this.dialog.show();
        }
        catch (Exception e) {
            logger.error((Object)"show failed", (Throwable)e);
        }
    }

    private void fillConfigTable(String schemaId, List<ProcessDefInfo> procDefInfos) {
        if (procDefInfos == null || procDefInfos.size() == 0) {
            return;
        }
        ArrayList<ProcSelectedInfo> procList = new ArrayList<ProcSelectedInfo>();
        for (int i = 0; i < procDefInfos.size(); ++i) {
            ProcessDefInfo procInfo = procDefInfos.get(i);
            ProcSelectedInfo info = new ProcSelectedInfo();
            IRow row = this.configTable.addRow();
            ICell cell = row.getCell("procDefId");
            cell.setValue((Object)procInfo.getProcDefId());
            info.setProcDefId(procInfo.getProcDefId());
            cell = row.getCell("procDefName");
            cell.setValue((Object)procInfo.getProcDefName(this.currentLocale));
            info.setName(procInfo.getProcDefName(this.currentLocale));
            cell = row.getCell("procDefNum");
            cell.setValue((Object)procInfo.getProcDefName(this.currentLocale));
            info.setProcCode(procInfo.getProcDefName(this.currentLocale));
            procList.add(info);
        }
        this.distributedProcMap.put(schemaId, procList);
    }

    private void fillConfigTable2(String schemaId, List<ProcSelectedInfo> procSelectedInfos) {
        if (procSelectedInfos == null || procSelectedInfos.size() == 0) {
            return;
        }
        for (int i = 0; i < procSelectedInfos.size(); ++i) {
            ProcSelectedInfo info = procSelectedInfos.get(i);
            IRow row = this.configTable.addRow();
            ICell cell = row.getCell("procDefId");
            cell.setValue((Object)info.getProcDefId());
            cell = row.getCell("procDefName");
            cell.setValue((Object)info.getName());
            cell = row.getCell("procDefNum");
            cell.setValue((Object)info.getName());
        }
    }

    private boolean checkProc(SummaryInfo info) throws Exception {
        for (String procId : this.selectedProcMap.keySet()) {
            if (BillDigestUtils.checkProc(procId, info.getMetadataPK())) continue;
            ProcSelectedInfo procDefInfo = (ProcSelectedInfo)this.selectedProcMap.get(procId);
            MsgBox.showError((String)(procDefInfo.getName() + BillDigestUtils.getResString("procErr")));
            return false;
        }
        return true;
    }

    private void SaveShemaDitribute(SummaryInfo info) throws BOSException {
        ArrayList<String> procDefids = new ArrayList<String>();
        for (String procId : this.selectedProcMap.keySet()) {
            procDefids.add(procId);
        }
        IBillDigestSchema schem = BillDigestSchemaFactory.getRemoteInstance();
        schem.saveShemaDistribute(info.getShcemaId(), procDefids);
    }

    private void addShemaDitribute(SummaryInfo info) throws BOSException {
        if (this.selectedProcMap != null && this.selectedProcMap.size() > 0) {
            List<ProcSelectedInfo> list = this.distributedProcMap.get(info.getShcemaId());
            if (list == null) {
                list = new ArrayList<ProcSelectedInfo>();
            }
            block0: for (String procId : this.selectedProcMap.keySet()) {
                for (int i = 0; i < list.size(); ++i) {
                    ProcSelectedInfo procInfo2 = list.get(i);
                    if (procId.equals(procInfo2.getProcDefId())) continue block0;
                }
                ProcSelectedInfo procInfo = (ProcSelectedInfo)this.selectedProcMap.get(procId);
                IRow row = this.configTable.addRow();
                ICell cell = row.getCell("procDefId");
                cell.setValue((Object)procInfo.getProcDefId());
                cell = row.getCell("procDefName");
                cell.setValue((Object)procInfo.getName());
                cell = row.getCell("procDefNum");
                cell.setValue((Object)procInfo.getName());
                list.add(procInfo);
            }
            this.distributedProcMap.put(info.getShcemaId(), list);
        }
    }

    private void save() {
        Set<Map.Entry<String, List<ProcSelectedInfo>>> entryseSet = this.distributedProcMap.entrySet();
        Set<Map.Entry<String, List<String>>> entryseSet2 = this.deletedMap.entrySet();
        try {
            IBillDigestSchema schema = BillDigestSchemaFactory.getRemoteInstance();
            for (Map.Entry<String, List<ProcSelectedInfo>> entry : entryseSet) {
                List<ProcSelectedInfo> list = entry.getValue();
                ArrayList<String> idList = new ArrayList<String>();
                for (ProcSelectedInfo info : list) {
                    idList.add(info.getProcDefId());
                }
                schema.saveShemaDistribute(entry.getKey(), idList);
            }
            for (Map.Entry<String, List<String>> entry : entryseSet2) {
                List<String> list2 = entry.getValue();
                schema.delShemaDistribute(entry.getKey(), list2);
            }
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.getUIWindow().close();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void setBtnControl(boolean enabled) {
        this.btnAdd.setEnabled(enabled);
        this.btnDel.setEnabled(enabled);
    }
}

